/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.update.Checker;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.update.Updater;

class DummyHandler
implements Checker,
Updater {
    private final RouterContext _context;
    private final ConsoleUpdateManager _mgr;

    public DummyHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        this._context = ctx;
        this._mgr = mgr;
    }

    @Override
    public UpdateTask check(UpdateType type, UpdateMethod method, String id, String currentVersion, long maxTime) {
        if (type != UpdateType.TYPE_DUMMY) {
            return null;
        }
        return new DummyRunner(this._context, this._mgr, maxTime);
    }

    @Override
    public UpdateTask update(UpdateType type, UpdateMethod method, List<URI> updateSources, String id, String newVersion, long maxTime) {
        if (type != UpdateType.TYPE_DUMMY) {
            return null;
        }
        return new DummyRunner(this._context, this._mgr, maxTime);
    }

    private static class DummyRunner
    extends UpdateRunner {
        private final long _delay;

        public DummyRunner(RouterContext ctx, ConsoleUpdateManager mgr, long maxTime) {
            super(ctx, mgr, UpdateType.TYPE_DUMMY, Collections.emptyList());
            this._delay = maxTime;
        }

        @Override
        public UpdateMethod getMethod() {
            return UpdateMethod.METHOD_DUMMY;
        }

        @Override
        protected void update() {
            try {
                Thread.sleep(this._delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._mgr.notifyCheckComplete(this, false, false);
            this._mgr.notifyTaskFailed(this, "dummy", null);
        }
    }
}

