/*
 * Decompiled with CFR 0.152.
 */
package org.xlattice.crypto.filters;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.xlattice.crypto.filters.KeySelector;

public class BloomSHA1 {
    private final int m;
    private final int k;
    private int count;
    private final int[] filter;
    private final KeySelector ks;
    private final int filterBits;
    private final int filterWords;
    private final BlockingQueue<int[]> buf;

    public BloomSHA1(int m, int k) {
        this.m = m;
        this.k = k;
        this.filterBits = 1 << m;
        this.filterWords = (this.filterBits + 31) / 32;
        this.filter = new int[this.filterWords];
        this.ks = new KeySelector(m, k);
        this.buf = new LinkedBlockingQueue<int[]>(16);
    }

    public BloomSHA1(int m) {
        this(m, 8);
    }

    public BloomSHA1() {
        this(20, 8);
    }

    private void doClear() {
        Arrays.fill(this.filter, 0);
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            this.doClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            return this.count;
        }
    }

    public final int capacity() {
        return this.filterBits;
    }

    public void insert(byte[] b) {
        this.insert(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(byte[] b, int offset, int len) {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            this.locked_insert(b, offset, len);
        }
    }

    public final void locked_insert(byte[] b) {
        this.locked_insert(b, 0, b.length);
    }

    public final void locked_insert(byte[] b, int offset, int len) {
        int[] bitOffset = this.acquire();
        int[] wordOffset = this.acquire();
        this.ks.getOffsets(b, offset, len, bitOffset, wordOffset);
        for (int i = 0; i < this.k; ++i) {
            int n = wordOffset[i];
            this.filter[n] = this.filter[n] | 1 << bitOffset[i];
        }
        ++this.count;
        this.buf.offer(bitOffset);
        this.buf.offer(wordOffset);
    }

    private final boolean isMember(byte[] b) {
        return this.isMember(b, 0, b.length);
    }

    private final boolean isMember(byte[] b, int offset, int len) {
        int[] bitOffset = this.acquire();
        int[] wordOffset = this.acquire();
        this.ks.getOffsets(b, offset, len, bitOffset, wordOffset);
        for (int i = 0; i < this.k; ++i) {
            if ((this.filter[wordOffset[i]] & 1 << bitOffset[i]) != 0) continue;
            this.buf.offer(bitOffset);
            this.buf.offer(wordOffset);
            return false;
        }
        this.buf.offer(bitOffset);
        this.buf.offer(wordOffset);
        return true;
    }

    public final boolean locked_member(byte[] b) {
        return this.isMember(b);
    }

    public final boolean locked_member(byte[] b, int offset, int len) {
        return this.isMember(b, offset, len);
    }

    public final boolean member(byte[] b) {
        return this.member(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean member(byte[] b, int offset, int len) {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            return this.isMember(b, offset, len);
        }
    }

    public FilterKey getFilterKey(byte[] b, int offset, int len) {
        int[] bitOffset = this.acquire();
        int[] wordOffset = this.acquire();
        this.ks.getOffsets(b, offset, len, bitOffset, wordOffset);
        return new FilterKey(bitOffset, wordOffset);
    }

    public void locked_insert(FilterKey fk) {
        for (int i = 0; i < this.k; ++i) {
            int n = fk.wordOffset[i];
            this.filter[n] = this.filter[n] | 1 << fk.bitOffset[i];
        }
        ++this.count;
    }

    public boolean locked_member(FilterKey fk) {
        for (int i = 0; i < this.k; ++i) {
            if ((this.filter[fk.wordOffset[i]] & 1 << fk.bitOffset[i]) != 0) continue;
            return false;
        }
        return true;
    }

    private int[] acquire() {
        int[] rv = (int[])this.buf.poll();
        if (rv != null) {
            return rv;
        }
        return new int[this.k];
    }

    public void release(FilterKey fk) {
        this.buf.offer(fk.bitOffset);
        this.buf.offer(fk.wordOffset);
    }

    public final double falsePositives(int n) {
        return Math.pow(1.0 - Math.exp(0.0 - (double)this.k * (double)n / (double)this.filterBits), this.k);
    }

    public final double falsePositives() {
        return this.falsePositives(this.count);
    }

    public static class FilterKey {
        private final int[] bitOffset;
        private final int[] wordOffset;

        private FilterKey(int[] bitOffset, int[] wordOffset) {
            this.bitOffset = bitOffset;
            this.wordOffset = wordOffset;
        }
    }
}

