/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.i2p.router.transport.TransportUtil;
import net.i2p.util.Addresses;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPResponse;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.ParserException;

public abstract class Parser {
    private static final String USER_AGENT = "Debian/buster/sid, UPnP/1.1, MiniUPnPc/2.1";
    private static final String PROP_HURLC_PROXY1 = "http.proxyHost";
    private static final boolean HURLC_PROXY_ENABLED = System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyHost").length() > 0;

    public abstract Node parse(InputStream var1) throws ParserException;

    public Node parse(URL locationURL) throws ParserException {
        String uri;
        byte[] ip;
        if (!"http".equals(locationURL.getProtocol())) {
            throw new ParserException("Not HTTP");
        }
        String host = locationURL.getHost();
        if (host == null || host.startsWith("127.")) {
            throw new ParserException("Bad host " + host);
        }
        if (host.startsWith("[") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }
        if ((ip = Addresses.getIP(host)) == null || TransportUtil.isPubliclyRoutable(ip, true)) {
            throw new ParserException("Bad host " + host);
        }
        int port = locationURL.getPort();
        if (port == -1) {
            port = 80;
        }
        if ((uri = locationURL.getPath()).length() <= 0) {
            uri = "/";
        }
        if (!HURLC_PROXY_ENABLED) {
            HttpURLConnection urlCon = null;
            InputStream urlIn = null;
            try {
                Node rootElem;
                urlCon = (HttpURLConnection)locationURL.openConnection();
                urlCon.setConnectTimeout(2000);
                urlCon.setReadTimeout(1000);
                urlCon.setRequestMethod("GET");
                urlCon.setRequestProperty("User-Agent", USER_AGENT);
                urlCon.setRequestProperty("Connection", "close");
                urlCon.setAllowUserInteraction(false);
                urlCon.setUseCaches(false);
                urlCon.setInstanceFollowRedirects(false);
                int code = urlCon.getResponseCode();
                if (code < 200 || code >= 300) {
                    throw new ParserException("Bad response code " + code);
                }
                if ("application/json".equals(urlCon.getContentType())) {
                    throw new ParserException("JSON response");
                }
                if (urlCon.getContentLength() > 32768) {
                    throw new ParserException("too big");
                }
                urlIn = urlCon.getInputStream();
                Node node = rootElem = this.parse(urlIn);
                return node;
            }
            catch (ParserException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
            finally {
                if (urlIn != null) {
                    try {
                        urlIn.close();
                    }
                    catch (IOException iOException) {}
                }
                if (urlCon != null) {
                    urlCon.disconnect();
                }
            }
        }
        HTTPRequest httpReq = new HTTPRequest();
        httpReq.setMethod("GET");
        httpReq.setURI(uri);
        HTTPResponse httpRes = httpReq.post(host, port);
        if (!httpRes.isSuccessful()) {
            throw new ParserException("HTTP comunication failed. Unable to retrieve resource -> " + locationURL + "\nRequest:\n" + httpReq + "\nResponse:\n" + httpRes);
        }
        ByteArrayInputStream strBuf = new ByteArrayInputStream(httpRes.getContent());
        try {
            return this.parse(strBuf);
        }
        catch (ParserException pe) {
            Debug.warning("Parse error at resource " + locationURL + "\nRequest:\n" + httpReq + "\nResponse:\n" + httpRes, pe);
            throw pe;
        }
    }

    public Node parse(File descriptionFile) throws ParserException {
        try {
            FileInputStream fileIn = new FileInputStream(descriptionFile);
            Node root = this.parse(fileIn);
            ((InputStream)fileIn).close();
            return root;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public Node parse(String descr) throws ParserException {
        try {
            ByteArrayInputStream decrIn = new ByteArrayInputStream(descr.getBytes());
            Node root = this.parse(decrIn);
            return root;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }
}

