/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.MessageWrapper;

class StoreState {
    private final RouterContext _context;
    private final Hash _key;
    private final DatabaseEntry _data;
    private final HashSet<Hash> _pendingPeers;
    private final Map<Hash, Long> _pendingPeerTimes;
    private final Map<Hash, MessageWrapper.WrappedMessage> _pendingMessages;
    private final Set<Hash> _successfulPeers;
    private final Set<Hash> _attemptedPeers;
    private int _completeCount;
    private int _attempted;
    private volatile long _completed;
    private volatile long _started;

    public StoreState(RouterContext ctx, Hash key, DatabaseEntry data) {
        this(ctx, key, data, null);
    }

    public StoreState(RouterContext ctx, Hash key, DatabaseEntry data, Set<Hash> toSkip) {
        this._context = ctx;
        this._key = key;
        this._data = data;
        this._pendingPeers = new HashSet(4);
        this._pendingPeerTimes = new HashMap<Hash, Long>(4);
        this._pendingMessages = new ConcurrentHashMap<Hash, MessageWrapper.WrappedMessage>(4);
        this._attemptedPeers = toSkip != null ? toSkip : new HashSet<Hash>(8);
        this._successfulPeers = new HashSet<Hash>(4);
        this._completed = -1L;
        this._started = this._context.clock().now();
    }

    public Hash getTarget() {
        return this._key;
    }

    public DatabaseEntry getData() {
        return this._data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingCount() {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            return this._pendingPeers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getAttempted() {
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            return new HashSet<Hash>(this._attemptedPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttemptedCount() {
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            return this._attempted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash getSuccessful() {
        Set<Hash> set = this._successfulPeers;
        synchronized (set) {
            if (this._successfulPeers.isEmpty()) {
                return null;
            }
            try {
                return this._successfulPeers.iterator().next();
            }
            catch (NoSuchElementException nsee) {
                return null;
            }
        }
    }

    public boolean completed() {
        return this._completed != -1L;
    }

    public void complete(boolean completed) {
        if (completed && this._completed <= 0L) {
            this._completed = this._context.clock().now();
        }
    }

    public int getCompleteCount() {
        return this._completeCount;
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getWhenCompleted() {
        return this._completed;
    }

    public void addPending(Hash peer, MessageWrapper.WrappedMessage msg) {
        this.addPending(peer);
        this._pendingMessages.put(peer, msg);
    }

    public MessageWrapper.WrappedMessage getPendingMessage(Hash peer) {
        return this._pendingMessages.remove(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Hash peer) {
        Long now = this._context.clock().now();
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.add(peer);
            this._pendingPeerTimes.put(peer, now);
        }
        set = this._attemptedPeers;
        synchronized (set) {
            if (this._attemptedPeers.add(peer)) {
                ++this._attempted;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkipped(Hash peer) {
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long confirmed(Hash peer) {
        long rv = -1L;
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.remove(peer);
            Long when = this._pendingPeerTimes.remove(peer);
            if (when != null) {
                rv = this._context.clock().now() - when;
            }
        }
        set = this._successfulPeers;
        synchronized (set) {
            this._successfulPeers.add(peer);
        }
        ++this._completeCount;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyTimeout(Hash peer) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("Storing ").append(this._key);
        buf.append(' ');
        if (this._completed <= 0L) {
            buf.append(" completed? false ");
        } else {
            buf.append(" completed on ").append(new Date(this._completed));
        }
        buf.append(" Attempted: ").append(this._attempted).append(" Attempted+Skipped: ");
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            buf.append(this._attemptedPeers.size()).append(' ');
            for (Hash peer : this._attemptedPeers) {
                buf.append(peer.toBase64()).append(' ');
            }
        }
        buf.append(" Pending: ");
        set = this._pendingPeers;
        synchronized (set) {
            buf.append(this._pendingPeers.size()).append(' ');
            for (Hash peer : this._pendingPeers) {
                buf.append(peer.toBase64()).append(' ');
            }
        }
        buf.append(" Successful: ");
        set = this._successfulPeers;
        synchronized (set) {
            buf.append(this._successfulPeers.size()).append(' ');
            for (Hash peer : this._successfulPeers) {
                buf.append(peer.toBase64()).append(' ');
            }
        }
        return buf.toString();
    }
}

