/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.IterativeLookupJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.util.Log;

class IterativeLookupSelector
implements MessageSelector {
    private final RouterContext _context;
    private final IterativeSearchJob _search;
    private boolean _matchFound;
    private final Log _log;

    public IterativeLookupSelector(RouterContext ctx, IterativeSearchJob search) {
        this._context = ctx;
        this._search = search;
        this._log = ctx.logManager().getLog(this.getClass());
    }

    @Override
    public boolean continueMatching() {
        return !this._matchFound && this._context.clock().now() < this.getExpiration();
    }

    @Override
    public long getExpiration() {
        return this._matchFound ? -1L : this._search.getExpiration();
    }

    @Override
    public boolean isMatch(I2NPMessage message) {
        if (message == null) {
            return false;
        }
        int type = message.getType();
        if (type == 1) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
            if (this._search.getKey().equals(dsm.getKey())) {
                this._matchFound = true;
                if (this._log.shouldDebug()) {
                    this._log.debug(this._search.getJobId() + ": DSM match " + this);
                }
                return true;
            }
        } else if (type == 3) {
            DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
            if (this._search.getKey().equals(dsrm.getSearchKey())) {
                if (this._log.shouldDebug()) {
                    Hash from = dsrm.getFromHash();
                    this._log.debug(this._search.getJobId() + ": Processing DSRM via IterativeLookupJob, apparently from " + from + ' ' + this);
                }
                this._context.jobQueue().addJob(new IterativeLookupJob(this._context, dsrm, this._search));
            }
        }
        return false;
    }

    public String toString() {
        return "IL Selector for " + this._search.getKey();
    }
}

