/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class JobQueueRunner
extends I2PThread {
    private final Log _log;
    private final RouterContext _context;
    private volatile boolean _keepRunning;
    private final int _id;
    private volatile Job _currentJob;
    private volatile Job _lastJob;
    private volatile long _lastBegin;
    private volatile long _lastEnd;

    public JobQueueRunner(RouterContext context, int id) {
        this._context = context;
        this._id = id;
        this._keepRunning = true;
        this._log = this._context.logManager().getLog(JobQueueRunner.class);
        this.setPriority(6);
    }

    public Job getCurrentJob() {
        return this._currentJob;
    }

    public Job getLastJob() {
        return this._lastJob;
    }

    public int getRunnerId() {
        return this._id;
    }

    public void stopRunning() {
        this._keepRunning = false;
    }

    public void startRunning() {
        this._keepRunning = true;
    }

    public long getLastBegin() {
        return this._lastBegin;
    }

    public long getLastEnd() {
        return this._lastEnd;
    }

    @Override
    public void run() {
        long lastActive = this._context.clock().now();
        while (this._keepRunning && this._context.jobQueue().isAlive()) {
            try {
                Job job = this._context.jobQueue().getNext();
                if (job == null) {
                    if (!this._context.router().isAlive() || !this._log.shouldLog(40)) continue;
                    this._log.error("getNext returned null - dead?");
                    continue;
                }
                long now = this._context.clock().now();
                long enqueuedTime = 0L;
                if (job instanceof JobImpl) {
                    long when = ((JobImpl)job).getMadeReadyOn();
                    if (when <= 0L) {
                        this._log.error("Job was not made ready?! " + job, new Exception("Not made ready?!"));
                    } else {
                        enqueuedTime = now - when;
                    }
                }
                this._currentJob = job;
                this._lastJob = null;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Runner " + this._id + " running job " + job.getJobId() + ": " + job.getName());
                }
                long origStartAfter = job.getTiming().getStartAfter();
                long doStart = this._context.clock().now();
                job.getTiming().start();
                this.runCurrentJob();
                job.getTiming().end();
                long duration = job.getTiming().getActualEnd() - job.getTiming().getActualStart();
                long beforeUpdate = this._context.clock().now();
                this._context.jobQueue().updateStats(job, doStart, origStartAfter, duration);
                long diff = this._context.clock().now() - beforeUpdate;
                long lag = doStart - origStartAfter;
                if (lag < 0L) {
                    lag = 0L;
                }
                this._context.statManager().addRateData("jobQueue.jobRun", duration, duration);
                this._context.statManager().addRateData("jobQueue.jobLag", lag);
                this._context.statManager().addRateData("jobQueue.jobWait", enqueuedTime, enqueuedTime);
                if (duration > 1000L) {
                    this._context.statManager().addRateData("jobQueue.jobRunSlow", duration, duration);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Duration of " + duration + " (lag " + (doStart - origStartAfter) + ") on job " + this._currentJob);
                    }
                }
                if (diff > 100L && this._log.shouldLog(30)) {
                    this._log.warn("Updating statistics for the job took too long [" + diff + "ms]");
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Job duration " + duration + "ms for " + job.getName() + " with lag of " + (doStart - origStartAfter) + "ms");
                }
                lastActive = this._context.clock().now();
                this._lastJob = this._currentJob;
                this._currentJob = null;
                this._lastEnd = lastActive;
            }
            catch (Throwable t) {
                this._log.log(50, "error running?", t);
            }
        }
        if (this._context.router().isAlive()) {
            this._log.log(50, "Queue runner " + this._id + " exiting");
        }
        this._context.jobQueue().removeRunner(this._id);
    }

    private void runCurrentJob() {
        try {
            this._lastBegin = this._context.clock().now();
            this._currentJob.runJob();
        }
        catch (OutOfMemoryError oom) {
            try {
                if (SystemVersion.isAndroid()) {
                    this._context.router().shutdown(10);
                }
                this.fireOOM(oom);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            this._log.log(50, "Error processing job [" + this._currentJob.getName() + "] on thread " + this._id + ": " + t, t);
        }
    }
}

