/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TryCache<T> {
    private static final boolean DEBUG_DUP = false;
    private final ObjectFactory<T> factory;
    protected final int capacity;
    protected final List<T> items;
    protected final Lock lock = new ReentrantLock();
    protected long _lastUnderflow;

    public TryCache(ObjectFactory<T> factory, int capacity) {
        this.factory = factory;
        this.capacity = capacity;
        this.items = new ArrayList<T>(capacity);
    }

    public T acquire() {
        T rv = null;
        if (this.lock.tryLock()) {
            try {
                if (!this.items.isEmpty()) {
                    rv = this.items.remove(this.items.size() - 1);
                } else {
                    this._lastUnderflow = System.currentTimeMillis();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (rv == null) {
            rv = this.factory.newInstance();
        }
        return rv;
    }

    public void release(T item) {
        if (this.lock.tryLock()) {
            try {
                if (this.items.size() < this.capacity) {
                    this.items.add(item);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.items.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface ObjectFactory<T> {
        public T newInstance();
    }
}

