/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.provider;

import java.security.Provider;
import java.security.Security;

public final class I2PProvider
extends Provider {
    public static final String PROVIDER_NAME = "I2P";
    private static final String INFO = "I2P Security Provider v0.1, implementingseveral algorithms used by I2P.";
    private static boolean _installed;

    public I2PProvider() {
        super(PROVIDER_NAME, 0.1, INFO);
        this.setup();
    }

    private void setup() {
        this.put("MessageDigest.SHA-1", "net.i2p.crypto.SHA1");
        this.put("KeyFactory.EdDSA", "net.i2p.crypto.eddsa.KeyFactory");
        this.put("KeyPairGenerator.EdDSA", "net.i2p.crypto.eddsa.KeyPairGenerator");
        this.put("Signature.SHA512withEdDSA", "net.i2p.crypto.eddsa.EdDSAEngine");
        this.put("Alg.Alias.KeyFactory.1.3.101.100", "EdDSA");
        this.put("Alg.Alias.KeyFactory.OID.1.3.101.100", "EdDSA");
        this.put("Alg.Alias.KeyPairGenerator.1.3.101.100", "EdDSA");
        this.put("Alg.Alias.KeyPairGenerator.OID.1.3.101.100", "EdDSA");
        this.put("Alg.Alias.Signature.1.3.101.101", "SHA512withEdDSA");
        this.put("Alg.Alias.Signature.OID.1.3.101.101", "SHA512withEdDSA");
        this.put("Alg.Alias.KeyFactory.1.3.101.112", "EdDSA");
        this.put("Alg.Alias.KeyFactory.OID.1.3.101.112", "EdDSA");
        this.put("Alg.Alias.KeyPairGenerator.1.3.101.112", "EdDSA");
        this.put("Alg.Alias.KeyPairGenerator.OID.1.3.101.112", "EdDSA");
        this.put("Alg.Alias.Signature.1.3.101.112", "SHA512withEdDSA");
        this.put("Alg.Alias.Signature.OID.1.3.101.112", "SHA512withEdDSA");
        this.put("KeyFactory.DH", "net.i2p.crypto.elgamal.KeyFactory");
        this.put("KeyFactory.DiffieHellman", "net.i2p.crypto.elgamal.KeyFactory");
        this.put("KeyFactory.ElGamal", "net.i2p.crypto.elgamal.KeyFactory");
        this.put("KeyPairGenerator.DH", "net.i2p.crypto.elgamal.KeyPairGenerator");
        this.put("KeyPairGenerator.DiffieHellman", "net.i2p.crypto.elgamal.KeyPairGenerator");
        this.put("KeyPairGenerator.ElGamal", "net.i2p.crypto.elgamal.KeyPairGenerator");
        this.put("Signature.SHA256withElGamal", "net.i2p.crypto.elgamal.ElGamalSigEngine");
        this.put("Alg.Alias.KeyFactory.1.3.14.7.2.1.1", "ElGamal");
        this.put("Alg.Alias.KeyFactory.OID.1.3.14.7.2.1.1", "ElGamal");
        this.put("Alg.Alias.KeyPairGenerator.1.3.14.7.2.1.1", "ElGamal");
        this.put("Alg.Alias.KeyPairGenerator.OID.1.3.14.7.2.1.1", "ElGamal");
        this.put("Alg.Alias.Signature.1.3.14.7.2.1.1", "SHA256withElGamal");
        this.put("Alg.Alias.Signature.OID.1.3.14.7.2.1.1", "SHA256withElGamal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProvider() {
        Class<I2PProvider> clazz = I2PProvider.class;
        synchronized (I2PProvider.class) {
            if (!_installed) {
                try {
                    I2PProvider us = new I2PProvider();
                    Provider[] provs = Security.getProviders();
                    for (int i = 0; i < provs.length; ++i) {
                        if (!provs[i].getName().equals("BC")) continue;
                        Security.insertProviderAt(us, i);
                        _installed = true;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    Security.addProvider(us);
                    _installed = true;
                }
                catch (SecurityException se) {
                    System.out.println("WARN: Could not install I2P provider: " + se);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

