/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.math.BigInteger;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerLittleEndianEncoding;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerScalarOps;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public final class EdDSABlinding {
    private static final byte[] ONE = Utils.hexToBytes("0100000000000000000000000000000000000000000000000000000000000000");
    private static final Field FIELD = EdDSANamedCurveTable.getByName("Ed25519").getCurve().getField();
    public static final BigInteger ORDER = new BigInteger("2").pow(252).add(new BigInteger("27742317777372353535851937790883648493"));

    private EdDSABlinding() {
    }

    public static EdDSAPublicKey blind(EdDSAPublicKey key, EdDSAPrivateKey alpha) {
        GroupElement a = key.getA();
        GroupElement aa = alpha.getA();
        GroupElement d = a.add(aa.toCached());
        EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(d, key.getParams());
        EdDSAPublicKey rv = new EdDSAPublicKey(pubKey);
        return rv;
    }

    public static EdDSAPrivateKey blind(EdDSAPrivateKey key, EdDSAPrivateKey alpha) {
        byte[] a = key.geta();
        byte[] aa = alpha.geta();
        Field f = key.getParams().getCurve().getField();
        BigIntegerLittleEndianEncoding enc = new BigIntegerLittleEndianEncoding();
        enc.setField(f);
        BigIntegerScalarOps sc = new BigIntegerScalarOps(f, ORDER);
        byte[] d = sc.multiplyAndAdd(ONE, a, aa);
        EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(d, null, key.getParams());
        return new EdDSAPrivateKey(privKey);
    }

    public static EdDSAPrivateKey unblind(EdDSAPrivateKey key, EdDSAPrivateKey alpha) {
        throw new UnsupportedOperationException();
    }

    public static byte[] reduce(byte[] b) {
        if (b.length != 64) {
            throw new IllegalArgumentException("Must be 64 bytes");
        }
        BigIntegerScalarOps sc = new BigIntegerScalarOps(FIELD, ORDER);
        return sc.reduce(b);
    }
}

