/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#include "ukuitaskbarplugin.h"

UKUITaskBarPlugin::UKUITaskBarPlugin(const IUKUIPanelPluginStartupInfo &startupInfo):
    QObject(),
    IUKUIPanelPlugin(startupInfo)
{
    translator();
    m_taskBar = new UKUITaskBar(this);
}


UKUITaskBarPlugin::~UKUITaskBarPlugin()
{
    delete m_taskBar;
}

void UKUITaskBarPlugin::realign()
{
    m_taskBar->realign();
}

void UKUITaskBarPlugin::translator()
{
    QTranslator *translator = new QTranslator(this);
    translator->load(QLocale(), "taskbar", "_", TASKBAR_TRANSLATION_DIR);
    QCoreApplication::installTranslator(translator);
}
