/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#include "alwaysdisplayonpanel.h"
#include <QtDebug>

AlwaysDisplayonPanel::AlwaysDisplayonPanel(QWidget *parent) : QFrame(parent)
{
    this->setMinimumSize(QSize(550, 0));
    this->setMaximumSize(QSize(16777215, 16777215));
    this->setFrameShape(QFrame::Box);

    m_alwaysDisplayonPanelLayout = new QVBoxLayout(this);
    m_alwaysDisplayonPanelLayout->setContentsMargins(0, 0, 0, 0);
    m_alwaysDisplayonPanelLayout->setSpacing(0);

    displayTaskview();
    panelBtnDisplayChanged();


}

void AlwaysDisplayonPanel::setFrame_Noframe(QFrame *frame)
{
    frame->setMinimumSize(QSize(550, 60));
    frame->setMaximumSize(QSize(16777215, 60));
    frame->setFrameShape(QFrame::NoFrame);
}

void AlwaysDisplayonPanel::displayTaskview()
{
    m_taskviewDisplayFrame = new QFrame(this);
    setFrame_Noframe(m_taskviewDisplayFrame);

    m_taskviewDisplayLayout = new QHBoxLayout(m_taskviewDisplayFrame);
    m_taskviewDisplayLayout->setContentsMargins(16, 0, 16, 0);

    m_taskviewDisplayLabel = new QLabel(m_taskviewDisplayFrame);
    m_taskviewDisplayLabel->setText(tr("Show Taskview"));

    m_taskviewDisplayBtn = new KSwitchButton(m_taskviewDisplayFrame);
    m_taskviewDisplayBtn->setObjectName("taskview");
    m_taskviewDisplayBtn->setFixedSize(48,24);

    m_taskviewDisplayLayout->addWidget(m_taskviewDisplayLabel);
    m_taskviewDisplayLayout->addWidget(m_taskviewDisplayBtn);
    m_alwaysDisplayonPanelLayout->addWidget(m_taskviewDisplayFrame);
}

void AlwaysDisplayonPanel::panelBtnDisplayChanged()
{
    const QByteArray id(UKUI_PANEL_SETTINGS);
    if(QGSettings::isSchemaInstalled(id)) {
        m_panelSettings = new QGSettings(id);
        m_taskviewDisplayBtn->setChecked(m_panelSettings->get(SHOW_TASKVIEW).toBool());
        connect(m_panelSettings, &QGSettings::changed, this, [=] (const QString &key) {
            if (key == SHOW_TASKVIEW) {
                m_taskviewDisplayBtn->setChecked(m_panelSettings->get(SHOW_TASKVIEW).toBool());
            }
        });
    }
    connect(m_taskviewDisplayBtn, &KSwitchButton::stateChanged, [=](bool checked) {
        m_panelSettings->set(SHOW_TASKVIEW,checked);
    });
}
