% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X2_modcomp.R
\name{x2__modcomp}
\alias{x2__modcomp}
\alias{X2modcomp}
\alias{X2modcomp.default}
\title{Chisq test}
\usage{
X2modcomp(largeModel, smallModel, betaH = 0, details = 0, ...)

\method{X2modcomp}{default}(largeModel, smallModel, betaH = 0, details = 0, ...)
}
\arguments{
\item{largeModel}{An \code{lmer} model}

\item{smallModel}{An \code{lmer} model or a restriction matrix}

\item{betaH}{A number or a vector of the beta of the hypothesis,
e.g. L beta=L betaH. If \code{smallModel} is a model object then betaH=0.}

\item{details}{If larger than 0 some timing details are printed.}

\item{...}{Additional arguments, currently not used.}
}
\description{
Chisq test
}
\details{
TBW
}
\author{
Ulrich Halekoh \email{uhalekoh@health.sdu.dk}, Søren Højsgaard
\email{sorenh@math.aau.dk}

(fm0 <- lmer(Reaction ~ (Days|Subject), sleepstudy))
(fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
(fm2 <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy))
\subsection{Test for no effect of Days in fm1, i.e. test fm0 under fm1}{

X2modcomp(fm1, "Days")
X2modcomp(fm1, ~.-Days)
L1 <- cbind(0, 1)
X2modcomp(fm1, L1) ## FIXME
X2modcomp(fm1, fm0)
anova(fm1, fm0)
}
}
\concept{model_comparison}
