% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaqc.R
\docType{package}
\name{oaqc}
\alias{oaqc}
\alias{oaqc-package}
\alias{oaqc}
\title{Orbit-aware Quad Census computation}
\usage{
oaqc(graph, non_ind_freq = F, file = "")
}
\arguments{
\item{graph}{A matrix, data.frame or graph object.}

\item{non_ind_freq}{A flag indicating whether non-induced frequencies have to be returned or not.}

\item{file}{Name (and location) of the file to be written.}
}
\value{
orbit-aware quad census on a node and edge level. Consult
\code{vignette('oaqc')} to see the correspondence between orbit and quad.
}
\description{
Calculates the orbit-aware quad census on an edge and node level, see
\code{vignette('oaqc')}.
}
\examples{
k4 <- data.frame(
  source = c(0, 0, 0, 1, 1, 2),
  target = c(1, 2, 3, 2, 3, 3)
)

k4orbits <- oaqc(k4, non_ind_freq = TRUE)
print(k4orbits)
}
