/*	test_Size_Limits

CVS ID: test_Size_Limits.java,v 1.3 2012/04/16 06:23:00 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Viewers.Size_Limits;
import	PIRL.Utilities.Integer_Range;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.JLabel;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.event.ComponentListener;
import	java.awt.event.ComponentEvent;


public class test_Size_Limits
	extends JFrame
	implements ComponentListener
{
private static JLabel
	Limits_Width_Label,
	Limits_Height_Label,
	Component_Width_Label,
	Component_Height_Label;


public test_Size_Limits ()
{
super ("test_Size_Limits");
addComponentListener (this);

JPanel
	panel = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

//	Limits:
location.fill		= GridBagConstraints.NONE;
location.anchor		= GridBagConstraints.EAST;
location.insets		= new Insets (10, 10, 5, 0);
panel.add (new JLabel ("Limits - Width:"), location);

location.anchor		= GridBagConstraints.WEST;
location.insets		= new Insets (10, 5, 5, 0);
panel.add (Limits_Width_Label, location);

location.anchor		= GridBagConstraints.EAST;
location.insets		= new Insets (10, 10, 5, 0);
panel.add (new JLabel ("Height: "), location);

location.gridwidth	= GridBagConstraints.REMAINDER;
location.anchor		= GridBagConstraints.WEST;
location.insets		= new Insets (10, 5, 5, 10);
panel.add (Limits_Height_Label, location);

//	Component:
location.gridwidth	= 1;
location.anchor		= GridBagConstraints.EAST;
location.insets		= new Insets (0, 10, 10, 0);
panel.add (new JLabel ("Component Size:"), location);

location.anchor		= GridBagConstraints.WEST;
location.insets		= new Insets (0, 5, 10, 0);
panel.add (Component_Width_Label =
	new JLabel (String.valueOf (getWidth ())), location);

location.anchor		= GridBagConstraints.EAST;
location.insets		= new Insets (0, 10, 10, 0);
panel.add (new JLabel (), location);

location.gridwidth	= GridBagConstraints.REMAINDER;
location.anchor		= GridBagConstraints.WEST;
location.insets		= new Insets (0, 5, 10, 10);
panel.add (Component_Height_Label =
	new JLabel (String.valueOf (getHeight ())), location);

setContentPane (panel);
setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
pack ();
}


public void componentResized
	(
	ComponentEvent	event
	)
{
System.out.println (" Resized to: "
	+ event.getComponent ().getWidth () + "x"
	+ event.getComponent ().getHeight ());
Component_Width_Label.setText
	(String.valueOf (event.getComponent ().getWidth ()));
Component_Height_Label.setText
	(String.valueOf (event.getComponent ().getHeight ()));
}

public void componentMoved (ComponentEvent event) {}
public void componentShown (ComponentEvent event) {}
public void componentHidden (ComponentEvent event) {}



public static void main (String[] args)
{
Integer_Range
	width_limits = null,
	height_limits = null;

for (int
		index = 0;
		index < args.length;
		index++)
	{
	if (args[index].length () > 1 &&
		args[index].charAt (0) == '-')
		{
		switch (args[index].toUpperCase ().charAt (1))
			{
			case 'W':
				if (++index == args.length ||
					args[index].length () == 0)
					{
					System.out.println ("Missing limits for " + args[--index]);
					Usage ();
					}
				width_limits = Limits (args[index]);
				break;

			case 'H':
				if (++index == args.length ||
					args[index].length () == 0)
					{
					System.out.println ("Missing limits for " + args[--index]);
					Usage ();
					}
				height_limits = Limits (args[index]);
				break;

			default:
				System.out.println ("Unknown argument: " + args[index]);
				Usage ();
			}
		}
	else
		{
		System.out.println ("Unknown argument: " + args[index]);
		Usage ();
		}
	}

if (width_limits == null)
	width_limits = new Integer_Range (0, Long.MAX_VALUE);
if (height_limits == null)
	height_limits = new Integer_Range (0, Long.MAX_VALUE);

Limits_Width_Label  = new JLabel (width_limits.toString ());
Limits_Height_Label = new JLabel (height_limits.toString ());

test_Size_Limits
	test = new test_Size_Limits ();
test.addComponentListener (new Size_Limits (width_limits, height_limits));

test.setVisible (true);
}


public static Integer_Range Limits
	(
	String	limits
	)
{
int
	min = 0,
	max = 0,
	index = limits.indexOf ('-');
String
	value;
if (index == 0)
	{
	System.out.println
		("Missing min value in " + limits + " limits.");
	Usage ();
	}
if (index > 0)
	value = limits.substring (0, index);
else
	value = limits;

try {min = Integer.parseInt (value);}
catch (NumberFormatException exception)
	{
	System.out.println
		("Invalid limits: " + limits);
	Usage ();
	}

if (index > 0 &&
	++index < limits.length ())
	{
	try {max = Integer.parseInt (limits.substring (index));}
	catch (NumberFormatException exception)
		{
		System.out.println
			("Invalid limits: " + limits);
		Usage ();
		}
	}
else
	max = min;

return new Integer_Range (min, max);
}


public static void Usage ()
{
System.out.println
	("Usage: test_Size_Limits [-Width <min>[-<max>]] [-Height <min>[-<max>]]");
System.exit (1);
}


}
