///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/viewport/Window3DContainer.h>
#include <core/viewport/Window3D.h>
#include <core/utilities/PathManager.h>

namespace Core {

/******************************************************************************
* The constructor of the 3d window container class.
******************************************************************************/
Window3DContainer::Window3DContainer(QWidget* parent)
	: QWidget(parent)
{
}


/******************************************************************************
* Returns the list of 3d windows in this container.
******************************************************************************/
QList<Window3D*> Window3DContainer::windows() const
{
	return findChildren<Window3D*>();
}

/******************************************************************************
* Returns true if one of the windows in this container is currently in
* being rendered.
******************************************************************************/
bool Window3DContainer::isRendering() const
{
	Q_FOREACH(Window3D* win, windows())
		if(win->isRendering()) return true;

	return false;
}

};
