/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class ASTUtility {
    public static String sourceInformation(ASTNode node) {
        CompilationUnit compilationUnit = ASTUtility.compilationUnitFor(node);
        return ASTUtility.sourceInformation(compilationUnit, node);
    }

    public static String sourceInformation(CompilationUnit compilationUnit, ASTNode node) {
        return String.valueOf(ASTUtility.compilationUnitPath(compilationUnit)) + ":" + ASTUtility.lineNumber(compilationUnit, node);
    }

    private static CompilationUnit compilationUnitFor(ASTNode node) {
        return ASTUtility.ancestorOf(node, CompilationUnit.class);
    }

    public static <T extends ASTNode> T ancestorOf(ASTNode node, Class<T> ancestorType) {
        ASTNode parent = node.getParent();
        do {
            if (!ancestorType.isInstance(parent)) continue;
            return (T)parent;
        } while ((parent = parent.getParent()) != null);
        throw new IllegalArgumentException(node + " has no ancestor of type " + ancestorType.getName());
    }

    public static String compilationUnitPath(CompilationUnit ast) {
        IJavaElement element = ast.getJavaElement();
        if (element == null) {
            return "<unknown>";
        }
        return element.getResource().getFullPath().toPortableString();
    }

    public static int lineNumber(CompilationUnit ast, ASTNode node) {
        return ast.lineNumber(node.getStartPosition());
    }

    public static void checkForProblems(CompilationUnit ast, boolean throwOnError) {
        if (ASTUtility.dumpProblemsToStdErr(ast) && throwOnError) {
            throw new RuntimeException("'" + ASTUtility.compilationUnitPath(ast) + "' has errors, check stderr for details.");
        }
    }

    private static void dumpProblem(IProblem problem) {
        System.err.print(problem.getOriginatingFileName());
        System.err.println("(" + problem.getSourceLineNumber() + "): " + problem.getMessage());
    }

    private static boolean dumpProblemsToStdErr(CompilationUnit ast) {
        boolean hasErrors = false;
        IProblem[] iProblemArray = ast.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                ASTUtility.dumpProblem(problem);
                hasErrors = true;
            }
            ++n2;
        }
        return hasErrors;
    }
}

