/* 
 * Copyright (c) 2005 Brian Tarricone <bjt23@cornell.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "xfce-widget-helpers.h"


/**
 * xfce_create_framebox:
 * @title: Title text for the frame, or %NULL
 * @frame_bin: Container for frame's children
 *
 * Creates an Xfce-styled frame, similar to the old deprecated #XfceFramebox
 * widget.  The frame is a #GtkFrame, with no shadow/border and an optional
 * bolded text label.  The contents of the frame are indented on the left.
 * The return value is the GtkFrame itself.  The frame_bin is a GtkAlignment
 * widget to which children of the frame should be added.
 *
 * Return value: A #GtkFrame.
 *
 * Since 4.3
 */
GtkWidget *
xfce_create_framebox(const gchar *title,
                     GtkWidget **frame_bin)
{
    GtkWidget *framebox;

    g_return_val_if_fail(frame_bin, NULL);

    framebox = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(framebox), GTK_SHADOW_NONE);
    gtk_frame_set_label_align(GTK_FRAME(framebox), 0.0, 1.0);
    gtk_widget_show(framebox);

    if(title) {
        gchar *tmp = g_strdup_printf("<b>%s</b>", title);
        GtkWidget *label = gtk_label_new(tmp);
        gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
        gtk_widget_show(label);
        gtk_frame_set_label_widget(GTK_FRAME(framebox), label);
        g_free(tmp);
    }

    *frame_bin = gtk_alignment_new(0.0, 0.0, 1.0, 1.0);
    gtk_alignment_set_padding(GTK_ALIGNMENT(*frame_bin), 5, 5, 21, 5);
    gtk_widget_show(*frame_bin);
    gtk_container_add(GTK_CONTAINER(framebox), *frame_bin);

    return framebox;
}

/**
 * xfce_create_framebox_with_content:
 * @title: Title text for the frame, or %NULL
 * @content: #GtkWidget to put inside the frame
 *
 * Creates an Xfce-styled frame, similar to the old deprecated #XfceFramebox
 * widget.  The frame is a #GtkFrame, with no shadow/border and an optional
 * bolded text label.  The contents of the frame are indented on the left.
 * The return value is the GtkFrame itself. The contents are put
*  as child of the frame.
 *
 * Return value: A #GtkFrame.
 *
 * Since 4.3
 */
GtkWidget* 
xfce_create_framebox_with_content (const gchar *title, GtkWidget *content)
{
  GtkWidget* bin1;
  GtkWidget* outer1;
      
  outer1 = xfce_create_framebox (title, &bin1);
  
  gtk_container_add (GTK_CONTAINER (bin1), content);
        
  return outer1;
}

