// Copyright Filippo Rusconi, GPLv3+

/////////////////////// StdLib includes
#include <limits>


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "../../core/types.h"
#include "pappsomspp/core/utils.h"
#include "pappsomspp/export-import-config.h"


#pragma once

namespace pappso
{

struct PMSPP_LIB_DECL ColorMapPlotConfig
{
  Enums::DataKind xAxisDataKind = Enums::DataKind::unset;
  Enums::DataKind yAxisDataKind = Enums::DataKind::unset;

  Enums::AxisScale xAxisScale = Enums::AxisScale::orig;
  Enums::AxisScale yAxisScale = Enums::AxisScale::orig;
  Enums::AxisScale zAxisScale = Enums::AxisScale::orig;

  std::size_t keyCellCount = 0;
  std::size_t mzCellCount  = 0;

  double lastMinZFilterThresholdPercentage = 0.0;
  double lastMaxZFilterThresholdPercentage = 0.0;

  double minKeyValue = std::numeric_limits<double>::max();
  double maxKeyValue = std::numeric_limits<double>::min();

  double minMzValue = std::numeric_limits<double>::max();
  double maxMzValue = std::numeric_limits<double>::max();

  double origMinZValue = std::numeric_limits<double>::max();
  double lastMinZValue = std::numeric_limits<double>::max();

  double origMaxZValue = std::numeric_limits<double>::min();
  double lastMaxZValue = std::numeric_limits<double>::min();

  ColorMapPlotConfig();

  ColorMapPlotConfig(const ColorMapPlotConfig &other);

  ColorMapPlotConfig(Enums::DataKind x_axis_data_kind,
                     Enums::DataKind y_axis_data_kind,

                     Enums::AxisScale x_axis_scale,
                     Enums::AxisScale y_axis_scale,
                     Enums::AxisScale z_axis_scale,

                     std::size_t key_cell_count,
                     std::size_t mz_cell_count,

                     double min_key_value,
                     double max_key_value,

                     double min_mz_value,
                     double max_mz_value,

                     double orig_min_z_value,
                     double orig_max_z_value);

  ColorMapPlotConfig &operator=(const ColorMapPlotConfig &other);

  void setOrigMinZValue(double value);
  void setOrigAndLastMinZValue(double value);

  void setOrigMaxZValue(double value);
  void setOrigAndLastMaxZValue(double value);

  QString toString() const;
};


} // namespace pappso
