; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i32 @test_or_fshl(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_or_fshl(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], [[C]]
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[B]], [[D]]
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.fshl.i32(i32 [[TMP1]], i32 [[TMP2]], i32 [[SH]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  %val2 = call i32 @llvm.fshl.i32(i32 %c, i32 %d, i32 %sh)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_and_fshl(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_and_fshl(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A]], [[C]]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[B]], [[D]]
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.fshl.i32(i32 [[TMP1]], i32 [[TMP2]], i32 [[SH]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  %val2 = call i32 @llvm.fshl.i32(i32 %c, i32 %d, i32 %sh)
  %ret = and i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_xor_fshl(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_xor_fshl(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[A]], [[C]]
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[B]], [[D]]
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.fshl.i32(i32 [[TMP1]], i32 [[TMP2]], i32 [[SH]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  %val2 = call i32 @llvm.fshl.i32(i32 %c, i32 %d, i32 %sh)
  %ret = xor i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_fshr(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_or_fshr(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], [[C]]
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[B]], [[D]]
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.fshr.i32(i32 [[TMP1]], i32 [[TMP2]], i32 [[SH]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshr.i32(i32 %a, i32 %b, i32 %sh)
  %val2 = call i32 @llvm.fshr.i32(i32 %c, i32 %d, i32 %sh)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_fshl_cascade(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: define i32 @test_or_fshl_cascade(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[A]], [[B]]
; CHECK-NEXT:    [[TMP3:%.*]] = or i32 [[TMP1]], [[C]]
; CHECK-NEXT:    [[TMP4:%.*]] = or i32 [[TMP2]], [[C]]
; CHECK-NEXT:    [[OR2:%.*]] = call i32 @llvm.fshl.i32(i32 [[TMP3]], i32 [[TMP4]], i32 24)
; CHECK-NEXT:    ret i32 [[OR2]]
;
  %fshl1 = call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 24)
  %fshl2 = call i32 @llvm.fshl.i32(i32 %b, i32 %b, i32 24)
  %fshl3 = call i32 @llvm.fshl.i32(i32 %c, i32 %c, i32 24)
  %or1 = or i32 %fshl1, %fshl2
  %or2 = or i32 %or1, %fshl3
  ret i32 %or2
}
define i32 @test_or_bitreverse(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_or_bitreverse(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], [[B]]
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.bitreverse.i32(i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %val2 = call i32 @llvm.bitreverse.i32(i32 %b)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_bitreverse_constant(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_or_bitreverse_constant(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], 255
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.bitreverse.i32(i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %ret = or i32 %val1, 4278190080
  ret i32 %ret
}
define i32 @test_or_bswap(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_or_bswap(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], [[B]]
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.bswap.i32(i32 %a)
  %val2 = call i32 @llvm.bswap.i32(i32 %b)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_bswap_constant(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_or_bswap_constant(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[A]], 255
; CHECK-NEXT:    [[RET:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.bswap.i32(i32 %a)
  %ret = or i32 %val1, 4278190080
  ret i32 %ret
}

; Negative tests

define i32 @test_or_fshl_fshr(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_or_fshl_fshr(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.fshl.i32(i32 [[A]], i32 [[B]], i32 [[SH]])
; CHECK-NEXT:    [[VAL2:%.*]] = call i32 @llvm.fshr.i32(i32 [[C]], i32 [[D]], i32 [[SH]])
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[VAL1]], [[VAL2]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  %val2 = call i32 @llvm.fshr.i32(i32 %c, i32 %d, i32 %sh)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_bitreverse_bswap(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_or_bitreverse_bswap(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.bitreverse.i32(i32 [[A]])
; CHECK-NEXT:    [[VAL2:%.*]] = call i32 @llvm.bswap.i32(i32 [[B]])
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[VAL1]], [[VAL2]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %val2 = call i32 @llvm.bswap.i32(i32 %b)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_fshl_mismatched_shamt(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh1, i32 %sh2) {
; CHECK-LABEL: define i32 @test_or_fshl_mismatched_shamt(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH1:%.*]], i32 [[SH2:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.fshl.i32(i32 [[A]], i32 [[B]], i32 [[SH1]])
; CHECK-NEXT:    [[VAL2:%.*]] = call i32 @llvm.fshl.i32(i32 [[C]], i32 [[D]], i32 [[SH2]])
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[VAL1]], [[VAL2]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh1)
  %val2 = call i32 @llvm.fshl.i32(i32 %c, i32 %d, i32 %sh2)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_add_fshl(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_add_fshl(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.fshl.i32(i32 [[A]], i32 [[B]], i32 [[SH]])
; CHECK-NEXT:    [[VAL2:%.*]] = call i32 @llvm.fshl.i32(i32 [[C]], i32 [[D]], i32 [[SH]])
; CHECK-NEXT:    [[RET:%.*]] = add i32 [[VAL1]], [[VAL2]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  %val2 = call i32 @llvm.fshl.i32(i32 %c, i32 %d, i32 %sh)
  %ret = add i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_fshl_multiuse(i32 %a, i32 %b, i32 %c, i32 %d, i32 %sh) {
; CHECK-LABEL: define i32 @test_or_fshl_multiuse(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]], i32 [[D:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.fshl.i32(i32 [[A]], i32 [[B]], i32 [[SH]])
; CHECK-NEXT:    call void @use(i32 [[VAL1]])
; CHECK-NEXT:    [[VAL2:%.*]] = call i32 @llvm.fshl.i32(i32 [[C]], i32 [[D]], i32 [[SH]])
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[VAL1]], [[VAL2]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  call void @use(i32 %val1)
  %val2 = call i32 @llvm.fshl.i32(i32 %c, i32 %d, i32 %sh)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_bitreverse_multiuse(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_or_bitreverse_multiuse(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.bitreverse.i32(i32 [[A]])
; CHECK-NEXT:    call void @use(i32 [[VAL1]])
; CHECK-NEXT:    [[VAL2:%.*]] = call i32 @llvm.bitreverse.i32(i32 [[B]])
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[VAL1]], [[VAL2]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.bitreverse.i32(i32 %a)
  call void @use(i32 %val1)
  %val2 = call i32 @llvm.bitreverse.i32(i32 %b)
  %ret = or i32 %val1, %val2
  ret i32 %ret
}
define i32 @test_or_fshl_constant(i32 %a, i32 %b, i32 %sh) {
; CHECK-LABEL: define i32 @test_or_fshl_constant(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[SH:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = call i32 @llvm.fshl.i32(i32 [[A]], i32 [[B]], i32 [[SH]])
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[VAL1]], -16777216
; CHECK-NEXT:    ret i32 [[RET]]
;
  %val1 = call i32 @llvm.fshl.i32(i32 %a, i32 %b, i32 %sh)
  %ret = or i32 %val1, 4278190080
  ret i32 %ret
}

declare void @use(i32)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i32 @llvm.fshr.i32(i32, i32, i32)
declare i32 @llvm.bitreverse.i32(i32)
declare i32 @llvm.bswap.i32(i32)
