# Kotlin Test

Module `kotlin-test` is used by the [Kotlin/JS](https://kotlinlang.org/docs/tutorials/javascript/kotlin-to-javascript/kotlin-to-javascript.html)
compiler output for performing assertions in tests, independently of the test framework being used. 

The library includes out-of-the-box support for [Jasmine](https://jasmine.github.io/), 
[Mocha](https://mochajs.org/), [Jest](https://facebook.github.io/jest/),
and [QUnit](https://qunitjs.com).

Try out the [examples](https://github.com/JetBrains/kotlin-examples/tree/master/gradle/js-tests),
read the [forum post](https://discuss.kotlinlang.org/t/unit-testing-in-kotlin-js/3943)
and the [library documentation](https://kotlinlang.org/api/latest/kotlin.test/kotlin.test/index.html) 
for more information.

## Handy links

 * [Kotlin Site](https://kotlinlang.org/)
 * [Getting Started Guide](https://kotlinlang.org/docs/tutorials/javascript/getting-started-idea/getting-started-with-intellij-idea.html)
 * [Try Kotlin](https://try.kotlinlang.org/)
 * [Kotlin Standard Library](https://kotlinlang.org/api/latest/jvm/stdlib/index.html)
 * [Issue Tracker](https://youtrack.jetbrains.com/issues/KT)
 * [Forum](https://discuss.kotlinlang.org/)
 * [Kotlin Blog](https://blog.jetbrains.com/kotlin/)
 * [Follow Kotlin on Twitter](https://twitter.com/kotlin)
 * [Public Slack channel](https://slack.kotlinlang.org/)
 * [TeamCity CI build](https://teamcity.jetbrains.com/project.html?tab=projectOverview&projectId=Kotlin)

## Editing Kotlin

 * [Kotlin IntelliJ IDEA Plugin](https://kotlinlang.org/docs/tutorials/getting-started.html)
 * [Kotlin Eclipse Plugin](https://kotlinlang.org/docs/tutorials/getting-started-eclipse.html)
 * [Kotlin TextMate Bundle](https://github.com/vkostyukov/kotlin-sublime-package)
