#include <stdio.h>
#include <string.h>
#include "conf.h"
#include "dir.h"
#include "err.h"
#include "mem.h"
#include "queue.h"
#include "tui.h"


int main (int argc, char **argv)
{
  int i, j, tree;
  struct CONFIG cfg = {0};
  struct DIR_INFO dinfo = {0};
  struct QUEUE queue = {0};
  struct TUI tui = {0};
  
  if (argc<2) {
    printf ("usage: juke <directory> [[directory]..]\n");
    exit (ERROR);
  }
  config_load (&cfg);
  
  tree = 0;
  for (i=1;i<argc;i++) {
    j = strlen (argv[i]);
    if (argv[i][j-1] == '/')
      argv[i][j-1] = 0;
    if (dir_recurse (&dinfo, &cfg, argv[i], tree) == E_OK)
      tree++;
  }
  if (!tree) {
    fprintf (stderr, "error: No valid directories specified\n");
    exit (ERROR);
  }
  dinfo.trees = tree;
  queue_init (&queue, &dinfo);
  
  tui.cfg = &cfg;
  tui.dinfo = &dinfo;
  tui.queue = &queue;
  tui_start (&tui);
  
  return E_OK;
}
