/* Generated by JTB 1.4.10 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.syntaxtree.*;
import java.util.*;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "Ret" visitors extend this class and override part or all of these methods.
 *
 * @param <R> - The user return information type
 */
public class DepthFirstRetVisitor<R> implements IRetVisitor<R> {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeChoice n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    final R nRes = n.choice.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeList n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      @SuppressWarnings("unused")
      final R sRes = e.next().accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeListOptional n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    if (n.present()) {
      R nRes = null;
      for (final Iterator<INode> e = n.elements(); e.hasNext();) {
        @SuppressWarnings("unused")
        R sRes = e.next().accept(this);
        }
      return nRes;
    } else
      return null;
  }

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeOptional n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    if (n.present()) {
      final R nRes = n.node.accept(this);
      return nRes;
    } else
      return null;
  }

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeSequence n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      @SuppressWarnings("unused")
      R subRet = e.next().accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link NodeTCF} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeTCF n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return nRes;
  }

  /**
   * Visits a {@link NodeToken} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeToken n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return nRes;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link JavaCCInput} node, whose children are the following :
   * <p>
   * f0 -> JavaCCOptions()<br>
   * f1 -> "PARSER_BEGIN"<br>
   * f2 -> "("<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> ")"<br>
   * f5 -> CompilationUnit()<br>
   * f6 -> "PARSER_END"<br>
   * f7 -> "("<br>
   * f8 -> IdentifierAsString()<br>
   * f9 -> ")"<br>
   * f10 -> ( Production() )+<br>
   * f11 -> <EOF><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final JavaCCInput n) {
    R nRes = null;
    // f0 -> JavaCCOptions()
    final JavaCCOptions n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "PARSER_BEGIN"
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> CompilationUnit()
    final CompilationUnit n5 = n.f5;
    nRes = n5.accept(this);
    // f6 -> "PARSER_END"
    final NodeToken n6 = n.f6;
    nRes = n6.accept(this);
    // f7 -> "("
    final NodeToken n7 = n.f7;
    nRes = n7.accept(this);
    // f8 -> IdentifierAsString()
    final IdentifierAsString n8 = n.f8;
    nRes = n8.accept(this);
    // f9 -> ")"
    final NodeToken n9 = n.f9;
    nRes = n9.accept(this);
    // f10 -> ( Production() )+
    final NodeList n10 = n.f10;
    for (int i = 0; i < n10.size(); i++) {
      final INode n10Ei = n10.elementAt(i);
      nRes = n10Ei.accept(this);
    }
    // f11 -> <EOF>
    final NodeToken n11 = n.f11;
    nRes = n11.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link JavaCCOptions} node, whose child is the following :
   * <p>
   * f0 -> [ #0 "options" #1 "{"<br>
   * .. .. . #2 ( OptionBinding() )*<br>
   * .. .. . #3 "}" ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final JavaCCOptions n) {
    R nRes = null;
    // f0 -> [ #0 "options" #1 "{"
    // .. .. . #2 ( OptionBinding() )*
    // .. .. . #3 "}" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence n0S = (NodeSequence) n0.node;
      // #0 "options"
      final INode n0SA0 = n0S.elementAt(0);
      nRes = n0SA0.accept(this);
      // #1 "{"
      final INode n0SA1 = n0S.elementAt(1);
      nRes = n0SA1.accept(this);
      // #2 ( OptionBinding() )*
      final INode n0SA2 = n0S.elementAt(2);
      final NodeListOptional n0SA2T = (NodeListOptional) n0SA2;
      if (n0SA2T.present()) {
        for (int i = 0; i < n0SA2T.size(); i++) {
          final INode n0SA2TMi = n0SA2T.elementAt(i);
          nRes = n0SA2TMi.accept(this);
        }
      }
      // #3 "}"
      final INode n0SA3 = n0S.elementAt(3);
      nRes = n0SA3.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link OptionBinding} node, whose children are the following :
   * <p>
   * f0 -> ( %0 <IDENTIFIER><br>
   * .. .. | %1 "LOOKAHEAD"<br>
   * .. .. | %2 "IGNORE_CASE"<br>
   * .. .. | %3 "static" )<br>
   * f1 -> "="<br>
   * f2 -> ( %0 IntegerLiteral()<br>
   * .. .. | %1 BooleanLiteral()<br>
   * .. .. | %2 StringLiteral() )<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final OptionBinding n) {
    R nRes = null;
    // f0 -> ( %0 <IDENTIFIER>
    // .. .. | %1 "LOOKAHEAD"
    // .. .. | %2 "IGNORE_CASE"
    // .. .. | %3 "static" )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 <IDENTIFIER>
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 "LOOKAHEAD"
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 "IGNORE_CASE"
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 "static"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f1 -> "="
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 IntegerLiteral()
    // .. .. | %1 BooleanLiteral()
    // .. .. | %2 StringLiteral() )
    final NodeChoice n2 = n.f2;
    final NodeChoice n2C = n2;
    final INode n2CH = n2C.choice;
    switch (n2C.which) {
      case 0:
        // %0 IntegerLiteral()
        nRes = n2CH.accept(this);
        break;
      case 1:
        // %1 BooleanLiteral()
        nRes = n2CH.accept(this);
        break;
      case 2:
        // %2 StringLiteral()
        nRes = n2CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Production} node, whose child is the following :
   * <p>
   * f0 -> . %0 JavaCodeProduction()<br>
   * .. .. | %1 RegularExprProduction()<br>
   * .. .. | %2 TokenManagerDecls()<br>
   * .. .. | %3 BNFProduction()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Production n) {
    R nRes = null;
    // f0 -> . %0 JavaCodeProduction()
    // .. .. | %1 RegularExprProduction()
    // .. .. | %2 TokenManagerDecls()
    // .. .. | %3 BNFProduction()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 JavaCodeProduction()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 RegularExprProduction()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 TokenManagerDecls()
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 BNFProduction()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link JavaCodeProduction} node, whose children are the following :
   * <p>
   * f0 -> "JAVACODE"<br>
   * f1 -> AccessModifier()<br>
   * f2 -> ResultType()<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> FormalParameters()<br>
   * f5 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f6 -> [ "%" ]<br>
   * f7 -> Block()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final JavaCodeProduction n) {
    R nRes = null;
    // f0 -> "JAVACODE"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> AccessModifier()
    final AccessModifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ResultType()
    final ResultType n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> FormalParameters()
    final FormalParameters n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence n5S = (NodeSequence) n5.node;
      // #0 "throws"
      final INode n5SA0 = n5S.elementAt(0);
      nRes = n5SA0.accept(this);
      // #1 Name()
      final INode n5SA1 = n5S.elementAt(1);
      nRes = n5SA1.accept(this);
      // #2 ( $0 "," $1 Name() )*
      final INode n5SA2 = n5S.elementAt(2);
      final NodeListOptional n5SA2T = (NodeListOptional) n5SA2;
      if (n5SA2T.present()) {
        for (int i = 0; i < n5SA2T.size(); i++) {
          final INode n5SA2TMi = n5SA2T.elementAt(i);
          final NodeSequence n5SA2TMiS1 = (NodeSequence) n5SA2TMi;
          // $0 ","
          final INode n5SA2TMiS1A0 = n5SA2TMiS1.elementAt(0);
          nRes = n5SA2TMiS1A0.accept(this);
          // $1 Name()
          final INode n5SA2TMiS1A1 = n5SA2TMiS1.elementAt(1);
          nRes = n5SA2TMiS1A1.accept(this);
        }
      }
    }
    // f6 -> [ "%" ]
    final NodeOptional n6 = n.f6;
    if (n6.present()) {
      nRes = n6.accept(this);
    }
    // f7 -> Block()
    final Block n7 = n.f7;
    nRes = n7.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BNFProduction} node, whose children are the following :
   * <p>
   * f0 -> AccessModifier()<br>
   * f1 -> ResultType()<br>
   * f2 -> IdentifierAsString()<br>
   * f3 -> FormalParameters()<br>
   * f4 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f5 -> [ "!" ]<br>
   * f6 -> ":"<br>
   * f7 -> Block()<br>
   * f8 -> "{"<br>
   * f9 -> ExpansionChoices()<br>
   * f10 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final BNFProduction n) {
    R nRes = null;
    // f0 -> AccessModifier()
    final AccessModifier n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> IdentifierAsString()
    final IdentifierAsString n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> FormalParameters()
    final FormalParameters n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence n4S = (NodeSequence) n4.node;
      // #0 "throws"
      final INode n4SA0 = n4S.elementAt(0);
      nRes = n4SA0.accept(this);
      // #1 Name()
      final INode n4SA1 = n4S.elementAt(1);
      nRes = n4SA1.accept(this);
      // #2 ( $0 "," $1 Name() )*
      final INode n4SA2 = n4S.elementAt(2);
      final NodeListOptional n4SA2T = (NodeListOptional) n4SA2;
      if (n4SA2T.present()) {
        for (int i = 0; i < n4SA2T.size(); i++) {
          final INode n4SA2TMi = n4SA2T.elementAt(i);
          final NodeSequence n4SA2TMiS1 = (NodeSequence) n4SA2TMi;
          // $0 ","
          final INode n4SA2TMiS1A0 = n4SA2TMiS1.elementAt(0);
          nRes = n4SA2TMiS1A0.accept(this);
          // $1 Name()
          final INode n4SA2TMiS1A1 = n4SA2TMiS1.elementAt(1);
          nRes = n4SA2TMiS1A1.accept(this);
        }
      }
    }
    // f5 -> [ "!" ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      nRes = n5.accept(this);
    }
    // f6 -> ":"
    final NodeToken n6 = n.f6;
    nRes = n6.accept(this);
    // f7 -> Block()
    final Block n7 = n.f7;
    nRes = n7.accept(this);
    // f8 -> "{"
    final NodeToken n8 = n.f8;
    nRes = n8.accept(this);
    // f9 -> ExpansionChoices()
    final ExpansionChoices n9 = n.f9;
    nRes = n9.accept(this);
    // f10 -> "}"
    final NodeToken n10 = n.f10;
    nRes = n10.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AccessModifier} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "public"<br>
   * .. .. | %1 "protected"<br>
   * .. .. | %2 "private"<br>
   * .. .. | %3 "final" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AccessModifier n) {
    R nRes = null;
    // f0 -> ( %0 "public"
    // .. .. | %1 "protected"
    // .. .. | %2 "private"
    // .. .. | %3 "final" )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode n0Mi = n0.elementAt(i);
        final NodeChoice n0MiC = (NodeChoice) n0Mi;
        final INode n0MiCH = n0MiC.choice;
        switch (n0MiC.which) {
          case 0:
            // %0 "public"
            nRes = n0MiCH.accept(this);
            break;
          case 1:
            // %1 "protected"
            nRes = n0MiCH.accept(this);
            break;
          case 2:
            // %2 "private"
            nRes = n0MiCH.accept(this);
            break;
          case 3:
            // %3 "final"
            nRes = n0MiCH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link RegularExprProduction} node, whose children are the following :
   * <p>
   * f0 -> [ %0 #0 "<" #1 "*" #2 ">"<br>
   * .. .. | %1 #0 "<" #1 <IDENTIFIER><br>
   * .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*<br>
   * .. .. . .. #3 ">" ]<br>
   * f1 -> RegExprKind()<br>
   * f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]<br>
   * f3 -> ":"<br>
   * f4 -> "{"<br>
   * f5 -> RegExprSpec()<br>
   * f6 -> ( #0 "|" #1 RegExprSpec() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RegularExprProduction n) {
    R nRes = null;
    // f0 -> [ %0 #0 "<" #1 "*" #2 ">"
    // .. .. | %1 #0 "<" #1 <IDENTIFIER>
    // .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*
    // .. .. . .. #3 ">" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeChoice n0C = (NodeChoice) n0.node;
      final INode n0CH = n0C.choice;
      switch (n0C.which) {
        case 0:
          // %0 #0 "<" #1 "*" #2 ">"
          final NodeSequence n0CHS = (NodeSequence) n0CH;
          // #0 "<"
          final INode n0CHS0A0 = n0CHS.elementAt(0);
          nRes = n0CHS0A0.accept(this);
          // #1 "*"
          final INode n0CHS0A1 = n0CHS.elementAt(1);
          nRes = n0CHS0A1.accept(this);
          // #2 ">"
          final INode n0CHS0A2 = n0CHS.elementAt(2);
          nRes = n0CHS0A2.accept(this);
          break;
        case 1:
          // %1 #0 "<" #1 <IDENTIFIER>
          // .. #2 ( $0 "," $1 <IDENTIFIER> )*
          // .. #3 ">"
          final NodeSequence n0CHS1 = (NodeSequence) n0CH;
          // #0 "<"
          final INode n0CHS11A0 = n0CHS1.elementAt(0);
          nRes = n0CHS11A0.accept(this);
          // #1 <IDENTIFIER>
          final INode n0CHS11A1 = n0CHS1.elementAt(1);
          nRes = n0CHS11A1.accept(this);
          // #2 ( $0 "," $1 <IDENTIFIER> )*
          final INode n0CHS11A2 = n0CHS1.elementAt(2);
          final NodeListOptional n0CHS11A2T = (NodeListOptional) n0CHS11A2;
          if (n0CHS11A2T.present()) {
            for (int i = 0; i < n0CHS11A2T.size(); i++) {
              final INode n0CHS11A2TMi = n0CHS11A2T.elementAt(i);
              final NodeSequence n0CHS11A2TMiS2 = (NodeSequence) n0CHS11A2TMi;
              // $0 ","
              final INode n0CHS11A2TMiS2A0 = n0CHS11A2TMiS2.elementAt(0);
              nRes = n0CHS11A2TMiS2A0.accept(this);
              // $1 <IDENTIFIER>
              final INode n0CHS11A2TMiS2A1 = n0CHS11A2TMiS2.elementAt(1);
              nRes = n0CHS11A2TMiS2A1.accept(this);
            }
          }
          // #3 ">"
          final INode n0CHS1A3 = n0CHS1.elementAt(3);
          nRes = n0CHS1A3.accept(this);
          break;
        default:
          // should not occur !!!
          break;
      }
    }
    // f1 -> RegExprKind()
    final RegExprKind n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence n2S3 = (NodeSequence) n2.node;
      // #0 "["
      final INode n2S3A0 = n2S3.elementAt(0);
      nRes = n2S3A0.accept(this);
      // #1 "IGNORE_CASE"
      final INode n2S3A1 = n2S3.elementAt(1);
      nRes = n2S3A1.accept(this);
      // #2 "]"
      final INode n2S3A2 = n2S3.elementAt(2);
      nRes = n2S3A2.accept(this);
    }
    // f3 -> ":"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> RegExprSpec()
    final RegExprSpec n5 = n.f5;
    nRes = n5.accept(this);
    // f6 -> ( #0 "|" #1 RegExprSpec() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode n6Mi = n6.elementAt(i);
        final NodeSequence n6MiS4 = (NodeSequence) n6Mi;
        // #0 "|"
        final INode n6MiS4A0 = n6MiS4.elementAt(0);
        nRes = n6MiS4A0.accept(this);
        // #1 RegExprSpec()
        final INode n6MiS4A1 = n6MiS4.elementAt(1);
        nRes = n6MiS4A1.accept(this);
      }
    }
    // f7 -> "}"
    final NodeToken n7 = n.f7;
    nRes = n7.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TokenManagerDecls} node, whose children are the following :
   * <p>
   * f0 -> "TOKEN_MGR_DECLS"<br>
   * f1 -> ":"<br>
   * f2 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TokenManagerDecls n) {
    R nRes = null;
    // f0 -> "TOKEN_MGR_DECLS"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ":"
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link RegExprKind} node, whose child is the following :
   * <p>
   * f0 -> . %0 "TOKEN"<br>
   * .. .. | %1 "SPECIAL_TOKEN"<br>
   * .. .. | %2 "SKIP"<br>
   * .. .. | %3 "MORE"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RegExprKind n) {
    R nRes = null;
    // f0 -> . %0 "TOKEN"
    // .. .. | %1 "SPECIAL_TOKEN"
    // .. .. | %2 "SKIP"
    // .. .. | %3 "MORE"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "TOKEN"
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 "SPECIAL_TOKEN"
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 "SKIP"
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 "MORE"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link RegExprSpec} node, whose children are the following :
   * <p>
   * f0 -> RegularExpression()<br>
   * f1 -> [ "!" ]<br>
   * f2 -> [ Block() ]<br>
   * f3 -> [ #0 ":" #1 <IDENTIFIER> ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RegExprSpec n) {
    R nRes = null;
    // f0 -> RegularExpression()
    final RegularExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ "!" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> [ Block() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ #0 ":" #1 <IDENTIFIER> ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 ":"
      final INode n3SA0 = n3S.elementAt(0);
      nRes = n3SA0.accept(this);
      // #1 <IDENTIFIER>
      final INode n3SA1 = n3S.elementAt(1);
      nRes = n3SA1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ExpansionChoices} node, whose children are the following :
   * <p>
   * f0 -> Expansion()<br>
   * f1 -> ( #0 "|" #1 Expansion() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ExpansionChoices n) {
    R nRes = null;
    // f0 -> Expansion()
    final Expansion n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "|" #1 Expansion() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "|"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 Expansion()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link Expansion} node, whose children are the following :
   * <p>
   * f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?<br>
   * f1 -> ( ExpansionUnit() )+<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Expansion n) {
    R nRes = null;
    // f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence n0S = (NodeSequence) n0.node;
      // #0 "LOOKAHEAD"
      final INode n0SA0 = n0S.elementAt(0);
      nRes = n0SA0.accept(this);
      // #1 "("
      final INode n0SA1 = n0S.elementAt(1);
      nRes = n0SA1.accept(this);
      // #2 LocalLookahead()
      final INode n0SA2 = n0S.elementAt(2);
      nRes = n0SA2.accept(this);
      // #3 ")"
      final INode n0SA3 = n0S.elementAt(3);
      nRes = n0SA3.accept(this);
    }
    // f1 -> ( ExpansionUnit() )+
    final NodeList n1 = n.f1;
    for (int i = 0; i < n1.size(); i++) {
      final INode n1Ei = n1.elementAt(i);
      nRes = n1Ei.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link LocalLookahead} node, whose children are the following :
   * <p>
   * f0 -> [ IntegerLiteral() ]<br>
   * f1 -> [ "," ]<br>
   * f2 -> [ ExpansionChoices() ]<br>
   * f3 -> [ "," ]<br>
   * f4 -> [ #0 "{" #1 Expression() #2 "}" ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final LocalLookahead n) {
    R nRes = null;
    // f0 -> [ IntegerLiteral() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> [ "," ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> [ ExpansionChoices() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> [ #0 "{" #1 Expression() #2 "}" ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence n4S = (NodeSequence) n4.node;
      // #0 "{"
      final INode n4SA0 = n4S.elementAt(0);
      nRes = n4SA0.accept(this);
      // #1 Expression()
      final INode n4SA1 = n4S.elementAt(1);
      nRes = n4SA1.accept(this);
      // #2 "}"
      final INode n4SA2 = n4S.elementAt(2);
      nRes = n4SA2.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ExpansionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"<br>
   * .. .. | %1 Block()<br>
   * .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"<br>
   * .. .. | %3 ExpansionUnitTCF()<br>
   * .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]<br>
   * .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()<br>
   * .. .. . .. .. . .. $2 [ "!" ]<br>
   * .. .. . .. .. | &1 $0 RegularExpression()<br>
   * .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]<br>
   * .. .. . .. .. . .. $2 [ "!" ] )<br>
   * .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?" )?<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ExpansionUnit n) {
    R nRes = null;
    // f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
    // .. .. | %1 Block()
    // .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"
    // .. .. | %3 ExpansionUnitTCF()
    // .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]
    // .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
    // .. .. . .. .. . .. $2 [ "!" ]
    // .. .. . .. .. | &1 $0 RegularExpression()
    // .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
    // .. .. . .. .. . .. $2 [ "!" ] )
    // .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?" )?
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "LOOKAHEAD"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 "("
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        // #2 LocalLookahead()
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        nRes = n0CHS0A2.accept(this);
        // #3 ")"
        final INode n0CHS0A3 = n0CHS.elementAt(3);
        nRes = n0CHS0A3.accept(this);
        break;
      case 1:
        // %1 Block()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 #0 "[" #1 ExpansionChoices() #2 "]"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "["
        final INode n0CHS12A0 = n0CHS1.elementAt(0);
        nRes = n0CHS12A0.accept(this);
        // #1 ExpansionChoices()
        final INode n0CHS12A1 = n0CHS1.elementAt(1);
        nRes = n0CHS12A1.accept(this);
        // #2 "]"
        final INode n0CHS12A2 = n0CHS1.elementAt(2);
        nRes = n0CHS12A2.accept(this);
        break;
      case 3:
        // %3 ExpansionUnitTCF()
        nRes = n0CH.accept(this);
        break;
      case 4:
        // %4 #0 [ $0 PrimaryExpression() $1 "=" ]
        // .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        // .. .. .. $2 [ "!" ]
        // .. .. | &1 $0 RegularExpression()
        // .. .. .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
        // .. .. .. $2 [ "!" ] )
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 [ $0 PrimaryExpression() $1 "=" ]
        final INode n0CHS24A0 = n0CHS2.elementAt(0);
        final NodeOptional n0CHS24A0P = (NodeOptional) n0CHS24A0;
        if (n0CHS24A0P.present()) {
          final NodeSequence n0CHS24A0PS3 = (NodeSequence) n0CHS24A0P.node;
          // $0 PrimaryExpression()
          final INode n0CHS24A0PS3A0 = n0CHS24A0PS3.elementAt(0);
          nRes = n0CHS24A0PS3A0.accept(this);
          // $1 "="
          final INode n0CHS24A0PS3A1 = n0CHS24A0PS3.elementAt(1);
          nRes = n0CHS24A0PS3A1.accept(this);
        }
        // #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        // .. .. $2 [ "!" ]
        // .. | &1 $0 RegularExpression()
        // .. .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
        // .. .. $2 [ "!" ] )
        final INode n0CHS2A1 = n0CHS2.elementAt(1);
        final NodeChoice n0CHS2A1C = (NodeChoice) n0CHS2A1;
        final INode n0CHS2A1CH = n0CHS2A1C.choice;
        switch (n0CHS2A1C.which) {
          case 0:
            // &0 $0 IdentifierAsString() $1 Arguments()
            // .. $2 [ "!" ]
            final NodeSequence n0CHS2A1CHS4 = (NodeSequence) n0CHS2A1CH;
            // $0 IdentifierAsString()
            final INode n0CHS2A1CHS40A0 = n0CHS2A1CHS4.elementAt(0);
            nRes = n0CHS2A1CHS40A0.accept(this);
            // $1 Arguments()
            final INode n0CHS2A1CHS40A1 = n0CHS2A1CHS4.elementAt(1);
            nRes = n0CHS2A1CHS40A1.accept(this);
            // $2 [ "!" ]
            final INode n0CHS2A1CHS40A2 = n0CHS2A1CHS4.elementAt(2);
            final NodeOptional n0CHS2A1CHS40A2P = (NodeOptional) n0CHS2A1CHS40A2;
            if (n0CHS2A1CHS40A2P.present()) {
              nRes = n0CHS2A1CHS40A2P.accept(this);
            }
            break;
          case 1:
            // &1 $0 RegularExpression()
            // .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
            // .. $2 [ "!" ]
            final NodeSequence n0CHS2A1CHS5 = (NodeSequence) n0CHS2A1CH;
            // $0 RegularExpression()
            final INode n0CHS2A1CHS51A0 = n0CHS2A1CHS5.elementAt(0);
            nRes = n0CHS2A1CHS51A0.accept(this);
            // $1 [ ?0 "." ?1 <IDENTIFIER> ]
            final INode n0CHS2A1CHS51A1 = n0CHS2A1CHS5.elementAt(1);
            final NodeOptional n0CHS2A1CHS51A1P = (NodeOptional) n0CHS2A1CHS51A1;
            if (n0CHS2A1CHS51A1P.present()) {
              final NodeSequence n0CHS2A1CHS51A1PS6 = (NodeSequence) n0CHS2A1CHS51A1P.node;
              // ?0 "."
              final INode n0CHS2A1CHS51A1PS6A0 = n0CHS2A1CHS51A1PS6.elementAt(0);
              nRes = n0CHS2A1CHS51A1PS6A0.accept(this);
              // ?1 <IDENTIFIER>
              final INode n0CHS2A1CHS51A1PS6A1 = n0CHS2A1CHS51A1PS6.elementAt(1);
              nRes = n0CHS2A1CHS51A1PS6A1.accept(this);
            }
            // $2 [ "!" ]
            final INode n0CHS2A1CHS5A2 = n0CHS2A1CHS5.elementAt(2);
            final NodeOptional n0CHS2A1CHS5A2P = (NodeOptional) n0CHS2A1CHS5A2;
            if (n0CHS2A1CHS5A2P.present()) {
              nRes = n0CHS2A1CHS5A2P.accept(this);
            }
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 5:
        // %5 #0 "(" #1 ExpansionChoices() #2 ")"
        // .. #3 ( &0 "+"
        // .. .. | &1 "*"
        // .. .. | &2 "?" )?
        final NodeSequence n0CHS7 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS75A0 = n0CHS7.elementAt(0);
        nRes = n0CHS75A0.accept(this);
        // #1 ExpansionChoices()
        final INode n0CHS75A1 = n0CHS7.elementAt(1);
        nRes = n0CHS75A1.accept(this);
        // #2 ")"
        final INode n0CHS75A2 = n0CHS7.elementAt(2);
        nRes = n0CHS75A2.accept(this);
        // #3 ( &0 "+"
        // .. | &1 "*"
        // .. | &2 "?" )?
        final INode n0CHS75A3 = n0CHS7.elementAt(3);
        final NodeOptional n0CHS75A3P = (NodeOptional) n0CHS75A3;
        if (n0CHS75A3P.present()) {
          final NodeChoice n0CHS75A3PC = (NodeChoice) n0CHS75A3P.node;
          final INode n0CHS75A3PCH = n0CHS75A3PC.choice;
          switch (n0CHS75A3PC.which) {
            case 0:
              // &0 "+"
              nRes = n0CHS75A3PCH.accept(this);
              break;
            case 1:
              // &1 "*"
              nRes = n0CHS75A3PCH.accept(this);
              break;
            case 2:
              // &2 "?"
              nRes = n0CHS75A3PCH.accept(this);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ExpansionUnitTCF} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> "{"<br>
   * f2 -> ExpansionChoices()<br>
   * f3 -> "}"<br>
   * f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*<br>
   * f5 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ExpansionUnitTCF n) {
    R nRes = null;
    // f0 -> "try"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "{"
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ExpansionChoices()
    final ExpansionChoices n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> "}"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*
    final NodeListOptional n4 = n.f4;
    if (n4.present()) {
      for (int i = 0; i < n4.size(); i++) {
        final INode n4Mi = n4.elementAt(i);
        final NodeSequence n4MiS = (NodeSequence) n4Mi;
        // #0 "catch"
        final INode n4MiSA0 = n4MiS.elementAt(0);
        nRes = n4MiSA0.accept(this);
        // #1 "("
        final INode n4MiSA1 = n4MiS.elementAt(1);
        nRes = n4MiSA1.accept(this);
        // #2 Name()
        final INode n4MiSA2 = n4MiS.elementAt(2);
        nRes = n4MiSA2.accept(this);
        // #3 <IDENTIFIER>
        final INode n4MiSA3 = n4MiS.elementAt(3);
        nRes = n4MiSA3.accept(this);
        // #4 ")"
        final INode n4MiSA4 = n4MiS.elementAt(4);
        nRes = n4MiSA4.accept(this);
        // #5 Block()
        final INode n4MiSA5 = n4MiS.elementAt(5);
        nRes = n4MiSA5.accept(this);
      }
    }
    // f5 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence n5S1 = (NodeSequence) n5.node;
      // #0 "finally"
      final INode n5S1A0 = n5S1.elementAt(0);
      nRes = n5S1A0.accept(this);
      // #1 Block()
      final INode n5S1A1 = n5S1.elementAt(1);
      nRes = n5S1A1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link RegularExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<"<br>
   * .. .. . .. #1 [ $0 [ "#" ]<br>
   * .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]<br>
   * .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"<br>
   * .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %3 #0 "<" #1 "EOF" #2 ">"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RegularExpression n) {
    R nRes = null;
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<"
    // .. .. . .. #1 [ $0 [ "#" ]
    // .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]
    // .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"
    // .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %3 #0 "<" #1 "EOF" #2 ">"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 StringLiteral()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 #0 "<"
        // .. #1 [ $0 [ "#" ]
        // .. .. . $1 IdentifierAsString() $2 ":" ]
        // .. #2 ComplexRegularExpressionChoices() #3 ">"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        nRes = n0CHS1A0.accept(this);
        // #1 [ $0 [ "#" ]
        // .. . $1 IdentifierAsString() $2 ":" ]
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeOptional n0CHS1A1P = (NodeOptional) n0CHS1A1;
        if (n0CHS1A1P.present()) {
          final NodeSequence n0CHS1A1PS1 = (NodeSequence) n0CHS1A1P.node;
          // $0 [ "#" ]
          final INode n0CHS1A1PS1A0 = n0CHS1A1PS1.elementAt(0);
          final NodeOptional n0CHS1A1PS1A0P = (NodeOptional) n0CHS1A1PS1A0;
          if (n0CHS1A1PS1A0P.present()) {
            nRes = n0CHS1A1PS1A0P.accept(this);
          }
          // $1 IdentifierAsString()
          final INode n0CHS1A1PS1A1 = n0CHS1A1PS1.elementAt(1);
          nRes = n0CHS1A1PS1A1.accept(this);
          // $2 ":"
          final INode n0CHS1A1PS1A2 = n0CHS1A1PS1.elementAt(2);
          nRes = n0CHS1A1PS1A2.accept(this);
        }
        // #2 ComplexRegularExpressionChoices()
        final INode n0CHSA2 = n0CHS.elementAt(2);
        nRes = n0CHSA2.accept(this);
        // #3 ">"
        final INode n0CHSA3 = n0CHS.elementAt(3);
        nRes = n0CHSA3.accept(this);
        break;
      case 2:
        // %2 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS22A0 = n0CHS2.elementAt(0);
        nRes = n0CHS22A0.accept(this);
        // #1 IdentifierAsString()
        final INode n0CHS22A1 = n0CHS2.elementAt(1);
        nRes = n0CHS22A1.accept(this);
        // #2 ">"
        final INode n0CHS22A2 = n0CHS2.elementAt(2);
        nRes = n0CHS22A2.accept(this);
        break;
      case 3:
        // %3 #0 "<" #1 "EOF" #2 ">"
        final NodeSequence n0CHS3 = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS33A0 = n0CHS3.elementAt(0);
        nRes = n0CHS33A0.accept(this);
        // #1 "EOF"
        final INode n0CHS33A1 = n0CHS3.elementAt(1);
        nRes = n0CHS33A1.accept(this);
        // #2 ">"
        final INode n0CHS33A2 = n0CHS3.elementAt(2);
        nRes = n0CHS33A2.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpressionChoices} node, whose children are the following :
   * <p>
   * f0 -> ComplexRegularExpression()<br>
   * f1 -> ( #0 "|" #1 ComplexRegularExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ComplexRegularExpressionChoices n) {
    R nRes = null;
    // f0 -> ComplexRegularExpression()
    final ComplexRegularExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "|" #1 ComplexRegularExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "|"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 ComplexRegularExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpression} node, whose child is the following :
   * <p>
   * f0 -> ( ComplexRegularExpressionUnit() )+<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ComplexRegularExpression n) {
    R nRes = null;
    // f0 -> ( ComplexRegularExpressionUnit() )+
    final NodeList n0 = n.f0;
    for (int i = 0; i < n0.size(); i++) {
      final INode n0Ei = n0.elementAt(i);
      nRes = n0Ei.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpressionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %2 CharacterList()<br>
   * .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?"<br>
   * .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()<br>
   * .. .. . .. .. . .. $2 [ ?0 ","<br>
   * .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]<br>
   * .. .. . .. .. . .. $3 "}" )?<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ComplexRegularExpressionUnit n) {
    R nRes = null;
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %2 CharacterList()
    // .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?"
    // .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()
    // .. .. . .. .. . .. $2 [ ?0 ","
    // .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]
    // .. .. . .. .. . .. $3 "}" )?
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 StringLiteral()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        nRes = n0CHS1A0.accept(this);
        // #1 IdentifierAsString()
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        nRes = n0CHS1A1.accept(this);
        // #2 ">"
        final INode n0CHS1A2 = n0CHS.elementAt(2);
        nRes = n0CHS1A2.accept(this);
        break;
      case 2:
        // %2 CharacterList()
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
        // .. #3 ( &0 "+"
        // .. .. | &1 "*"
        // .. .. | &2 "?"
        // .. .. | &3 $0 "{" $1 IntegerLiteral()
        // .. .. .. $2 [ ?0 ","
        // .. .. .. .. . ?1 [ IntegerLiteral() ] ]
        // .. .. .. $3 "}" )?
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS13A0 = n0CHS1.elementAt(0);
        nRes = n0CHS13A0.accept(this);
        // #1 ComplexRegularExpressionChoices()
        final INode n0CHS13A1 = n0CHS1.elementAt(1);
        nRes = n0CHS13A1.accept(this);
        // #2 ")"
        final INode n0CHS13A2 = n0CHS1.elementAt(2);
        nRes = n0CHS13A2.accept(this);
        // #3 ( &0 "+"
        // .. | &1 "*"
        // .. | &2 "?"
        // .. | &3 $0 "{" $1 IntegerLiteral()
        // .. .. $2 [ ?0 ","
        // .. .. .. . ?1 [ IntegerLiteral() ] ]
        // .. .. $3 "}" )?
        final INode n0CHS13A3 = n0CHS1.elementAt(3);
        final NodeOptional n0CHS13A3P = (NodeOptional) n0CHS13A3;
        if (n0CHS13A3P.present()) {
          final NodeChoice n0CHS13A3PC = (NodeChoice) n0CHS13A3P.node;
          final INode n0CHS13A3PCH = n0CHS13A3PC.choice;
          switch (n0CHS13A3PC.which) {
            case 0:
              // &0 "+"
              nRes = n0CHS13A3PCH.accept(this);
              break;
            case 1:
              // &1 "*"
              nRes = n0CHS13A3PCH.accept(this);
              break;
            case 2:
              // &2 "?"
              nRes = n0CHS13A3PCH.accept(this);
              break;
            case 3:
              // &3 $0 "{" $1 IntegerLiteral()
              // .. $2 [ ?0 ","
              // .. .. . ?1 [ IntegerLiteral() ] ]
              // .. $3 "}"
              final NodeSequence n0CHS13A3PCHS2 = (NodeSequence) n0CHS13A3PCH;
              // $0 "{"
              final INode n0CHS13A3PCHS23A0 = n0CHS13A3PCHS2.elementAt(0);
              nRes = n0CHS13A3PCHS23A0.accept(this);
              // $1 IntegerLiteral()
              final INode n0CHS13A3PCHS23A1 = n0CHS13A3PCHS2.elementAt(1);
              nRes = n0CHS13A3PCHS23A1.accept(this);
              // $2 [ ?0 ","
              // .. . ?1 [ IntegerLiteral() ] ]
              final INode n0CHS13A3PCHS23A2 = n0CHS13A3PCHS2.elementAt(2);
              final NodeOptional n0CHS13A3PCHS23A2P = (NodeOptional) n0CHS13A3PCHS23A2;
              if (n0CHS13A3PCHS23A2P.present()) {
                final NodeSequence n0CHS13A3PCHS23A2PS3 = (NodeSequence) n0CHS13A3PCHS23A2P.node;
                // ?0 ","
                final INode n0CHS13A3PCHS23A2PS3A0 = n0CHS13A3PCHS23A2PS3.elementAt(0);
                nRes = n0CHS13A3PCHS23A2PS3A0.accept(this);
                // ?1 [ IntegerLiteral() ]
                final INode n0CHS13A3PCHS23A2PS3A1 = n0CHS13A3PCHS23A2PS3.elementAt(1);
                final NodeOptional n0CHS13A3PCHS23A2PS3A1P = (NodeOptional) n0CHS13A3PCHS23A2PS3A1;
                if (n0CHS13A3PCHS23A2PS3A1P.present()) {
                  nRes = n0CHS13A3PCHS23A2PS3A1P.accept(this);
                }
              }
              // $3 "}"
              final INode n0CHS13A3PCHS2A3 = n0CHS13A3PCHS2.elementAt(3);
              nRes = n0CHS13A3PCHS2A3.accept(this);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link CharacterList} node, whose children are the following :
   * <p>
   * f0 -> [ "~" ]<br>
   * f1 -> "["<br>
   * f2 -> [ #0 CharacterDescriptor()<br>
   * .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]<br>
   * f3 -> "]"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final CharacterList n) {
    R nRes = null;
    // f0 -> [ "~" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> "["
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ #0 CharacterDescriptor()
    // .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence n2S = (NodeSequence) n2.node;
      // #0 CharacterDescriptor()
      final INode n2SA0 = n2S.elementAt(0);
      nRes = n2SA0.accept(this);
      // #1 ( $0 "," $1 CharacterDescriptor() )*
      final INode n2SA1 = n2S.elementAt(1);
      final NodeListOptional n2SA1T = (NodeListOptional) n2SA1;
      if (n2SA1T.present()) {
        for (int i = 0; i < n2SA1T.size(); i++) {
          final INode n2SA1TMi = n2SA1T.elementAt(i);
          final NodeSequence n2SA1TMiS1 = (NodeSequence) n2SA1TMi;
          // $0 ","
          final INode n2SA1TMiS1A0 = n2SA1TMiS1.elementAt(0);
          nRes = n2SA1TMiS1A0.accept(this);
          // $1 CharacterDescriptor()
          final INode n2SA1TMiS1A1 = n2SA1TMiS1.elementAt(1);
          nRes = n2SA1TMiS1A1.accept(this);
        }
      }
    }
    // f3 -> "]"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link CharacterDescriptor} node, whose children are the following :
   * <p>
   * f0 -> StringLiteral()<br>
   * f1 -> [ #0 "-" #1 StringLiteral() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final CharacterDescriptor n) {
    R nRes = null;
    // f0 -> StringLiteral()
    final StringLiteral n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "-" #1 StringLiteral() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "-"
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 StringLiteral()
      final INode n1SA1 = n1S.elementAt(1);
      nRes = n1SA1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link IdentifierAsString} node, whose child is the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final IdentifierAsString n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link JavaIdentifier} node, whose child is the following :
   * <p>
   * f0 -> ( %00 <IDENTIFIER><br>
   * .. .. | %01 "LOOKAHEAD"<br>
   * .. .. | %02 "IGNORE_CASE"<br>
   * .. .. | %03 "PARSER_BEGIN"<br>
   * .. .. | %04 "PARSER_END"<br>
   * .. .. | %05 "JAVACODE"<br>
   * .. .. | %06 "TOKEN"<br>
   * .. .. | %07 "SPECIAL_TOKEN"<br>
   * .. .. | %08 "MORE"<br>
   * .. .. | %09 "SKIP"<br>
   * .. .. | %10 "TOKEN_MGR_DECLS"<br>
   * .. .. | %11 "EOF" )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final JavaIdentifier n) {
    R nRes = null;
    // f0 -> ( %00 <IDENTIFIER>
    // .. .. | %01 "LOOKAHEAD"
    // .. .. | %02 "IGNORE_CASE"
    // .. .. | %03 "PARSER_BEGIN"
    // .. .. | %04 "PARSER_END"
    // .. .. | %05 "JAVACODE"
    // .. .. | %06 "TOKEN"
    // .. .. | %07 "SPECIAL_TOKEN"
    // .. .. | %08 "MORE"
    // .. .. | %09 "SKIP"
    // .. .. | %10 "TOKEN_MGR_DECLS"
    // .. .. | %11 "EOF" )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %00 <IDENTIFIER>
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %01 "LOOKAHEAD"
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %02 "IGNORE_CASE"
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %03 "PARSER_BEGIN"
        nRes = n0CH.accept(this);
        break;
      case 4:
        // %04 "PARSER_END"
        nRes = n0CH.accept(this);
        break;
      case 5:
        // %05 "JAVACODE"
        nRes = n0CH.accept(this);
        break;
      case 6:
        // %06 "TOKEN"
        nRes = n0CH.accept(this);
        break;
      case 7:
        // %07 "SPECIAL_TOKEN"
        nRes = n0CH.accept(this);
        break;
      case 8:
        // %08 "MORE"
        nRes = n0CH.accept(this);
        break;
      case 9:
        // %09 "SKIP"
        nRes = n0CH.accept(this);
        break;
      case 10:
        // %10 "TOKEN_MGR_DECLS"
        nRes = n0CH.accept(this);
        break;
      case 11:
        // %11 "EOF"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link CompilationUnit} node, whose children are the following :
   * <p>
   * f0 -> [ PackageDeclaration() ]<br>
   * f1 -> ( ImportDeclaration() )*<br>
   * f2 -> ( TypeDeclaration() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final CompilationUnit n) {
    R nRes = null;
    // f0 -> [ PackageDeclaration() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> ( ImportDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        nRes = n1Mi.accept(this);
      }
    }
    // f2 -> ( TypeDeclaration() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        nRes = n2Mi.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link PackageDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "package"<br>
   * f1 -> Name()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PackageDeclaration n) {
    R nRes = null;
    // f0 -> "package"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ImportDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "import"<br>
   * f1 -> [ "static" ]<br>
   * f2 -> Name()<br>
   * f3 -> [ #0 "." #1 "*" ]<br>
   * f4 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ImportDeclaration n) {
    R nRes = null;
    // f0 -> "import"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ "static" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> Name()
    final Name n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ #0 "." #1 "*" ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 "."
      final INode n3SA0 = n3S.elementAt(0);
      nRes = n3SA0.accept(this);
      // #1 "*"
      final INode n3SA1 = n3S.elementAt(1);
      nRes = n3SA1.accept(this);
    }
    // f4 -> ";"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Modifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %00 "public"<br>
   * .. .. . | %01 "static"<br>
   * .. .. . | %02 "protected"<br>
   * .. .. . | %03 "private"<br>
   * .. .. . | %04 "final"<br>
   * .. .. . | %05 "abstract"<br>
   * .. .. . | %06 "synchronized"<br>
   * .. .. . | %07 "native"<br>
   * .. .. . | %08 "transient"<br>
   * .. .. . | %09 "volatile"<br>
   * .. .. . | %10 "strictfp"<br>
   * .. .. . | %11 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Modifiers n) {
    R nRes = null;
    // f0 -> ( ( %00 "public"
    // .. .. . | %01 "static"
    // .. .. . | %02 "protected"
    // .. .. . | %03 "private"
    // .. .. . | %04 "final"
    // .. .. . | %05 "abstract"
    // .. .. . | %06 "synchronized"
    // .. .. . | %07 "native"
    // .. .. . | %08 "transient"
    // .. .. . | %09 "volatile"
    // .. .. . | %10 "strictfp"
    // .. .. . | %11 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode n0Mi = n0.elementAt(i);
        final NodeChoice n0MiC = (NodeChoice) n0Mi;
        final INode n0MiCH = n0MiC.choice;
        switch (n0MiC.which) {
          case 0:
            // %00 "public"
            nRes = n0MiCH.accept(this);
            break;
          case 1:
            // %01 "static"
            nRes = n0MiCH.accept(this);
            break;
          case 2:
            // %02 "protected"
            nRes = n0MiCH.accept(this);
            break;
          case 3:
            // %03 "private"
            nRes = n0MiCH.accept(this);
            break;
          case 4:
            // %04 "final"
            nRes = n0MiCH.accept(this);
            break;
          case 5:
            // %05 "abstract"
            nRes = n0MiCH.accept(this);
            break;
          case 6:
            // %06 "synchronized"
            nRes = n0MiCH.accept(this);
            break;
          case 7:
            // %07 "native"
            nRes = n0MiCH.accept(this);
            break;
          case 8:
            // %08 "transient"
            nRes = n0MiCH.accept(this);
            break;
          case 9:
            // %09 "volatile"
            nRes = n0MiCH.accept(this);
            break;
          case 10:
            // %10 "strictfp"
            nRes = n0MiCH.accept(this);
            break;
          case 11:
            // %11 Annotation()
            nRes = n0MiCH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 ";"<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration() )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TypeDeclaration n) {
    R nRes = null;
    // f0 -> . %0 ";"
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration() )
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ";"
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 #0 Modifiers()
        // .. #1 ( &0 ClassOrInterfaceDeclaration()
        // .. .. | &1 EnumDeclaration()
        // .. .. | &2 AnnotationTypeDeclaration() )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 Modifiers()
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        nRes = n0CHS1A0.accept(this);
        // #1 ( &0 ClassOrInterfaceDeclaration()
        // .. | &1 EnumDeclaration()
        // .. | &2 AnnotationTypeDeclaration() )
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeChoice n0CHS1A1C = (NodeChoice) n0CHS1A1;
        final INode n0CHS1A1CH = n0CHS1A1C.choice;
        switch (n0CHS1A1C.which) {
          case 0:
            // &0 ClassOrInterfaceDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 1:
            // &1 EnumDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 2:
            // &2 AnnotationTypeDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "class"<br>
   * .. .. | %1 "interface" )<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ TypeParameters() ]<br>
   * f3 -> [ ExtendsList() ]<br>
   * f4 -> [ ImplementsList() ]<br>
   * f5 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ClassOrInterfaceDeclaration n) {
    R nRes = null;
    // f0 -> ( %0 "class"
    // .. .. | %1 "interface" )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "class"
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 "interface"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ TypeParameters() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ ExtendsList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> [ ImplementsList() ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      nRes = n4.accept(this);
    }
    // f5 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n5 = n.f5;
    nRes = n5.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ExtendsList} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ExtendsList n) {
    R nRes = null;
    // f0 -> "extends"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 ClassOrInterfaceType()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ImplementsList} node, whose children are the following :
   * <p>
   * f0 -> "implements"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ImplementsList n) {
    R nRes = null;
    // f0 -> "implements"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 ClassOrInterfaceType()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link EnumDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "enum"<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ ImplementsList() ]<br>
   * f3 -> EnumBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final EnumDeclaration n) {
    R nRes = null;
    // f0 -> "enum"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ ImplementsList() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> EnumBody()
    final EnumBody n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link EnumBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 EnumConstant()<br>
   * .. .. . #1 ( $0 "," $1 EnumConstant() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> [ #0 ";"<br>
   * .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final EnumBody n) {
    R nRes = null;
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 EnumConstant()
    // .. .. . #1 ( $0 "," $1 EnumConstant() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 EnumConstant()
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 ( $0 "," $1 EnumConstant() )*
      final INode n1SA1 = n1S.elementAt(1);
      final NodeListOptional n1SA1T = (NodeListOptional) n1SA1;
      if (n1SA1T.present()) {
        for (int i = 0; i < n1SA1T.size(); i++) {
          final INode n1SA1TMi = n1SA1T.elementAt(i);
          final NodeSequence n1SA1TMiS1 = (NodeSequence) n1SA1TMi;
          // $0 ","
          final INode n1SA1TMiS1A0 = n1SA1TMiS1.elementAt(0);
          nRes = n1SA1TMiS1A0.accept(this);
          // $1 EnumConstant()
          final INode n1SA1TMiS1A1 = n1SA1TMiS1.elementAt(1);
          nRes = n1SA1TMiS1A1.accept(this);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ #0 ";"
    // .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S2 = (NodeSequence) n3.node;
      // #0 ";"
      final INode n3S2A0 = n3S2.elementAt(0);
      nRes = n3S2A0.accept(this);
      // #1 ( ClassOrInterfaceBodyDeclaration() )*
      final INode n3S2A1 = n3S2.elementAt(1);
      final NodeListOptional n3S2A1T1 = (NodeListOptional) n3S2A1;
      if (n3S2A1T1.present()) {
        for (int i = 0; i < n3S2A1T1.size(); i++) {
          final INode n3S2A1T1Mi = n3S2A1T1.elementAt(i);
          nRes = n3S2A1T1Mi.accept(this);
        }
      }
    }
    // f4 -> "}"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link EnumConstant} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ Arguments() ]<br>
   * f3 -> [ ClassOrInterfaceBody() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final EnumConstant n) {
    R nRes = null;
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ Arguments() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ ClassOrInterfaceBody() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeParameters} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeParameter()<br>
   * f2 -> ( #0 "," #1 TypeParameter() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TypeParameters n) {
    R nRes = null;
    // f0 -> "<"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> TypeParameter()
    final TypeParameter n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 TypeParameter() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 TypeParameter()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    // f3 -> ">"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TypeParameter} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeBound() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TypeParameter n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ TypeBound() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeBound} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TypeBound n) {
    R nRes = null;
    // f0 -> "extends"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "&"
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 ClassOrInterfaceType()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( ClassOrInterfaceBodyDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ClassOrInterfaceBody n) {
    R nRes = null;
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( ClassOrInterfaceBodyDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        nRes = n1Mi.accept(this);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceBodyDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 Initializer()<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &3 ConstructorDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration()<br>
   * .. .. . .. .. | &5 MethodDeclaration() )<br>
   * .. .. | %2 ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ClassOrInterfaceBodyDeclaration n) {
    R nRes = null;
    // f0 -> . %0 Initializer()
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration()
    // .. .. . .. .. | &3 ConstructorDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration()
    // .. .. . .. .. | &5 MethodDeclaration() )
    // .. .. | %2 ";"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 Initializer()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 #0 Modifiers()
        // .. #1 ( &0 ClassOrInterfaceDeclaration()
        // .. .. | &1 EnumDeclaration()
        // .. .. | &2 AnnotationTypeDeclaration()
        // .. .. | &3 ConstructorDeclaration()
        // .. .. | &4 FieldDeclaration()
        // .. .. | &5 MethodDeclaration() )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 Modifiers()
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        nRes = n0CHS1A0.accept(this);
        // #1 ( &0 ClassOrInterfaceDeclaration()
        // .. | &1 EnumDeclaration()
        // .. | &2 AnnotationTypeDeclaration()
        // .. | &3 ConstructorDeclaration()
        // .. | &4 FieldDeclaration()
        // .. | &5 MethodDeclaration() )
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeChoice n0CHS1A1C = (NodeChoice) n0CHS1A1;
        final INode n0CHS1A1CH = n0CHS1A1C.choice;
        switch (n0CHS1A1C.which) {
          case 0:
            // &0 ClassOrInterfaceDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 1:
            // &1 EnumDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 2:
            // &2 AnnotationTypeDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 3:
            // &3 ConstructorDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 4:
            // &4 FieldDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          case 5:
            // &5 MethodDeclaration()
            nRes = n0CHS1A1CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 2:
        // %2 ";"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link FieldDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Type()<br>
   * f1 -> VariableDeclarator()<br>
   * f2 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final FieldDeclaration n) {
    R nRes = null;
    // f0 -> Type()
    final Type n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> VariableDeclarator()
    final VariableDeclarator n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 VariableDeclarator()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link VariableDeclarator} node, whose children are the following :
   * <p>
   * f0 -> VariableDeclaratorId()<br>
   * f1 -> [ #0 "=" #1 VariableInitializer() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final VariableDeclarator n) {
    R nRes = null;
    // f0 -> VariableDeclaratorId()
    final VariableDeclaratorId n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "=" #1 VariableInitializer() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "="
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 VariableInitializer()
      final INode n1SA1 = n1S.elementAt(1);
      nRes = n1SA1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link VariableDeclaratorId} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final VariableDeclaratorId n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "["
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 "]"
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link VariableInitializer} node, whose child is the following :
   * <p>
   * f0 -> . %0 ArrayInitializer()<br>
   * .. .. | %1 Expression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final VariableInitializer n) {
    R nRes = null;
    // f0 -> . %0 ArrayInitializer()
    // .. .. | %1 Expression()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ArrayInitializer()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 Expression()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 VariableInitializer()<br>
   * .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ArrayInitializer n) {
    R nRes = null;
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 VariableInitializer()
    // .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 VariableInitializer()
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 ( $0 "," $1 VariableInitializer() )*
      final INode n1SA1 = n1S.elementAt(1);
      final NodeListOptional n1SA1T = (NodeListOptional) n1SA1;
      if (n1SA1T.present()) {
        for (int i = 0; i < n1SA1T.size(); i++) {
          final INode n1SA1TMi = n1SA1T.elementAt(i);
          final NodeSequence n1SA1TMiS1 = (NodeSequence) n1SA1TMi;
          // $0 ","
          final INode n1SA1TMiS1A0 = n1SA1TMiS1.elementAt(0);
          nRes = n1SA1TMiS1A0.accept(this);
          // $1 VariableInitializer()
          final INode n1SA1TMiS1A1 = n1SA1TMiS1.elementAt(1);
          nRes = n1SA1TMiS1A1.accept(this);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> "}"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MethodDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> ResultType()<br>
   * f2 -> MethodDeclarator()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> ( %0 Block()<br>
   * .. .. | %1 ";" )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MethodDeclaration n) {
    R nRes = null;
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> MethodDeclarator()
    final MethodDeclarator n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 "throws"
      final INode n3SA0 = n3S.elementAt(0);
      nRes = n3SA0.accept(this);
      // #1 NameList()
      final INode n3SA1 = n3S.elementAt(1);
      nRes = n3SA1.accept(this);
    }
    // f4 -> ( %0 Block()
    // .. .. | %1 ";" )
    final NodeChoice n4 = n.f4;
    final NodeChoice n4C = n4;
    final INode n4CH = n4C.choice;
    switch (n4C.which) {
      case 0:
        // %0 Block()
        nRes = n4CH.accept(this);
        break;
      case 1:
        // %1 ";"
        nRes = n4CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link MethodDeclarator} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> FormalParameters()<br>
   * f2 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MethodDeclarator n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> FormalParameters()
    final FormalParameters n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "["
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 "]"
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link FormalParameters} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ #0 FormalParameter()<br>
   * .. .. . #1 ( $0 "," $1 FormalParameter() )* ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final FormalParameters n) {
    R nRes = null;
    // f0 -> "("
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 FormalParameter()
    // .. .. . #1 ( $0 "," $1 FormalParameter() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 FormalParameter()
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 ( $0 "," $1 FormalParameter() )*
      final INode n1SA1 = n1S.elementAt(1);
      final NodeListOptional n1SA1T = (NodeListOptional) n1SA1;
      if (n1SA1T.present()) {
        for (int i = 0; i < n1SA1T.size(); i++) {
          final INode n1SA1TMi = n1SA1T.elementAt(i);
          final NodeSequence n1SA1TMiS1 = (NodeSequence) n1SA1TMi;
          // $0 ","
          final INode n1SA1TMiS1A0 = n1SA1TMiS1.elementAt(0);
          nRes = n1SA1TMiS1A0.accept(this);
          // $1 FormalParameter()
          final INode n1SA1TMiS1A1 = n1SA1TMiS1.elementAt(1);
          nRes = n1SA1TMiS1A1.accept(this);
        }
      }
    }
    // f2 -> ")"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link FormalParameter} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> [ "..." ]<br>
   * f3 -> VariableDeclaratorId()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final FormalParameter n) {
    R nRes = null;
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Type()
    final Type n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ "..." ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> VariableDeclaratorId()
    final VariableDeclaratorId n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ConstructorDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> FormalParameters()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> "{"<br>
   * f5 -> [ ExplicitConstructorInvocation() ]<br>
   * f6 -> ( BlockStatement() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ConstructorDeclaration n) {
    R nRes = null;
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> FormalParameters()
    final FormalParameters n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 "throws"
      final INode n3SA0 = n3S.elementAt(0);
      nRes = n3SA0.accept(this);
      // #1 NameList()
      final INode n3SA1 = n3S.elementAt(1);
      nRes = n3SA1.accept(this);
    }
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> [ ExplicitConstructorInvocation() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      nRes = n5.accept(this);
    }
    // f6 -> ( BlockStatement() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode n6Mi = n6.elementAt(i);
        nRes = n6Mi.accept(this);
      }
    }
    // f7 -> "}"
    final NodeToken n7 = n.f7;
    nRes = n7.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ExplicitConstructorInvocation} node, whose child is the following :
   * <p>
   * f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()<br>
   * .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*<br>
   * .. .. . .. .. . $3 ">" ]<br>
   * .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"<br>
   * .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )<br>
   * .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ExplicitConstructorInvocation n) {
    R nRes = null;
    // f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()
    // .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
    // .. .. . .. .. . $3 ">" ]
    // .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
    // .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
    // .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 [ $0 "<" $1 ReferenceType()
        // .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
        // .. .. . $3 ">" ]
        // .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        // .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 [ $0 "<" $1 ReferenceType()
        // .. . $2 ( ?0 "," ?1 ReferenceType() )*
        // .. . $3 ">" ]
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeOptional n0CHS0A0P = (NodeOptional) n0CHS0A0;
        if (n0CHS0A0P.present()) {
          final NodeSequence n0CHS0A0PS1 = (NodeSequence) n0CHS0A0P.node;
          // $0 "<"
          final INode n0CHS0A0PS1A0 = n0CHS0A0PS1.elementAt(0);
          nRes = n0CHS0A0PS1A0.accept(this);
          // $1 ReferenceType()
          final INode n0CHS0A0PS1A1 = n0CHS0A0PS1.elementAt(1);
          nRes = n0CHS0A0PS1A1.accept(this);
          // $2 ( ?0 "," ?1 ReferenceType() )*
          final INode n0CHS0A0PS1A2 = n0CHS0A0PS1.elementAt(2);
          final NodeListOptional n0CHS0A0PS1A2T = (NodeListOptional) n0CHS0A0PS1A2;
          if (n0CHS0A0PS1A2T.present()) {
            for (int i = 0; i < n0CHS0A0PS1A2T.size(); i++) {
              final INode n0CHS0A0PS1A2TMi = n0CHS0A0PS1A2T.elementAt(i);
              final NodeSequence n0CHS0A0PS1A2TMiS2 = (NodeSequence) n0CHS0A0PS1A2TMi;
              // ?0 ","
              final INode n0CHS0A0PS1A2TMiS2A0 = n0CHS0A0PS1A2TMiS2.elementAt(0);
              nRes = n0CHS0A0PS1A2TMiS2A0.accept(this);
              // ?1 ReferenceType()
              final INode n0CHS0A0PS1A2TMiS2A1 = n0CHS0A0PS1A2TMiS2.elementAt(1);
              nRes = n0CHS0A0PS1A2TMiS2A1.accept(this);
            }
          }
          // $3 ">"
          final INode n0CHS0A0PS1A3 = n0CHS0A0PS1.elementAt(3);
          nRes = n0CHS0A0PS1A3.accept(this);
        }
        // #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        // .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final INode n0CHSA1 = n0CHS.elementAt(1);
        final NodeChoice n0CHSA1C = (NodeChoice) n0CHSA1;
        final INode n0CHSA1CH = n0CHSA1C.choice;
        switch (n0CHSA1C.which) {
          case 0:
            // &0 $0 "this" $1 Arguments() $2 ";"
            final NodeSequence n0CHSA1CHS3 = (NodeSequence) n0CHSA1CH;
            // $0 "this"
            final INode n0CHSA1CHS30A0 = n0CHSA1CHS3.elementAt(0);
            nRes = n0CHSA1CHS30A0.accept(this);
            // $1 Arguments()
            final INode n0CHSA1CHS30A1 = n0CHSA1CHS3.elementAt(1);
            nRes = n0CHSA1CHS30A1.accept(this);
            // $2 ";"
            final INode n0CHSA1CHS30A2 = n0CHSA1CHS3.elementAt(2);
            nRes = n0CHSA1CHS30A2.accept(this);
            break;
          case 1:
            // &1 $0 "super" $1 Arguments() $2 ";"
            final NodeSequence n0CHSA1CHS4 = (NodeSequence) n0CHSA1CH;
            // $0 "super"
            final INode n0CHSA1CHS41A0 = n0CHSA1CHS4.elementAt(0);
            nRes = n0CHSA1CHS41A0.accept(this);
            // $1 Arguments()
            final INode n0CHSA1CHS41A1 = n0CHSA1CHS4.elementAt(1);
            nRes = n0CHSA1CHS41A1.accept(this);
            // $2 ";"
            final INode n0CHSA1CHS41A2 = n0CHSA1CHS4.elementAt(2);
            nRes = n0CHSA1CHS41A2.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 1:
        // %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" )
        final NodeSequence n0CHS5 = (NodeSequence) n0CH;
        // #0 PrimaryExpression()
        final INode n0CHS5A0 = n0CHS5.elementAt(0);
        nRes = n0CHS5A0.accept(this);
        // #1 "."
        final INode n0CHS5A1 = n0CHS5.elementAt(1);
        nRes = n0CHS5A1.accept(this);
        // #2 "super"
        final INode n0CHS5A2 = n0CHS5.elementAt(2);
        nRes = n0CHS5A2.accept(this);
        // #3 Arguments()
        final INode n0CHS5A3 = n0CHS5.elementAt(3);
        nRes = n0CHS5A3.accept(this);
        // #4 ";"
        final INode n0CHS5A4 = n0CHS5.elementAt(4);
        nRes = n0CHS5A4.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link Initializer} node, whose children are the following :
   * <p>
   * f0 -> [ "static" ]<br>
   * f1 -> Block()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Initializer n) {
    R nRes = null;
    // f0 -> [ "static" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> Block()
    final Block n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Type} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 PrimitiveType()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Type n) {
    R nRes = null;
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 PrimitiveType()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ReferenceType()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 PrimitiveType()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ReferenceType} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 PrimitiveType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )+<br>
   * .. .. | %1 #0 ClassOrInterfaceType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ReferenceType n) {
    R nRes = null;
    // f0 -> . %0 #0 PrimitiveType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )+
    // .. .. | %1 #0 ClassOrInterfaceType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 PrimitiveType()
        // .. #1 ( $0 "[" $1 "]" )+
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 PrimitiveType()
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 ( $0 "[" $1 "]" )+
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        final NodeList n0CHS0A1L = (NodeList) n0CHS0A1;
        for (int i = 0; i < n0CHS0A1L.size(); i++) {
          final INode n0CHS0A1LEi = n0CHS0A1L.elementAt(i);
          final NodeSequence n0CHS0A1LEiS1 = (NodeSequence) n0CHS0A1LEi;
          // $0 "["
          final INode n0CHS0A1LEiS1A0 = n0CHS0A1LEiS1.elementAt(0);
          nRes = n0CHS0A1LEiS1A0.accept(this);
          // $1 "]"
          final INode n0CHS0A1LEiS1A1 = n0CHS0A1LEiS1.elementAt(1);
          nRes = n0CHS0A1LEiS1A1.accept(this);
        }
        break;
      case 1:
        // %1 #0 ClassOrInterfaceType()
        // .. #1 ( $0 "[" $1 "]" )*
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 ClassOrInterfaceType()
        final INode n0CHS21A0 = n0CHS2.elementAt(0);
        nRes = n0CHS21A0.accept(this);
        // #1 ( $0 "[" $1 "]" )*
        final INode n0CHS21A1 = n0CHS2.elementAt(1);
        final NodeListOptional n0CHS21A1T = (NodeListOptional) n0CHS21A1;
        if (n0CHS21A1T.present()) {
          for (int i = 0; i < n0CHS21A1T.size(); i++) {
            final INode n0CHS21A1TMi = n0CHS21A1T.elementAt(i);
            final NodeSequence n0CHS21A1TMiS3 = (NodeSequence) n0CHS21A1TMi;
            // $0 "["
            final INode n0CHS21A1TMiS3A0 = n0CHS21A1TMiS3.elementAt(0);
            nRes = n0CHS21A1TMiS3A0.accept(this);
            // $1 "]"
            final INode n0CHS21A1TMiS3A1 = n0CHS21A1TMiS3.elementAt(1);
            nRes = n0CHS21A1TMiS3A1.accept(this);
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceType} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeArguments() ]<br>
   * f2 -> ( #0 "." #1 <IDENTIFIER><br>
   * .. .. . #2 [ TypeArguments() ] )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ClassOrInterfaceType n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ TypeArguments() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ( #0 "." #1 <IDENTIFIER>
    // .. .. . #2 [ TypeArguments() ] )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "."
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 <IDENTIFIER>
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
        // #2 [ TypeArguments() ]
        final INode n2MiSA2 = n2MiS.elementAt(2);
        final NodeOptional n2MiSA2P = (NodeOptional) n2MiSA2;
        if (n2MiSA2P.present()) {
          nRes = n2MiSA2P.accept(this);
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeArgument()<br>
   * f2 -> ( #0 "," #1 TypeArgument() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TypeArguments n) {
    R nRes = null;
    // f0 -> "<"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> TypeArgument()
    final TypeArgument n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 TypeArgument() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 TypeArgument()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    // f3 -> ">"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TypeArgument} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 #0 "?"<br>
   * .. .. . .. #1 [ WildcardBounds() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TypeArgument n) {
    R nRes = null;
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 #0 "?"
    // .. .. . .. #1 [ WildcardBounds() ]
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ReferenceType()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 #0 "?"
        // .. #1 [ WildcardBounds() ]
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "?"
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        nRes = n0CHS1A0.accept(this);
        // #1 [ WildcardBounds() ]
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeOptional n0CHS1A1P = (NodeOptional) n0CHS1A1;
        if (n0CHS1A1P.present()) {
          nRes = n0CHS1A1P.accept(this);
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link WildcardBounds} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "extends" #1 ReferenceType()<br>
   * .. .. | %1 #0 "super" #1 ReferenceType()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final WildcardBounds n) {
    R nRes = null;
    // f0 -> . %0 #0 "extends" #1 ReferenceType()
    // .. .. | %1 #0 "super" #1 ReferenceType()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "extends" #1 ReferenceType()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "extends"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 ReferenceType()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        break;
      case 1:
        // %1 #0 "super" #1 ReferenceType()
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "super"
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        nRes = n0CHS11A0.accept(this);
        // #1 ReferenceType()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        nRes = n0CHS11A1.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link PrimitiveType} node, whose child is the following :
   * <p>
   * f0 -> . %0 "boolean"<br>
   * .. .. | %1 "char"<br>
   * .. .. | %2 "byte"<br>
   * .. .. | %3 "short"<br>
   * .. .. | %4 "int"<br>
   * .. .. | %5 "long"<br>
   * .. .. | %6 "float"<br>
   * .. .. | %7 "double"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PrimitiveType n) {
    R nRes = null;
    // f0 -> . %0 "boolean"
    // .. .. | %1 "char"
    // .. .. | %2 "byte"
    // .. .. | %3 "short"
    // .. .. | %4 "int"
    // .. .. | %5 "long"
    // .. .. | %6 "float"
    // .. .. | %7 "double"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "boolean"
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 "char"
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 "byte"
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 "short"
        nRes = n0CH.accept(this);
        break;
      case 4:
        // %4 "int"
        nRes = n0CH.accept(this);
        break;
      case 5:
        // %5 "long"
        nRes = n0CH.accept(this);
        break;
      case 6:
        // %6 "float"
        nRes = n0CH.accept(this);
        break;
      case 7:
        // %7 "double"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ResultType} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "void"<br>
   * .. .. | %1 Type() )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ResultType n) {
    R nRes = null;
    // f0 -> ( %0 "void"
    // .. .. | %1 Type() )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "void"
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 Type()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link Name} node, whose children are the following :
   * <p>
   * f0 -> JavaIdentifier()<br>
   * f1 -> ( #0 "." #1 JavaIdentifier() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Name n) {
    R nRes = null;
    // f0 -> JavaIdentifier()
    final JavaIdentifier n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "." #1 JavaIdentifier() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "."
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 JavaIdentifier()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link NameList} node, whose children are the following :
   * <p>
   * f0 -> Name()<br>
   * f1 -> ( #0 "," #1 Name() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NameList n) {
    R nRes = null;
    // f0 -> Name()
    final Name n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 Name() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 Name()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link Expression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalExpression()<br>
   * f1 -> [ #0 AssignmentOperator() #1 Expression() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Expression n) {
    R nRes = null;
    // f0 -> ConditionalExpression()
    final ConditionalExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 AssignmentOperator() #1 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 AssignmentOperator()
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 Expression()
      final INode n1SA1 = n1S.elementAt(1);
      nRes = n1SA1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link AssignmentOperator} node, whose child is the following :
   * <p>
   * f0 -> . %00 "="<br>
   * .. .. | %01 "*="<br>
   * .. .. | %02 "/="<br>
   * .. .. | %03 "%="<br>
   * .. .. | %04 "+="<br>
   * .. .. | %05 "-="<br>
   * .. .. | %06 "<<="<br>
   * .. .. | %07 ">>="<br>
   * .. .. | %08 ">>>="<br>
   * .. .. | %09 "&="<br>
   * .. .. | %10 "^="<br>
   * .. .. | %11 "|="<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AssignmentOperator n) {
    R nRes = null;
    // f0 -> . %00 "="
    // .. .. | %01 "*="
    // .. .. | %02 "/="
    // .. .. | %03 "%="
    // .. .. | %04 "+="
    // .. .. | %05 "-="
    // .. .. | %06 "<<="
    // .. .. | %07 ">>="
    // .. .. | %08 ">>>="
    // .. .. | %09 "&="
    // .. .. | %10 "^="
    // .. .. | %11 "|="
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %00 "="
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %01 "*="
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %02 "/="
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %03 "%="
        nRes = n0CH.accept(this);
        break;
      case 4:
        // %04 "+="
        nRes = n0CH.accept(this);
        break;
      case 5:
        // %05 "-="
        nRes = n0CH.accept(this);
        break;
      case 6:
        // %06 "<<="
        nRes = n0CH.accept(this);
        break;
      case 7:
        // %07 ">>="
        nRes = n0CH.accept(this);
        break;
      case 8:
        // %08 ">>>="
        nRes = n0CH.accept(this);
        break;
      case 9:
        // %09 "&="
        nRes = n0CH.accept(this);
        break;
      case 10:
        // %10 "^="
        nRes = n0CH.accept(this);
        break;
      case 11:
        // %11 "|="
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ConditionalExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalOrExpression()<br>
   * f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ConditionalExpression n) {
    R nRes = null;
    // f0 -> ConditionalOrExpression()
    final ConditionalOrExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "?"
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 Expression()
      final INode n1SA1 = n1S.elementAt(1);
      nRes = n1SA1.accept(this);
      // #2 ":"
      final INode n1SA2 = n1S.elementAt(2);
      nRes = n1SA2.accept(this);
      // #3 Expression()
      final INode n1SA3 = n1S.elementAt(3);
      nRes = n1SA3.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ConditionalOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalAndExpression()<br>
   * f1 -> ( #0 "||" #1 ConditionalAndExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ConditionalOrExpression n) {
    R nRes = null;
    // f0 -> ConditionalAndExpression()
    final ConditionalAndExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "||" #1 ConditionalAndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "||"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 ConditionalAndExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ConditionalAndExpression} node, whose children are the following :
   * <p>
   * f0 -> InclusiveOrExpression()<br>
   * f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ConditionalAndExpression n) {
    R nRes = null;
    // f0 -> InclusiveOrExpression()
    final InclusiveOrExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "&&"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 InclusiveOrExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link InclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ExclusiveOrExpression()<br>
   * f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final InclusiveOrExpression n) {
    R nRes = null;
    // f0 -> ExclusiveOrExpression()
    final ExclusiveOrExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "|"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 ExclusiveOrExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ExclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> AndExpression()<br>
   * f1 -> ( #0 "^" #1 AndExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ExclusiveOrExpression n) {
    R nRes = null;
    // f0 -> AndExpression()
    final AndExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "^" #1 AndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "^"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 AndExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link AndExpression} node, whose children are the following :
   * <p>
   * f0 -> EqualityExpression()<br>
   * f1 -> ( #0 "&" #1 EqualityExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AndExpression n) {
    R nRes = null;
    // f0 -> EqualityExpression()
    final EqualityExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "&" #1 EqualityExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "&"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 EqualityExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link EqualityExpression} node, whose children are the following :
   * <p>
   * f0 -> InstanceOfExpression()<br>
   * f1 -> ( #0 ( %0 "=="<br>
   * .. .. . .. | %1 "!=" )<br>
   * .. .. . #1 InstanceOfExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final EqualityExpression n) {
    R nRes = null;
    // f0 -> InstanceOfExpression()
    final InstanceOfExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "=="
    // .. .. . .. | %1 "!=" )
    // .. .. . #1 InstanceOfExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "=="
        // .. | %1 "!=" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "=="
            nRes = n1MiSA0CH.accept(this);
            break;
          case 1:
            // %1 "!="
            nRes = n1MiSA0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 InstanceOfExpression()
        final INode n1MiS1A1 = n1MiS.elementAt(1);
        nRes = n1MiS1A1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link InstanceOfExpression} node, whose children are the following :
   * <p>
   * f0 -> RelationalExpression()<br>
   * f1 -> [ #0 "instanceof" #1 Type() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final InstanceOfExpression n) {
    R nRes = null;
    // f0 -> RelationalExpression()
    final RelationalExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "instanceof" #1 Type() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "instanceof"
      final INode n1SA0 = n1S.elementAt(0);
      nRes = n1SA0.accept(this);
      // #1 Type()
      final INode n1SA1 = n1S.elementAt(1);
      nRes = n1SA1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link RelationalExpression} node, whose children are the following :
   * <p>
   * f0 -> ShiftExpression()<br>
   * f1 -> ( #0 ( %0 "<"<br>
   * .. .. . .. | %1 ">"<br>
   * .. .. . .. | %2 "<="<br>
   * .. .. . .. | %3 ">=" )<br>
   * .. .. . #1 ShiftExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RelationalExpression n) {
    R nRes = null;
    // f0 -> ShiftExpression()
    final ShiftExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "<"
    // .. .. . .. | %1 ">"
    // .. .. . .. | %2 "<="
    // .. .. . .. | %3 ">=" )
    // .. .. . #1 ShiftExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "<"
        // .. | %1 ">"
        // .. | %2 "<="
        // .. | %3 ">=" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "<"
            nRes = n1MiSA0CH.accept(this);
            break;
          case 1:
            // %1 ">"
            nRes = n1MiSA0CH.accept(this);
            break;
          case 2:
            // %2 "<="
            nRes = n1MiSA0CH.accept(this);
            break;
          case 3:
            // %3 ">="
            nRes = n1MiSA0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 ShiftExpression()
        final INode n1MiS3A1 = n1MiS.elementAt(1);
        nRes = n1MiS3A1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ShiftExpression} node, whose children are the following :
   * <p>
   * f0 -> AdditiveExpression()<br>
   * f1 -> ( #0 ( %0 "<<"<br>
   * .. .. . .. | %1 RUnsignedShift()<br>
   * .. .. . .. | %2 RSignedShift() )<br>
   * .. .. . #1 AdditiveExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ShiftExpression n) {
    R nRes = null;
    // f0 -> AdditiveExpression()
    final AdditiveExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "<<"
    // .. .. . .. | %1 RUnsignedShift()
    // .. .. . .. | %2 RSignedShift() )
    // .. .. . #1 AdditiveExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "<<"
        // .. | %1 RUnsignedShift()
        // .. | %2 RSignedShift() )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "<<"
            nRes = n1MiSA0CH.accept(this);
            break;
          case 1:
            // %1 RUnsignedShift()
            nRes = n1MiSA0CH.accept(this);
            break;
          case 2:
            // %2 RSignedShift()
            nRes = n1MiSA0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 AdditiveExpression()
        final INode n1MiS2A1 = n1MiS.elementAt(1);
        nRes = n1MiS2A1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link RSignedShift} node, whose child is the following :
   * <p>
   * f0 -> ">>"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RSignedShift n) {
    R nRes = null;
    // f0 -> ">>"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link RUnsignedShift} node, whose child is the following :
   * <p>
   * f0 -> ">>>"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final RUnsignedShift n) {
    R nRes = null;
    // f0 -> ">>>"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AdditiveExpression} node, whose children are the following :
   * <p>
   * f0 -> MultiplicativeExpression()<br>
   * f1 -> ( #0 ( %0 "+"<br>
   * .. .. . .. | %1 "-" )<br>
   * .. .. . #1 MultiplicativeExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AdditiveExpression n) {
    R nRes = null;
    // f0 -> MultiplicativeExpression()
    final MultiplicativeExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "+"
    // .. .. . .. | %1 "-" )
    // .. .. . #1 MultiplicativeExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "+"
        // .. | %1 "-" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "+"
            nRes = n1MiSA0CH.accept(this);
            break;
          case 1:
            // %1 "-"
            nRes = n1MiSA0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 MultiplicativeExpression()
        final INode n1MiS1A1 = n1MiS.elementAt(1);
        nRes = n1MiS1A1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link MultiplicativeExpression} node, whose children are the following :
   * <p>
   * f0 -> UnaryExpression()<br>
   * f1 -> ( #0 ( %0 "*"<br>
   * .. .. . .. | %1 "/"<br>
   * .. .. . .. | %2 "%" )<br>
   * .. .. . #1 UnaryExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MultiplicativeExpression n) {
    R nRes = null;
    // f0 -> UnaryExpression()
    final UnaryExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "*"
    // .. .. . .. | %1 "/"
    // .. .. . .. | %2 "%" )
    // .. .. . #1 UnaryExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "*"
        // .. | %1 "/"
        // .. | %2 "%" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "*"
            nRes = n1MiSA0CH.accept(this);
            break;
          case 1:
            // %1 "/"
            nRes = n1MiSA0CH.accept(this);
            break;
          case 2:
            // %2 "%"
            nRes = n1MiSA0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode n1MiS2A1 = n1MiS.elementAt(1);
        nRes = n1MiS2A1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link UnaryExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "+"<br>
   * .. .. . .. .. | &1 "-" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 PreIncrementExpression()<br>
   * .. .. | %2 PreDecrementExpression()<br>
   * .. .. | %3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final UnaryExpression n) {
    R nRes = null;
    // f0 -> . %0 #0 ( &0 "+"
    // .. .. . .. .. | &1 "-" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 PreIncrementExpression()
    // .. .. | %2 PreDecrementExpression()
    // .. .. | %3 UnaryExpressionNotPlusMinus()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 ( &0 "+"
        // .. .. | &1 "-" )
        // .. #1 UnaryExpression()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 ( &0 "+"
        // .. | &1 "-" )
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeChoice n0CHS0A0C = (NodeChoice) n0CHS0A0;
        final INode n0CHS0A0CH = n0CHS0A0C.choice;
        switch (n0CHS0A0C.which) {
          case 0:
            // &0 "+"
            nRes = n0CHS0A0CH.accept(this);
            break;
          case 1:
            // &1 "-"
            nRes = n0CHS0A0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        nRes = n0CHS1A1.accept(this);
        break;
      case 1:
        // %1 PreIncrementExpression()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 PreDecrementExpression()
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 UnaryExpressionNotPlusMinus()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link PreIncrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "++"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PreIncrementExpression n) {
    R nRes = null;
    // f0 -> "++"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link PreDecrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "--"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PreDecrementExpression n) {
    R nRes = null;
    // f0 -> "--"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link UnaryExpressionNotPlusMinus} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 CastExpression()<br>
   * .. .. | %2 PostfixExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final UnaryExpressionNotPlusMinus n) {
    R nRes = null;
    // f0 -> . %0 #0 ( &0 "~"
    // .. .. . .. .. | &1 "!" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 CastExpression()
    // .. .. | %2 PostfixExpression()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 ( &0 "~"
        // .. .. | &1 "!" )
        // .. #1 UnaryExpression()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 ( &0 "~"
        // .. | &1 "!" )
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeChoice n0CHS0A0C = (NodeChoice) n0CHS0A0;
        final INode n0CHS0A0CH = n0CHS0A0C.choice;
        switch (n0CHS0A0C.which) {
          case 0:
            // &0 "~"
            nRes = n0CHS0A0CH.accept(this);
            break;
          case 1:
            // &1 "!"
            nRes = n0CHS0A0CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        nRes = n0CHS1A1.accept(this);
        break;
      case 1:
        // %1 CastExpression()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 PostfixExpression()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link CastLookahead} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 PrimitiveType()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"<br>
   * .. .. | %2 #0 "(" #1 Type() #2 ")"<br>
   * .. .. . .. #3 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!"<br>
   * .. .. . .. .. | &2 "("<br>
   * .. .. . .. .. | &3 <IDENTIFIER><br>
   * .. .. . .. .. | &4 "this"<br>
   * .. .. . .. .. | &5 "super"<br>
   * .. .. . .. .. | &6 "new"<br>
   * .. .. . .. .. | &7 Literal() )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final CastLookahead n) {
    R nRes = null;
    // f0 -> . %0 #0 "(" #1 PrimitiveType()
    // .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"
    // .. .. | %2 #0 "(" #1 Type() #2 ")"
    // .. .. . .. #3 ( &0 "~"
    // .. .. . .. .. | &1 "!"
    // .. .. . .. .. | &2 "("
    // .. .. . .. .. | &3 <IDENTIFIER>
    // .. .. . .. .. | &4 "this"
    // .. .. . .. .. | &5 "super"
    // .. .. . .. .. | &6 "new"
    // .. .. . .. .. | &7 Literal() )
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "(" #1 PrimitiveType()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 PrimitiveType()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        break;
      case 1:
        // %1 #0 "(" #1 Type() #2 "[" #3 "]"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        nRes = n0CHS11A0.accept(this);
        // #1 Type()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        nRes = n0CHS11A1.accept(this);
        // #2 "["
        final INode n0CHS11A2 = n0CHS1.elementAt(2);
        nRes = n0CHS11A2.accept(this);
        // #3 "]"
        final INode n0CHS11A3 = n0CHS1.elementAt(3);
        nRes = n0CHS11A3.accept(this);
        break;
      case 2:
        // %2 #0 "(" #1 Type() #2 ")"
        // .. #3 ( &0 "~"
        // .. .. | &1 "!"
        // .. .. | &2 "("
        // .. .. | &3 <IDENTIFIER>
        // .. .. | &4 "this"
        // .. .. | &5 "super"
        // .. .. | &6 "new"
        // .. .. | &7 Literal() )
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS22A0 = n0CHS2.elementAt(0);
        nRes = n0CHS22A0.accept(this);
        // #1 Type()
        final INode n0CHS22A1 = n0CHS2.elementAt(1);
        nRes = n0CHS22A1.accept(this);
        // #2 ")"
        final INode n0CHS22A2 = n0CHS2.elementAt(2);
        nRes = n0CHS22A2.accept(this);
        // #3 ( &0 "~"
        // .. | &1 "!"
        // .. | &2 "("
        // .. | &3 <IDENTIFIER>
        // .. | &4 "this"
        // .. | &5 "super"
        // .. | &6 "new"
        // .. | &7 Literal() )
        final INode n0CHS22A3 = n0CHS2.elementAt(3);
        final NodeChoice n0CHS22A3C = (NodeChoice) n0CHS22A3;
        final INode n0CHS22A3CH = n0CHS22A3C.choice;
        switch (n0CHS22A3C.which) {
          case 0:
            // &0 "~"
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 1:
            // &1 "!"
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 2:
            // &2 "("
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 3:
            // &3 <IDENTIFIER>
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 4:
            // &4 "this"
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 5:
            // &5 "super"
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 6:
            // &6 "new"
            nRes = n0CHS22A3CH.accept(this);
            break;
          case 7:
            // &7 Literal()
            nRes = n0CHS22A3CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link PostfixExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryExpression()<br>
   * f1 -> [ %0 "++"<br>
   * .. .. | %1 "--" ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PostfixExpression n) {
    R nRes = null;
    // f0 -> PrimaryExpression()
    final PrimaryExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ %0 "++"
    // .. .. | %1 "--" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeChoice n1C = (NodeChoice) n1.node;
      final INode n1CH = n1C.choice;
      switch (n1C.which) {
        case 0:
          // %0 "++"
          nRes = n1CH.accept(this);
          break;
        case 1:
          // %1 "--"
          nRes = n1CH.accept(this);
          break;
        default:
          // should not occur !!!
          break;
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link CastExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final CastExpression n) {
    R nRes = null;
    // f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
    // .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 Type()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        // #2 ")"
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        nRes = n0CHS0A2.accept(this);
        // #3 UnaryExpression()
        final INode n0CHS0A3 = n0CHS.elementAt(3);
        nRes = n0CHS0A3.accept(this);
        break;
      case 1:
        // %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        nRes = n0CHS11A0.accept(this);
        // #1 Type()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        nRes = n0CHS11A1.accept(this);
        // #2 ")"
        final INode n0CHS11A2 = n0CHS1.elementAt(2);
        nRes = n0CHS11A2.accept(this);
        // #3 UnaryExpressionNotPlusMinus()
        final INode n0CHS11A3 = n0CHS1.elementAt(3);
        nRes = n0CHS11A3.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link PrimaryExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryPrefix()<br>
   * f1 -> ( PrimarySuffix() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PrimaryExpression n) {
    R nRes = null;
    // f0 -> PrimaryPrefix()
    final PrimaryPrefix n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( PrimarySuffix() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        nRes = n1Mi.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link MemberSelector} node, whose children are the following :
   * <p>
   * f0 -> "."<br>
   * f1 -> TypeArguments()<br>
   * f2 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MemberSelector n) {
    R nRes = null;
    // f0 -> "."
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> TypeArguments()
    final TypeArguments n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> <IDENTIFIER>
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link PrimaryPrefix} node, whose child is the following :
   * <p>
   * f0 -> . %0 Literal()<br>
   * .. .. | %1 "this"<br>
   * .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER><br>
   * .. .. | %3 #0 "(" #1 Expression() #2 ")"<br>
   * .. .. | %4 AllocationExpression()<br>
   * .. .. | %5 #0 ResultType() #1 "." #2 "class"<br>
   * .. .. | %6 Name()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PrimaryPrefix n) {
    R nRes = null;
    // f0 -> . %0 Literal()
    // .. .. | %1 "this"
    // .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER>
    // .. .. | %3 #0 "(" #1 Expression() #2 ")"
    // .. .. | %4 AllocationExpression()
    // .. .. | %5 #0 ResultType() #1 "." #2 "class"
    // .. .. | %6 Name()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 Literal()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 "this"
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 #0 "super" #1 "." #2 <IDENTIFIER>
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "super"
        final INode n0CHS2A0 = n0CHS.elementAt(0);
        nRes = n0CHS2A0.accept(this);
        // #1 "."
        final INode n0CHS2A1 = n0CHS.elementAt(1);
        nRes = n0CHS2A1.accept(this);
        // #2 <IDENTIFIER>
        final INode n0CHS2A2 = n0CHS.elementAt(2);
        nRes = n0CHS2A2.accept(this);
        break;
      case 3:
        // %3 #0 "(" #1 Expression() #2 ")"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS13A0 = n0CHS1.elementAt(0);
        nRes = n0CHS13A0.accept(this);
        // #1 Expression()
        final INode n0CHS13A1 = n0CHS1.elementAt(1);
        nRes = n0CHS13A1.accept(this);
        // #2 ")"
        final INode n0CHS13A2 = n0CHS1.elementAt(2);
        nRes = n0CHS13A2.accept(this);
        break;
      case 4:
        // %4 AllocationExpression()
        nRes = n0CH.accept(this);
        break;
      case 5:
        // %5 #0 ResultType() #1 "." #2 "class"
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 ResultType()
        final INode n0CHS25A0 = n0CHS2.elementAt(0);
        nRes = n0CHS25A0.accept(this);
        // #1 "."
        final INode n0CHS25A1 = n0CHS2.elementAt(1);
        nRes = n0CHS25A1.accept(this);
        // #2 "class"
        final INode n0CHS25A2 = n0CHS2.elementAt(2);
        nRes = n0CHS25A2.accept(this);
        break;
      case 6:
        // %6 Name()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link PrimarySuffix} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "." #1 "this"<br>
   * .. .. | %1 #0 "." #1 AllocationExpression()<br>
   * .. .. | %2 MemberSelector()<br>
   * .. .. | %3 #0 "[" #1 Expression() #2 "]"<br>
   * .. .. | %4 #0 "." #1 <IDENTIFIER><br>
   * .. .. | %5 Arguments()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final PrimarySuffix n) {
    R nRes = null;
    // f0 -> . %0 #0 "." #1 "this"
    // .. .. | %1 #0 "." #1 AllocationExpression()
    // .. .. | %2 MemberSelector()
    // .. .. | %3 #0 "[" #1 Expression() #2 "]"
    // .. .. | %4 #0 "." #1 <IDENTIFIER>
    // .. .. | %5 Arguments()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "." #1 "this"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "."
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 "this"
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        break;
      case 1:
        // %1 #0 "." #1 AllocationExpression()
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "."
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        nRes = n0CHS11A0.accept(this);
        // #1 AllocationExpression()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        nRes = n0CHS11A1.accept(this);
        break;
      case 2:
        // %2 MemberSelector()
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 #0 "[" #1 Expression() #2 "]"
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 "["
        final INode n0CHS23A0 = n0CHS2.elementAt(0);
        nRes = n0CHS23A0.accept(this);
        // #1 Expression()
        final INode n0CHS23A1 = n0CHS2.elementAt(1);
        nRes = n0CHS23A1.accept(this);
        // #2 "]"
        final INode n0CHS23A2 = n0CHS2.elementAt(2);
        nRes = n0CHS23A2.accept(this);
        break;
      case 4:
        // %4 #0 "." #1 <IDENTIFIER>
        final NodeSequence n0CHS3 = (NodeSequence) n0CH;
        // #0 "."
        final INode n0CHS34A0 = n0CHS3.elementAt(0);
        nRes = n0CHS34A0.accept(this);
        // #1 <IDENTIFIER>
        final INode n0CHS34A1 = n0CHS3.elementAt(1);
        nRes = n0CHS34A1.accept(this);
        break;
      case 5:
        // %5 Arguments()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link Literal} node, whose child is the following :
   * <p>
   * f0 -> . %0 <INTEGER_LITERAL><br>
   * .. .. | %1 <FLOATING_POINT_LITERAL><br>
   * .. .. | %2 <CHARACTER_LITERAL><br>
   * .. .. | %3 <STRING_LITERAL><br>
   * .. .. | %4 BooleanLiteral()<br>
   * .. .. | %5 NullLiteral()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Literal n) {
    R nRes = null;
    // f0 -> . %0 <INTEGER_LITERAL>
    // .. .. | %1 <FLOATING_POINT_LITERAL>
    // .. .. | %2 <CHARACTER_LITERAL>
    // .. .. | %3 <STRING_LITERAL>
    // .. .. | %4 BooleanLiteral()
    // .. .. | %5 NullLiteral()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 <INTEGER_LITERAL>
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 <FLOATING_POINT_LITERAL>
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 <CHARACTER_LITERAL>
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %3 <STRING_LITERAL>
        nRes = n0CH.accept(this);
        break;
      case 4:
        // %4 BooleanLiteral()
        nRes = n0CH.accept(this);
        break;
      case 5:
        // %5 NullLiteral()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link IntegerLiteral} node, whose child is the following :
   * <p>
   * f0 -> <INTEGER_LITERAL><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final IntegerLiteral n) {
    R nRes = null;
    // f0 -> <INTEGER_LITERAL>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BooleanLiteral} node, whose child is the following :
   * <p>
   * f0 -> . %0 "true"<br>
   * .. .. | %1 "false"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final BooleanLiteral n) {
    R nRes = null;
    // f0 -> . %0 "true"
    // .. .. | %1 "false"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "true"
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 "false"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link StringLiteral} node, whose child is the following :
   * <p>
   * f0 -> <STRING_LITERAL><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final StringLiteral n) {
    R nRes = null;
    // f0 -> <STRING_LITERAL>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link NullLiteral} node, whose child is the following :
   * <p>
   * f0 -> "null"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NullLiteral n) {
    R nRes = null;
    // f0 -> "null"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Arguments} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ ArgumentList() ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Arguments n) {
    R nRes = null;
    // f0 -> "("
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ ArgumentList() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ")"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ArgumentList} node, whose children are the following :
   * <p>
   * f0 -> Expression()<br>
   * f1 -> ( #0 "," #1 Expression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ArgumentList n) {
    R nRes = null;
    // f0 -> Expression()
    final Expression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 Expression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 Expression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link AllocationExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()<br>
   * .. .. | %1 #0 "new" #1 ClassOrInterfaceType()<br>
   * .. .. . .. #2 [ TypeArguments() ]<br>
   * .. .. . .. #3 ( &0 ArrayDimsAndInits()<br>
   * .. .. . .. .. | &1 $0 Arguments()<br>
   * .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AllocationExpression n) {
    R nRes = null;
    // f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
    // .. .. | %1 #0 "new" #1 ClassOrInterfaceType()
    // .. .. . .. #2 [ TypeArguments() ]
    // .. .. . .. #3 ( &0 ArrayDimsAndInits()
    // .. .. . .. .. | &1 $0 Arguments()
    // .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "new"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 PrimitiveType()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        // #2 ArrayDimsAndInits()
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        nRes = n0CHS0A2.accept(this);
        break;
      case 1:
        // %1 #0 "new" #1 ClassOrInterfaceType()
        // .. #2 [ TypeArguments() ]
        // .. #3 ( &0 ArrayDimsAndInits()
        // .. .. | &1 $0 Arguments()
        // .. .. .. $1 [ ClassOrInterfaceBody() ] )
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "new"
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        nRes = n0CHS11A0.accept(this);
        // #1 ClassOrInterfaceType()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        nRes = n0CHS11A1.accept(this);
        // #2 [ TypeArguments() ]
        final INode n0CHS11A2 = n0CHS1.elementAt(2);
        final NodeOptional n0CHS11A2P = (NodeOptional) n0CHS11A2;
        if (n0CHS11A2P.present()) {
          nRes = n0CHS11A2P.accept(this);
        }
        // #3 ( &0 ArrayDimsAndInits()
        // .. | &1 $0 Arguments()
        // .. .. $1 [ ClassOrInterfaceBody() ] )
        final INode n0CHS1A3 = n0CHS1.elementAt(3);
        final NodeChoice n0CHS1A3C = (NodeChoice) n0CHS1A3;
        final INode n0CHS1A3CH = n0CHS1A3C.choice;
        switch (n0CHS1A3C.which) {
          case 0:
            // &0 ArrayDimsAndInits()
            nRes = n0CHS1A3CH.accept(this);
            break;
          case 1:
            // &1 $0 Arguments()
            // .. $1 [ ClassOrInterfaceBody() ]
            final NodeSequence n0CHS1A3CHS2 = (NodeSequence) n0CHS1A3CH;
            // $0 Arguments()
            final INode n0CHS1A3CHS21A0 = n0CHS1A3CHS2.elementAt(0);
            nRes = n0CHS1A3CHS21A0.accept(this);
            // $1 [ ClassOrInterfaceBody() ]
            final INode n0CHS1A3CHS21A1 = n0CHS1A3CHS2.elementAt(1);
            final NodeOptional n0CHS1A3CHS21A1P = (NodeOptional) n0CHS1A3CHS21A1;
            if (n0CHS1A3CHS21A1P.present()) {
              nRes = n0CHS1A3CHS21A1P.accept(this);
            }
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link ArrayDimsAndInits} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * .. .. | %1 #0 ( $0 "[" $1 "]" )+<br>
   * .. .. . .. #1 ArrayInitializer()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ArrayDimsAndInits n) {
    R nRes = null;
    // f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    // .. .. | %1 #0 ( $0 "[" $1 "]" )+
    // .. .. . .. #1 ArrayInitializer()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
        // .. #1 ( $0 "[" $1 "]" )*
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 ( $0 "[" $1 Expression() $2 "]" )+
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeList n0CHS0A0L = (NodeList) n0CHS0A0;
        for (int i = 0; i < n0CHS0A0L.size(); i++) {
          final INode n0CHS0A0LEi = n0CHS0A0L.elementAt(i);
          final NodeSequence n0CHS0A0LEiS1 = (NodeSequence) n0CHS0A0LEi;
          // $0 "["
          final INode n0CHS0A0LEiS1A0 = n0CHS0A0LEiS1.elementAt(0);
          nRes = n0CHS0A0LEiS1A0.accept(this);
          // $1 Expression()
          final INode n0CHS0A0LEiS1A1 = n0CHS0A0LEiS1.elementAt(1);
          nRes = n0CHS0A0LEiS1A1.accept(this);
          // $2 "]"
          final INode n0CHS0A0LEiS1A2 = n0CHS0A0LEiS1.elementAt(2);
          nRes = n0CHS0A0LEiS1A2.accept(this);
        }
        // #1 ( $0 "[" $1 "]" )*
        final INode n0CHSA1 = n0CHS.elementAt(1);
        final NodeListOptional n0CHSA1T = (NodeListOptional) n0CHSA1;
        if (n0CHSA1T.present()) {
          for (int i = 0; i < n0CHSA1T.size(); i++) {
            final INode n0CHSA1TMi = n0CHSA1T.elementAt(i);
            final NodeSequence n0CHSA1TMiS2 = (NodeSequence) n0CHSA1TMi;
            // $0 "["
            final INode n0CHSA1TMiS2A0 = n0CHSA1TMiS2.elementAt(0);
            nRes = n0CHSA1TMiS2A0.accept(this);
            // $1 "]"
            final INode n0CHSA1TMiS2A1 = n0CHSA1TMiS2.elementAt(1);
            nRes = n0CHSA1TMiS2A1.accept(this);
          }
        }
        break;
      case 1:
        // %1 #0 ( $0 "[" $1 "]" )+
        // .. #1 ArrayInitializer()
        final NodeSequence n0CHS3 = (NodeSequence) n0CH;
        // #0 ( $0 "[" $1 "]" )+
        final INode n0CHS31A0 = n0CHS3.elementAt(0);
        final NodeList n0CHS31A0L1 = (NodeList) n0CHS31A0;
        for (int i = 0; i < n0CHS31A0L1.size(); i++) {
          final INode n0CHS31A0L1Ei = n0CHS31A0L1.elementAt(i);
          final NodeSequence n0CHS31A0L1EiS4 = (NodeSequence) n0CHS31A0L1Ei;
          // $0 "["
          final INode n0CHS31A0L1EiS4A0 = n0CHS31A0L1EiS4.elementAt(0);
          nRes = n0CHS31A0L1EiS4A0.accept(this);
          // $1 "]"
          final INode n0CHS31A0L1EiS4A1 = n0CHS31A0L1EiS4.elementAt(1);
          nRes = n0CHS31A0L1EiS4A1.accept(this);
        }
        // #1 ArrayInitializer()
        final INode n0CHS3A1 = n0CHS3.elementAt(1);
        nRes = n0CHS3A1.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link Statement} node, whose child is the following :
   * <p>
   * f0 -> . %00 LabeledStatement()<br>
   * .. .. | %01 AssertStatement()<br>
   * .. .. | %02 Block()<br>
   * .. .. | %03 EmptyStatement()<br>
   * .. .. | %04 #0 StatementExpression() #1 ";"<br>
   * .. .. | %05 SwitchStatement()<br>
   * .. .. | %06 IfStatement()<br>
   * .. .. | %07 WhileStatement()<br>
   * .. .. | %08 DoStatement()<br>
   * .. .. | %09 ForStatement()<br>
   * .. .. | %10 BreakStatement()<br>
   * .. .. | %11 ContinueStatement()<br>
   * .. .. | %12 ReturnStatement()<br>
   * .. .. | %13 ThrowStatement()<br>
   * .. .. | %14 SynchronizedStatement()<br>
   * .. .. | %15 TryStatement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Statement n) {
    R nRes = null;
    // f0 -> . %00 LabeledStatement()
    // .. .. | %01 AssertStatement()
    // .. .. | %02 Block()
    // .. .. | %03 EmptyStatement()
    // .. .. | %04 #0 StatementExpression() #1 ";"
    // .. .. | %05 SwitchStatement()
    // .. .. | %06 IfStatement()
    // .. .. | %07 WhileStatement()
    // .. .. | %08 DoStatement()
    // .. .. | %09 ForStatement()
    // .. .. | %10 BreakStatement()
    // .. .. | %11 ContinueStatement()
    // .. .. | %12 ReturnStatement()
    // .. .. | %13 ThrowStatement()
    // .. .. | %14 SynchronizedStatement()
    // .. .. | %15 TryStatement()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %00 LabeledStatement()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %01 AssertStatement()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %02 Block()
        nRes = n0CH.accept(this);
        break;
      case 3:
        // %03 EmptyStatement()
        nRes = n0CH.accept(this);
        break;
      case 4:
        // %04 #0 StatementExpression() #1 ";"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 StatementExpression()
        final INode n0CHS4A0 = n0CHS.elementAt(0);
        nRes = n0CHS4A0.accept(this);
        // #1 ";"
        final INode n0CHS4A1 = n0CHS.elementAt(1);
        nRes = n0CHS4A1.accept(this);
        break;
      case 5:
        // %05 SwitchStatement()
        nRes = n0CH.accept(this);
        break;
      case 6:
        // %06 IfStatement()
        nRes = n0CH.accept(this);
        break;
      case 7:
        // %07 WhileStatement()
        nRes = n0CH.accept(this);
        break;
      case 8:
        // %08 DoStatement()
        nRes = n0CH.accept(this);
        break;
      case 9:
        // %09 ForStatement()
        nRes = n0CH.accept(this);
        break;
      case 10:
        // %10 BreakStatement()
        nRes = n0CH.accept(this);
        break;
      case 11:
        // %11 ContinueStatement()
        nRes = n0CH.accept(this);
        break;
      case 12:
        // %12 ReturnStatement()
        nRes = n0CH.accept(this);
        break;
      case 13:
        // %13 ThrowStatement()
        nRes = n0CH.accept(this);
        break;
      case 14:
        // %14 SynchronizedStatement()
        nRes = n0CH.accept(this);
        break;
      case 15:
        // %15 TryStatement()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link AssertStatement} node, whose children are the following :
   * <p>
   * f0 -> "assert"<br>
   * f1 -> Expression()<br>
   * f2 -> [ #0 ":" #1 Expression() ]<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AssertStatement n) {
    R nRes = null;
    // f0 -> "assert"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ #0 ":" #1 Expression() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence n2S = (NodeSequence) n2.node;
      // #0 ":"
      final INode n2SA0 = n2S.elementAt(0);
      nRes = n2SA0.accept(this);
      // #1 Expression()
      final INode n2SA1 = n2S.elementAt(1);
      nRes = n2SA1.accept(this);
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link LabeledStatement} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ":"<br>
   * f2 -> Statement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final LabeledStatement n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ":"
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Statement()
    final Statement n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Block} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( BlockStatement() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Block n) {
    R nRes = null;
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( BlockStatement() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        nRes = n1Mi.accept(this);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BlockStatement} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"<br>
   * .. .. | %1 Statement()<br>
   * .. .. | %2 ClassOrInterfaceDeclaration()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final BlockStatement n) {
    R nRes = null;
    // f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"
    // .. .. | %1 Statement()
    // .. .. | %2 ClassOrInterfaceDeclaration()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 LocalVariableDeclaration() #1 ";"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 LocalVariableDeclaration()
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 ";"
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        break;
      case 1:
        // %1 Statement()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 ClassOrInterfaceDeclaration()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link LocalVariableDeclaration} node, whose children are the following :
   * <p>
   * f0 -> VariableModifiers()<br>
   * f1 -> Type()<br>
   * f2 -> VariableDeclarator()<br>
   * f3 -> ( #0 "," #1 VariableDeclarator() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final LocalVariableDeclaration n) {
    R nRes = null;
    // f0 -> VariableModifiers()
    final VariableModifiers n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Type()
    final Type n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> VariableDeclarator()
    final VariableDeclarator n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n3 = n.f3;
    if (n3.present()) {
      for (int i = 0; i < n3.size(); i++) {
        final INode n3Mi = n3.elementAt(i);
        final NodeSequence n3MiS = (NodeSequence) n3Mi;
        // #0 ","
        final INode n3MiSA0 = n3MiS.elementAt(0);
        nRes = n3MiSA0.accept(this);
        // #1 VariableDeclarator()
        final INode n3MiSA1 = n3MiS.elementAt(1);
        nRes = n3MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link VariableModifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %0 "final"<br>
   * .. .. . | %1 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final VariableModifiers n) {
    R nRes = null;
    // f0 -> ( ( %0 "final"
    // .. .. . | %1 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode n0Mi = n0.elementAt(i);
        final NodeChoice n0MiC = (NodeChoice) n0Mi;
        final INode n0MiCH = n0MiC.choice;
        switch (n0MiC.which) {
          case 0:
            // %0 "final"
            nRes = n0MiCH.accept(this);
            break;
          case 1:
            // %1 Annotation()
            nRes = n0MiCH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link EmptyStatement} node, whose child is the following :
   * <p>
   * f0 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final EmptyStatement n) {
    R nRes = null;
    // f0 -> ";"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link StatementExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 PreIncrementExpression()<br>
   * .. .. | %1 PreDecrementExpression()<br>
   * .. .. | %2 #0 PrimaryExpression()<br>
   * .. .. . .. #1 [ &0 "++"<br>
   * .. .. . .. .. | &1 "--"<br>
   * .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final StatementExpression n) {
    R nRes = null;
    // f0 -> . %0 PreIncrementExpression()
    // .. .. | %1 PreDecrementExpression()
    // .. .. | %2 #0 PrimaryExpression()
    // .. .. . .. #1 [ &0 "++"
    // .. .. . .. .. | &1 "--"
    // .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 PreIncrementExpression()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 PreDecrementExpression()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 #0 PrimaryExpression()
        // .. #1 [ &0 "++"
        // .. .. | &1 "--"
        // .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 PrimaryExpression()
        final INode n0CHS2A0 = n0CHS.elementAt(0);
        nRes = n0CHS2A0.accept(this);
        // #1 [ &0 "++"
        // .. | &1 "--"
        // .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final INode n0CHS2A1 = n0CHS.elementAt(1);
        final NodeOptional n0CHS2A1P = (NodeOptional) n0CHS2A1;
        if (n0CHS2A1P.present()) {
          final NodeChoice n0CHS2A1PC = (NodeChoice) n0CHS2A1P.node;
          final INode n0CHS2A1PCH = n0CHS2A1PC.choice;
          switch (n0CHS2A1PC.which) {
            case 0:
              // &0 "++"
              nRes = n0CHS2A1PCH.accept(this);
              break;
            case 1:
              // &1 "--"
              nRes = n0CHS2A1PCH.accept(this);
              break;
            case 2:
              // &2 $0 AssignmentOperator() $1 Expression()
              final NodeSequence n0CHS2A1PCHS1 = (NodeSequence) n0CHS2A1PCH;
              // $0 AssignmentOperator()
              final INode n0CHS2A1PCHS12A0 = n0CHS2A1PCHS1.elementAt(0);
              nRes = n0CHS2A1PCHS12A0.accept(this);
              // $1 Expression()
              final INode n0CHS2A1PCHS12A1 = n0CHS2A1PCHS1.elementAt(1);
              nRes = n0CHS2A1PCHS12A1.accept(this);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link SwitchStatement} node, whose children are the following :
   * <p>
   * f0 -> "switch"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> "{"<br>
   * f5 -> ( #0 SwitchLabel()<br>
   * .. .. . #1 ( BlockStatement() )* )*<br>
   * f6 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final SwitchStatement n) {
    R nRes = null;
    // f0 -> "switch"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> ( #0 SwitchLabel()
    // .. .. . #1 ( BlockStatement() )* )*
    final NodeListOptional n5 = n.f5;
    if (n5.present()) {
      for (int i = 0; i < n5.size(); i++) {
        final INode n5Mi = n5.elementAt(i);
        final NodeSequence n5MiS = (NodeSequence) n5Mi;
        // #0 SwitchLabel()
        final INode n5MiSA0 = n5MiS.elementAt(0);
        nRes = n5MiSA0.accept(this);
        // #1 ( BlockStatement() )*
        final INode n5MiSA1 = n5MiS.elementAt(1);
        final NodeListOptional n5MiSA1T = (NodeListOptional) n5MiSA1;
        if (n5MiSA1T.present()) {
          for (int i1 = 0; i1 < n5MiSA1T.size(); i1++) {
            final INode n5MiSA1TMi = n5MiSA1T.elementAt(i1);
            nRes = n5MiSA1TMi.accept(this);
          }
        }
      }
    }
    // f6 -> "}"
    final NodeToken n6 = n.f6;
    nRes = n6.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link SwitchLabel} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "case" #1 Expression() #2 ":"<br>
   * .. .. | %1 #0 "default" #1 ":"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final SwitchLabel n) {
    R nRes = null;
    // f0 -> . %0 #0 "case" #1 Expression() #2 ":"
    // .. .. | %1 #0 "default" #1 ":"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "case" #1 Expression() #2 ":"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "case"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 Expression()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        nRes = n0CHS0A1.accept(this);
        // #2 ":"
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        nRes = n0CHS0A2.accept(this);
        break;
      case 1:
        // %1 #0 "default" #1 ":"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "default"
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        nRes = n0CHS11A0.accept(this);
        // #1 ":"
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        nRes = n0CHS11A1.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link IfStatement} node, whose children are the following :
   * <p>
   * f0 -> "if"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * f5 -> [ #0 "else" #1 Statement() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final IfStatement n) {
    R nRes = null;
    // f0 -> "if"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> [ #0 "else" #1 Statement() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence n5S = (NodeSequence) n5.node;
      // #0 "else"
      final INode n5SA0 = n5S.elementAt(0);
      nRes = n5SA0.accept(this);
      // #1 Statement()
      final INode n5SA1 = n5S.elementAt(1);
      nRes = n5SA1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link WhileStatement} node, whose children are the following :
   * <p>
   * f0 -> "while"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final WhileStatement n) {
    R nRes = null;
    // f0 -> "while"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link DoStatement} node, whose children are the following :
   * <p>
   * f0 -> "do"<br>
   * f1 -> Statement()<br>
   * f2 -> "while"<br>
   * f3 -> "("<br>
   * f4 -> Expression()<br>
   * f5 -> ")"<br>
   * f6 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final DoStatement n) {
    R nRes = null;
    // f0 -> "do"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Statement()
    final Statement n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "while"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> "("
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Expression()
    final Expression n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> ")"
    final NodeToken n5 = n.f5;
    nRes = n5.accept(this);
    // f6 -> ";"
    final NodeToken n6 = n.f6;
    nRes = n6.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ForStatement} node, whose children are the following :
   * <p>
   * f0 -> "for"<br>
   * f1 -> "("<br>
   * f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()<br>
   * .. .. | %1 #0 [ ForInit() ]<br>
   * .. .. . .. #1 ";"<br>
   * .. .. . .. #2 [ Expression() ]<br>
   * .. .. . .. #3 ";"<br>
   * .. .. . .. #4 [ ForUpdate() ] )<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ForStatement n) {
    R nRes = null;
    // f0 -> "for"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()
    // .. .. | %1 #0 [ ForInit() ]
    // .. .. . .. #1 ";"
    // .. .. . .. #2 [ Expression() ]
    // .. .. . .. #3 ";"
    // .. .. . .. #4 [ ForUpdate() ] )
    final NodeChoice n2 = n.f2;
    final NodeChoice n2C = n2;
    final INode n2CH = n2C.choice;
    switch (n2C.which) {
      case 0:
        // %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()
        final NodeSequence n2CHS = (NodeSequence) n2CH;
        // #0 VariableModifiers()
        final INode n2CHS0A0 = n2CHS.elementAt(0);
        nRes = n2CHS0A0.accept(this);
        // #1 Type()
        final INode n2CHS0A1 = n2CHS.elementAt(1);
        nRes = n2CHS0A1.accept(this);
        // #2 <IDENTIFIER>
        final INode n2CHS0A2 = n2CHS.elementAt(2);
        nRes = n2CHS0A2.accept(this);
        // #3 ":"
        final INode n2CHS0A3 = n2CHS.elementAt(3);
        nRes = n2CHS0A3.accept(this);
        // #4 Expression()
        final INode n2CHS0A4 = n2CHS.elementAt(4);
        nRes = n2CHS0A4.accept(this);
        break;
      case 1:
        // %1 #0 [ ForInit() ]
        // .. #1 ";"
        // .. #2 [ Expression() ]
        // .. #3 ";"
        // .. #4 [ ForUpdate() ]
        final NodeSequence n2CHS1 = (NodeSequence) n2CH;
        // #0 [ ForInit() ]
        final INode n2CHS11A0 = n2CHS1.elementAt(0);
        final NodeOptional n2CHS11A0P = (NodeOptional) n2CHS11A0;
        if (n2CHS11A0P.present()) {
          nRes = n2CHS11A0P.accept(this);
        }
        // #1 ";"
        final INode n2CHS1A1 = n2CHS1.elementAt(1);
        nRes = n2CHS1A1.accept(this);
        // #2 [ Expression() ]
        final INode n2CHS1A2 = n2CHS1.elementAt(2);
        final NodeOptional n2CHS1A2P = (NodeOptional) n2CHS1A2;
        if (n2CHS1A2P.present()) {
          nRes = n2CHS1A2P.accept(this);
        }
        // #3 ";"
        final INode n2CHS1A3 = n2CHS1.elementAt(3);
        nRes = n2CHS1A3.accept(this);
        // #4 [ ForUpdate() ]
        final INode n2CHS1A4 = n2CHS1.elementAt(4);
        final NodeOptional n2CHS1A4P = (NodeOptional) n2CHS1A4;
        if (n2CHS1A4P.present()) {
          nRes = n2CHS1A4P.accept(this);
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ForInit} node, whose child is the following :
   * <p>
   * f0 -> . %0 LocalVariableDeclaration()<br>
   * .. .. | %1 StatementExpressionList()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ForInit n) {
    R nRes = null;
    // f0 -> . %0 LocalVariableDeclaration()
    // .. .. | %1 StatementExpressionList()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 LocalVariableDeclaration()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 StatementExpressionList()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link StatementExpressionList} node, whose children are the following :
   * <p>
   * f0 -> StatementExpression()<br>
   * f1 -> ( #0 "," #1 StatementExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final StatementExpressionList n) {
    R nRes = null;
    // f0 -> StatementExpression()
    final StatementExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 StatementExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 StatementExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ForUpdate} node, whose child is the following :
   * <p>
   * f0 -> StatementExpressionList()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ForUpdate n) {
    R nRes = null;
    // f0 -> StatementExpressionList()
    final StatementExpressionList n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BreakStatement} node, whose children are the following :
   * <p>
   * f0 -> "break"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final BreakStatement n) {
    R nRes = null;
    // f0 -> "break"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ <IDENTIFIER> ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ContinueStatement} node, whose children are the following :
   * <p>
   * f0 -> "continue"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ContinueStatement n) {
    R nRes = null;
    // f0 -> "continue"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ <IDENTIFIER> ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ReturnStatement} node, whose children are the following :
   * <p>
   * f0 -> "return"<br>
   * f1 -> [ Expression() ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ReturnStatement n) {
    R nRes = null;
    // f0 -> "return"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ThrowStatement} node, whose children are the following :
   * <p>
   * f0 -> "throw"<br>
   * f1 -> Expression()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final ThrowStatement n) {
    R nRes = null;
    // f0 -> "throw"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link SynchronizedStatement} node, whose children are the following :
   * <p>
   * f0 -> "synchronized"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Block()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final SynchronizedStatement n) {
    R nRes = null;
    // f0 -> "synchronized"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Block()
    final Block n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TryStatement} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> Block()<br>
   * f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*<br>
   * f3 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final TryStatement n) {
    R nRes = null;
    // f0 -> "try"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Block()
    final Block n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "catch"
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 "("
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
        // #2 FormalParameter()
        final INode n2MiSA2 = n2MiS.elementAt(2);
        nRes = n2MiSA2.accept(this);
        // #3 ")"
        final INode n2MiSA3 = n2MiS.elementAt(3);
        nRes = n2MiSA3.accept(this);
        // #4 Block()
        final INode n2MiSA4 = n2MiS.elementAt(4);
        nRes = n2MiSA4.accept(this);
      }
    }
    // f3 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S1 = (NodeSequence) n3.node;
      // #0 "finally"
      final INode n3S1A0 = n3S1.elementAt(0);
      nRes = n3S1A0.accept(this);
      // #1 Block()
      final INode n3S1A1 = n3S1.elementAt(1);
      nRes = n3S1A1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link Annotation} node, whose child is the following :
   * <p>
   * f0 -> . %0 NormalAnnotation()<br>
   * .. .. | %1 SingleMemberAnnotation()<br>
   * .. .. | %2 MarkerAnnotation()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Annotation n) {
    R nRes = null;
    // f0 -> . %0 NormalAnnotation()
    // .. .. | %1 SingleMemberAnnotation()
    // .. .. | %2 MarkerAnnotation()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 NormalAnnotation()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 SingleMemberAnnotation()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 MarkerAnnotation()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link NormalAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> [ MemberValuePairs() ]<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NormalAnnotation n) {
    R nRes = null;
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ MemberValuePairs() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MarkerAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MarkerAnnotation n) {
    R nRes = null;
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link SingleMemberAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> MemberValue()<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final SingleMemberAnnotation n) {
    R nRes = null;
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> MemberValue()
    final MemberValue n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MemberValuePairs} node, whose children are the following :
   * <p>
   * f0 -> MemberValuePair()<br>
   * f1 -> ( #0 "," #1 MemberValuePair() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MemberValuePairs n) {
    R nRes = null;
    // f0 -> MemberValuePair()
    final MemberValuePair n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 MemberValuePair() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        nRes = n1MiSA0.accept(this);
        // #1 MemberValuePair()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        nRes = n1MiSA1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link MemberValuePair} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> "="<br>
   * f2 -> MemberValue()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MemberValuePair n) {
    R nRes = null;
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "="
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> MemberValue()
    final MemberValue n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MemberValue} node, whose child is the following :
   * <p>
   * f0 -> . %0 Annotation()<br>
   * .. .. | %1 MemberValueArrayInitializer()<br>
   * .. .. | %2 ConditionalExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MemberValue n) {
    R nRes = null;
    // f0 -> . %0 Annotation()
    // .. .. | %1 MemberValueArrayInitializer()
    // .. .. | %2 ConditionalExpression()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 Annotation()
        nRes = n0CH.accept(this);
        break;
      case 1:
        // %1 MemberValueArrayInitializer()
        nRes = n0CH.accept(this);
        break;
      case 2:
        // %2 ConditionalExpression()
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link MemberValueArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> MemberValue()<br>
   * f2 -> ( #0 "," #1 MemberValue() )*<br>
   * f3 -> [ "," ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final MemberValueArrayInitializer n) {
    R nRes = null;
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 MemberValue() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        nRes = n2MiSA0.accept(this);
        // #1 MemberValue()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        nRes = n2MiSA1.accept(this);
      }
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> "}"
    final NodeToken n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> "interface"<br>
   * f2 -> <IDENTIFIER><br>
   * f3 -> AnnotationTypeBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AnnotationTypeDeclaration n) {
    R nRes = null;
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "interface"
    final NodeToken n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> <IDENTIFIER>
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> AnnotationTypeBody()
    final AnnotationTypeBody n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( AnnotationTypeMemberDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AnnotationTypeBody n) {
    R nRes = null;
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( AnnotationTypeMemberDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        nRes = n1Mi.accept(this);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeMemberDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"<br>
   * .. .. . .. .. . .. $4 [ DefaultValue() ]<br>
   * .. .. . .. .. . .. $5 ";"<br>
   * .. .. . .. .. | &1 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &2 EnumDeclaration()<br>
   * .. .. . .. .. | &3 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration() )<br>
   * .. .. | %1 ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final AnnotationTypeMemberDeclaration n) {
    R nRes = null;
    // f0 -> . %0 #0 Modifiers()
    // .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
    // .. .. . .. .. . .. $4 [ DefaultValue() ]
    // .. .. . .. .. . .. $5 ";"
    // .. .. . .. .. | &1 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &2 EnumDeclaration()
    // .. .. . .. .. | &3 AnnotationTypeDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration() )
    // .. .. | %1 ";"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 Modifiers()
        // .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
        // .. .. .. $4 [ DefaultValue() ]
        // .. .. .. $5 ";"
        // .. .. | &1 ClassOrInterfaceDeclaration()
        // .. .. | &2 EnumDeclaration()
        // .. .. | &3 AnnotationTypeDeclaration()
        // .. .. | &4 FieldDeclaration() )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 Modifiers()
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        nRes = n0CHS0A0.accept(this);
        // #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
        // .. .. $4 [ DefaultValue() ]
        // .. .. $5 ";"
        // .. | &1 ClassOrInterfaceDeclaration()
        // .. | &2 EnumDeclaration()
        // .. | &3 AnnotationTypeDeclaration()
        // .. | &4 FieldDeclaration() )
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        final NodeChoice n0CHS0A1C = (NodeChoice) n0CHS0A1;
        final INode n0CHS0A1CH = n0CHS0A1C.choice;
        switch (n0CHS0A1C.which) {
          case 0:
            // &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
            // .. $4 [ DefaultValue() ]
            // .. $5 ";"
            final NodeSequence n0CHS0A1CHS1 = (NodeSequence) n0CHS0A1CH;
            // $0 Type()
            final INode n0CHS0A1CHS10A0 = n0CHS0A1CHS1.elementAt(0);
            nRes = n0CHS0A1CHS10A0.accept(this);
            // $1 <IDENTIFIER>
            final INode n0CHS0A1CHS10A1 = n0CHS0A1CHS1.elementAt(1);
            nRes = n0CHS0A1CHS10A1.accept(this);
            // $2 "("
            final INode n0CHS0A1CHS10A2 = n0CHS0A1CHS1.elementAt(2);
            nRes = n0CHS0A1CHS10A2.accept(this);
            // $3 ")"
            final INode n0CHS0A1CHS10A3 = n0CHS0A1CHS1.elementAt(3);
            nRes = n0CHS0A1CHS10A3.accept(this);
            // $4 [ DefaultValue() ]
            final INode n0CHS0A1CHS10A4 = n0CHS0A1CHS1.elementAt(4);
            final NodeOptional n0CHS0A1CHS10A4P = (NodeOptional) n0CHS0A1CHS10A4;
            if (n0CHS0A1CHS10A4P.present()) {
              nRes = n0CHS0A1CHS10A4P.accept(this);
            }
            // $5 ";"
            final INode n0CHS0A1CHS1A5 = n0CHS0A1CHS1.elementAt(5);
            nRes = n0CHS0A1CHS1A5.accept(this);
            break;
          case 1:
            // &1 ClassOrInterfaceDeclaration()
            nRes = n0CHS0A1CH.accept(this);
            break;
          case 2:
            // &2 EnumDeclaration()
            nRes = n0CHS0A1CH.accept(this);
            break;
          case 3:
            // &3 AnnotationTypeDeclaration()
            nRes = n0CHS0A1CH.accept(this);
            break;
          case 4:
            // &4 FieldDeclaration()
            nRes = n0CHS0A1CH.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 1:
        // %1 ";"
        nRes = n0CH.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    return nRes;
  }

  /**
   * Visits a {@link DefaultValue} node, whose children are the following :
   * <p>
   * f0 -> "default"<br>
   * f1 -> MemberValue()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final DefaultValue n) {
    R nRes = null;
    // f0 -> "default"
    final NodeToken n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

}
