.\" @(#)$RCSfile: gfal_creat.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_CREAT 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_creat \- create a new file or truncate an existing one
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_creat (const char *" filename ,
.BI "mode_t " mode );
.sp
Under Linux, for large files:
.br
.B #define _LARGEFILE64_SOURCE
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_creat64 (const char *" filename ,
.BI "mode_t " mode );
.sp
For large files, under other systems:
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_creat64 (const char *" filename ,
.BI "mode_t " mode );
.SH DESCRIPTION
.B gfal_creat
creates a new file or truncates an existing one.
.TP
.I filename
specifies the file name: either a logical file name, a guid, an SURL or a TURL.
.TP
.I mode
is used only if the file is created.
.LP
gfal_creat (filename, mode) is equivalent to:

	open(filename, O_WRONLY | O_CREAT | O_TRUNC, mode)
.SH RETURN VALUE
This routine returns a write-only file descriptor if the operation was successful
or -1 if the operation failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EACCES
Search permission is denied on a component of the
.I filename
prefix or the file does not exist and write permission on the parent directory
is denied or the file exists and write permission on the file itself is denied.
.TP
.B EFAULT
.I filename
is a NULL pointer.
.TP
.B EBUSY
Device or resource busy. Happens if you try to open in write mode a CASTOR file that is in an active migration stream.
.TP
.B ENOTDIR
A component of
.I filename
prefix is not a directory.
.TP
.B EINVAL
.I filename
has an invalid syntax.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
