#!/bin/bash
#
# Copyright 2016, International Business Machines
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# Test-script to measure compression ratio
#
data=linux.tar

function extract_real_time() {
    local file=$1;

    duration=`grep real $file | perl -e '$a=<STDIN>; $a=~m/([0-9]*)m([0-9]*)\.([0-9]*)/; $sec=$1*60+$2; $msec=$3; print "$sec,$msec"'`
    echo "; ${duration}"
}

function usage() {
    echo "ratio_test.sh"
}

echo "Generate tar if it is not exsiting yet ..."

if [ ! -d linux ]; then
    echo "linux directory missing, needed to perform this measurement!"
    exit 1
fi
if [ ! -f ${data} ]; then
    time tar cf ${data} linux
else
    echo "    ${data} already existing, skipping"
fi
du -ch ${data}

echo -n "Hardware ...         "
rm -f linux.hw.tar.gz
sync
(time PATH=/usr/bin/genwqe:$PATH ZLIB_TRACE=0x0 ZLIB_ACCELERATOR=CAPI \
    gzip -c ${data} > linux.hw.tar.gz) 2> output.stderr
extract_real_time output.stderr
du -ch linux.hw.tar.gz

echo -n "Software default     "
rm -f linux.sw.default.tar.gz
sync
(time gzip -c ${data} > linux.sw.default.tar.gz) 2> output.stderr
extract_real_time output.stderr
du -ch linux.sw.default.tar.gz

echo -n "Software fast        "
rm -f linux.sw.fast.tar.gz
sync
(time gzip -1 -c ${data} > linux.sw.fast.tar.gz) 2> output.stderr
extract_real_time output.stderr
du -ch linux.sw.fast.tar.gz

echo -n "Software best        "
rm -f linux.sw.best.tar.gz
sync
(time gzip -9 -c ${data} > linux.sw.best.tar.gz) 2> output.stderr
extract_real_time output.stderr
du -ch linux.sw.best.tar.gz

exit 0
