;; DFA-based pipeline description for I6400.
;;
;; Copyright (C) 2015-2021 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "i6400_int_pipe, i6400_mdu_pipe, i6400_fpu_short_pipe,
		   i6400_fpu_long_pipe")

(define_cpu_unit "i6400_gpmul, i6400_gpdiv" "i6400_mdu_pipe")
(define_cpu_unit "i6400_agen, i6400_alu1, i6400_lsu" "i6400_int_pipe")
(define_cpu_unit "i6400_control, i6400_ctu, i6400_alu0" "i6400_int_pipe")

;; Short FPU pipeline.
(define_cpu_unit "i6400_fpu_short, i6400_fpu_intadd, i6400_fpu_logic,
		  i6400_fpu_div, i6400_fpu_cmp, i6400_fpu_float,
		  i6400_fpu_store" "i6400_fpu_short_pipe")

;; Long FPU pipeline.
(define_cpu_unit "i6400_fpu_long, i6400_fpu_logic_l, i6400_fpu_float_l,
		  i6400_fpu_mult, i6400_fpu_apu" "i6400_fpu_long_pipe")

(define_reservation "i6400_control_ctu" "i6400_control, i6400_ctu")
(define_reservation "i6400_control_alu0" "i6400_control, i6400_alu0")
(define_reservation "i6400_agen_lsu" "i6400_agen, i6400_lsu")
(define_reservation "i6400_agen_alu1" "i6400_agen, i6400_alu1")

;;
;; FPU-MSA pipe
;;

;; Short pipe

;; addv, subv
(define_insn_reservation "i6400_msa_add_d" 1
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "!V2DI")
	    (eq_attr "alu_type" "simd_add")))
  "i6400_fpu_short+i6400_fpu_intadd*2")

;; add, hadd, sub, hsub, average, min, max, compare
(define_insn_reservation "i6400_msa_int_add" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_int_arith"))
  "i6400_fpu_short+i6400_fpu_intadd*2")

;; sat, pcnt
(define_insn_reservation "i6400_msa_short_logic3" 3
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_sat,simd_pcnt"))
  "i6400_fpu_short+i6400_fpu_logic*2")

;; shifts, nloc, nlzc, bneg, bclr, shf
(define_insn_reservation "i6400_msa_short_logic2" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_shift,simd_shf,simd_bit"))
  "i6400_fpu_short+i6400_fpu_logic*2")

;; and, or, xor, ilv, pck, fill, splat
(define_insn_reservation "i6400_msa_short_logic" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_permute,simd_logic,simd_splat,simd_fill"))
  "i6400_fpu_short+i6400_fpu_logic*2")

;; move.v, ldi
(define_insn_reservation "i6400_msa_move" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_move"))
  "i6400_fpu_short+i6400_fpu_logic*2")

;; Float compare New: CMP.cond.fmt
(define_insn_reservation "i6400_msa_cmp" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_fcmp"))
  "i6400_fpu_short+i6400_fpu_cmp*2")

;; Float min, max, class
(define_insn_reservation "i6400_msa_short_float2" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_fminmax,simd_fclass"))
  "i6400_fpu_short+i6400_fpu_float*2")

;; div.d, mod.d (non-pipelined)
(define_insn_reservation "i6400_msa_div_d" 36
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "V2DI")
	    (eq_attr "type" "simd_div")))
  "i6400_fpu_short+i6400_fpu_div*36")

;; div.w, mod.w (non-pipelined)
(define_insn_reservation "i6400_msa_div_w" 20
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "V4SI")
	    (eq_attr "type" "simd_div")))
  "i6400_fpu_short+i6400_fpu_div*20")

;; div.h, mod.h (non-pipelined)
(define_insn_reservation "i6400_msa_div_h" 12
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "V8HI")
	    (eq_attr "type" "simd_div")))
  "i6400_fpu_short+i6400_fpu_div*12")

;; div.b, mod.b (non-pipelined)
(define_insn_reservation "i6400_msa_div_b" 8
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "V16QI")
	    (eq_attr "type" "simd_div")))
  "i6400_fpu_short+i6400_fpu_div*8")

;; Vector copy
(define_insn_reservation "i6400_msa_copy" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_copy"))
  "i6400_fpu_short, i6400_fpu_store")

;; Vector bz, bnz
(define_insn_reservation "i6400_msa_branch" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_branch"))
  "i6400_control_ctu")

;; Vector store
(define_insn_reservation "i6400_fpu_msa_store" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_store"))
  "i6400_agen_lsu")

;; Vector load
(define_insn_reservation "i6400_fpu_msa_load" 3
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_load"))
  "i6400_agen_lsu")

;; cfcmsa, ctcmsa
(define_insn_reservation "i6400_fpu_msa_move" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_cmsa"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; Long pipe

;; bmz, bmnz, bsel, insert, insve
(define_insn_reservation "i6400_msa_long_logic1" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_bitmov,simd_insert"))
  "i6400_fpu_long+i6400_fpu_logic_l*2")

;; binsl, binsr, vshf, sld
(define_insn_reservation "i6400_msa_long_logic2" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_bitins,simd_sld"))
  "i6400_fpu_long+i6400_fpu_logic_l*2")

;; Vector mul, dotp, madd, msub
(define_insn_reservation "i6400_msa_mult" 5
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_mul"))
  "i6400_fpu_long+i6400_fpu_mult*2")

;; Float flog2
(define_insn_reservation "i6400_msa_long_float2" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_flog2"))
  "i6400_fpu_long+i6400_fpu_float_l*2")

;; fadd, fsub
(define_insn_reservation "i6400_msa_long_float4" 4
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_fadd,simd_fcvt"))
  "i6400_fpu_long+i6400_fpu_float_l*2")

;; fmul, fexp2
(define_insn_reservation "i6400_msa_long_float5" 5
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_fmul,simd_fexp2"))
  "i6400_fpu_long+i6400_fpu_float_l*2")

;; fmadd, fmsub
(define_insn_reservation "i6400_msa_long_float8" 8
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_fmadd"))
  "i6400_fpu_long+i6400_fpu_float_l*2")

;; fdiv.d
(define_insn_reservation "i6400_msa_fdiv_df" 30
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "V2DF")
	    (eq_attr "type" "simd_fdiv")))
  "i6400_fpu_long+i6400_fpu_float_l*30")

;; fdiv.w
(define_insn_reservation "i6400_msa_fdiv_sf" 22
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "simd_fdiv"))
  "i6400_fpu_long+i6400_fpu_float_l*22")

;;
;; FPU pipe
;;

;; fabs, fneg
(define_insn_reservation "i6400_fpu_fabs" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fabs,fneg,fmove"))
  "i6400_fpu_short, i6400_fpu_apu")

;; fadd, fsub, fcvt
(define_insn_reservation "i6400_fpu_fadd" 4
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fadd,fcvt"))
  "i6400_fpu_long, i6400_fpu_apu")

;; fmul
(define_insn_reservation "i6400_fpu_fmul" 5
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fmul"))
  "i6400_fpu_long, i6400_fpu_apu")

;; div, sqrt (Double Precision)
(define_insn_reservation "i6400_fpu_div_df" 30
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "DF")
	    (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")))
  "i6400_fpu_long+i6400_fpu_apu*30")

;; div, sqrt (Single Precision)
(define_insn_reservation "i6400_fpu_div_sf" 22
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt"))
  "i6400_fpu_long+i6400_fpu_apu*22")

;; sdc1, swc1
(define_insn_reservation "i6400_fpu_store" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fpstore"))
  "i6400_agen_lsu")

;; ldc1, lwc1
(define_insn_reservation "i6400_fpu_load" 3
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fpload"))
  "i6400_agen_lsu")

;; mfc, mtc
(define_insn_reservation "i6400_fpu_move" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "move_type" "mfc, mtc"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; fcmp
(define_insn_reservation "i6400_fpu_fcmp" 2
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fcmp"))
  "i6400_fpu_short, i6400_fpu_apu")

;; fmadd
(define_insn_reservation "i6400_fpu_fmadd" 8
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fmadd"))
  "i6400_fpu_long, i6400_fpu_apu")

;;
;; Integer pipe
;;

;; and, lui, shifts, seb, seh
(define_insn_reservation "i6400_int_logical" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "move_type" "logical,const,andi,sll0,signext"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; addi, addiu, ori, xori, add, addu, sub, nor
(define_insn_reservation "i6400_int_add" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "alu_type" "add,sub,or,xor,nor"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; shifts, clo, clz, cond move, arith
(define_insn_reservation "i6400_int_arith" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "shift,slt,move,clz,condmove,arith"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; nop
(define_insn_reservation "i6400_int_nop" 0
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "nop"))
  "nothing")

;; mul, mulu, muh, muhu
(define_insn_reservation "i6400_int_mult" 4
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "imul3,imul,imul3nc"))
  "i6400_gpmul")

;; divide
(define_insn_reservation "i6400_int_div" 32
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "idiv,idiv3"))
  "i6400_gpdiv*32")

;; Load lb, lbu, lh, lhu, lq, lw, lw_i2f, lwxs
(define_insn_reservation "i6400_int_load" 3
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "load"))
  "i6400_agen_lsu")

;; store
(define_insn_reservation "i6400_int_store" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "store"))
  "i6400_agen_lsu")

;; prefetch
(define_insn_reservation "i6400_int_prefetch" 0
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "prefetch"))
  "i6400_agen_lsu")

;; branch and jump
(define_insn_reservation "i6400_int_branch" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "branch,jump"))
  "i6400_control_ctu")

;; call
(define_insn_reservation "i6400_int_call" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "jal" "indirect,direct"))
  "i6400_control_ctu")
