/* bluez-backend.c generated by valac 0.36.1.697-2b74, the Vala compiler
 * generated from bluez-backend.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Arun Raghavan <arun.raghavan@collabora.co.uk>
 *       Jeremy Whiting <jeremy.whiting@collabora.com>
 *       Simon McVittie <simon.mcvittie@collabora.co.uk>
 *       Gustavo Padovan <gustavo.padovan@collabora.co.uk>
 *       Matthieu Bouron <matthieu.bouron@collabora.com>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *
 * Based on kf-backend.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks/small-set.h>
#include <folks/small-set-internal.h>
#include <folks-internal.h>
#include <glib/gi18n-lib.h>


#define FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND (folks_backends_blue_z_backend_get_type ())
#define FOLKS_BACKENDS_BLUE_Z_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackend))
#define FOLKS_BACKENDS_BLUE_Z_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackendClass))
#define FOLKS_BACKENDS_BLUE_Z_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND))
#define FOLKS_BACKENDS_BLUE_Z_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND))
#define FOLKS_BACKENDS_BLUE_Z_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackendClass))

typedef struct _FolksBackendsBlueZBackend FolksBackendsBlueZBackend;
typedef struct _FolksBackendsBlueZBackendClass FolksBackendsBlueZBackendClass;
typedef struct _FolksBackendsBlueZBackendPrivate FolksBackendsBlueZBackendPrivate;

#define FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE (folks_backends_blue_z_persona_store_get_type ())
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStoreClass))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStoreClass))

typedef struct _FolksBackendsBlueZPersonaStore FolksBackendsBlueZPersonaStore;
typedef struct _FolksBackendsBlueZPersonaStoreClass FolksBackendsBlueZPersonaStoreClass;

#define ORG_BLUEZ_OBEX_TYPE_CLIENT (org_bluez_obex_client_get_type ())
#define ORG_BLUEZ_OBEX_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_OBEX_TYPE_CLIENT, orgbluezobexClient))
#define ORG_BLUEZ_OBEX_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_OBEX_TYPE_CLIENT))
#define ORG_BLUEZ_OBEX_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_OBEX_TYPE_CLIENT, orgbluezobexClientIface))

typedef struct _orgbluezobexClient orgbluezobexClient;
typedef struct _orgbluezobexClientIface orgbluezobexClientIface;

#define ORG_BLUEZ_OBEX_TYPE_CLIENT_PROXY (org_bluez_obex_client_proxy_get_type ())
enum  {
	FOLKS_BACKENDS_BLUE_Z_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_QUIESCENT,
	FOLKS_BACKENDS_BLUE_Z_BACKEND_NAME,
	FOLKS_BACKENDS_BLUE_Z_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_BLUE_Z_BACKEND_LAST_PROPERTY
};
static GParamSpec* folks_backends_blue_z_backend_properties[FOLKS_BACKENDS_BLUE_Z_BACKEND_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ORG_BLUEZ_TYPE_DEVICE (org_bluez_device_get_type ())
#define ORG_BLUEZ_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_TYPE_DEVICE, orgbluezDevice))
#define ORG_BLUEZ_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_TYPE_DEVICE))
#define ORG_BLUEZ_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_TYPE_DEVICE, orgbluezDeviceIface))

typedef struct _orgbluezDevice orgbluezDevice;
typedef struct _orgbluezDeviceIface orgbluezDeviceIface;

#define ORG_BLUEZ_TYPE_DEVICE_PROXY (org_bluez_device_proxy_get_type ())
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsBlueZBackendAddPersonaStoreData FolksBackendsBlueZBackendAddPersonaStoreData;
typedef struct _FolksBackendsBlueZBackendRefreshDevicesData FolksBackendsBlueZBackendRefreshDevicesData;
typedef struct _FolksBackendsBlueZBackendAddDeviceData FolksBackendsBlueZBackendAddDeviceData;
typedef struct _FolksBackendsBlueZBackendRemoveDeviceData FolksBackendsBlueZBackendRemoveDeviceData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _FolksBackendsBlueZBackendSaveEnabledDevicesData FolksBackendsBlueZBackendSaveEnabledDevicesData;
typedef struct _FolksBackendsBlueZBackendLoadEnabledDevicesData FolksBackendsBlueZBackendLoadEnabledDevicesData;
typedef struct _FolksBackendsBlueZBackendPrepareData FolksBackendsBlueZBackendPrepareData;
typedef struct _FolksBackendsBlueZBackendUnprepareData FolksBackendsBlueZBackendUnprepareData;

struct _FolksBackendsBlueZBackend {
	FolksBackend parent_instance;
	FolksBackendsBlueZBackendPrivate * priv;
};

struct _FolksBackendsBlueZBackendClass {
	FolksBackendClass parent_class;
};

struct _orgbluezobexClientIface {
	GTypeInterface parent_iface;
	void (*create_session) (orgbluezobexClient* self, const gchar* address, GHashTable* args, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*create_session_finish) (orgbluezobexClient* self, GAsyncResult* _res_, GError** error);
	void (*remove_session) (orgbluezobexClient* self, const char* session, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_session_finish) (orgbluezobexClient* self, GAsyncResult* _res_, GError** error);
};

struct _FolksBackendsBlueZBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	GDBusObjectManagerClient* _manager;
	gulong _object_added_handler;
	gulong _object_removed_handler;
	gulong _properties_changed_handler;
	GeeHashMap* _watched_devices;
	orgbluezobexClient* _obex_client;
	FolksSmallSet* _enabled_devices;
};

typedef enum  {
	ORG_BLUEZ_ERROR_NOT_READY,
	ORG_BLUEZ_ERROR_FAILED,
	ORG_BLUEZ_ERROR_IN_PROGRESS,
	ORG_BLUEZ_ERROR_ALREADY_CONNECTED,
	ORG_BLUEZ_ERROR_NOT_CONNECTED,
	ORG_BLUEZ_ERROR_DOES_NOT_EXIST,
	ORG_BLUEZ_ERROR_CONNECT_FAILED,
	ORG_BLUEZ_ERROR_NOT_SUPPORTED,
	ORG_BLUEZ_ERROR_INVALID_ARGUMENTS,
	ORG_BLUEZ_ERROR_AUTHENTICATION_CANCELED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_FAILED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_REJECTED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_TIMEOUT,
	ORG_BLUEZ_ERROR_CONNECTION_ATTEMPT_FAILED
} orgbluezError;
#define ORG_BLUEZ_ERROR org_bluez_error_quark ()
struct _orgbluezDeviceIface {
	GTypeInterface parent_iface;
	void (*connect) (orgbluezDevice* self, GError** error);
	void (*disconnect) (orgbluezDevice* self, GError** error);
	void (*disconnect_profile) (orgbluezDevice* self, const gchar* uuid, GError** error);
	void (*pair) (orgbluezDevice* self, GError** error);
	void (*cancel_pairing) (orgbluezDevice* self, GError** error);
	gchar* (*get_address) (orgbluezDevice* self);
	gchar* (*get_name) (orgbluezDevice* self);
	gchar* (*get_icon) (orgbluezDevice* self);
	guint32 (*get_bluetooth_class) (orgbluezDevice* self);
	guint16 (*get_appearance) (orgbluezDevice* self);
	gchar** (*get_uuids) (orgbluezDevice* self, int* result_length1);
	gboolean (*get_paired) (orgbluezDevice* self);
	gboolean (*get_connected) (orgbluezDevice* self);
	gboolean (*get_trusted) (orgbluezDevice* self);
	void (*set_trusted) (orgbluezDevice* self, gboolean value);
	gboolean (*get_blocked) (orgbluezDevice* self);
	void (*set_blocked) (orgbluezDevice* self, gboolean value);
	gchar* (*get_alias) (orgbluezDevice* self);
	void (*set_alias) (orgbluezDevice* self, const gchar* value);
	char* (*get_adapter) (orgbluezDevice* self);
	gboolean (*get_legacy_pairing) (orgbluezDevice* self);
	gchar* (*get_mod_alias) (orgbluezDevice* self);
	gint16 (*get_rssi) (orgbluezDevice* self);
};

struct _Block1Data {
	int _ref_count_;
	FolksBackendsBlueZBackend* self;
	orgbluezDevice* device;
	FolksBackendsBlueZPersonaStore* store;
};

struct _FolksBackendsBlueZBackendAddPersonaStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	orgbluezDevice* device;
	gchar* path;
	FolksBackendsBlueZPersonaStore* store;
	orgbluezDevice* _tmp0_;
	const gchar* _tmp1_;
	orgbluezobexClient* _tmp2_;
	FolksBackendsBlueZPersonaStore* _tmp3_;
	orgbluezDevice* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	orgbluezDevice* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GeeHashMap* _tmp11_;
	const gchar* _tmp12_;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
};

struct _FolksBackendsBlueZBackendRefreshDevicesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	GList* objs;
	GDBusObjectManagerClient* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* obj_collection;
	GList* obj_it;
	GDBusObject* _tmp3_;
	GDBusObject* obj;
	GDBusObject* _tmp4_;
};

struct _FolksBackendsBlueZBackendAddDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	GDBusObject* obj;
	GDBusObject* _tmp0_;
	const gchar* _tmp1_;
	orgbluezDevice* device;
	GDBusObject* _tmp2_;
	GDBusInterface* _tmp3_;
	orgbluezDevice* _tmp4_;
	orgbluezDevice* _tmp5_;
	gchar* path;
	GDBusObject* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	orgbluezDevice* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	orgbluezDevice* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	orgbluezDevice* _tmp18_;
	gboolean _tmp19_;
	FolksSmallSet* _tmp20_;
	orgbluezDevice* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	orgbluezDevice* _tmp27_;
	const gchar* _tmp28_;
};

struct _FolksBackendsBlueZBackendRemoveDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	GDBusObject* obj;
	gchar* path;
	GDBusObject* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FolksBackendsBlueZPersonaStore* store;
	const gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	FolksBackendsBlueZPersonaStore* _tmp9_;
};

struct _FolksBackendsBlueZBackendSaveEnabledDevicesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	GKeyFile* kf;
	GKeyFile* _tmp0_;
	gchar* kf_path;
	gchar* _tmp1_;
	FolksSmallSet* _address_list;
	FolksSmallSet* _tmp2_;
	FolksSmallSet* _tmp3_;
	gint _address_size;
	FolksSmallSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _address_index;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* address;
	FolksSmallSet* _tmp10_;
	gint _tmp11_;
	gconstpointer _tmp12_;
	gchar* _tmp13_;
	GKeyFile* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GFile* file;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	gchar* data;
	GKeyFile* _tmp19_;
	gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	GError* e;
	const gchar* _tmp23_;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZBackendLoadEnabledDevicesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	GKeyFile* kf;
	GKeyFile* _tmp0_;
	gchar* kf_path;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	guint8* contents;
	gint contents_length1;
	gint _contents_size_;
	GFile* file;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	guint8* _tmp6_;
	gsize _tmp7_;
	const gchar* contents_s;
	guint8* _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GKeyFile* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GError* e1;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	FolksSmallSet* _tmp21_;
	gchar** groups;
	GKeyFile* _tmp22_;
	gsize _tmp23_;
	gchar** _tmp24_;
	gint groups_length1;
	gint _groups_size_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** address_collection;
	gint address_collection_length1;
	gint _address_collection_size_;
	gint address_it;
	gchar* _tmp26_;
	gchar* address;
	gboolean _tmp27_;
	GKeyFile* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp31_;
	FolksSmallSet* _tmp32_;
	const gchar* _tmp33_;
	GError* e;
	GError * _inner_error_;
};

typedef GType (*FolksBackendsBlueZBackendTypeFunc) (void* user_data);
struct _FolksBackendsBlueZBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GDBusObjectManagerClient* _tmp3_;
	GDBusObjectManagerClient* _tmp4_;
	GDBusObjectManagerClient* _tmp5_;
	GError* e1;
	GError* _tmp6_;
	orgbluezobexClient* _tmp7_;
	orgbluezobexClient* _tmp8_;
	orgbluezobexClient* _tmp9_;
	GError* _vala1_e1;
	GError* _tmp10_;
	GDBusObjectManagerClient* _tmp11_;
	gulong _tmp12_;
	GDBusObjectManagerClient* _tmp13_;
	gulong _tmp14_;
	GDBusObjectManagerClient* _tmp15_;
	gulong _tmp16_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksBackendsBlueZBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GDBusObjectManagerClient* _tmp3_;
	GDBusObjectManagerClient* _tmp4_;
	gulong _tmp5_;
	GDBusObjectManagerClient* _tmp6_;
	gulong _tmp7_;
	GDBusObjectManagerClient* _tmp8_;
	gulong _tmp9_;
	GeeMapIterator* iter;
	GeeHashMap* _tmp10_;
	GeeMapIterator* _tmp11_;
	GeeMapIterator* _tmp12_;
	gboolean _tmp13_;
	GeeMapIterator* _tmp14_;
	gpointer _tmp15_;
	FolksBackendsBlueZPersonaStore* _tmp16_;
	GeeMapIterator* _tmp17_;
	GError * _inner_error_;
};


static gpointer folks_backends_blue_z_backend_parent_class = NULL;

GType folks_backends_blue_z_backend_get_type (void) G_GNUC_CONST;
GType folks_backends_blue_z_persona_store_get_type (void) G_GNUC_CONST;
GType org_bluez_obex_client_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_obex_client_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_obex_client_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_BLUE_Z_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackendPrivate))
static void folks_backends_blue_z_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_blue_z_backend_save_enabled_devices (FolksBackendsBlueZBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_save_enabled_devices_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_);
static void __lambda9_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_backends_blue_z_backend_remove_persona_store (FolksBackendsBlueZBackend* self, FolksBackendsBlueZPersonaStore* store, gboolean remove_from_persona_stores, gboolean remove_from_watched_devices);
static void folks_backends_blue_z_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void __lambda10_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_backends_blue_z_backend_refresh_devices (FolksBackendsBlueZBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_refresh_devices_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_);
static void __lambda11_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void folks_backends_blue_z_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids);
GType org_bluez_device_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_device_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GQuark org_bluez_error_quark (void);
GType org_bluez_device_get_type (void) G_GNUC_CONST;
gchar* org_bluez_device_get_address (orgbluezDevice* self);
static void _folks_backends_blue_z_backend_add_device (FolksBackendsBlueZBackend* self, GDBusObject* obj, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_add_device_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_);
static void _____lambda12_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ______lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda13_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda14_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda15_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
FolksBackendsBlueZBackend* folks_backends_blue_z_backend_new (void);
FolksBackendsBlueZBackend* folks_backends_blue_z_backend_construct (GType object_type);
static void _folks_backends_blue_z_backend_device_properties_changed_cb (FolksBackendsBlueZBackend* self, GDBusObjectProxy* obj_proxy, GDBusProxy* iface_proxy, GVariant* changed, gchar** invalidated, int invalidated_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gboolean org_bluez_device_get_paired (orgbluezDevice* self);
gboolean org_bluez_device_get_blocked (orgbluezDevice* self);
static gboolean _folks_backends_blue_z_backend_device_supports_pbap_pse (FolksBackendsBlueZBackend* self, orgbluezDevice* device);
static void ____lambda16_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void _____lambda16__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_backends_blue_z_backend_remove_device (FolksBackendsBlueZBackend* self, GDBusObject* obj, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_remove_device_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_);
static void ____lambda17_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void _____lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void folks_backends_blue_z_persona_store_set_connection_state (FolksBackendsBlueZPersonaStore* self, gboolean connected, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_blue_z_persona_store_set_connection_state_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error);
static void ___lambda18_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
gchar* org_bluez_device_get_alias (orgbluezDevice* self);
static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void folks_backends_blue_z_persona_store_set_is_trusted (FolksBackendsBlueZPersonaStore* self, gboolean trusted);
void folks_backends_blue_z_persona_store_set_alias (FolksBackendsBlueZPersonaStore* self, const gchar* alias);
static void _folks_backends_blue_z_backend_add_persona_store_data_free (gpointer _data);
static void _folks_backends_blue_z_backend_add_persona_store_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void _folks_backends_blue_z_backend_add_persona_store (FolksBackendsBlueZBackend* self, orgbluezDevice* device, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_add_persona_store_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_);
static gboolean _folks_backends_blue_z_backend_add_persona_store_co (FolksBackendsBlueZBackendAddPersonaStoreData* _data_);
FolksBackendsBlueZPersonaStore* folks_backends_blue_z_persona_store_new (orgbluezDevice* device, const gchar* object_path, orgbluezobexClient* obex_client);
FolksBackendsBlueZPersonaStore* folks_backends_blue_z_persona_store_construct (GType object_type, orgbluezDevice* device, const gchar* object_path, orgbluezobexClient* obex_client);
gboolean org_bluez_device_get_trusted (orgbluezDevice* self);
static void _folks_backends_blue_z_backend_persona_store_removed_cb (FolksBackendsBlueZBackend* self, FolksPersonaStore* store);
static void __folks_backends_blue_z_backend_persona_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
void folks_backends_blue_z_persona_store_cancel_updates (FolksBackendsBlueZPersonaStore* self);
const gchar* folks_backends_blue_z_persona_store_get_object_path (FolksBackendsBlueZPersonaStore* self);
gchar** org_bluez_device_get_uuids (orgbluezDevice* self, int* result_length1);
static void _folks_backends_blue_z_backend_refresh_devices_data_free (gpointer _data);
static void _folks_backends_blue_z_backend_refresh_devices_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean _folks_backends_blue_z_backend_refresh_devices_co (FolksBackendsBlueZBackendRefreshDevicesData* _data_);
static void _folks_backends_blue_z_backend_refresh_devices_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_add_device_data_free (gpointer _data);
static void _folks_backends_blue_z_backend_add_device_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean _folks_backends_blue_z_backend_add_device_co (FolksBackendsBlueZBackendAddDeviceData* _data_);
static void _folks_backends_blue_z_backend_add_device_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_remove_device_data_free (gpointer _data);
static void _folks_backends_blue_z_backend_remove_device_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean _folks_backends_blue_z_backend_remove_device_co (FolksBackendsBlueZBackendRemoveDeviceData* _data_);
static gchar* _folks_backends_blue_z_backend_get_enabled_devices_key_file_path (FolksBackendsBlueZBackend* self);
static void _folks_backends_blue_z_backend_save_enabled_devices_data_free (gpointer _data);
static void _folks_backends_blue_z_backend_save_enabled_devices_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean _folks_backends_blue_z_backend_save_enabled_devices_co (FolksBackendsBlueZBackendSaveEnabledDevicesData* _data_);
static void _folks_backends_blue_z_backend_load_enabled_devices_data_free (gpointer _data);
static void _folks_backends_blue_z_backend_load_enabled_devices_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void _folks_backends_blue_z_backend_load_enabled_devices (FolksBackendsBlueZBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_backend_load_enabled_devices_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_);
static gboolean _folks_backends_blue_z_backend_load_enabled_devices_co (FolksBackendsBlueZBackendLoadEnabledDevicesData* _data_);
static void _folks_backends_blue_z_backend_load_enabled_devices_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_blue_z_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_blue_z_backend_real_prepare_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void folks_backends_blue_z_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_blue_z_backend_real_prepare_co (FolksBackendsBlueZBackendPrepareData* _data_);
static void folks_backends_blue_z_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GType ____lambda19_ (FolksBackendsBlueZBackend* self, GDBusObjectManagerClient* manager, const gchar* path, const gchar* iface_name);
static GType _____lambda19__gd_bus_proxy_type_func (GDBusObjectManagerClient* manager, const gchar* object_path, const gchar* interface_name, gpointer self);
static void ___lambda20_ (FolksBackendsBlueZBackend* self, GDBusObject* obj);
static void __lambda21_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ____lambda20__g_dbus_object_manager_object_added (GDBusObjectManager* _sender, GDBusObject* object, gpointer self);
static void ___lambda22_ (FolksBackendsBlueZBackend* self, GDBusObject* obj);
static void __lambda23_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r);
static void ___lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ____lambda22__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender, GDBusObject* object, gpointer self);
static void __folks_backends_blue_z_backend_device_properties_changed_cb_g_dbus_object_manager_client_interface_proxy_properties_changed (GDBusObjectManagerClient* _sender, GDBusObjectProxy* object_proxy, GDBusProxy* interface_proxy, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void folks_backends_blue_z_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_blue_z_backend_real_unprepare_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void folks_backends_blue_z_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_blue_z_backend_real_unprepare_co (FolksBackendsBlueZBackendUnprepareData* _data_);
static GObject * folks_backends_blue_z_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_blue_z_backend_finalize (GObject * obj);
static void _vala_folks_backends_blue_z_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda9_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_save_enabled_devices_finish (self, _tmp0_);
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda9_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void folks_backends_blue_z_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsBlueZBackend * self;
	FolksBackendsBlueZPersonaStore* _store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksBackendsBlueZPersonaStore* _tmp1_;
	FolksBackendsBlueZPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* device_address = NULL;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	FolksSmallSet* _tmp10_;
	const gchar* _tmp11_;
	GeeHashMap* _tmp12_;
	FolksPersonaStore* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	FolksBackendsBlueZPersonaStore* _tmp17_;
	self = (FolksBackendsBlueZBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE) ? ((FolksBackendsBlueZPersonaStore*) _tmp0_) : NULL);
	_store = _tmp1_;
	_tmp2_ = _store;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_store);
		return;
	}
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("bluez-backend.vala:165: Disabling persona store ‘%s’.", _tmp5_);
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	device_address = _tmp9_;
	_tmp10_ = self->priv->_enabled_devices;
	_tmp11_ = device_address;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	_folks_backends_blue_z_backend_save_enabled_devices (self, ___lambda9__gasync_ready_callback, g_object_ref (self));
	_tmp12_ = self->priv->_persona_stores;
	_tmp13_ = store;
	_tmp14_ = folks_persona_store_get_id (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, _tmp15_);
	if (!_tmp16_) {
		_g_free0 (device_address);
		_g_object_unref0 (_store);
		return;
	}
	_tmp17_ = _store;
	_folks_backends_blue_z_backend_remove_persona_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore), TRUE, TRUE);
	_g_free0 (device_address);
	_g_object_unref0 (_store);
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void __lambda10_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_save_enabled_devices_finish (self, _tmp0_);
}


static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda10_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda11_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_refresh_devices_finish (self, _tmp0_);
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda11_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void folks_backends_blue_z_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsBlueZBackend * self;
	FolksBackendsBlueZPersonaStore* _store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksBackendsBlueZPersonaStore* _tmp1_;
	FolksBackendsBlueZPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* device_address = NULL;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	FolksSmallSet* _tmp10_;
	const gchar* _tmp11_;
	self = (FolksBackendsBlueZBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE) ? ((FolksBackendsBlueZPersonaStore*) _tmp0_) : NULL);
	_store = _tmp1_;
	_tmp2_ = _store;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_store);
		return;
	}
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("bluez-backend.vala:191: Enabling persona store ‘%s’.", _tmp5_);
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	device_address = _tmp9_;
	_tmp10_ = self->priv->_enabled_devices;
	_tmp11_ = device_address;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	_folks_backends_blue_z_backend_save_enabled_devices (self, ___lambda10__gasync_ready_callback, g_object_ref (self));
	_folks_backends_blue_z_backend_refresh_devices (self, ___lambda11__gasync_ready_callback, g_object_ref (self));
	_g_free0 (device_address);
	_g_object_unref0 (_store);
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void _____lambda12_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_add_device_finish (self, _tmp0_);
}


static void ______lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_____lambda12_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void ___lambda13_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_save_enabled_devices_finish (self, _tmp0_);
}


static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda13_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void __lambda14_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_save_enabled_devices_finish (self, _tmp0_);
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda14_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda15_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_refresh_devices_finish (self, _tmp0_);
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda15_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void folks_backends_blue_z_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids) {
	FolksBackendsBlueZBackend * self;
	GeeSet* _tmp0_;
	FolksSmallSet* _tmp15_;
	self = (FolksBackendsBlueZBackend*) base;
	_tmp0_ = storeids;
	if (_tmp0_ == NULL) {
		GList* objs = NULL;
		GDBusObjectManagerClient* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		_tmp1_ = self->priv->_manager;
		_tmp2_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp1_);
		objs = _tmp2_;
		_tmp3_ = objs;
		{
			GList* obj_collection = NULL;
			GList* obj_it = NULL;
			obj_collection = _tmp3_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GDBusObject* _tmp4_;
				GDBusObject* obj = NULL;
				_tmp4_ = _g_object_ref0 ((GDBusObject*) obj_it->data);
				obj = _tmp4_;
				{
					orgbluezDevice* device = NULL;
					GDBusObject* _tmp5_;
					GDBusInterface* _tmp6_;
					orgbluezDevice* _tmp7_;
					orgbluezDevice* _tmp8_;
					FolksSmallSet* _tmp9_;
					orgbluezDevice* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					GDBusObject* _tmp14_;
					_tmp5_ = obj;
					_tmp6_ = g_dbus_object_get_interface (_tmp5_, "org.bluez.Device1");
					_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, ORG_BLUEZ_TYPE_DEVICE) ? ((orgbluezDevice*) _tmp6_) : NULL;
					if (_tmp7_ == NULL) {
						_g_object_unref0 (_tmp6_);
					}
					device = _tmp7_;
					_tmp8_ = device;
					if (_tmp8_ == NULL) {
						_g_object_unref0 (device);
						_g_object_unref0 (obj);
						continue;
					}
					_tmp9_ = self->priv->_enabled_devices;
					_tmp10_ = device;
					_tmp11_ = org_bluez_device_get_address (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = _tmp12_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp13_);
					_g_free0 (_tmp13_);
					_tmp14_ = obj;
					_folks_backends_blue_z_backend_add_device (self, _tmp14_, ______lambda12__gasync_ready_callback, g_object_ref (self));
					_g_object_unref0 (device);
					_g_object_unref0 (obj);
				}
			}
		}
		_folks_backends_blue_z_backend_save_enabled_devices (self, ____lambda13__gasync_ready_callback, g_object_ref (self));
		__g_list_free__g_object_unref0_0 (objs);
		return;
	}
	_tmp15_ = self->priv->_enabled_devices;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp15_);
	{
		GeeIterator* _store_id_it = NULL;
		GeeSet* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp16_ = storeids;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_store_id_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_;
			gchar* store_id = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			gchar* device_address = NULL;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			FolksSmallSet* _tmp24_;
			const gchar* _tmp25_;
			_tmp18_ = _store_id_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _store_id_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			store_id = (gchar*) _tmp21_;
			_tmp22_ = store_id;
			_tmp23_ = g_strdup (_tmp22_);
			device_address = _tmp23_;
			_tmp24_ = self->priv->_enabled_devices;
			_tmp25_ = device_address;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			_g_free0 (device_address);
			_g_free0 (store_id);
		}
		_g_object_unref0 (_store_id_it);
	}
	_folks_backends_blue_z_backend_save_enabled_devices (self, ___lambda14__gasync_ready_callback, g_object_ref (self));
	_folks_backends_blue_z_backend_refresh_devices (self, ___lambda15__gasync_ready_callback, g_object_ref (self));
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
FolksBackendsBlueZBackend* folks_backends_blue_z_backend_construct (GType object_type) {
	FolksBackendsBlueZBackend * self = NULL;
	self = (FolksBackendsBlueZBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksBackendsBlueZBackend* folks_backends_blue_z_backend_new (void) {
	return folks_backends_blue_z_backend_construct (FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND);
}


/**
   * Callback executed when a device property has changed.
   *
   * The callback is executed when a PropertiesChanged signal is received
   * on device. If the device is seen as connected it tries to update the
   * Persona store associated with it. If the device is seen as disconnected,
   * the OBEX session used by the {@link PersonaStore} is removed.
   *
   * @param obj_proxy D-Bus proxy for the object
   * @param iface_proxy D-Bus proxy for the interface on which the property
   * changed
   * @param changed the list of properties that have changed
   * @param invalidated the list of properties that have been invalidated
   *
   * @since 0.9.6
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FolksBackendsBlueZBackend* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->store);
		_g_object_unref0 (_data1_->device);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ____lambda16_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_add_device_finish (self, _tmp0_);
}


static void _____lambda16__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda16_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void ____lambda17_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_remove_device_finish (self, _tmp0_);
}


static void _____lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda17_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void ___lambda18_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	FolksBackendsBlueZBackend* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	{
		FolksBackendsBlueZPersonaStore* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data1_->store;
		_tmp1_ = r;
		folks_backends_blue_z_persona_store_set_connection_state_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch0_folks_persona_store_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e1 = NULL;
		orgbluezDevice* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		orgbluezDevice* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data1_->device;
		_tmp3_ = org_bluez_device_get_alias (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = _data1_->device;
		_tmp7_ = org_bluez_device_get_address (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		g_debug ("Changing connection state for device ‘%s’ (%s) " "was cancelled.", _tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e1);
	}
	goto __finally0;
	__catch0_folks_persona_store_error:
	{
		GError* e2 = NULL;
		orgbluezDevice* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		orgbluezDevice* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _data1_->device;
		_tmp11_ = org_bluez_device_get_alias (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = _data1_->device;
		_tmp15_ = org_bluez_device_get_address (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = e2;
		_tmp19_ = _tmp18_->message;
		g_warning ("Error changing connection state for device " "‘%s’ (%s): %s", _tmp13_, _tmp17_, _tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e2);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda18_ (self, source_object, res);
	block1_data_unref (self);
}


static void _folks_backends_blue_z_backend_device_properties_changed_cb (FolksBackendsBlueZBackend* self, GDBusObjectProxy* obj_proxy, GDBusProxy* iface_proxy, GVariant* changed, gchar** invalidated, int invalidated_length1) {
	Block1Data* _data1_;
	GDBusProxy* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GDBusObjectProxy* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GVariantIter* iter = NULL;
	GVariant* _tmp8_;
	GVariantIter* _tmp9_;
	gchar* key = NULL;
	GVariant* variant = NULL;
	GDBusProxy* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	GDBusProxy* _tmp18_;
	orgbluezDevice* _tmp19_;
	GVariant* uuids = NULL;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* paired = NULL;
	GVariant* _tmp22_;
	const GVariantType* _tmp23_;
	GVariant* _tmp24_;
	GVariant* blocked = NULL;
	GVariant* _tmp25_;
	const GVariantType* _tmp26_;
	GVariant* _tmp27_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	GVariant* _tmp30_;
	GeeHashMap* _tmp45_;
	orgbluezDevice* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gpointer _tmp50_;
	FolksBackendsBlueZPersonaStore* _tmp51_;
	FolksBackendsBlueZPersonaStore* _tmp52_;
	GVariant* connected = NULL;
	GVariant* _tmp53_;
	const GVariantType* _tmp54_;
	GVariant* _tmp55_;
	GVariant* _tmp56_;
	GVariant* trusted = NULL;
	GVariant* _tmp60_;
	const GVariantType* _tmp61_;
	GVariant* _tmp62_;
	GVariant* _tmp63_;
	GVariant* alias = NULL;
	GVariant* _tmp67_;
	const GVariantType* _tmp68_;
	GVariant* _tmp69_;
	GVariant* _tmp70_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj_proxy != NULL);
	g_return_if_fail (iface_proxy != NULL);
	g_return_if_fail (changed != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = iface_proxy;
	g_object_get (_tmp0_, "g-interface-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = obj_proxy;
	g_object_get (_tmp4_, "g-object-path", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	g_debug ("bluez-backend.vala:297: Properties changed on interface ‘%s’ of object" \
" ‘%s’:", _tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	_tmp8_ = changed;
	_tmp9_ = g_variant_iter_new (_tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GVariantIter* _tmp10_;
		gboolean _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = iter;
		_tmp11_ = g_variant_iter_next (_tmp10_, "{sv}", &key, &variant, NULL);
		if (!(_tmp11_ == TRUE)) {
			break;
		}
		_tmp12_ = key;
		g_debug ("bluez-backend.vala:303:     %s", _tmp12_);
	}
	_tmp13_ = iface_proxy;
	g_object_get (_tmp13_, "g-interface-name", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strcmp0 (_tmp16_, "org.bluez.Device1") != 0;
	_g_free0 (_tmp16_);
	if (_tmp17_) {
		_g_variant_unref0 (variant);
		_g_free0 (key);
		_g_variant_iter_free0 (iter);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp18_ = iface_proxy;
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, ORG_BLUEZ_TYPE_DEVICE, orgbluezDevice));
	_data1_->device = _tmp19_;
	_tmp20_ = changed;
	_tmp21_ = g_variant_lookup_value (_tmp20_, "UUIDs", NULL);
	uuids = _tmp21_;
	_tmp22_ = changed;
	_tmp23_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp24_ = g_variant_lookup_value (_tmp22_, "Paired", _tmp23_);
	paired = _tmp24_;
	_tmp25_ = changed;
	_tmp26_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp27_ = g_variant_lookup_value (_tmp25_, "Blocked", _tmp26_);
	blocked = _tmp27_;
	_tmp30_ = uuids;
	if (_tmp30_ != NULL) {
		_tmp29_ = TRUE;
	} else {
		GVariant* _tmp31_;
		_tmp31_ = paired;
		_tmp29_ = _tmp31_ != NULL;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		GVariant* _tmp32_;
		_tmp32_ = blocked;
		_tmp28_ = _tmp32_ != NULL;
	}
	if (_tmp28_) {
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		orgbluezDevice* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp35_ = _data1_->device;
		_tmp36_ = org_bluez_device_get_paired (_tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp37_ == TRUE) {
			orgbluezDevice* _tmp38_;
			gboolean _tmp39_;
			gboolean _tmp40_;
			_tmp38_ = _data1_->device;
			_tmp39_ = org_bluez_device_get_blocked (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp34_ = _tmp40_ == FALSE;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			orgbluezDevice* _tmp41_;
			gboolean _tmp42_;
			_tmp41_ = _data1_->device;
			_tmp42_ = _folks_backends_blue_z_backend_device_supports_pbap_pse (self, _tmp41_);
			_tmp33_ = _tmp42_;
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			GDBusObjectProxy* _tmp43_;
			_tmp43_ = obj_proxy;
			_folks_backends_blue_z_backend_add_device (self, (GDBusObject*) _tmp43_, _____lambda16__gasync_ready_callback, g_object_ref (self));
		} else {
			GDBusObjectProxy* _tmp44_;
			_tmp44_ = obj_proxy;
			_folks_backends_blue_z_backend_remove_device (self, (GDBusObject*) _tmp44_, _____lambda17__gasync_ready_callback, g_object_ref (self));
		}
	}
	_tmp45_ = self->priv->_persona_stores;
	_tmp46_ = _data1_->device;
	_tmp47_ = org_bluez_device_get_address (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp50_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp45_, _tmp49_);
	_tmp51_ = (FolksBackendsBlueZPersonaStore*) _tmp50_;
	_g_free0 (_tmp49_);
	_data1_->store = _tmp51_;
	_tmp52_ = _data1_->store;
	if (_tmp52_ == NULL) {
		_g_variant_unref0 (blocked);
		_g_variant_unref0 (paired);
		_g_variant_unref0 (uuids);
		_g_variant_unref0 (variant);
		_g_free0 (key);
		_g_variant_iter_free0 (iter);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp53_ = changed;
	_tmp54_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp55_ = g_variant_lookup_value (_tmp53_, "Connected", _tmp54_);
	connected = _tmp55_;
	_tmp56_ = connected;
	if (_tmp56_ != NULL) {
		FolksBackendsBlueZPersonaStore* _tmp57_;
		GVariant* _tmp58_;
		gboolean _tmp59_;
		_tmp57_ = _data1_->store;
		_tmp58_ = connected;
		_tmp59_ = g_variant_get_boolean (_tmp58_);
		folks_backends_blue_z_persona_store_set_connection_state (_tmp57_, _tmp59_, ____lambda18__gasync_ready_callback, block1_data_ref (_data1_));
	}
	_tmp60_ = changed;
	_tmp61_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp62_ = g_variant_lookup_value (_tmp60_, "Trusted", _tmp61_);
	trusted = _tmp62_;
	_tmp63_ = trusted;
	if (_tmp63_ != NULL) {
		FolksBackendsBlueZPersonaStore* _tmp64_;
		GVariant* _tmp65_;
		gboolean _tmp66_;
		_tmp64_ = _data1_->store;
		_tmp65_ = trusted;
		_tmp66_ = g_variant_get_boolean (_tmp65_);
		folks_backends_blue_z_persona_store_set_is_trusted (_tmp64_, _tmp66_);
	}
	_tmp67_ = changed;
	_tmp68_ = G_VARIANT_TYPE_STRING;
	_tmp69_ = g_variant_lookup_value (_tmp67_, "Alias", _tmp68_);
	alias = _tmp69_;
	_tmp70_ = alias;
	if (_tmp70_ != NULL) {
		FolksBackendsBlueZPersonaStore* _tmp71_;
		GVariant* _tmp72_;
		const gchar* _tmp73_;
		_tmp71_ = _data1_->store;
		_tmp72_ = alias;
		_tmp73_ = g_variant_get_string (_tmp72_, NULL);
		folks_backends_blue_z_persona_store_set_alias (_tmp71_, _tmp73_);
	}
	_g_variant_unref0 (alias);
	_g_variant_unref0 (trusted);
	_g_variant_unref0 (connected);
	_g_variant_unref0 (blocked);
	_g_variant_unref0 (paired);
	_g_variant_unref0 (uuids);
	_g_variant_unref0 (variant);
	_g_free0 (key);
	_g_variant_iter_free0 (iter);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _folks_backends_blue_z_backend_add_persona_store_data_free (gpointer _data) {
	FolksBackendsBlueZBackendAddPersonaStoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendAddPersonaStoreData, _data_);
}


static void _folks_backends_blue_z_backend_add_persona_store_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendAddPersonaStoreData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void _folks_backends_blue_z_backend_add_persona_store (FolksBackendsBlueZBackend* self, orgbluezDevice* device, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackendAddPersonaStoreData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	orgbluezDevice* _tmp1_;
	orgbluezDevice* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendAddPersonaStoreData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _folks_backends_blue_z_backend_add_persona_store_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_backend_add_persona_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = device;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->path);
	_data_->path = _tmp4_;
	_folks_backends_blue_z_backend_add_persona_store_co (_data_);
}


static void _folks_backends_blue_z_backend_add_persona_store_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_) {
	FolksBackendsBlueZBackendAddPersonaStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Add a new Persona store to this backend.
   *
   * Add a new Persona store associated with a device identified by
   * its address and alias. The function takes care of creating all
   * the D-Bus object and path required by the Personna store.
   *
   * @param device the D-Bus object for the Bluetooth device
   * @param path the path of the D-Bus device object.
   *
   * @since 0.9.6
   */
static void __folks_backends_blue_z_backend_persona_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_blue_z_backend_persona_store_removed_cb ((FolksBackendsBlueZBackend*) self, _sender);
}


static gboolean _folks_backends_blue_z_backend_add_persona_store_co (FolksBackendsBlueZBackendAddPersonaStoreData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->device;
	_data_->_tmp1_ = _data_->path;
	_data_->_tmp2_ = _data_->self->priv->_obex_client;
	_data_->_tmp3_ = folks_backends_blue_z_persona_store_new (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
	_data_->store = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->device;
	_data_->_tmp5_ = org_bluez_device_get_trusted (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	folks_backends_blue_z_persona_store_set_is_trusted (_data_->store, _data_->_tmp6_);
	_data_->_tmp7_ = _data_->device;
	_data_->_tmp8_ = org_bluez_device_get_alias (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	folks_backends_blue_z_persona_store_set_alias (_data_->store, _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->self->priv->_watched_devices;
	_data_->_tmp12_ = _data_->path;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp11_, _data_->_tmp12_, _data_->store);
	_data_->_tmp13_ = _data_->self->priv->_persona_stores;
	_data_->_tmp14_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->store);
	_data_->_tmp15_ = _data_->_tmp14_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp13_, _data_->_tmp15_, _data_->store);
	g_signal_connect_object ((FolksPersonaStore*) _data_->store, "removed", (GCallback) __folks_backends_blue_z_backend_persona_store_removed_cb_folks_persona_store_removed, _data_->self, 0);
	g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-added", (FolksPersonaStore*) _data_->store);
	g_object_notify ((GObject*) _data_->self, "persona-stores");
	_g_object_unref0 (_data_->store);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_backend_remove_persona_store (FolksBackendsBlueZBackend* self, FolksBackendsBlueZPersonaStore* store, gboolean remove_from_persona_stores, gboolean remove_from_watched_devices) {
	FolksBackendsBlueZPersonaStore* _tmp0_;
	guint _tmp1_;
	FolksBackendsBlueZPersonaStore* _tmp2_;
	FolksBackendsBlueZPersonaStore* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FolksPersonaStore*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_backends_blue_z_backend_persona_store_removed_cb_folks_persona_store_removed, self);
	_tmp2_ = store;
	folks_backends_blue_z_persona_store_cancel_updates (_tmp2_);
	_tmp3_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", (FolksPersonaStore*) _tmp3_);
	_tmp4_ = remove_from_persona_stores;
	if (_tmp4_ == TRUE) {
		GeeHashMap* _tmp5_;
		FolksBackendsBlueZPersonaStore* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = self->priv->_persona_stores;
		_tmp6_ = store;
		_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp6_);
		_tmp8_ = _tmp7_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, _tmp8_, NULL);
	}
	_tmp9_ = remove_from_watched_devices;
	if (_tmp9_ == TRUE) {
		GeeHashMap* _tmp10_;
		FolksBackendsBlueZPersonaStore* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = self->priv->_watched_devices;
		_tmp11_ = store;
		_tmp12_ = folks_backends_blue_z_persona_store_get_object_path (_tmp11_);
		_tmp13_ = _tmp12_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp13_, NULL);
	}
	g_object_notify ((GObject*) self, "persona-stores");
}


/**
   * Check if a device supports PSE (Phone Book Server Equipment.
   *
   * We assume that UUIDs won’t change after we initially see the device, so
   * don’t listen for changes to it.
   *
   * @param device the D-Bus device object
   * @return ``true`` if the device supports PSE, ``false`` otherwise.
   *
   * @since 0.9.6
   */
static gboolean _folks_backends_blue_z_backend_device_supports_pbap_pse (FolksBackendsBlueZBackend* self, orgbluezDevice* device) {
	gboolean result = FALSE;
	gchar** uuids = NULL;
	orgbluezDevice* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint uuids_length1;
	gint _uuids_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_tmp0_ = device;
	_tmp1_ = org_bluez_device_get_uuids (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	uuids = _tmp2_;
	uuids_length1 = _tmp2__length1;
	_uuids_size_ = uuids_length1;
	_tmp3_ = uuids;
	_tmp3__length1 = uuids_length1;
	if (_tmp3_ == NULL) {
		result = FALSE;
		uuids = (_vala_array_free (uuids, uuids_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = uuids;
	_tmp4__length1 = uuids_length1;
	{
		gchar** uuid_collection = NULL;
		gint uuid_collection_length1 = 0;
		gint _uuid_collection_size_ = 0;
		gint uuid_it = 0;
		uuid_collection = (gchar**) _tmp4_;
		uuid_collection_length1 = (_tmp4__length1 * sizeof (gchar*)) / sizeof (gchar*);
		for (uuid_it = 0; uuid_it < ((_tmp4__length1 * sizeof (gchar*)) / sizeof (gchar*)); uuid_it = uuid_it + 1) {
			gchar* _tmp5_;
			gchar* uuid = NULL;
			_tmp5_ = g_strdup (uuid_collection[uuid_it]);
			uuid = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = uuid;
				if (g_strcmp0 (_tmp6_, "0000112f-0000-1000-8000-00805f9b34fb") == 0) {
					result = TRUE;
					_g_free0 (uuid);
					uuids = (_vala_array_free (uuids, uuids_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (uuid);
			}
		}
	}
	result = FALSE;
	uuids = (_vala_array_free (uuids, uuids_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _folks_backends_blue_z_backend_refresh_devices_data_free (gpointer _data) {
	FolksBackendsBlueZBackendRefreshDevicesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendRefreshDevicesData, _data_);
}


static void _folks_backends_blue_z_backend_refresh_devices_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendRefreshDevicesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void _folks_backends_blue_z_backend_refresh_devices (FolksBackendsBlueZBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackendRefreshDevicesData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendRefreshDevicesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _folks_backends_blue_z_backend_refresh_devices_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_backend_refresh_devices_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backends_blue_z_backend_refresh_devices_co (_data_);
}


static void _folks_backends_blue_z_backend_refresh_devices_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_) {
	FolksBackendsBlueZBackendRefreshDevicesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Refresh the list of devices from D-Bus.
   *
   * Add any new devices which are on D-Bus but aren’t in the BlueZ backend.
   * This does not currently remove devices which have disappeared from D-Bus.
   *
   * @since 0.9.7
   */
static void _folks_backends_blue_z_backend_refresh_devices_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZBackendRefreshDevicesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	_folks_backends_blue_z_backend_refresh_devices_co (_data_);
}


static gboolean _folks_backends_blue_z_backend_refresh_devices_co (FolksBackendsBlueZBackendRefreshDevicesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_manager;
	_data_->_tmp1_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _data_->_tmp0_);
	_data_->objs = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->objs;
	{
		_data_->obj_collection = _data_->_tmp2_;
		for (_data_->obj_it = _data_->obj_collection; _data_->obj_it != NULL; _data_->obj_it = _data_->obj_it->next) {
			_data_->_tmp3_ = _g_object_ref0 ((GDBusObject*) _data_->obj_it->data);
			_data_->obj = _data_->_tmp3_;
			{
				_data_->_tmp4_ = _data_->obj;
				_data_->_state_ = 1;
				_folks_backends_blue_z_backend_add_device (_data_->self, _data_->_tmp4_, _folks_backends_blue_z_backend_refresh_devices_ready, _data_);
				return FALSE;
				_state_1:
				_folks_backends_blue_z_backend_add_device_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->obj);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (_data_->objs);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_backend_add_device_data_free (gpointer _data) {
	FolksBackendsBlueZBackendAddDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->obj);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendAddDeviceData, _data_);
}


static void _folks_backends_blue_z_backend_add_device_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendAddDeviceData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void _folks_backends_blue_z_backend_add_device (FolksBackendsBlueZBackend* self, GDBusObject* obj, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackendAddDeviceData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	GDBusObject* _tmp1_;
	GDBusObject* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendAddDeviceData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _folks_backends_blue_z_backend_add_device_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_backend_add_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = obj;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->obj);
	_data_->obj = _tmp2_;
	_folks_backends_blue_z_backend_add_device_co (_data_);
}


static void _folks_backends_blue_z_backend_add_device_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_) {
	FolksBackendsBlueZBackendAddDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Add a device to the backend.
   *
   * @param _obj the device's D-Bus object
   *
   * @since 0.9.6
   */
static void _folks_backends_blue_z_backend_add_device_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZBackendAddDeviceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	_folks_backends_blue_z_backend_add_device_co (_data_);
}


static gboolean _folks_backends_blue_z_backend_add_device_co (FolksBackendsBlueZBackendAddDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->obj;
	_data_->_tmp1_ = g_dbus_object_get_object_path (_data_->_tmp0_);
	g_debug ("bluez-backend.vala:486: Adding device at path ‘%s’.", _data_->_tmp1_);
	_data_->_tmp2_ = _data_->obj;
	_data_->_tmp3_ = g_dbus_object_get_interface (_data_->_tmp2_, "org.bluez.Device1");
	_data_->_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, ORG_BLUEZ_TYPE_DEVICE) ? ((orgbluezDevice*) _data_->_tmp3_) : NULL;
	if (_data_->_tmp4_ == NULL) {
		_g_object_unref0 (_data_->_tmp3_);
	}
	_data_->device = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->device;
	if (_data_->_tmp5_ == NULL) {
		g_debug ("bluez-backend.vala:491: %s", "    Device doesn’t implement org.bluez.Device1 " "interface. Ignoring.");
		_g_object_unref0 (_data_->device);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->obj;
	_data_->_tmp7_ = g_dbus_object_get_object_path (_data_->_tmp6_);
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
	_data_->path = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->self->priv->_watched_devices;
	_data_->_tmp10_ = _data_->path;
	_data_->_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp9_, _data_->_tmp10_);
	if (_data_->_tmp11_) {
		g_debug ("bluez-backend.vala:500:     Device already watched. Ignoring.");
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->device);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->device;
	_data_->_tmp13_ = org_bluez_device_get_paired (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	if (_data_->_tmp14_ == FALSE) {
		g_debug ("bluez-backend.vala:506: %s", "    Device isn’t paired. Ignoring. Manually pair the device" " to start downloading contacts.");
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->device);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->device;
	_data_->_tmp16_ = org_bluez_device_get_blocked (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	if (_data_->_tmp17_ == TRUE) {
		g_debug ("bluez-backend.vala:513:     Device is blocked. Ignoring.");
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->device);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->device;
	_data_->_tmp19_ = _folks_backends_blue_z_backend_device_supports_pbap_pse (_data_->self, _data_->_tmp18_);
	if (!_data_->_tmp19_) {
		g_debug ("bluez-backend.vala:519:     Doesn’t support PBAP PSE. Ignoring.");
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->device);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->self->priv->_enabled_devices;
	_data_->_tmp21_ = _data_->device;
	_data_->_tmp22_ = org_bluez_device_get_address (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp20_, _data_->_tmp24_);
	_data_->_tmp26_ = !_data_->_tmp25_;
	_g_free0 (_data_->_tmp24_);
	if (_data_->_tmp26_) {
		g_debug ("bluez-backend.vala:525:     Device not in enabled devices list.");
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->device);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->device;
	_data_->_tmp28_ = _data_->path;
	_data_->_state_ = 1;
	_folks_backends_blue_z_backend_add_persona_store (_data_->self, _data_->_tmp27_, _data_->_tmp28_, _folks_backends_blue_z_backend_add_device_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backends_blue_z_backend_add_persona_store_finish (_data_->self, _data_->_res_);
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->device);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_backend_remove_device_data_free (gpointer _data) {
	FolksBackendsBlueZBackendRemoveDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->obj);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendRemoveDeviceData, _data_);
}


static void _folks_backends_blue_z_backend_remove_device_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendRemoveDeviceData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void _folks_backends_blue_z_backend_remove_device (FolksBackendsBlueZBackend* self, GDBusObject* obj, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackendRemoveDeviceData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	GDBusObject* _tmp1_;
	GDBusObject* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendRemoveDeviceData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _folks_backends_blue_z_backend_remove_device_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_backend_remove_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = obj;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->obj);
	_data_->obj = _tmp2_;
	_folks_backends_blue_z_backend_remove_device_co (_data_);
}


static void _folks_backends_blue_z_backend_remove_device_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_) {
	FolksBackendsBlueZBackendRemoveDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Remove a device from the backend.
   *
   * @param obj the device's D-Bus object
   *
   * @since 0.9.6
   */
static gboolean _folks_backends_blue_z_backend_remove_device_co (FolksBackendsBlueZBackendRemoveDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->obj;
	_data_->_tmp1_ = g_dbus_object_get_object_path (_data_->_tmp0_);
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->path = _data_->_tmp2_;
	_data_->store = NULL;
	_data_->_tmp3_ = _data_->path;
	g_debug ("bluez-backend.vala:544: Removing device at ‘%s’.", _data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->_watched_devices;
	_data_->_tmp5_ = _data_->path;
	_data_->_tmp6_ = NULL;
	_data_->_tmp7_ = gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp4_, _data_->_tmp5_, &_data_->_tmp6_);
	_g_object_unref0 (_data_->store);
	_data_->store = _data_->_tmp6_;
	if (_data_->_tmp7_ == TRUE) {
		_data_->_tmp8_ = _data_->path;
		g_debug ("bluez-backend.vala:548: Device ‘%s’ removed", _data_->_tmp8_);
		_data_->_tmp9_ = _data_->store;
		_folks_backends_blue_z_backend_remove_persona_store (_data_->self, _data_->_tmp9_, TRUE, FALSE);
	}
	_g_object_unref0 (_data_->store);
	_g_free0 (_data_->path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* _folks_backends_blue_z_backend_get_enabled_devices_key_file_path (FolksBackendsBlueZBackend* self) {
	gchar* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_child (_tmp2_, "folks");
	_g_object_unref0 (file);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_get_child (_tmp4_, "bluez-persona-stores.ini");
	_g_object_unref0 (file);
	file = _tmp5_;
	_tmp6_ = file;
	_tmp7_ = g_file_get_path (_tmp6_);
	result = _tmp7_;
	_g_object_unref0 (file);
	return result;
}


static void _folks_backends_blue_z_backend_save_enabled_devices_data_free (gpointer _data) {
	FolksBackendsBlueZBackendSaveEnabledDevicesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendSaveEnabledDevicesData, _data_);
}


static void _folks_backends_blue_z_backend_save_enabled_devices_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendSaveEnabledDevicesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void _folks_backends_blue_z_backend_save_enabled_devices (FolksBackendsBlueZBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackendSaveEnabledDevicesData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendSaveEnabledDevicesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _folks_backends_blue_z_backend_save_enabled_devices_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_backend_save_enabled_devices_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backends_blue_z_backend_save_enabled_devices_co (_data_);
}


static void _folks_backends_blue_z_backend_save_enabled_devices_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_) {
	FolksBackendsBlueZBackendSaveEnabledDevicesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Save the list of enabled devices to a configuration file.
   *
   * @since 0.11.4
   */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gboolean _folks_backends_blue_z_backend_save_enabled_devices_co (FolksBackendsBlueZBackendSaveEnabledDevicesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_key_file_new ();
	_data_->kf = _data_->_tmp0_;
	_data_->_tmp1_ = _folks_backends_blue_z_backend_get_enabled_devices_key_file_path (_data_->self);
	_data_->kf_path = _data_->_tmp1_;
	{
		_data_->_tmp2_ = _data_->self->priv->_enabled_devices;
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
		_data_->_address_list = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->_address_list;
		_data_->_tmp5_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_address_size = _data_->_tmp6_;
		_data_->_address_index = -1;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_address_index;
			_data_->_address_index = _data_->_tmp7_ + 1;
			_data_->_tmp8_ = _data_->_address_index;
			_data_->_tmp9_ = _data_->_address_size;
			if (!(_data_->_tmp8_ < _data_->_tmp9_)) {
				break;
			}
			_data_->_tmp10_ = _data_->_address_list;
			_data_->_tmp11_ = _data_->_address_index;
			_data_->_tmp12_ = folks_small_set_get (_data_->_tmp10_, _data_->_tmp11_);
			_data_->_tmp13_ = g_strdup ((const gchar*) _data_->_tmp12_);
			_data_->address = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->kf;
			_data_->_tmp15_ = _data_->address;
			g_key_file_set_boolean (_data_->_tmp14_, _data_->_tmp15_, "enabled", TRUE);
			_g_free0 (_data_->address);
		}
		_g_object_unref0 (_data_->_address_list);
	}
	_data_->_tmp16_ = _data_->kf_path;
	g_debug ("bluez-backend.vala:575: Saving BlueZ enabled devices key file ‘%s’.", _data_->_tmp16_);
	{
		_data_->_tmp17_ = _data_->kf_path;
		_data_->_tmp18_ = g_file_new_for_path (_data_->_tmp17_);
		_data_->file = _data_->_tmp18_;
		_data_->_tmp19_ = _data_->kf;
		_data_->_tmp20_ = g_key_file_to_data (_data_->_tmp19_, NULL, NULL);
		_data_->data = _data_->_tmp20_;
		_data_->_tmp21_ = string_get_data (_data_->data, &_data_->_tmp21__length1);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp22__length1 = _data_->_tmp21__length1;
		g_file_replace_contents (_data_->file, _data_->_tmp22_, (gsize) _data_->_tmp22__length1, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->data);
			_g_object_unref0 (_data_->file);
			goto __catch1_g_error;
		}
		_g_free0 (_data_->data);
		_g_object_unref0 (_data_->file);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp23_ = _data_->kf_path;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("Could not write updated BlueZ enabled devices key file " "‘%s’: %s", _data_->_tmp23_, _data_->_tmp25_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->kf_path);
		_g_key_file_unref0 (_data_->kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->kf_path);
	_g_key_file_unref0 (_data_->kf);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_backend_load_enabled_devices_data_free (gpointer _data) {
	FolksBackendsBlueZBackendLoadEnabledDevicesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendLoadEnabledDevicesData, _data_);
}


static void _folks_backends_blue_z_backend_load_enabled_devices_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendLoadEnabledDevicesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void _folks_backends_blue_z_backend_load_enabled_devices (FolksBackendsBlueZBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackendLoadEnabledDevicesData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendLoadEnabledDevicesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _folks_backends_blue_z_backend_load_enabled_devices_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_backend_load_enabled_devices_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backends_blue_z_backend_load_enabled_devices_co (_data_);
}


static void _folks_backends_blue_z_backend_load_enabled_devices_finish (FolksBackendsBlueZBackend* self, GAsyncResult* _res_) {
	FolksBackendsBlueZBackendLoadEnabledDevicesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Load the list of enabled devices from a configuration file.
   *
   * @since 0.11.4
   */
static void _folks_backends_blue_z_backend_load_enabled_devices_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZBackendLoadEnabledDevicesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	_folks_backends_blue_z_backend_load_enabled_devices_co (_data_);
}


static gboolean _folks_backends_blue_z_backend_load_enabled_devices_co (FolksBackendsBlueZBackendLoadEnabledDevicesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_key_file_new ();
	_data_->kf = _data_->_tmp0_;
	_data_->_tmp1_ = _folks_backends_blue_z_backend_get_enabled_devices_key_file_path (_data_->self);
	_data_->kf_path = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->kf_path;
	g_debug ("bluez-backend.vala:602: Loading BlueZ enabled devices key file ‘%s’.", _data_->_tmp2_);
	{
		_data_->contents_length1 = 0;
		_data_->_contents_size_ = 0;
		_data_->_tmp3_ = _data_->kf_path;
		_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
		_data_->file = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->file;
		_data_->_tmp6_ = NULL;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp5_, NULL, _folks_backends_blue_z_backend_load_enabled_devices_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp6_, &_data_->_tmp7_, NULL, &_data_->_inner_error_);
		_data_->contents = (g_free (_data_->contents), NULL);
		_data_->contents = _data_->_tmp6_;
		_data_->contents_length1 = _data_->_tmp7_;
		_data_->_contents_size_ = _data_->contents_length1;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->file);
			_data_->contents = (g_free (_data_->contents), NULL);
			goto __catch2_g_error;
		}
		_data_->_tmp8_ = _data_->contents;
		_data_->_tmp8__length1 = _data_->contents_length1;
		_data_->contents_s = (const gchar*) _data_->_tmp8_;
		_data_->_tmp9_ = _data_->contents_s;
		_data_->_tmp10_ = strlen (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		if (_data_->_tmp11_ > 0) {
			_data_->_tmp12_ = _data_->kf;
			_data_->_tmp13_ = _data_->contents_s;
			_data_->_tmp14_ = _data_->contents_s;
			_data_->_tmp15_ = strlen (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			g_key_file_load_from_data (_data_->_tmp12_, _data_->_tmp13_, (gsize) _data_->_tmp16_, G_KEY_FILE_KEEP_COMMENTS, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->file);
				_data_->contents = (g_free (_data_->contents), NULL);
				goto __catch2_g_error;
			}
		}
		_g_object_unref0 (_data_->file);
		_data_->contents = (g_free (_data_->contents), NULL);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = _data_->e1;
		if (!g_error_matches (_data_->_tmp17_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp18_ = _data_->kf_path;
			_data_->_tmp19_ = _data_->e1;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_warning ("The BlueZ enabled devices key file ‘%s’ could not be " "loaded: %s", _data_->_tmp18_, _data_->_tmp20_);
			_g_error_free0 (_data_->e1);
			_g_free0 (_data_->kf_path);
			_g_key_file_unref0 (_data_->kf);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (_data_->_task_complete_ != TRUE) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_debug ("bluez-backend.vala:628:     Not found.");
		}
		_g_error_free0 (_data_->e1);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->kf_path);
		_g_key_file_unref0 (_data_->kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->self->priv->_enabled_devices;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp21_);
	_data_->_tmp22_ = _data_->kf;
	_data_->_tmp24_ = g_key_file_get_groups (_data_->_tmp22_, &_data_->_tmp23_);
	_data_->groups = _data_->_tmp24_;
	_data_->groups_length1 = _data_->_tmp23_;
	_data_->_groups_size_ = _data_->groups_length1;
	_data_->_tmp25_ = _data_->groups;
	_data_->_tmp25__length1 = _data_->groups_length1;
	{
		_data_->address_collection_length1 = 0;
		_data_->_address_collection_size_ = 0;
		_data_->address_collection = _data_->_tmp25_;
		_data_->address_collection_length1 = _data_->_tmp25__length1;
		for (_data_->address_it = 0; _data_->address_it < _data_->_tmp25__length1; _data_->address_it = _data_->address_it + 1) {
			_data_->_tmp26_ = g_strdup (_data_->address_collection[_data_->address_it]);
			_data_->address = _data_->_tmp26_;
			{
				{
					_data_->_tmp28_ = _data_->kf;
					_data_->_tmp29_ = _data_->address;
					_data_->_tmp30_ = g_key_file_get_boolean (_data_->_tmp28_, _data_->_tmp29_, "enabled", &_data_->_inner_error_);
					_data_->_tmp27_ = _data_->_tmp30_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						if (_data_->_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch3_g_key_file_error;
						}
						_g_free0 (_data_->address);
						_data_->groups = (_vala_array_free (_data_->groups, _data_->groups_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_data_->kf_path);
						_g_key_file_unref0 (_data_->kf);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					if (_data_->_tmp27_) {
						_data_->_tmp31_ = _data_->address;
						g_debug ("bluez-backend.vala:641:     Enabling device ‘%s’", _data_->_tmp31_);
						_data_->_tmp32_ = _data_->self->priv->_enabled_devices;
						_data_->_tmp33_ = _data_->address;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp32_, _data_->_tmp33_);
					}
				}
				goto __finally3;
				__catch3_g_key_file_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_error_free0 (_data_->e);
				}
				__finally3:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_free0 (_data_->address);
					_data_->groups = (_vala_array_free (_data_->groups, _data_->groups_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->kf_path);
					_g_key_file_unref0 (_data_->kf);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_free0 (_data_->address);
			}
		}
	}
	_data_->groups = (_vala_array_free (_data_->groups, _data_->groups_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->kf_path);
	_g_key_file_unref0 (_data_->kf);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_blue_z_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsBlueZBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendPrepareData, _data_);
}


static void folks_backends_blue_z_backend_real_prepare_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendPrepareData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void folks_backends_blue_z_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackend * self;
	FolksBackendsBlueZBackendPrepareData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	self = (FolksBackendsBlueZBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendPrepareData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, folks_backends_blue_z_backend_real_prepare_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_blue_z_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_blue_z_backend_real_prepare_co (_data_);
}


static void folks_backends_blue_z_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZBackendPrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void folks_backends_blue_z_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZBackendPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	folks_backends_blue_z_backend_real_prepare_co (_data_);
}


static GType ____lambda19_ (FolksBackendsBlueZBackend* self, GDBusObjectManagerClient* manager, const gchar* path, const gchar* iface_name) {
	GType result = 0UL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GType retval = 0UL;
	const gchar* _tmp2_;
	GType _tmp9_;
	const gchar* _tmp10_;
	g_return_val_if_fail (manager != NULL, 0UL);
	g_return_val_if_fail (path != NULL, 0UL);
	_tmp0_ = path;
	_tmp1_ = iface_name;
	g_debug ("DBusProxyTypeFunc for path ‘%s’ and " "interface ‘%s’.", _tmp0_, _tmp1_);
	_tmp2_ = iface_name;
	if (g_strcmp0 (_tmp2_, "org.bluez.Device1") == 0) {
		GQuark q = 0U;
		GQuark _tmp3_;
		GType dev_type = 0UL;
		GType _tmp4_;
		GQuark _tmp5_;
		void* _tmp6_;
		GType _tmp7_;
		_tmp3_ = g_quark_from_string ("vala-dbus-proxy-type");
		q = _tmp3_;
		dev_type = ORG_BLUEZ_TYPE_DEVICE;
		_tmp4_ = dev_type;
		_tmp5_ = q;
		_tmp6_ = g_type_get_qdata (_tmp4_, _tmp5_);
		_tmp7_ = ((FolksBackendsBlueZBackendTypeFunc) _tmp6_) (NULL);
		retval = _tmp7_;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = iface_name;
		if (_tmp8_ == NULL) {
			retval = g_dbus_object_proxy_get_type ();
		} else {
			retval = g_dbus_proxy_get_type ();
		}
	}
	_tmp9_ = retval;
	_tmp10_ = g_type_name (_tmp9_);
	g_debug ("bluez-backend.vala:726:     Returning: %s", _tmp10_);
	result = retval;
	return result;
}


static GType _____lambda19__gd_bus_proxy_type_func (GDBusObjectManagerClient* manager, const gchar* object_path, const gchar* interface_name, gpointer self) {
	GType result;
	result = ____lambda19_ ((FolksBackendsBlueZBackend*) self, manager, object_path, interface_name);
	return result;
}


static void __lambda21_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_add_device_finish (self, _tmp0_);
}


static void ___lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda21_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void ___lambda20_ (FolksBackendsBlueZBackend* self, GDBusObject* obj) {
	GDBusObject* _tmp0_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_folks_backends_blue_z_backend_add_device (self, _tmp0_, ___lambda21__gasync_ready_callback, g_object_ref (self));
}


static void ____lambda20__g_dbus_object_manager_object_added (GDBusObjectManager* _sender, GDBusObject* object, gpointer self) {
	___lambda20_ ((FolksBackendsBlueZBackend*) self, object);
}


static void __lambda23_ (FolksBackendsBlueZBackend* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_folks_backends_blue_z_backend_remove_device_finish (self, _tmp0_);
}


static void ___lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda23_ ((FolksBackendsBlueZBackend*) self, source_object, res);
	g_object_unref (self);
}


static void ___lambda22_ (FolksBackendsBlueZBackend* self, GDBusObject* obj) {
	GDBusObject* _tmp0_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_folks_backends_blue_z_backend_remove_device (self, _tmp0_, ___lambda23__gasync_ready_callback, g_object_ref (self));
}


static void ____lambda22__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender, GDBusObject* object, gpointer self) {
	___lambda22_ ((FolksBackendsBlueZBackend*) self, object);
}


static void __folks_backends_blue_z_backend_device_properties_changed_cb_g_dbus_object_manager_client_interface_proxy_properties_changed (GDBusObjectManagerClient* _sender, GDBusObjectProxy* object_proxy, GDBusProxy* interface_proxy, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	_folks_backends_blue_z_backend_device_properties_changed_cb ((FolksBackendsBlueZBackend*) self, object_proxy, interface_proxy, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


static gboolean folks_backends_blue_z_backend_real_prepare_co (FolksBackendsBlueZBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing BlueZ.Backend", NULL);
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->_state_ = 1;
		_folks_backends_blue_z_backend_load_enabled_devices (_data_->self, folks_backends_blue_z_backend_prepare_ready, _data_);
		return FALSE;
		_state_1:
		_folks_backends_blue_z_backend_load_enabled_devices_finish (_data_->self, _data_->_res_);
		{
			_data_->_state_ = 2;
			g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.bluez", "/", _____lambda19__gd_bus_proxy_type_func, g_object_ref (_data_->self), g_object_unref, NULL, folks_backends_blue_z_backend_prepare_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp4_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp3_ = _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
			_data_->_tmp5_ = _data_->_tmp3_;
			_data_->_tmp3_ = NULL;
			_g_object_unref0 (_data_->self->priv->_manager);
			_data_->self->priv->_manager = _data_->_tmp5_;
			_g_object_unref0 (_data_->_tmp3_);
		}
		goto __finally5;
		__catch5_g_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp6_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_SERVICE_UNKNOWN, _ ("No BlueZ 5 object manager running, so the BlueZ backend will be inacti" \
"ve. Either your BlueZ installation is too old (only version 5 is suppo" \
"rted) or the service can’t be started."));
			_data_->_inner_error_ = _data_->_tmp6_;
			_g_error_free0 (_data_->e1);
			goto __finally5;
		}
		__finally5:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __finally4;
		}
		{
			_data_->_state_ = 3;
			g_async_initable_new_async (ORG_BLUEZ_OBEX_TYPE_CLIENT_PROXY, 0, NULL, folks_backends_blue_z_backend_prepare_ready, _data_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/bluez/obex", "g-interface-name", "org.bluez.obex.Client1", "g-interface-info", g_type_get_qdata (ORG_BLUEZ_OBEX_TYPE_CLIENT, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			return FALSE;
			_state_3:
			_data_->_tmp8_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp7_ = (orgbluezobexClient*) _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
			_data_->_tmp9_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_g_object_unref0 (_data_->self->priv->_obex_client);
			_data_->self->priv->_obex_client = _data_->_tmp9_;
			_g_object_unref0 (_data_->_tmp7_);
		}
		goto __finally6;
		__catch6_g_error:
		{
			_data_->_vala1_e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp10_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_SERVICE_UNKNOWN, _ ("Error connecting to OBEX transfer daemon over D-Bus. Ensure BlueZ and " \
"obexd are installed."));
			_data_->_inner_error_ = _data_->_tmp10_;
			_g_error_free0 (_data_->_vala1_e1);
			goto __finally6;
		}
		__finally6:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __finally4;
		}
		_data_->_tmp11_ = _data_->self->priv->_manager;
		_data_->_tmp12_ = g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp11_, "object-added", (GCallback) ____lambda20__g_dbus_object_manager_object_added, _data_->self, 0);
		_data_->self->priv->_object_added_handler = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->self->priv->_manager;
		_data_->_tmp14_ = g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp13_, "object-removed", (GCallback) ____lambda22__g_dbus_object_manager_object_removed, _data_->self, 0);
		_data_->self->priv->_object_removed_handler = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->self->priv->_manager;
		_data_->_tmp16_ = g_signal_connect_object (_data_->_tmp15_, "interface-proxy-properties-changed", (GCallback) __folks_backends_blue_z_backend_device_properties_changed_cb_g_dbus_object_manager_client_interface_proxy_properties_changed, _data_->self, 0);
		_data_->self->priv->_properties_changed_handler = _data_->_tmp16_;
		_data_->_state_ = 4;
		_folks_backends_blue_z_backend_refresh_devices (_data_->self, folks_backends_blue_z_backend_prepare_ready, _data_);
		return FALSE;
		_state_4:
		_folks_backends_blue_z_backend_refresh_devices_finish (_data_->self, _data_->_res_);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
	}
	__finally4:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	folks_internal_profiling_end ("preparing BlueZ.Backend", NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_blue_z_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsBlueZBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZBackendUnprepareData, _data_);
}


static void folks_backends_blue_z_backend_real_unprepare_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksBackendsBlueZBackendUnprepareData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void folks_backends_blue_z_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZBackend * self;
	FolksBackendsBlueZBackendUnprepareData* _data_;
	FolksBackendsBlueZBackend* _tmp0_;
	self = (FolksBackendsBlueZBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZBackendUnprepareData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, folks_backends_blue_z_backend_real_unprepare_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_blue_z_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_blue_z_backend_real_unprepare_co (_data_);
}


static void folks_backends_blue_z_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZBackendUnprepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static gboolean folks_backends_blue_z_backend_real_unprepare_co (FolksBackendsBlueZBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_ == TRUE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp3_ = _data_->self->priv->_manager;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->self->priv->_manager;
			_data_->_tmp5_ = _data_->self->priv->_object_added_handler;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp4_, _data_->_tmp5_);
			_data_->_tmp6_ = _data_->self->priv->_manager;
			_data_->_tmp7_ = _data_->self->priv->_object_removed_handler;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp6_, _data_->_tmp7_);
			_data_->_tmp8_ = _data_->self->priv->_manager;
			_data_->_tmp9_ = _data_->self->priv->_properties_changed_handler;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp8_, _data_->_tmp9_);
			_g_object_unref0 (_data_->self->priv->_manager);
			_data_->self->priv->_manager = NULL;
			_data_->self->priv->_object_added_handler = (gulong) 0;
			_data_->self->priv->_object_removed_handler = (gulong) 0;
			_data_->self->priv->_properties_changed_handler = (gulong) 0;
		}
		_g_object_unref0 (_data_->self->priv->_obex_client);
		_data_->self->priv->_obex_client = NULL;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->_tmp10_ = _data_->self->priv->_persona_stores;
		_data_->_tmp11_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _data_->_tmp10_);
		_data_->iter = _data_->_tmp11_;
		while (TRUE) {
			_data_->_tmp12_ = _data_->iter;
			_data_->_tmp13_ = gee_map_iterator_next (_data_->_tmp12_);
			if (!(_data_->_tmp13_ == TRUE)) {
				break;
			}
			_data_->_tmp14_ = _data_->iter;
			_data_->_tmp15_ = gee_map_iterator_get_value (_data_->_tmp14_);
			_data_->_tmp16_ = (FolksBackendsBlueZPersonaStore*) _data_->_tmp15_;
			_folks_backends_blue_z_backend_remove_persona_store (_data_->self, _data_->_tmp16_, FALSE, TRUE);
			_g_object_unref0 (_data_->_tmp16_);
			_data_->_tmp17_ = _data_->iter;
			gee_map_iterator_unset (_data_->_tmp17_);
		}
		g_object_notify ((GObject*) _data_->self, "persona-stores");
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		g_object_thaw_notify ((GObject*) _data_->self);
		_g_object_unref0 (_data_->iter);
	}
	__finally7:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_backend_persona_store_removed_cb (FolksBackendsBlueZBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_backends_blue_z_backend_remove_persona_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore), TRUE, TRUE);
}


static gboolean folks_backends_blue_z_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsBlueZBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsBlueZBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_blue_z_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsBlueZBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsBlueZBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static const gchar* folks_backends_blue_z_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsBlueZBackend* self;
	self = (FolksBackendsBlueZBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_blue_z_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsBlueZBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsBlueZBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static GObject * folks_backends_blue_z_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsBlueZBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeHashMap* _tmp4_;
	FolksSmallSet* _tmp5_;
	parent_class = G_OBJECT_CLASS (folks_backends_blue_z_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_watched_devices);
	self->priv->_watched_devices = _tmp4_;
	_tmp5_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_enabled_devices);
	self->priv->_enabled_devices = _tmp5_;
	return obj;
}


static void folks_backends_blue_z_backend_class_init (FolksBackendsBlueZBackendClass * klass) {
	folks_backends_blue_z_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsBlueZBackendPrivate));
	((FolksBackendClass *) klass)->disable_persona_store = (void (*) (FolksBackend *, FolksPersonaStore*)) folks_backends_blue_z_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->enable_persona_store = (void (*) (FolksBackend *, FolksPersonaStore*)) folks_backends_blue_z_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = (void (*) (FolksBackend *, GeeSet*)) folks_backends_blue_z_backend_real_set_persona_stores;
	((FolksBackendClass *) klass)->prepare = (void (*) (FolksBackend *, GAsyncReadyCallback, gpointer)) folks_backends_blue_z_backend_real_prepare;
	((FolksBackendClass *) klass)->prepare_finish = (void (*) (FolksBackend *, GAsyncResult*, GError**)) folks_backends_blue_z_backend_real_prepare_finish;
	((FolksBackendClass *) klass)->unprepare = (void (*) (FolksBackend *, GAsyncReadyCallback, gpointer)) folks_backends_blue_z_backend_real_unprepare;
	((FolksBackendClass *) klass)->unprepare_finish = (void (*) (FolksBackend *, GAsyncResult*, GError**)) folks_backends_blue_z_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_blue_z_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_blue_z_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_blue_z_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_blue_z_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_blue_z_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_blue_z_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_blue_z_backend_finalize;
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_PREPARED, folks_backends_blue_z_backend_properties[FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_PREPARED] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_QUIESCENT, folks_backends_blue_z_backend_properties[FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_QUIESCENT] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_BACKEND_NAME, folks_backends_blue_z_backend_properties[FOLKS_BACKENDS_BLUE_Z_BACKEND_NAME] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_BACKEND_PERSONA_STORES, folks_backends_blue_z_backend_properties[FOLKS_BACKENDS_BLUE_Z_BACKEND_PERSONA_STORES] = g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_backends_blue_z_backend_instance_init (FolksBackendsBlueZBackend * self) {
	self->priv = FOLKS_BACKENDS_BLUE_Z_BACKEND_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_obex_client = NULL;
}


static void folks_backends_blue_z_backend_finalize (GObject * obj) {
	FolksBackendsBlueZBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackend);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	_g_object_unref0 (self->priv->_manager);
	_g_object_unref0 (self->priv->_watched_devices);
	_g_object_unref0 (self->priv->_obex_client);
	_g_object_unref0 (self->priv->_enabled_devices);
	G_OBJECT_CLASS (folks_backends_blue_z_backend_parent_class)->finalize (obj);
}


/**
 * A backend which loads {@link Persona}s from paired Bluetooth
 * devices using the Phonebook Access Protocol (PBAP) and presents them
 * using one {@link PersonaStore} per device.
 *
 * Each device can be in four states:
 *  - Unpaired and unconnected
 *  - Unpaired but connected
 *  - Paired but unconnected
 *  - Paired and connected
 *
 * The default state for a device is unpaired. The user must explicitly pair
 * their device and enable it using {@link Backend.enable_persona_store} or
 * {@link Backend.set_persona_stores} before folks will begin to use it — folks
 * ignores unpaired devices. Once a device is paired and enabled, folks will
 * attempt to do an OBEX PBAP transfer to copy the device’s address book; this
 * will automatically connect the device. After the transfer is complete, the
 * device will go back to being paired and unconnected.
 *
 * Note that by requiring that devices are explicitly enabled by calling
 * {@link Backend.set_persona_stores}, the BlueZ backend is empty by default
 * every time libfolks is loaded, until the client explicitly enables a device.
 * This may change in future, and the state of enabled devices may be retained
 * between runs.
 *
 * Every time the user explicitly connects to the device, folks will re-download
 * its address book. Currently, folks will not otherwise re-download it (i.e.
 * there are no change notifications and no polling).
 *
 * If a transfer is started from an unpaired device, the device will move to the
 * unpaired but connected state, and will pop up a notification asking the user
 * whether they want to pair to the computer. This should be avoided, and is why
 * folks ignores all unpaired devices.
 *
 * If a connection timeout occurs (e.g. because the user took too long to
 * approve a pairing request, or explicitly denied it), the device will become
 * disconnected again.
 *
 * If the phone user explicitly denies the phone’s request to share address book
 * data with the laptop (which happens after pairing is successful), creating an
 * OBEX transfer session will fail with an explicit error, which is handled in
 * the {@link PersonaStore}.
 *
 * No caching is implemented by libfolks at the moment, so the address book
 * will be downloaded every time folks starts up.
 *
 * Each device can be advertised by BlueZ as trusted or untrusted, a property
 * which is explicitly set by the user on the laptop (not on the device). Folks
 * will set the PersonaStore’s trust level appropriately, fully trusting devices
 * marked as trusted, and only partially trusting others.
 *
 * Each device can also be advertised by BlueZ as being blocked or non-blocked.
 * Blocked devices are not made available as persona stores, even if they are
 * paired with the laptop.
 *
 * @since 0.9.6
 */
GType folks_backends_blue_z_backend_get_type (void) {
	static volatile gsize folks_backends_blue_z_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_blue_z_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsBlueZBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_blue_z_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsBlueZBackend), 0, (GInstanceInitFunc) folks_backends_blue_z_backend_instance_init, NULL };
		GType folks_backends_blue_z_backend_type_id;
		folks_backends_blue_z_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsBlueZBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_blue_z_backend_type_id__volatile, folks_backends_blue_z_backend_type_id);
	}
	return folks_backends_blue_z_backend_type_id__volatile;
}


static void _vala_folks_backends_blue_z_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_BACKEND, FolksBackendsBlueZBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



