// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file calculatorTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "calculatorTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include <fastdds/dds/rpc/RPCTypeObjectSupport.hpp>

#include "calculator.hpp"


using namespace eprosima::fastdds::dds::xtypes;

namespace calculator_example {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_OverflowException_type_identifier(
        TypeIdentifierPair& type_ids_OverflowException)
{

    ReturnCode_t return_code_OverflowException {eprosima::fastdds::dds::RETCODE_OK};
    return_code_OverflowException =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::OverflowException", type_ids_OverflowException);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_OverflowException)
    {
        StructTypeFlag struct_flags_OverflowException = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        return_code_OverflowException =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "eprosima::fastdds::dds::rpc::RpcOperationError", type_ids_OverflowException);

        if (return_code_OverflowException != eprosima::fastdds::dds::RETCODE_OK)
        {
            ::eprosima::fastdds::dds::rpc::register_RpcOperationError_type_identifier(type_ids_OverflowException);
        }
        QualifiedTypeName type_name_OverflowException = "calculator_example::OverflowException";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_OverflowException;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_OverflowException;
        CompleteTypeDetail detail_OverflowException = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_OverflowException, ann_custom_OverflowException, type_name_OverflowException.to_string());
        CompleteStructHeader header_OverflowException;
        if (EK_COMPLETE == type_ids_OverflowException.type_identifier1()._d())
        {
            header_OverflowException = TypeObjectUtils::build_complete_struct_header(type_ids_OverflowException.type_identifier1(), detail_OverflowException);
        }
        else if (EK_COMPLETE == type_ids_OverflowException.type_identifier2()._d())
        {
            header_OverflowException = TypeObjectUtils::build_complete_struct_header(type_ids_OverflowException.type_identifier2(), detail_OverflowException);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::OverflowException Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_OverflowException;
        CompleteStructType struct_type_OverflowException = TypeObjectUtils::build_complete_struct_type(struct_flags_OverflowException, header_OverflowException, member_seq_OverflowException);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_OverflowException, type_name_OverflowException.to_string(), type_ids_OverflowException))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::OverflowException already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_FilterKind_type_identifier(
        TypeIdentifierPair& type_ids_FilterKind)
{
    ReturnCode_t return_code_FilterKind {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FilterKind =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::FilterKind", type_ids_FilterKind);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FilterKind)
    {
        EnumTypeFlag enum_flags_FilterKind = 0;
        BitBound bit_bound_FilterKind = 32;
        CommonEnumeratedHeader common_FilterKind = TypeObjectUtils::build_common_enumerated_header(bit_bound_FilterKind);
        QualifiedTypeName type_name_FilterKind = "calculator_example::FilterKind";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FilterKind;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FilterKind;
        CompleteTypeDetail detail_FilterKind = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FilterKind, ann_custom_FilterKind, type_name_FilterKind.to_string());
        CompleteEnumeratedHeader header_FilterKind = TypeObjectUtils::build_complete_enumerated_header(common_FilterKind, detail_FilterKind);
        CompleteEnumeratedLiteralSeq literal_seq_FilterKind;
        {
            EnumeratedLiteralFlag flags_EVEN = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_EVEN = TypeObjectUtils::build_common_enumerated_literal(0, flags_EVEN);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_EVEN;
            ann_custom_FilterKind.reset();
            MemberName name_EVEN = "EVEN";
            CompleteMemberDetail detail_EVEN = TypeObjectUtils::build_complete_member_detail(name_EVEN, member_ann_builtin_EVEN, ann_custom_FilterKind);
            CompleteEnumeratedLiteral literal_EVEN = TypeObjectUtils::build_complete_enumerated_literal(common_EVEN, detail_EVEN);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_FilterKind, literal_EVEN);
        }
        {
            EnumeratedLiteralFlag flags_ODD = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_ODD = TypeObjectUtils::build_common_enumerated_literal(1, flags_ODD);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ODD;
            ann_custom_FilterKind.reset();
            MemberName name_ODD = "ODD";
            CompleteMemberDetail detail_ODD = TypeObjectUtils::build_complete_member_detail(name_ODD, member_ann_builtin_ODD, ann_custom_FilterKind);
            CompleteEnumeratedLiteral literal_ODD = TypeObjectUtils::build_complete_enumerated_literal(common_ODD, detail_ODD);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_FilterKind, literal_ODD);
        }
        {
            EnumeratedLiteralFlag flags_PRIME = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_PRIME = TypeObjectUtils::build_common_enumerated_literal(2, flags_PRIME);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_PRIME;
            ann_custom_FilterKind.reset();
            MemberName name_PRIME = "PRIME";
            CompleteMemberDetail detail_PRIME = TypeObjectUtils::build_complete_member_detail(name_PRIME, member_ann_builtin_PRIME, ann_custom_FilterKind);
            CompleteEnumeratedLiteral literal_PRIME = TypeObjectUtils::build_complete_enumerated_literal(common_PRIME, detail_PRIME);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_FilterKind, literal_PRIME);
        }
        CompleteEnumeratedType enumerated_type_FilterKind = TypeObjectUtils::build_complete_enumerated_type(enum_flags_FilterKind, header_FilterKind,
                literal_seq_FilterKind);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_FilterKind, type_name_FilterKind.to_string(), type_ids_FilterKind))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "calculator_example::FilterKind already registered in TypeObjectRegistry for a different type.");
        }
    }
}

namespace detail {

//{ representation_limits
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_representation_limits_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_representation_limits_In)
{

    ReturnCode_t return_code_Calculator_representation_limits_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_representation_limits_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_representation_limits_In", type_ids_Calculator_representation_limits_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_representation_limits_In)
    {
        StructTypeFlag struct_flags_Calculator_representation_limits_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_representation_limits_In = "calculator_example::detail::Calculator_representation_limits_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_representation_limits_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_representation_limits_In;
        CompleteTypeDetail detail_Calculator_representation_limits_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_representation_limits_In, ann_custom_Calculator_representation_limits_In, type_name_Calculator_representation_limits_In.to_string());
        CompleteStructHeader header_Calculator_representation_limits_In;
        header_Calculator_representation_limits_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_representation_limits_In);
        CompleteStructMemberSeq member_seq_Calculator_representation_limits_In;
        CompleteStructType struct_type_Calculator_representation_limits_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_representation_limits_In, header_Calculator_representation_limits_In, member_seq_Calculator_representation_limits_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_representation_limits_In, type_name_Calculator_representation_limits_In.to_string(), type_ids_Calculator_representation_limits_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_representation_limits_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}


// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_representation_limits_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_representation_limits_Out)
{

    ReturnCode_t return_code_Calculator_representation_limits_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_representation_limits_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_representation_limits_Out", type_ids_Calculator_representation_limits_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_representation_limits_Out)
    {
        StructTypeFlag struct_flags_Calculator_representation_limits_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_representation_limits_Out = "calculator_example::detail::Calculator_representation_limits_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_representation_limits_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_representation_limits_Out;
        CompleteTypeDetail detail_Calculator_representation_limits_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_representation_limits_Out, ann_custom_Calculator_representation_limits_Out, type_name_Calculator_representation_limits_Out.to_string());
        CompleteStructHeader header_Calculator_representation_limits_Out;
        header_Calculator_representation_limits_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_representation_limits_Out);
        CompleteStructMemberSeq member_seq_Calculator_representation_limits_Out;
        {
            TypeIdentifierPair type_ids_min_value;
            ReturnCode_t return_code_min_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_min_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_min_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_min_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "min_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_min_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_min_value = 0x00000000;
            bool common_min_value_ec {false};
            CommonStructMember common_min_value {TypeObjectUtils::build_common_struct_member(member_id_min_value, member_flags_min_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_min_value, common_min_value_ec))};
            if (!common_min_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure min_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_min_value = "min_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_min_value;
            ann_custom_Calculator_representation_limits_Out.reset();
            CompleteMemberDetail detail_min_value = TypeObjectUtils::build_complete_member_detail(name_min_value, member_ann_builtin_min_value, ann_custom_Calculator_representation_limits_Out);
            CompleteStructMember member_min_value = TypeObjectUtils::build_complete_struct_member(common_min_value, detail_min_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_representation_limits_Out, member_min_value);
        }
        {
            TypeIdentifierPair type_ids_max_value;
            ReturnCode_t return_code_max_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_max_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_max_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_max_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "max_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_max_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_max_value = 0x00000001;
            bool common_max_value_ec {false};
            CommonStructMember common_max_value {TypeObjectUtils::build_common_struct_member(member_id_max_value, member_flags_max_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_max_value, common_max_value_ec))};
            if (!common_max_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure max_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_max_value = "max_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_max_value;
            ann_custom_Calculator_representation_limits_Out.reset();
            CompleteMemberDetail detail_max_value = TypeObjectUtils::build_complete_member_detail(name_max_value, member_ann_builtin_max_value, ann_custom_Calculator_representation_limits_Out);
            CompleteStructMember member_max_value = TypeObjectUtils::build_complete_struct_member(common_max_value, detail_max_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_representation_limits_Out, member_max_value);
        }
        CompleteStructType struct_type_Calculator_representation_limits_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_representation_limits_Out, header_Calculator_representation_limits_Out, member_seq_Calculator_representation_limits_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_representation_limits_Out, type_name_Calculator_representation_limits_Out.to_string(), type_ids_Calculator_representation_limits_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_representation_limits_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_representation_limits_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_representation_limits_Result)
{

    ReturnCode_t return_code_Calculator_representation_limits_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_representation_limits_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_representation_limits_Result", type_ids_Calculator_representation_limits_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_representation_limits_Result)
    {
        StructTypeFlag struct_flags_Calculator_representation_limits_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_representation_limits_Result = "calculator_example::detail::Calculator_representation_limits_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_representation_limits_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_representation_limits_Result;
        CompleteTypeDetail detail_Calculator_representation_limits_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_representation_limits_Result, ann_custom_Calculator_representation_limits_Result, type_name_Calculator_representation_limits_Result.to_string());
        CompleteStructHeader header_Calculator_representation_limits_Result;
        header_Calculator_representation_limits_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_representation_limits_Result);
        CompleteStructMemberSeq member_seq_Calculator_representation_limits_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_representation_limits_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_representation_limits_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_representation_limits_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_representation_limits_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_representation_limits_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_representation_limits_Result, member_result);
        }
        CompleteStructType struct_type_Calculator_representation_limits_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_representation_limits_Result, header_Calculator_representation_limits_Result, member_seq_Calculator_representation_limits_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_representation_limits_Result, type_name_Calculator_representation_limits_Result.to_string(), type_ids_Calculator_representation_limits_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_representation_limits_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // representation_limits
 
//{ addition
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_addition_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_addition_In)
{

    ReturnCode_t return_code_Calculator_addition_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_addition_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_addition_In", type_ids_Calculator_addition_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_addition_In)
    {
        StructTypeFlag struct_flags_Calculator_addition_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_addition_In = "calculator_example::detail::Calculator_addition_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_addition_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_addition_In;
        CompleteTypeDetail detail_Calculator_addition_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_addition_In, ann_custom_Calculator_addition_In, type_name_Calculator_addition_In.to_string());
        CompleteStructHeader header_Calculator_addition_In;
        header_Calculator_addition_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_addition_In);
        CompleteStructMemberSeq member_seq_Calculator_addition_In;
        {
            TypeIdentifierPair type_ids_value1;
            ReturnCode_t return_code_value1 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value1 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value1);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value1)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value1 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value1 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value1 = 0x00000000;
            bool common_value1_ec {false};
            CommonStructMember common_value1 {TypeObjectUtils::build_common_struct_member(member_id_value1, member_flags_value1, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value1, common_value1_ec))};
            if (!common_value1_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value1 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value1 = "value1";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value1;
            ann_custom_Calculator_addition_In.reset();
            CompleteMemberDetail detail_value1 = TypeObjectUtils::build_complete_member_detail(name_value1, member_ann_builtin_value1, ann_custom_Calculator_addition_In);
            CompleteStructMember member_value1 = TypeObjectUtils::build_complete_struct_member(common_value1, detail_value1);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_addition_In, member_value1);
        }
        {
            TypeIdentifierPair type_ids_value2;
            ReturnCode_t return_code_value2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value2)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value2 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value2 = 0x00000001;
            bool common_value2_ec {false};
            CommonStructMember common_value2 {TypeObjectUtils::build_common_struct_member(member_id_value2, member_flags_value2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value2, common_value2_ec))};
            if (!common_value2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value2 = "value2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value2;
            ann_custom_Calculator_addition_In.reset();
            CompleteMemberDetail detail_value2 = TypeObjectUtils::build_complete_member_detail(name_value2, member_ann_builtin_value2, ann_custom_Calculator_addition_In);
            CompleteStructMember member_value2 = TypeObjectUtils::build_complete_struct_member(common_value2, detail_value2);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_addition_In, member_value2);
        }
        CompleteStructType struct_type_Calculator_addition_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_addition_In, header_Calculator_addition_In, member_seq_Calculator_addition_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_addition_In, type_name_Calculator_addition_In.to_string(), type_ids_Calculator_addition_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_addition_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}

  

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_addition_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_addition_Out)
{

    ReturnCode_t return_code_Calculator_addition_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_addition_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_addition_Out", type_ids_Calculator_addition_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_addition_Out)
    {
        StructTypeFlag struct_flags_Calculator_addition_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_addition_Out = "calculator_example::detail::Calculator_addition_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_addition_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_addition_Out;
        CompleteTypeDetail detail_Calculator_addition_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_addition_Out, ann_custom_Calculator_addition_Out, type_name_Calculator_addition_Out.to_string());
        CompleteStructHeader header_Calculator_addition_Out;
        header_Calculator_addition_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_addition_Out);
        CompleteStructMemberSeq member_seq_Calculator_addition_Out;
        {
            TypeIdentifierPair type_ids_return_;
            ReturnCode_t return_code_return_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_return_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_return_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_return_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "return_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_return_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_return_ = 0x00000000;
            bool common_return__ec {false};
            CommonStructMember common_return_ {TypeObjectUtils::build_common_struct_member(member_id_return_, member_flags_return_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_return_, common_return__ec))};
            if (!common_return__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure return_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_return_ = "return_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_return_;
            ann_custom_Calculator_addition_Out.reset();
            CompleteMemberDetail detail_return_ = TypeObjectUtils::build_complete_member_detail(name_return_, member_ann_builtin_return_, ann_custom_Calculator_addition_Out);
            CompleteStructMember member_return_ = TypeObjectUtils::build_complete_struct_member(common_return_, detail_return_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_addition_Out, member_return_);
        }
        CompleteStructType struct_type_Calculator_addition_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_addition_Out, header_Calculator_addition_Out, member_seq_Calculator_addition_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_addition_Out, type_name_Calculator_addition_Out.to_string(), type_ids_Calculator_addition_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_addition_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_addition_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_addition_Result)
{

    ReturnCode_t return_code_Calculator_addition_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_addition_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_addition_Result", type_ids_Calculator_addition_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_addition_Result)
    {
        StructTypeFlag struct_flags_Calculator_addition_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_addition_Result = "calculator_example::detail::Calculator_addition_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_addition_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_addition_Result;
        CompleteTypeDetail detail_Calculator_addition_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_addition_Result, ann_custom_Calculator_addition_Result, type_name_Calculator_addition_Result.to_string());
        CompleteStructHeader header_Calculator_addition_Result;
        header_Calculator_addition_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_addition_Result);
        CompleteStructMemberSeq member_seq_Calculator_addition_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_addition_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_addition_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_addition_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_addition_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_addition_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_addition_Result, member_result);
        }
        {
            TypeIdentifierPair type_ids_calculator_example_OverflowException_ex;
            ReturnCode_t return_code_calculator_example_OverflowException_ex {eprosima::fastdds::dds::RETCODE_OK};
            return_code_calculator_example_OverflowException_ex =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::OverflowException", type_ids_calculator_example_OverflowException_ex);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_calculator_example_OverflowException_ex)
            {
                ::calculator_example::register_OverflowException_type_identifier(type_ids_calculator_example_OverflowException_ex);
            }
            StructMemberFlag member_flags_calculator_example_OverflowException_ex = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_calculator_example_OverflowException_ex = 0x0d39fcce;
            bool common_calculator_example_OverflowException_ex_ec {false};
            CommonStructMember common_calculator_example_OverflowException_ex {TypeObjectUtils::build_common_struct_member(member_id_calculator_example_OverflowException_ex, member_flags_calculator_example_OverflowException_ex, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_calculator_example_OverflowException_ex, common_calculator_example_OverflowException_ex_ec))};
            if (!common_calculator_example_OverflowException_ex_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure calculator_example_OverflowException_ex member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_calculator_example_OverflowException_ex = "calculator_example_OverflowException_ex";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_calculator_example_OverflowException_ex;
            ann_custom_Calculator_addition_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> unit_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> hash_id_calculator_example_OverflowException_ex;
            hash_id_calculator_example_OverflowException_ex = "";

            if (unit_calculator_example_OverflowException_ex.has_value() || min_calculator_example_OverflowException_ex.has_value() || max_calculator_example_OverflowException_ex.has_value() || hash_id_calculator_example_OverflowException_ex.has_value())
            {
                member_ann_builtin_calculator_example_OverflowException_ex = TypeObjectUtils::build_applied_builtin_member_annotations(unit_calculator_example_OverflowException_ex, min_calculator_example_OverflowException_ex, max_calculator_example_OverflowException_ex, hash_id_calculator_example_OverflowException_ex);
            }
            if (!tmp_ann_custom_calculator_example_OverflowException_ex.empty())
            {
                ann_custom_Calculator_addition_Result = tmp_ann_custom_calculator_example_OverflowException_ex;
            }
            CompleteMemberDetail detail_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_member_detail(name_calculator_example_OverflowException_ex, member_ann_builtin_calculator_example_OverflowException_ex, ann_custom_Calculator_addition_Result);
            CompleteStructMember member_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_struct_member(common_calculator_example_OverflowException_ex, detail_calculator_example_OverflowException_ex);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_addition_Result, member_calculator_example_OverflowException_ex);
        }
        CompleteStructType struct_type_Calculator_addition_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_addition_Result, header_Calculator_addition_Result, member_seq_Calculator_addition_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_addition_Result, type_name_Calculator_addition_Result.to_string(), type_ids_Calculator_addition_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_addition_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // addition
 
//{ subtraction
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_subtraction_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_subtraction_In)
{

    ReturnCode_t return_code_Calculator_subtraction_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_subtraction_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_subtraction_In", type_ids_Calculator_subtraction_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_subtraction_In)
    {
        StructTypeFlag struct_flags_Calculator_subtraction_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_subtraction_In = "calculator_example::detail::Calculator_subtraction_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_subtraction_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_subtraction_In;
        CompleteTypeDetail detail_Calculator_subtraction_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_subtraction_In, ann_custom_Calculator_subtraction_In, type_name_Calculator_subtraction_In.to_string());
        CompleteStructHeader header_Calculator_subtraction_In;
        header_Calculator_subtraction_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_subtraction_In);
        CompleteStructMemberSeq member_seq_Calculator_subtraction_In;
        {
            TypeIdentifierPair type_ids_value1;
            ReturnCode_t return_code_value1 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value1 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value1);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value1)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value1 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value1 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value1 = 0x00000000;
            bool common_value1_ec {false};
            CommonStructMember common_value1 {TypeObjectUtils::build_common_struct_member(member_id_value1, member_flags_value1, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value1, common_value1_ec))};
            if (!common_value1_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value1 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value1 = "value1";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value1;
            ann_custom_Calculator_subtraction_In.reset();
            CompleteMemberDetail detail_value1 = TypeObjectUtils::build_complete_member_detail(name_value1, member_ann_builtin_value1, ann_custom_Calculator_subtraction_In);
            CompleteStructMember member_value1 = TypeObjectUtils::build_complete_struct_member(common_value1, detail_value1);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_subtraction_In, member_value1);
        }
        {
            TypeIdentifierPair type_ids_value2;
            ReturnCode_t return_code_value2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value2)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value2 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value2 = 0x00000001;
            bool common_value2_ec {false};
            CommonStructMember common_value2 {TypeObjectUtils::build_common_struct_member(member_id_value2, member_flags_value2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value2, common_value2_ec))};
            if (!common_value2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value2 = "value2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value2;
            ann_custom_Calculator_subtraction_In.reset();
            CompleteMemberDetail detail_value2 = TypeObjectUtils::build_complete_member_detail(name_value2, member_ann_builtin_value2, ann_custom_Calculator_subtraction_In);
            CompleteStructMember member_value2 = TypeObjectUtils::build_complete_struct_member(common_value2, detail_value2);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_subtraction_In, member_value2);
        }
        CompleteStructType struct_type_Calculator_subtraction_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_subtraction_In, header_Calculator_subtraction_In, member_seq_Calculator_subtraction_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_subtraction_In, type_name_Calculator_subtraction_In.to_string(), type_ids_Calculator_subtraction_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_subtraction_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}

  

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_subtraction_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_subtraction_Out)
{

    ReturnCode_t return_code_Calculator_subtraction_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_subtraction_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_subtraction_Out", type_ids_Calculator_subtraction_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_subtraction_Out)
    {
        StructTypeFlag struct_flags_Calculator_subtraction_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_subtraction_Out = "calculator_example::detail::Calculator_subtraction_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_subtraction_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_subtraction_Out;
        CompleteTypeDetail detail_Calculator_subtraction_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_subtraction_Out, ann_custom_Calculator_subtraction_Out, type_name_Calculator_subtraction_Out.to_string());
        CompleteStructHeader header_Calculator_subtraction_Out;
        header_Calculator_subtraction_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_subtraction_Out);
        CompleteStructMemberSeq member_seq_Calculator_subtraction_Out;
        {
            TypeIdentifierPair type_ids_return_;
            ReturnCode_t return_code_return_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_return_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_return_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_return_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "return_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_return_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_return_ = 0x00000000;
            bool common_return__ec {false};
            CommonStructMember common_return_ {TypeObjectUtils::build_common_struct_member(member_id_return_, member_flags_return_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_return_, common_return__ec))};
            if (!common_return__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure return_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_return_ = "return_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_return_;
            ann_custom_Calculator_subtraction_Out.reset();
            CompleteMemberDetail detail_return_ = TypeObjectUtils::build_complete_member_detail(name_return_, member_ann_builtin_return_, ann_custom_Calculator_subtraction_Out);
            CompleteStructMember member_return_ = TypeObjectUtils::build_complete_struct_member(common_return_, detail_return_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_subtraction_Out, member_return_);
        }
        CompleteStructType struct_type_Calculator_subtraction_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_subtraction_Out, header_Calculator_subtraction_Out, member_seq_Calculator_subtraction_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_subtraction_Out, type_name_Calculator_subtraction_Out.to_string(), type_ids_Calculator_subtraction_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_subtraction_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_subtraction_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_subtraction_Result)
{

    ReturnCode_t return_code_Calculator_subtraction_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_subtraction_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_subtraction_Result", type_ids_Calculator_subtraction_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_subtraction_Result)
    {
        StructTypeFlag struct_flags_Calculator_subtraction_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_subtraction_Result = "calculator_example::detail::Calculator_subtraction_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_subtraction_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_subtraction_Result;
        CompleteTypeDetail detail_Calculator_subtraction_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_subtraction_Result, ann_custom_Calculator_subtraction_Result, type_name_Calculator_subtraction_Result.to_string());
        CompleteStructHeader header_Calculator_subtraction_Result;
        header_Calculator_subtraction_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_subtraction_Result);
        CompleteStructMemberSeq member_seq_Calculator_subtraction_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_subtraction_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_subtraction_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_subtraction_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_subtraction_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_subtraction_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_subtraction_Result, member_result);
        }
        {
            TypeIdentifierPair type_ids_calculator_example_OverflowException_ex;
            ReturnCode_t return_code_calculator_example_OverflowException_ex {eprosima::fastdds::dds::RETCODE_OK};
            return_code_calculator_example_OverflowException_ex =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::OverflowException", type_ids_calculator_example_OverflowException_ex);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_calculator_example_OverflowException_ex)
            {
                ::calculator_example::register_OverflowException_type_identifier(type_ids_calculator_example_OverflowException_ex);
            }
            StructMemberFlag member_flags_calculator_example_OverflowException_ex = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_calculator_example_OverflowException_ex = 0x0d39fcce;
            bool common_calculator_example_OverflowException_ex_ec {false};
            CommonStructMember common_calculator_example_OverflowException_ex {TypeObjectUtils::build_common_struct_member(member_id_calculator_example_OverflowException_ex, member_flags_calculator_example_OverflowException_ex, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_calculator_example_OverflowException_ex, common_calculator_example_OverflowException_ex_ec))};
            if (!common_calculator_example_OverflowException_ex_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure calculator_example_OverflowException_ex member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_calculator_example_OverflowException_ex = "calculator_example_OverflowException_ex";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_calculator_example_OverflowException_ex;
            ann_custom_Calculator_subtraction_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> unit_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> hash_id_calculator_example_OverflowException_ex;
            hash_id_calculator_example_OverflowException_ex = "";

            if (unit_calculator_example_OverflowException_ex.has_value() || min_calculator_example_OverflowException_ex.has_value() || max_calculator_example_OverflowException_ex.has_value() || hash_id_calculator_example_OverflowException_ex.has_value())
            {
                member_ann_builtin_calculator_example_OverflowException_ex = TypeObjectUtils::build_applied_builtin_member_annotations(unit_calculator_example_OverflowException_ex, min_calculator_example_OverflowException_ex, max_calculator_example_OverflowException_ex, hash_id_calculator_example_OverflowException_ex);
            }
            if (!tmp_ann_custom_calculator_example_OverflowException_ex.empty())
            {
                ann_custom_Calculator_subtraction_Result = tmp_ann_custom_calculator_example_OverflowException_ex;
            }
            CompleteMemberDetail detail_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_member_detail(name_calculator_example_OverflowException_ex, member_ann_builtin_calculator_example_OverflowException_ex, ann_custom_Calculator_subtraction_Result);
            CompleteStructMember member_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_struct_member(common_calculator_example_OverflowException_ex, detail_calculator_example_OverflowException_ex);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_subtraction_Result, member_calculator_example_OverflowException_ex);
        }
        CompleteStructType struct_type_Calculator_subtraction_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_subtraction_Result, header_Calculator_subtraction_Result, member_seq_Calculator_subtraction_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_subtraction_Result, type_name_Calculator_subtraction_Result.to_string(), type_ids_Calculator_subtraction_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_subtraction_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // subtraction
 
//{ fibonacci_seq
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_fibonacci_seq_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_fibonacci_seq_In)
{

    ReturnCode_t return_code_Calculator_fibonacci_seq_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_fibonacci_seq_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_fibonacci_seq_In", type_ids_Calculator_fibonacci_seq_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_fibonacci_seq_In)
    {
        StructTypeFlag struct_flags_Calculator_fibonacci_seq_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_fibonacci_seq_In = "calculator_example::detail::Calculator_fibonacci_seq_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_fibonacci_seq_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_fibonacci_seq_In;
        CompleteTypeDetail detail_Calculator_fibonacci_seq_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_fibonacci_seq_In, ann_custom_Calculator_fibonacci_seq_In, type_name_Calculator_fibonacci_seq_In.to_string());
        CompleteStructHeader header_Calculator_fibonacci_seq_In;
        header_Calculator_fibonacci_seq_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_fibonacci_seq_In);
        CompleteStructMemberSeq member_seq_Calculator_fibonacci_seq_In;
        {
            TypeIdentifierPair type_ids_n_results;
            ReturnCode_t return_code_n_results {eprosima::fastdds::dds::RETCODE_OK};
            return_code_n_results =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_n_results);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_n_results)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "n_results Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_n_results = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_n_results = 0x00000000;
            bool common_n_results_ec {false};
            CommonStructMember common_n_results {TypeObjectUtils::build_common_struct_member(member_id_n_results, member_flags_n_results, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_n_results, common_n_results_ec))};
            if (!common_n_results_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure n_results member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_n_results = "n_results";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_n_results;
            ann_custom_Calculator_fibonacci_seq_In.reset();
            CompleteMemberDetail detail_n_results = TypeObjectUtils::build_complete_member_detail(name_n_results, member_ann_builtin_n_results, ann_custom_Calculator_fibonacci_seq_In);
            CompleteStructMember member_n_results = TypeObjectUtils::build_complete_struct_member(common_n_results, detail_n_results);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_fibonacci_seq_In, member_n_results);
        }
        CompleteStructType struct_type_Calculator_fibonacci_seq_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_fibonacci_seq_In, header_Calculator_fibonacci_seq_In, member_seq_Calculator_fibonacci_seq_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_fibonacci_seq_In, type_name_Calculator_fibonacci_seq_In.to_string(), type_ids_Calculator_fibonacci_seq_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_fibonacci_seq_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}

 

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_fibonacci_seq_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_fibonacci_seq_Out)
{

    ReturnCode_t return_code_Calculator_fibonacci_seq_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_fibonacci_seq_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_fibonacci_seq_Out", type_ids_Calculator_fibonacci_seq_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_fibonacci_seq_Out)
    {
        StructTypeFlag struct_flags_Calculator_fibonacci_seq_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_fibonacci_seq_Out = "calculator_example::detail::Calculator_fibonacci_seq_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_fibonacci_seq_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_fibonacci_seq_Out;
        CompleteTypeDetail detail_Calculator_fibonacci_seq_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_fibonacci_seq_Out, ann_custom_Calculator_fibonacci_seq_Out, type_name_Calculator_fibonacci_seq_Out.to_string());
        CompleteStructHeader header_Calculator_fibonacci_seq_Out;
        header_Calculator_fibonacci_seq_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_fibonacci_seq_Out);
        CompleteStructMemberSeq member_seq_Calculator_fibonacci_seq_Out;
        {
            TypeIdentifierPair type_ids_return_;
            ReturnCode_t return_code_return_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_return_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_return_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_return_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "return_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_return_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_return_ = 0x00000000;
            bool common_return__ec {false};
            CommonStructMember common_return_ {TypeObjectUtils::build_common_struct_member(member_id_return_, member_flags_return_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_return_, common_return__ec))};
            if (!common_return__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure return_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_return_ = "return_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_return_;
            ann_custom_Calculator_fibonacci_seq_Out.reset();
            AppliedAnnotationSeq tmp_ann_custom_return_;
            eprosima::fastcdr::optional<std::string> unit_return_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_return_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_return_;
            eprosima::fastcdr::optional<std::string> hash_id_return_;
            if (unit_return_.has_value() || min_return_.has_value() || max_return_.has_value() || hash_id_return_.has_value())
            {
                member_ann_builtin_return_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_return_, min_return_, max_return_, hash_id_return_);
            }
            if (!tmp_ann_custom_return_.empty())
            {
                ann_custom_Calculator_fibonacci_seq_Out = tmp_ann_custom_return_;
            }
            CompleteMemberDetail detail_return_ = TypeObjectUtils::build_complete_member_detail(name_return_, member_ann_builtin_return_, ann_custom_Calculator_fibonacci_seq_Out);
            CompleteStructMember member_return_ = TypeObjectUtils::build_complete_struct_member(common_return_, detail_return_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_fibonacci_seq_Out, member_return_);
        }
        {
            TypeIdentifierPair type_ids_finished_;
            ReturnCode_t return_code_finished_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_finished_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_finished_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_finished_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "finished_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_finished_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_finished_ = 0x00000001;
            bool common_finished__ec {false};
            CommonStructMember common_finished_ {TypeObjectUtils::build_common_struct_member(member_id_finished_, member_flags_finished_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_finished_, common_finished__ec))};
            if (!common_finished__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure finished_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_finished_ = "finished_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_finished_;
            ann_custom_Calculator_fibonacci_seq_Out.reset();
            AppliedAnnotationSeq tmp_ann_custom_finished_;
            eprosima::fastcdr::optional<std::string> unit_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_finished_;
            eprosima::fastcdr::optional<std::string> hash_id_finished_;
            if (unit_finished_.has_value() || min_finished_.has_value() || max_finished_.has_value() || hash_id_finished_.has_value())
            {
                member_ann_builtin_finished_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_finished_, min_finished_, max_finished_, hash_id_finished_);
            }
            if (!tmp_ann_custom_finished_.empty())
            {
                ann_custom_Calculator_fibonacci_seq_Out = tmp_ann_custom_finished_;
            }
            CompleteMemberDetail detail_finished_ = TypeObjectUtils::build_complete_member_detail(name_finished_, member_ann_builtin_finished_, ann_custom_Calculator_fibonacci_seq_Out);
            CompleteStructMember member_finished_ = TypeObjectUtils::build_complete_struct_member(common_finished_, detail_finished_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_fibonacci_seq_Out, member_finished_);
        }
        CompleteStructType struct_type_Calculator_fibonacci_seq_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_fibonacci_seq_Out, header_Calculator_fibonacci_seq_Out, member_seq_Calculator_fibonacci_seq_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_fibonacci_seq_Out, type_name_Calculator_fibonacci_seq_Out.to_string(), type_ids_Calculator_fibonacci_seq_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_fibonacci_seq_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_fibonacci_seq_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_fibonacci_seq_Result)
{

    ReturnCode_t return_code_Calculator_fibonacci_seq_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_fibonacci_seq_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_fibonacci_seq_Result", type_ids_Calculator_fibonacci_seq_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_fibonacci_seq_Result)
    {
        StructTypeFlag struct_flags_Calculator_fibonacci_seq_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_fibonacci_seq_Result = "calculator_example::detail::Calculator_fibonacci_seq_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_fibonacci_seq_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_fibonacci_seq_Result;
        CompleteTypeDetail detail_Calculator_fibonacci_seq_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_fibonacci_seq_Result, ann_custom_Calculator_fibonacci_seq_Result, type_name_Calculator_fibonacci_seq_Result.to_string());
        CompleteStructHeader header_Calculator_fibonacci_seq_Result;
        header_Calculator_fibonacci_seq_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_fibonacci_seq_Result);
        CompleteStructMemberSeq member_seq_Calculator_fibonacci_seq_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_fibonacci_seq_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_fibonacci_seq_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_fibonacci_seq_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_fibonacci_seq_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_fibonacci_seq_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_fibonacci_seq_Result, member_result);
        }
        {
            TypeIdentifierPair type_ids_calculator_example_OverflowException_ex;
            ReturnCode_t return_code_calculator_example_OverflowException_ex {eprosima::fastdds::dds::RETCODE_OK};
            return_code_calculator_example_OverflowException_ex =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::OverflowException", type_ids_calculator_example_OverflowException_ex);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_calculator_example_OverflowException_ex)
            {
                ::calculator_example::register_OverflowException_type_identifier(type_ids_calculator_example_OverflowException_ex);
            }
            StructMemberFlag member_flags_calculator_example_OverflowException_ex = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_calculator_example_OverflowException_ex = 0x0d39fcce;
            bool common_calculator_example_OverflowException_ex_ec {false};
            CommonStructMember common_calculator_example_OverflowException_ex {TypeObjectUtils::build_common_struct_member(member_id_calculator_example_OverflowException_ex, member_flags_calculator_example_OverflowException_ex, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_calculator_example_OverflowException_ex, common_calculator_example_OverflowException_ex_ec))};
            if (!common_calculator_example_OverflowException_ex_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure calculator_example_OverflowException_ex member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_calculator_example_OverflowException_ex = "calculator_example_OverflowException_ex";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_calculator_example_OverflowException_ex;
            ann_custom_Calculator_fibonacci_seq_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> unit_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> hash_id_calculator_example_OverflowException_ex;
            hash_id_calculator_example_OverflowException_ex = "";

            if (unit_calculator_example_OverflowException_ex.has_value() || min_calculator_example_OverflowException_ex.has_value() || max_calculator_example_OverflowException_ex.has_value() || hash_id_calculator_example_OverflowException_ex.has_value())
            {
                member_ann_builtin_calculator_example_OverflowException_ex = TypeObjectUtils::build_applied_builtin_member_annotations(unit_calculator_example_OverflowException_ex, min_calculator_example_OverflowException_ex, max_calculator_example_OverflowException_ex, hash_id_calculator_example_OverflowException_ex);
            }
            if (!tmp_ann_custom_calculator_example_OverflowException_ex.empty())
            {
                ann_custom_Calculator_fibonacci_seq_Result = tmp_ann_custom_calculator_example_OverflowException_ex;
            }
            CompleteMemberDetail detail_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_member_detail(name_calculator_example_OverflowException_ex, member_ann_builtin_calculator_example_OverflowException_ex, ann_custom_Calculator_fibonacci_seq_Result);
            CompleteStructMember member_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_struct_member(common_calculator_example_OverflowException_ex, detail_calculator_example_OverflowException_ex);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_fibonacci_seq_Result, member_calculator_example_OverflowException_ex);
        }
        CompleteStructType struct_type_Calculator_fibonacci_seq_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_fibonacci_seq_Result, header_Calculator_fibonacci_seq_Result, member_seq_Calculator_fibonacci_seq_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_fibonacci_seq_Result, type_name_Calculator_fibonacci_seq_Result.to_string(), type_ids_Calculator_fibonacci_seq_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_fibonacci_seq_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // fibonacci_seq
 
//{ sum_all
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_sum_all_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_sum_all_In)
{

    ReturnCode_t return_code_Calculator_sum_all_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_sum_all_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_sum_all_In", type_ids_Calculator_sum_all_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_sum_all_In)
    {
        StructTypeFlag struct_flags_Calculator_sum_all_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_sum_all_In = "calculator_example::detail::Calculator_sum_all_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_sum_all_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_sum_all_In;
        CompleteTypeDetail detail_Calculator_sum_all_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_sum_all_In, ann_custom_Calculator_sum_all_In, type_name_Calculator_sum_all_In.to_string());
        CompleteStructHeader header_Calculator_sum_all_In;
        header_Calculator_sum_all_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_sum_all_In);
        CompleteStructMemberSeq member_seq_Calculator_sum_all_In;
        CompleteStructType struct_type_Calculator_sum_all_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_sum_all_In, header_Calculator_sum_all_In, member_seq_Calculator_sum_all_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_sum_all_In, type_name_Calculator_sum_all_In.to_string(), type_ids_Calculator_sum_all_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_sum_all_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_sum_all_value_Feed_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_sum_all_value_Feed)
{

    ReturnCode_t return_code_Calculator_sum_all_value_Feed {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_sum_all_value_Feed =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_sum_all_value_Feed", type_ids_Calculator_sum_all_value_Feed);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_sum_all_value_Feed)
    {
        StructTypeFlag struct_flags_Calculator_sum_all_value_Feed = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_sum_all_value_Feed = "calculator_example::detail::Calculator_sum_all_value_Feed";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_sum_all_value_Feed;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_sum_all_value_Feed;
        CompleteTypeDetail detail_Calculator_sum_all_value_Feed = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_sum_all_value_Feed, ann_custom_Calculator_sum_all_value_Feed, type_name_Calculator_sum_all_value_Feed.to_string());
        CompleteStructHeader header_Calculator_sum_all_value_Feed;
        header_Calculator_sum_all_value_Feed = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_sum_all_value_Feed);
        CompleteStructMemberSeq member_seq_Calculator_sum_all_value_Feed;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_Calculator_sum_all_value_Feed.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_Calculator_sum_all_value_Feed = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_Calculator_sum_all_value_Feed);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_sum_all_value_Feed, member_value);
        }
        {
            TypeIdentifierPair type_ids_finished_;
            ReturnCode_t return_code_finished_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_finished_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_finished_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_finished_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "finished_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_finished_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_finished_ = 0x00000001;
            bool common_finished__ec {false};
            CommonStructMember common_finished_ {TypeObjectUtils::build_common_struct_member(member_id_finished_, member_flags_finished_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_finished_, common_finished__ec))};
            if (!common_finished__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure finished_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_finished_ = "finished_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_finished_;
            ann_custom_Calculator_sum_all_value_Feed.reset();
            AppliedAnnotationSeq tmp_ann_custom_finished_;
            eprosima::fastcdr::optional<std::string> unit_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_finished_;
            eprosima::fastcdr::optional<std::string> hash_id_finished_;
            if (unit_finished_.has_value() || min_finished_.has_value() || max_finished_.has_value() || hash_id_finished_.has_value())
            {
                member_ann_builtin_finished_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_finished_, min_finished_, max_finished_, hash_id_finished_);
            }
            if (!tmp_ann_custom_finished_.empty())
            {
                ann_custom_Calculator_sum_all_value_Feed = tmp_ann_custom_finished_;
            }
            CompleteMemberDetail detail_finished_ = TypeObjectUtils::build_complete_member_detail(name_finished_, member_ann_builtin_finished_, ann_custom_Calculator_sum_all_value_Feed);
            CompleteStructMember member_finished_ = TypeObjectUtils::build_complete_struct_member(common_finished_, detail_finished_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_sum_all_value_Feed, member_finished_);
        }
        CompleteStructType struct_type_Calculator_sum_all_value_Feed = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_sum_all_value_Feed, header_Calculator_sum_all_value_Feed, member_seq_Calculator_sum_all_value_Feed);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_sum_all_value_Feed, type_name_Calculator_sum_all_value_Feed.to_string(), type_ids_Calculator_sum_all_value_Feed))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_sum_all_value_Feed already registered in TypeObjectRegistry for a different type.");
        }
    }
} 

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_sum_all_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_sum_all_Out)
{

    ReturnCode_t return_code_Calculator_sum_all_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_sum_all_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_sum_all_Out", type_ids_Calculator_sum_all_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_sum_all_Out)
    {
        StructTypeFlag struct_flags_Calculator_sum_all_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_sum_all_Out = "calculator_example::detail::Calculator_sum_all_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_sum_all_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_sum_all_Out;
        CompleteTypeDetail detail_Calculator_sum_all_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_sum_all_Out, ann_custom_Calculator_sum_all_Out, type_name_Calculator_sum_all_Out.to_string());
        CompleteStructHeader header_Calculator_sum_all_Out;
        header_Calculator_sum_all_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_sum_all_Out);
        CompleteStructMemberSeq member_seq_Calculator_sum_all_Out;
        {
            TypeIdentifierPair type_ids_return_;
            ReturnCode_t return_code_return_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_return_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_return_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_return_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "return_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_return_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_return_ = 0x00000000;
            bool common_return__ec {false};
            CommonStructMember common_return_ {TypeObjectUtils::build_common_struct_member(member_id_return_, member_flags_return_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_return_, common_return__ec))};
            if (!common_return__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure return_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_return_ = "return_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_return_;
            ann_custom_Calculator_sum_all_Out.reset();
            CompleteMemberDetail detail_return_ = TypeObjectUtils::build_complete_member_detail(name_return_, member_ann_builtin_return_, ann_custom_Calculator_sum_all_Out);
            CompleteStructMember member_return_ = TypeObjectUtils::build_complete_struct_member(common_return_, detail_return_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_sum_all_Out, member_return_);
        }
        CompleteStructType struct_type_Calculator_sum_all_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_sum_all_Out, header_Calculator_sum_all_Out, member_seq_Calculator_sum_all_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_sum_all_Out, type_name_Calculator_sum_all_Out.to_string(), type_ids_Calculator_sum_all_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_sum_all_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_sum_all_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_sum_all_Result)
{

    ReturnCode_t return_code_Calculator_sum_all_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_sum_all_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_sum_all_Result", type_ids_Calculator_sum_all_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_sum_all_Result)
    {
        StructTypeFlag struct_flags_Calculator_sum_all_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_sum_all_Result = "calculator_example::detail::Calculator_sum_all_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_sum_all_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_sum_all_Result;
        CompleteTypeDetail detail_Calculator_sum_all_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_sum_all_Result, ann_custom_Calculator_sum_all_Result, type_name_Calculator_sum_all_Result.to_string());
        CompleteStructHeader header_Calculator_sum_all_Result;
        header_Calculator_sum_all_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_sum_all_Result);
        CompleteStructMemberSeq member_seq_Calculator_sum_all_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_sum_all_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_sum_all_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_sum_all_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_sum_all_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_sum_all_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_sum_all_Result, member_result);
        }
        {
            TypeIdentifierPair type_ids_calculator_example_OverflowException_ex;
            ReturnCode_t return_code_calculator_example_OverflowException_ex {eprosima::fastdds::dds::RETCODE_OK};
            return_code_calculator_example_OverflowException_ex =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::OverflowException", type_ids_calculator_example_OverflowException_ex);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_calculator_example_OverflowException_ex)
            {
                ::calculator_example::register_OverflowException_type_identifier(type_ids_calculator_example_OverflowException_ex);
            }
            StructMemberFlag member_flags_calculator_example_OverflowException_ex = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_calculator_example_OverflowException_ex = 0x0d39fcce;
            bool common_calculator_example_OverflowException_ex_ec {false};
            CommonStructMember common_calculator_example_OverflowException_ex {TypeObjectUtils::build_common_struct_member(member_id_calculator_example_OverflowException_ex, member_flags_calculator_example_OverflowException_ex, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_calculator_example_OverflowException_ex, common_calculator_example_OverflowException_ex_ec))};
            if (!common_calculator_example_OverflowException_ex_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure calculator_example_OverflowException_ex member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_calculator_example_OverflowException_ex = "calculator_example_OverflowException_ex";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_calculator_example_OverflowException_ex;
            ann_custom_Calculator_sum_all_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> unit_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> hash_id_calculator_example_OverflowException_ex;
            hash_id_calculator_example_OverflowException_ex = "";

            if (unit_calculator_example_OverflowException_ex.has_value() || min_calculator_example_OverflowException_ex.has_value() || max_calculator_example_OverflowException_ex.has_value() || hash_id_calculator_example_OverflowException_ex.has_value())
            {
                member_ann_builtin_calculator_example_OverflowException_ex = TypeObjectUtils::build_applied_builtin_member_annotations(unit_calculator_example_OverflowException_ex, min_calculator_example_OverflowException_ex, max_calculator_example_OverflowException_ex, hash_id_calculator_example_OverflowException_ex);
            }
            if (!tmp_ann_custom_calculator_example_OverflowException_ex.empty())
            {
                ann_custom_Calculator_sum_all_Result = tmp_ann_custom_calculator_example_OverflowException_ex;
            }
            CompleteMemberDetail detail_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_member_detail(name_calculator_example_OverflowException_ex, member_ann_builtin_calculator_example_OverflowException_ex, ann_custom_Calculator_sum_all_Result);
            CompleteStructMember member_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_struct_member(common_calculator_example_OverflowException_ex, detail_calculator_example_OverflowException_ex);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_sum_all_Result, member_calculator_example_OverflowException_ex);
        }
        CompleteStructType struct_type_Calculator_sum_all_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_sum_all_Result, header_Calculator_sum_all_Result, member_seq_Calculator_sum_all_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_sum_all_Result, type_name_Calculator_sum_all_Result.to_string(), type_ids_Calculator_sum_all_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_sum_all_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // sum_all
 
//{ accumulator
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_accumulator_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_accumulator_In)
{

    ReturnCode_t return_code_Calculator_accumulator_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_accumulator_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_accumulator_In", type_ids_Calculator_accumulator_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_accumulator_In)
    {
        StructTypeFlag struct_flags_Calculator_accumulator_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_accumulator_In = "calculator_example::detail::Calculator_accumulator_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_accumulator_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_accumulator_In;
        CompleteTypeDetail detail_Calculator_accumulator_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_accumulator_In, ann_custom_Calculator_accumulator_In, type_name_Calculator_accumulator_In.to_string());
        CompleteStructHeader header_Calculator_accumulator_In;
        header_Calculator_accumulator_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_accumulator_In);
        CompleteStructMemberSeq member_seq_Calculator_accumulator_In;
        CompleteStructType struct_type_Calculator_accumulator_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_accumulator_In, header_Calculator_accumulator_In, member_seq_Calculator_accumulator_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_accumulator_In, type_name_Calculator_accumulator_In.to_string(), type_ids_Calculator_accumulator_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_accumulator_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_accumulator_value_Feed_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_accumulator_value_Feed)
{

    ReturnCode_t return_code_Calculator_accumulator_value_Feed {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_accumulator_value_Feed =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_accumulator_value_Feed", type_ids_Calculator_accumulator_value_Feed);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_accumulator_value_Feed)
    {
        StructTypeFlag struct_flags_Calculator_accumulator_value_Feed = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_accumulator_value_Feed = "calculator_example::detail::Calculator_accumulator_value_Feed";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_accumulator_value_Feed;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_accumulator_value_Feed;
        CompleteTypeDetail detail_Calculator_accumulator_value_Feed = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_accumulator_value_Feed, ann_custom_Calculator_accumulator_value_Feed, type_name_Calculator_accumulator_value_Feed.to_string());
        CompleteStructHeader header_Calculator_accumulator_value_Feed;
        header_Calculator_accumulator_value_Feed = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_accumulator_value_Feed);
        CompleteStructMemberSeq member_seq_Calculator_accumulator_value_Feed;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_Calculator_accumulator_value_Feed.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_Calculator_accumulator_value_Feed = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_Calculator_accumulator_value_Feed);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_accumulator_value_Feed, member_value);
        }
        {
            TypeIdentifierPair type_ids_finished_;
            ReturnCode_t return_code_finished_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_finished_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_finished_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_finished_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "finished_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_finished_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_finished_ = 0x00000001;
            bool common_finished__ec {false};
            CommonStructMember common_finished_ {TypeObjectUtils::build_common_struct_member(member_id_finished_, member_flags_finished_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_finished_, common_finished__ec))};
            if (!common_finished__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure finished_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_finished_ = "finished_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_finished_;
            ann_custom_Calculator_accumulator_value_Feed.reset();
            AppliedAnnotationSeq tmp_ann_custom_finished_;
            eprosima::fastcdr::optional<std::string> unit_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_finished_;
            eprosima::fastcdr::optional<std::string> hash_id_finished_;
            if (unit_finished_.has_value() || min_finished_.has_value() || max_finished_.has_value() || hash_id_finished_.has_value())
            {
                member_ann_builtin_finished_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_finished_, min_finished_, max_finished_, hash_id_finished_);
            }
            if (!tmp_ann_custom_finished_.empty())
            {
                ann_custom_Calculator_accumulator_value_Feed = tmp_ann_custom_finished_;
            }
            CompleteMemberDetail detail_finished_ = TypeObjectUtils::build_complete_member_detail(name_finished_, member_ann_builtin_finished_, ann_custom_Calculator_accumulator_value_Feed);
            CompleteStructMember member_finished_ = TypeObjectUtils::build_complete_struct_member(common_finished_, detail_finished_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_accumulator_value_Feed, member_finished_);
        }
        CompleteStructType struct_type_Calculator_accumulator_value_Feed = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_accumulator_value_Feed, header_Calculator_accumulator_value_Feed, member_seq_Calculator_accumulator_value_Feed);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_accumulator_value_Feed, type_name_Calculator_accumulator_value_Feed.to_string(), type_ids_Calculator_accumulator_value_Feed))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_accumulator_value_Feed already registered in TypeObjectRegistry for a different type.");
        }
    }
} 

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_accumulator_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_accumulator_Out)
{

    ReturnCode_t return_code_Calculator_accumulator_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_accumulator_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_accumulator_Out", type_ids_Calculator_accumulator_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_accumulator_Out)
    {
        StructTypeFlag struct_flags_Calculator_accumulator_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_accumulator_Out = "calculator_example::detail::Calculator_accumulator_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_accumulator_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_accumulator_Out;
        CompleteTypeDetail detail_Calculator_accumulator_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_accumulator_Out, ann_custom_Calculator_accumulator_Out, type_name_Calculator_accumulator_Out.to_string());
        CompleteStructHeader header_Calculator_accumulator_Out;
        header_Calculator_accumulator_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_accumulator_Out);
        CompleteStructMemberSeq member_seq_Calculator_accumulator_Out;
        {
            TypeIdentifierPair type_ids_return_;
            ReturnCode_t return_code_return_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_return_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_return_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_return_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "return_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_return_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_return_ = 0x00000000;
            bool common_return__ec {false};
            CommonStructMember common_return_ {TypeObjectUtils::build_common_struct_member(member_id_return_, member_flags_return_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_return_, common_return__ec))};
            if (!common_return__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure return_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_return_ = "return_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_return_;
            ann_custom_Calculator_accumulator_Out.reset();
            AppliedAnnotationSeq tmp_ann_custom_return_;
            eprosima::fastcdr::optional<std::string> unit_return_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_return_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_return_;
            eprosima::fastcdr::optional<std::string> hash_id_return_;
            if (unit_return_.has_value() || min_return_.has_value() || max_return_.has_value() || hash_id_return_.has_value())
            {
                member_ann_builtin_return_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_return_, min_return_, max_return_, hash_id_return_);
            }
            if (!tmp_ann_custom_return_.empty())
            {
                ann_custom_Calculator_accumulator_Out = tmp_ann_custom_return_;
            }
            CompleteMemberDetail detail_return_ = TypeObjectUtils::build_complete_member_detail(name_return_, member_ann_builtin_return_, ann_custom_Calculator_accumulator_Out);
            CompleteStructMember member_return_ = TypeObjectUtils::build_complete_struct_member(common_return_, detail_return_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_accumulator_Out, member_return_);
        }
        {
            TypeIdentifierPair type_ids_finished_;
            ReturnCode_t return_code_finished_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_finished_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_finished_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_finished_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "finished_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_finished_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_finished_ = 0x00000001;
            bool common_finished__ec {false};
            CommonStructMember common_finished_ {TypeObjectUtils::build_common_struct_member(member_id_finished_, member_flags_finished_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_finished_, common_finished__ec))};
            if (!common_finished__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure finished_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_finished_ = "finished_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_finished_;
            ann_custom_Calculator_accumulator_Out.reset();
            AppliedAnnotationSeq tmp_ann_custom_finished_;
            eprosima::fastcdr::optional<std::string> unit_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_finished_;
            eprosima::fastcdr::optional<std::string> hash_id_finished_;
            if (unit_finished_.has_value() || min_finished_.has_value() || max_finished_.has_value() || hash_id_finished_.has_value())
            {
                member_ann_builtin_finished_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_finished_, min_finished_, max_finished_, hash_id_finished_);
            }
            if (!tmp_ann_custom_finished_.empty())
            {
                ann_custom_Calculator_accumulator_Out = tmp_ann_custom_finished_;
            }
            CompleteMemberDetail detail_finished_ = TypeObjectUtils::build_complete_member_detail(name_finished_, member_ann_builtin_finished_, ann_custom_Calculator_accumulator_Out);
            CompleteStructMember member_finished_ = TypeObjectUtils::build_complete_struct_member(common_finished_, detail_finished_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_accumulator_Out, member_finished_);
        }
        CompleteStructType struct_type_Calculator_accumulator_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_accumulator_Out, header_Calculator_accumulator_Out, member_seq_Calculator_accumulator_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_accumulator_Out, type_name_Calculator_accumulator_Out.to_string(), type_ids_Calculator_accumulator_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_accumulator_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_accumulator_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_accumulator_Result)
{

    ReturnCode_t return_code_Calculator_accumulator_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_accumulator_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_accumulator_Result", type_ids_Calculator_accumulator_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_accumulator_Result)
    {
        StructTypeFlag struct_flags_Calculator_accumulator_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_accumulator_Result = "calculator_example::detail::Calculator_accumulator_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_accumulator_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_accumulator_Result;
        CompleteTypeDetail detail_Calculator_accumulator_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_accumulator_Result, ann_custom_Calculator_accumulator_Result, type_name_Calculator_accumulator_Result.to_string());
        CompleteStructHeader header_Calculator_accumulator_Result;
        header_Calculator_accumulator_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_accumulator_Result);
        CompleteStructMemberSeq member_seq_Calculator_accumulator_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_accumulator_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_accumulator_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_accumulator_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_accumulator_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_accumulator_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_accumulator_Result, member_result);
        }
        {
            TypeIdentifierPair type_ids_calculator_example_OverflowException_ex;
            ReturnCode_t return_code_calculator_example_OverflowException_ex {eprosima::fastdds::dds::RETCODE_OK};
            return_code_calculator_example_OverflowException_ex =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::OverflowException", type_ids_calculator_example_OverflowException_ex);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_calculator_example_OverflowException_ex)
            {
                ::calculator_example::register_OverflowException_type_identifier(type_ids_calculator_example_OverflowException_ex);
            }
            StructMemberFlag member_flags_calculator_example_OverflowException_ex = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_calculator_example_OverflowException_ex = 0x0d39fcce;
            bool common_calculator_example_OverflowException_ex_ec {false};
            CommonStructMember common_calculator_example_OverflowException_ex {TypeObjectUtils::build_common_struct_member(member_id_calculator_example_OverflowException_ex, member_flags_calculator_example_OverflowException_ex, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_calculator_example_OverflowException_ex, common_calculator_example_OverflowException_ex_ec))};
            if (!common_calculator_example_OverflowException_ex_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure calculator_example_OverflowException_ex member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_calculator_example_OverflowException_ex = "calculator_example_OverflowException_ex";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_calculator_example_OverflowException_ex;
            ann_custom_Calculator_accumulator_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> unit_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_calculator_example_OverflowException_ex;
            eprosima::fastcdr::optional<std::string> hash_id_calculator_example_OverflowException_ex;
            hash_id_calculator_example_OverflowException_ex = "";

            if (unit_calculator_example_OverflowException_ex.has_value() || min_calculator_example_OverflowException_ex.has_value() || max_calculator_example_OverflowException_ex.has_value() || hash_id_calculator_example_OverflowException_ex.has_value())
            {
                member_ann_builtin_calculator_example_OverflowException_ex = TypeObjectUtils::build_applied_builtin_member_annotations(unit_calculator_example_OverflowException_ex, min_calculator_example_OverflowException_ex, max_calculator_example_OverflowException_ex, hash_id_calculator_example_OverflowException_ex);
            }
            if (!tmp_ann_custom_calculator_example_OverflowException_ex.empty())
            {
                ann_custom_Calculator_accumulator_Result = tmp_ann_custom_calculator_example_OverflowException_ex;
            }
            CompleteMemberDetail detail_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_member_detail(name_calculator_example_OverflowException_ex, member_ann_builtin_calculator_example_OverflowException_ex, ann_custom_Calculator_accumulator_Result);
            CompleteStructMember member_calculator_example_OverflowException_ex = TypeObjectUtils::build_complete_struct_member(common_calculator_example_OverflowException_ex, detail_calculator_example_OverflowException_ex);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_accumulator_Result, member_calculator_example_OverflowException_ex);
        }
        CompleteStructType struct_type_Calculator_accumulator_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_accumulator_Result, header_Calculator_accumulator_Result, member_seq_Calculator_accumulator_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_accumulator_Result, type_name_Calculator_accumulator_Result.to_string(), type_ids_Calculator_accumulator_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_accumulator_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // accumulator
 
//{ filter
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_filter_In_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_filter_In)
{

    ReturnCode_t return_code_Calculator_filter_In {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_filter_In =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_filter_In", type_ids_Calculator_filter_In);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_filter_In)
    {
        StructTypeFlag struct_flags_Calculator_filter_In = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_filter_In = "calculator_example::detail::Calculator_filter_In";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_filter_In;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_filter_In;
        CompleteTypeDetail detail_Calculator_filter_In = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_filter_In, ann_custom_Calculator_filter_In, type_name_Calculator_filter_In.to_string());
        CompleteStructHeader header_Calculator_filter_In;
        header_Calculator_filter_In = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_filter_In);
        CompleteStructMemberSeq member_seq_Calculator_filter_In;
        {
            TypeIdentifierPair type_ids_filter_kind;
            ReturnCode_t return_code_filter_kind {eprosima::fastdds::dds::RETCODE_OK};
            return_code_filter_kind =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::FilterKind", type_ids_filter_kind);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_filter_kind)
            {
                ::calculator_example::register_FilterKind_type_identifier(type_ids_filter_kind);
            }
            StructMemberFlag member_flags_filter_kind = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_filter_kind = 0x00000000;
            bool common_filter_kind_ec {false};
            CommonStructMember common_filter_kind {TypeObjectUtils::build_common_struct_member(member_id_filter_kind, member_flags_filter_kind, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_filter_kind, common_filter_kind_ec))};
            if (!common_filter_kind_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure filter_kind member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_filter_kind = "filter_kind";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_filter_kind;
            ann_custom_Calculator_filter_In.reset();
            CompleteMemberDetail detail_filter_kind = TypeObjectUtils::build_complete_member_detail(name_filter_kind, member_ann_builtin_filter_kind, ann_custom_Calculator_filter_In);
            CompleteStructMember member_filter_kind = TypeObjectUtils::build_complete_struct_member(common_filter_kind, detail_filter_kind);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_filter_In, member_filter_kind);
        }
        CompleteStructType struct_type_Calculator_filter_In = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_filter_In, header_Calculator_filter_In, member_seq_Calculator_filter_In);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_filter_In, type_name_Calculator_filter_In.to_string(), type_ids_Calculator_filter_In))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_filter_In already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_filter_value_Feed_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_filter_value_Feed)
{

    ReturnCode_t return_code_Calculator_filter_value_Feed {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_filter_value_Feed =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_filter_value_Feed", type_ids_Calculator_filter_value_Feed);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_filter_value_Feed)
    {
        StructTypeFlag struct_flags_Calculator_filter_value_Feed = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_filter_value_Feed = "calculator_example::detail::Calculator_filter_value_Feed";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_filter_value_Feed;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_filter_value_Feed;
        CompleteTypeDetail detail_Calculator_filter_value_Feed = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_filter_value_Feed, ann_custom_Calculator_filter_value_Feed, type_name_Calculator_filter_value_Feed.to_string());
        CompleteStructHeader header_Calculator_filter_value_Feed;
        header_Calculator_filter_value_Feed = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_filter_value_Feed);
        CompleteStructMemberSeq member_seq_Calculator_filter_value_Feed;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_Calculator_filter_value_Feed.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_Calculator_filter_value_Feed = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_Calculator_filter_value_Feed);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_filter_value_Feed, member_value);
        }
        {
            TypeIdentifierPair type_ids_finished_;
            ReturnCode_t return_code_finished_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_finished_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_finished_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_finished_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "finished_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_finished_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_finished_ = 0x00000001;
            bool common_finished__ec {false};
            CommonStructMember common_finished_ {TypeObjectUtils::build_common_struct_member(member_id_finished_, member_flags_finished_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_finished_, common_finished__ec))};
            if (!common_finished__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure finished_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_finished_ = "finished_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_finished_;
            ann_custom_Calculator_filter_value_Feed.reset();
            AppliedAnnotationSeq tmp_ann_custom_finished_;
            eprosima::fastcdr::optional<std::string> unit_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_finished_;
            eprosima::fastcdr::optional<std::string> hash_id_finished_;
            if (unit_finished_.has_value() || min_finished_.has_value() || max_finished_.has_value() || hash_id_finished_.has_value())
            {
                member_ann_builtin_finished_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_finished_, min_finished_, max_finished_, hash_id_finished_);
            }
            if (!tmp_ann_custom_finished_.empty())
            {
                ann_custom_Calculator_filter_value_Feed = tmp_ann_custom_finished_;
            }
            CompleteMemberDetail detail_finished_ = TypeObjectUtils::build_complete_member_detail(name_finished_, member_ann_builtin_finished_, ann_custom_Calculator_filter_value_Feed);
            CompleteStructMember member_finished_ = TypeObjectUtils::build_complete_struct_member(common_finished_, detail_finished_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_filter_value_Feed, member_finished_);
        }
        CompleteStructType struct_type_Calculator_filter_value_Feed = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_filter_value_Feed, header_Calculator_filter_value_Feed, member_seq_Calculator_filter_value_Feed);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_filter_value_Feed, type_name_Calculator_filter_value_Feed.to_string(), type_ids_Calculator_filter_value_Feed))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_filter_value_Feed already registered in TypeObjectRegistry for a different type.");
        }
    }
}  

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_filter_Out_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_filter_Out)
{

    ReturnCode_t return_code_Calculator_filter_Out {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_filter_Out =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_filter_Out", type_ids_Calculator_filter_Out);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_filter_Out)
    {
        StructTypeFlag struct_flags_Calculator_filter_Out = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_Calculator_filter_Out = "calculator_example::detail::Calculator_filter_Out";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_filter_Out;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_filter_Out;
        CompleteTypeDetail detail_Calculator_filter_Out = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_filter_Out, ann_custom_Calculator_filter_Out, type_name_Calculator_filter_Out.to_string());
        CompleteStructHeader header_Calculator_filter_Out;
        header_Calculator_filter_Out = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_filter_Out);
        CompleteStructMemberSeq member_seq_Calculator_filter_Out;
        {
            TypeIdentifierPair type_ids_return_;
            ReturnCode_t return_code_return_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_return_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_return_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_return_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "return_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_return_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_return_ = 0x00000000;
            bool common_return__ec {false};
            CommonStructMember common_return_ {TypeObjectUtils::build_common_struct_member(member_id_return_, member_flags_return_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_return_, common_return__ec))};
            if (!common_return__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure return_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_return_ = "return_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_return_;
            ann_custom_Calculator_filter_Out.reset();
            AppliedAnnotationSeq tmp_ann_custom_return_;
            eprosima::fastcdr::optional<std::string> unit_return_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_return_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_return_;
            eprosima::fastcdr::optional<std::string> hash_id_return_;
            if (unit_return_.has_value() || min_return_.has_value() || max_return_.has_value() || hash_id_return_.has_value())
            {
                member_ann_builtin_return_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_return_, min_return_, max_return_, hash_id_return_);
            }
            if (!tmp_ann_custom_return_.empty())
            {
                ann_custom_Calculator_filter_Out = tmp_ann_custom_return_;
            }
            CompleteMemberDetail detail_return_ = TypeObjectUtils::build_complete_member_detail(name_return_, member_ann_builtin_return_, ann_custom_Calculator_filter_Out);
            CompleteStructMember member_return_ = TypeObjectUtils::build_complete_struct_member(common_return_, detail_return_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_filter_Out, member_return_);
        }
        {
            TypeIdentifierPair type_ids_finished_;
            ReturnCode_t return_code_finished_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_finished_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_finished_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_finished_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "finished_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_finished_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_finished_ = 0x00000001;
            bool common_finished__ec {false};
            CommonStructMember common_finished_ {TypeObjectUtils::build_common_struct_member(member_id_finished_, member_flags_finished_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_finished_, common_finished__ec))};
            if (!common_finished__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure finished_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_finished_ = "finished_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_finished_;
            ann_custom_Calculator_filter_Out.reset();
            AppliedAnnotationSeq tmp_ann_custom_finished_;
            eprosima::fastcdr::optional<std::string> unit_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_finished_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_finished_;
            eprosima::fastcdr::optional<std::string> hash_id_finished_;
            if (unit_finished_.has_value() || min_finished_.has_value() || max_finished_.has_value() || hash_id_finished_.has_value())
            {
                member_ann_builtin_finished_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_finished_, min_finished_, max_finished_, hash_id_finished_);
            }
            if (!tmp_ann_custom_finished_.empty())
            {
                ann_custom_Calculator_filter_Out = tmp_ann_custom_finished_;
            }
            CompleteMemberDetail detail_finished_ = TypeObjectUtils::build_complete_member_detail(name_finished_, member_ann_builtin_finished_, ann_custom_Calculator_filter_Out);
            CompleteStructMember member_finished_ = TypeObjectUtils::build_complete_struct_member(common_finished_, detail_finished_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_filter_Out, member_finished_);
        }
        CompleteStructType struct_type_Calculator_filter_Out = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_filter_Out, header_Calculator_filter_Out, member_seq_Calculator_filter_Out);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_filter_Out, type_name_Calculator_filter_Out.to_string(), type_ids_Calculator_filter_Out))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_filter_Out already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_filter_Result_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_filter_Result)
{

    ReturnCode_t return_code_Calculator_filter_Result {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_filter_Result =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_filter_Result", type_ids_Calculator_filter_Result);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_filter_Result)
    {
        StructTypeFlag struct_flags_Calculator_filter_Result = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_filter_Result = "calculator_example::detail::Calculator_filter_Result";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_filter_Result;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_filter_Result;
        CompleteTypeDetail detail_Calculator_filter_Result = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_filter_Result, ann_custom_Calculator_filter_Result, type_name_Calculator_filter_Result.to_string());
        CompleteStructHeader header_Calculator_filter_Result;
        header_Calculator_filter_Result = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_filter_Result);
        CompleteStructMemberSeq member_seq_Calculator_filter_Result;
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_filter_Out", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                ::calculator_example::detail::register_Calculator_filter_Out_type_identifier(type_ids_result);
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_result = 0x0784a8b4;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_Calculator_filter_Result.reset();
            AppliedAnnotationSeq tmp_ann_custom_result;
            eprosima::fastcdr::optional<std::string> unit_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_result;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_result;
            eprosima::fastcdr::optional<std::string> hash_id_result;
            hash_id_result = "";

            if (unit_result.has_value() || min_result.has_value() || max_result.has_value() || hash_id_result.has_value())
            {
                member_ann_builtin_result = TypeObjectUtils::build_applied_builtin_member_annotations(unit_result, min_result, max_result, hash_id_result);
            }
            if (!tmp_ann_custom_result.empty())
            {
                ann_custom_Calculator_filter_Result = tmp_ann_custom_result;
            }
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_Calculator_filter_Result);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_filter_Result, member_result);
        }
        CompleteStructType struct_type_Calculator_filter_Result = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_filter_Result, header_Calculator_filter_Result, member_seq_Calculator_filter_Result);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_filter_Result, type_name_Calculator_filter_Result.to_string(), type_ids_Calculator_filter_Result))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_filter_Result already registered in TypeObjectRegistry for a different type.");
        }
    }
}

//}  // filter
 

}  // namespace detail

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_Request_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_Request)
{

    ReturnCode_t return_code_Calculator_Request {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_Request =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_Request", type_ids_Calculator_Request);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_Request)
    {
        StructTypeFlag struct_flags_Calculator_Request = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_Request = "calculator_example::detail::Calculator_Request";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_Request;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_Request;
        CompleteTypeDetail detail_Calculator_Request = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_Request, ann_custom_Calculator_Request, type_name_Calculator_Request.to_string());
        CompleteStructHeader header_Calculator_Request;
        header_Calculator_Request = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_Request);
        CompleteStructMemberSeq member_seq_Calculator_Request;
        {
            TypeIdentifierPair type_ids_representation_limits;
            ReturnCode_t return_code_representation_limits {eprosima::fastdds::dds::RETCODE_OK};
            return_code_representation_limits =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_representation_limits_In", type_ids_representation_limits);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_representation_limits)
            {
                ::calculator_example::detail::register_Calculator_representation_limits_In_type_identifier(type_ids_representation_limits);
            }
            StructMemberFlag member_flags_representation_limits = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_representation_limits = 0x0e205a8d;
            bool common_representation_limits_ec {false};
            CommonStructMember common_representation_limits {TypeObjectUtils::build_common_struct_member(member_id_representation_limits, member_flags_representation_limits, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_representation_limits, common_representation_limits_ec))};
            if (!common_representation_limits_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure representation_limits member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_representation_limits = "representation_limits";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_representation_limits;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_representation_limits;
            eprosima::fastcdr::optional<std::string> unit_representation_limits;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_representation_limits;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_representation_limits;
            eprosima::fastcdr::optional<std::string> hash_id_representation_limits;
            hash_id_representation_limits = "";

            if (unit_representation_limits.has_value() || min_representation_limits.has_value() || max_representation_limits.has_value() || hash_id_representation_limits.has_value())
            {
                member_ann_builtin_representation_limits = TypeObjectUtils::build_applied_builtin_member_annotations(unit_representation_limits, min_representation_limits, max_representation_limits, hash_id_representation_limits);
            }
            if (!tmp_ann_custom_representation_limits.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_representation_limits;
            }
            CompleteMemberDetail detail_representation_limits = TypeObjectUtils::build_complete_member_detail(name_representation_limits, member_ann_builtin_representation_limits, ann_custom_Calculator_Request);
            CompleteStructMember member_representation_limits = TypeObjectUtils::build_complete_struct_member(common_representation_limits, detail_representation_limits);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_representation_limits);
        }
        {
            TypeIdentifierPair type_ids_addition;
            ReturnCode_t return_code_addition {eprosima::fastdds::dds::RETCODE_OK};
            return_code_addition =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_addition_In", type_ids_addition);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_addition)
            {
                ::calculator_example::detail::register_Calculator_addition_In_type_identifier(type_ids_addition);
            }
            StructMemberFlag member_flags_addition = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_addition = 0x04e82a2b;
            bool common_addition_ec {false};
            CommonStructMember common_addition {TypeObjectUtils::build_common_struct_member(member_id_addition, member_flags_addition, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_addition, common_addition_ec))};
            if (!common_addition_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure addition member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_addition = "addition";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_addition;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_addition;
            eprosima::fastcdr::optional<std::string> unit_addition;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_addition;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_addition;
            eprosima::fastcdr::optional<std::string> hash_id_addition;
            hash_id_addition = "";

            if (unit_addition.has_value() || min_addition.has_value() || max_addition.has_value() || hash_id_addition.has_value())
            {
                member_ann_builtin_addition = TypeObjectUtils::build_applied_builtin_member_annotations(unit_addition, min_addition, max_addition, hash_id_addition);
            }
            if (!tmp_ann_custom_addition.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_addition;
            }
            CompleteMemberDetail detail_addition = TypeObjectUtils::build_complete_member_detail(name_addition, member_ann_builtin_addition, ann_custom_Calculator_Request);
            CompleteStructMember member_addition = TypeObjectUtils::build_complete_struct_member(common_addition, detail_addition);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_addition);
        }
        {
            TypeIdentifierPair type_ids_subtraction;
            ReturnCode_t return_code_subtraction {eprosima::fastdds::dds::RETCODE_OK};
            return_code_subtraction =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_subtraction_In", type_ids_subtraction);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_subtraction)
            {
                ::calculator_example::detail::register_Calculator_subtraction_In_type_identifier(type_ids_subtraction);
            }
            StructMemberFlag member_flags_subtraction = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_subtraction = 0x096bbc8d;
            bool common_subtraction_ec {false};
            CommonStructMember common_subtraction {TypeObjectUtils::build_common_struct_member(member_id_subtraction, member_flags_subtraction, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_subtraction, common_subtraction_ec))};
            if (!common_subtraction_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure subtraction member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_subtraction = "subtraction";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_subtraction;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_subtraction;
            eprosima::fastcdr::optional<std::string> unit_subtraction;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_subtraction;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_subtraction;
            eprosima::fastcdr::optional<std::string> hash_id_subtraction;
            hash_id_subtraction = "";

            if (unit_subtraction.has_value() || min_subtraction.has_value() || max_subtraction.has_value() || hash_id_subtraction.has_value())
            {
                member_ann_builtin_subtraction = TypeObjectUtils::build_applied_builtin_member_annotations(unit_subtraction, min_subtraction, max_subtraction, hash_id_subtraction);
            }
            if (!tmp_ann_custom_subtraction.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_subtraction;
            }
            CompleteMemberDetail detail_subtraction = TypeObjectUtils::build_complete_member_detail(name_subtraction, member_ann_builtin_subtraction, ann_custom_Calculator_Request);
            CompleteStructMember member_subtraction = TypeObjectUtils::build_complete_struct_member(common_subtraction, detail_subtraction);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_subtraction);
        }
        {
            TypeIdentifierPair type_ids_fibonacci_seq;
            ReturnCode_t return_code_fibonacci_seq {eprosima::fastdds::dds::RETCODE_OK};
            return_code_fibonacci_seq =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_fibonacci_seq_In", type_ids_fibonacci_seq);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_fibonacci_seq)
            {
                ::calculator_example::detail::register_Calculator_fibonacci_seq_In_type_identifier(type_ids_fibonacci_seq);
            }
            StructMemberFlag member_flags_fibonacci_seq = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_fibonacci_seq = 0x0bad50ff;
            bool common_fibonacci_seq_ec {false};
            CommonStructMember common_fibonacci_seq {TypeObjectUtils::build_common_struct_member(member_id_fibonacci_seq, member_flags_fibonacci_seq, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_fibonacci_seq, common_fibonacci_seq_ec))};
            if (!common_fibonacci_seq_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure fibonacci_seq member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_fibonacci_seq = "fibonacci_seq";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_fibonacci_seq;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_fibonacci_seq;
            eprosima::fastcdr::optional<std::string> unit_fibonacci_seq;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_fibonacci_seq;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_fibonacci_seq;
            eprosima::fastcdr::optional<std::string> hash_id_fibonacci_seq;
            hash_id_fibonacci_seq = "";

            if (unit_fibonacci_seq.has_value() || min_fibonacci_seq.has_value() || max_fibonacci_seq.has_value() || hash_id_fibonacci_seq.has_value())
            {
                member_ann_builtin_fibonacci_seq = TypeObjectUtils::build_applied_builtin_member_annotations(unit_fibonacci_seq, min_fibonacci_seq, max_fibonacci_seq, hash_id_fibonacci_seq);
            }
            if (!tmp_ann_custom_fibonacci_seq.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_fibonacci_seq;
            }
            CompleteMemberDetail detail_fibonacci_seq = TypeObjectUtils::build_complete_member_detail(name_fibonacci_seq, member_ann_builtin_fibonacci_seq, ann_custom_Calculator_Request);
            CompleteStructMember member_fibonacci_seq = TypeObjectUtils::build_complete_struct_member(common_fibonacci_seq, detail_fibonacci_seq);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_fibonacci_seq);
        }
        {
            TypeIdentifierPair type_ids_sum_all;
            ReturnCode_t return_code_sum_all {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sum_all =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_sum_all_In", type_ids_sum_all);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sum_all)
            {
                ::calculator_example::detail::register_Calculator_sum_all_In_type_identifier(type_ids_sum_all);
            }
            StructMemberFlag member_flags_sum_all = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_sum_all = 0x0635cd81;
            bool common_sum_all_ec {false};
            CommonStructMember common_sum_all {TypeObjectUtils::build_common_struct_member(member_id_sum_all, member_flags_sum_all, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sum_all, common_sum_all_ec))};
            if (!common_sum_all_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sum_all member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sum_all = "sum_all";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sum_all;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_sum_all;
            eprosima::fastcdr::optional<std::string> unit_sum_all;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sum_all;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sum_all;
            eprosima::fastcdr::optional<std::string> hash_id_sum_all;
            hash_id_sum_all = "";

            if (unit_sum_all.has_value() || min_sum_all.has_value() || max_sum_all.has_value() || hash_id_sum_all.has_value())
            {
                member_ann_builtin_sum_all = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sum_all, min_sum_all, max_sum_all, hash_id_sum_all);
            }
            if (!tmp_ann_custom_sum_all.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_sum_all;
            }
            CompleteMemberDetail detail_sum_all = TypeObjectUtils::build_complete_member_detail(name_sum_all, member_ann_builtin_sum_all, ann_custom_Calculator_Request);
            CompleteStructMember member_sum_all = TypeObjectUtils::build_complete_struct_member(common_sum_all, detail_sum_all);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_sum_all);
        }
        {
            TypeIdentifierPair type_ids_sum_all_value;
            ReturnCode_t return_code_sum_all_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sum_all_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_sum_all_value_Feed", type_ids_sum_all_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sum_all_value)
            {
                ::calculator_example::detail::register_Calculator_sum_all_value_Feed_type_identifier(type_ids_sum_all_value);
            }
            StructMemberFlag member_flags_sum_all_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_sum_all_value = 0x04efb71e;
            bool common_sum_all_value_ec {false};
            CommonStructMember common_sum_all_value {TypeObjectUtils::build_common_struct_member(member_id_sum_all_value, member_flags_sum_all_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sum_all_value, common_sum_all_value_ec))};
            if (!common_sum_all_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sum_all_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sum_all_value = "sum_all_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sum_all_value;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_sum_all_value;
            eprosima::fastcdr::optional<std::string> unit_sum_all_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sum_all_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sum_all_value;
            eprosima::fastcdr::optional<std::string> hash_id_sum_all_value;
            hash_id_sum_all_value = "";

            if (unit_sum_all_value.has_value() || min_sum_all_value.has_value() || max_sum_all_value.has_value() || hash_id_sum_all_value.has_value())
            {
                member_ann_builtin_sum_all_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sum_all_value, min_sum_all_value, max_sum_all_value, hash_id_sum_all_value);
            }
            if (!tmp_ann_custom_sum_all_value.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_sum_all_value;
            }
            CompleteMemberDetail detail_sum_all_value = TypeObjectUtils::build_complete_member_detail(name_sum_all_value, member_ann_builtin_sum_all_value, ann_custom_Calculator_Request);
            CompleteStructMember member_sum_all_value = TypeObjectUtils::build_complete_struct_member(common_sum_all_value, detail_sum_all_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_sum_all_value);
        }
        {
            TypeIdentifierPair type_ids_accumulator;
            ReturnCode_t return_code_accumulator {eprosima::fastdds::dds::RETCODE_OK};
            return_code_accumulator =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_accumulator_In", type_ids_accumulator);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_accumulator)
            {
                ::calculator_example::detail::register_Calculator_accumulator_In_type_identifier(type_ids_accumulator);
            }
            StructMemberFlag member_flags_accumulator = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_accumulator = 0x03d4c1bd;
            bool common_accumulator_ec {false};
            CommonStructMember common_accumulator {TypeObjectUtils::build_common_struct_member(member_id_accumulator, member_flags_accumulator, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_accumulator, common_accumulator_ec))};
            if (!common_accumulator_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure accumulator member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_accumulator = "accumulator";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_accumulator;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_accumulator;
            eprosima::fastcdr::optional<std::string> unit_accumulator;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_accumulator;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_accumulator;
            eprosima::fastcdr::optional<std::string> hash_id_accumulator;
            hash_id_accumulator = "";

            if (unit_accumulator.has_value() || min_accumulator.has_value() || max_accumulator.has_value() || hash_id_accumulator.has_value())
            {
                member_ann_builtin_accumulator = TypeObjectUtils::build_applied_builtin_member_annotations(unit_accumulator, min_accumulator, max_accumulator, hash_id_accumulator);
            }
            if (!tmp_ann_custom_accumulator.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_accumulator;
            }
            CompleteMemberDetail detail_accumulator = TypeObjectUtils::build_complete_member_detail(name_accumulator, member_ann_builtin_accumulator, ann_custom_Calculator_Request);
            CompleteStructMember member_accumulator = TypeObjectUtils::build_complete_struct_member(common_accumulator, detail_accumulator);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_accumulator);
        }
        {
            TypeIdentifierPair type_ids_accumulator_value;
            ReturnCode_t return_code_accumulator_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_accumulator_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_accumulator_value_Feed", type_ids_accumulator_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_accumulator_value)
            {
                ::calculator_example::detail::register_Calculator_accumulator_value_Feed_type_identifier(type_ids_accumulator_value);
            }
            StructMemberFlag member_flags_accumulator_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_accumulator_value = 0x0916f618;
            bool common_accumulator_value_ec {false};
            CommonStructMember common_accumulator_value {TypeObjectUtils::build_common_struct_member(member_id_accumulator_value, member_flags_accumulator_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_accumulator_value, common_accumulator_value_ec))};
            if (!common_accumulator_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure accumulator_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_accumulator_value = "accumulator_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_accumulator_value;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_accumulator_value;
            eprosima::fastcdr::optional<std::string> unit_accumulator_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_accumulator_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_accumulator_value;
            eprosima::fastcdr::optional<std::string> hash_id_accumulator_value;
            hash_id_accumulator_value = "";

            if (unit_accumulator_value.has_value() || min_accumulator_value.has_value() || max_accumulator_value.has_value() || hash_id_accumulator_value.has_value())
            {
                member_ann_builtin_accumulator_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_accumulator_value, min_accumulator_value, max_accumulator_value, hash_id_accumulator_value);
            }
            if (!tmp_ann_custom_accumulator_value.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_accumulator_value;
            }
            CompleteMemberDetail detail_accumulator_value = TypeObjectUtils::build_complete_member_detail(name_accumulator_value, member_ann_builtin_accumulator_value, ann_custom_Calculator_Request);
            CompleteStructMember member_accumulator_value = TypeObjectUtils::build_complete_struct_member(common_accumulator_value, detail_accumulator_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_accumulator_value);
        }
        {
            TypeIdentifierPair type_ids_filter;
            ReturnCode_t return_code_filter {eprosima::fastdds::dds::RETCODE_OK};
            return_code_filter =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_filter_In", type_ids_filter);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_filter)
            {
                ::calculator_example::detail::register_Calculator_filter_In_type_identifier(type_ids_filter);
            }
            StructMemberFlag member_flags_filter = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_filter = 0x047ac9b2;
            bool common_filter_ec {false};
            CommonStructMember common_filter {TypeObjectUtils::build_common_struct_member(member_id_filter, member_flags_filter, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_filter, common_filter_ec))};
            if (!common_filter_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure filter member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_filter = "filter";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_filter;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_filter;
            eprosima::fastcdr::optional<std::string> unit_filter;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_filter;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_filter;
            eprosima::fastcdr::optional<std::string> hash_id_filter;
            hash_id_filter = "";

            if (unit_filter.has_value() || min_filter.has_value() || max_filter.has_value() || hash_id_filter.has_value())
            {
                member_ann_builtin_filter = TypeObjectUtils::build_applied_builtin_member_annotations(unit_filter, min_filter, max_filter, hash_id_filter);
            }
            if (!tmp_ann_custom_filter.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_filter;
            }
            CompleteMemberDetail detail_filter = TypeObjectUtils::build_complete_member_detail(name_filter, member_ann_builtin_filter, ann_custom_Calculator_Request);
            CompleteStructMember member_filter = TypeObjectUtils::build_complete_struct_member(common_filter, detail_filter);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_filter);
        }
        {
            TypeIdentifierPair type_ids_filter_value;
            ReturnCode_t return_code_filter_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_filter_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_filter_value_Feed", type_ids_filter_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_filter_value)
            {
                ::calculator_example::detail::register_Calculator_filter_value_Feed_type_identifier(type_ids_filter_value);
            }
            StructMemberFlag member_flags_filter_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_filter_value = 0x09fd5a08;
            bool common_filter_value_ec {false};
            CommonStructMember common_filter_value {TypeObjectUtils::build_common_struct_member(member_id_filter_value, member_flags_filter_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_filter_value, common_filter_value_ec))};
            if (!common_filter_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure filter_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_filter_value = "filter_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_filter_value;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_filter_value;
            eprosima::fastcdr::optional<std::string> unit_filter_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_filter_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_filter_value;
            eprosima::fastcdr::optional<std::string> hash_id_filter_value;
            hash_id_filter_value = "";

            if (unit_filter_value.has_value() || min_filter_value.has_value() || max_filter_value.has_value() || hash_id_filter_value.has_value())
            {
                member_ann_builtin_filter_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_filter_value, min_filter_value, max_filter_value, hash_id_filter_value);
            }
            if (!tmp_ann_custom_filter_value.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_filter_value;
            }
            CompleteMemberDetail detail_filter_value = TypeObjectUtils::build_complete_member_detail(name_filter_value, member_ann_builtin_filter_value, ann_custom_Calculator_Request);
            CompleteStructMember member_filter_value = TypeObjectUtils::build_complete_struct_member(common_filter_value, detail_filter_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_filter_value);
        }
        {
            TypeIdentifierPair type_ids_feed_cancel_;
            ReturnCode_t return_code_feed_cancel_ {eprosima::fastdds::dds::RETCODE_OK};
            return_code_feed_cancel_ =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_feed_cancel_);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_feed_cancel_)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "feed_cancel_ Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_feed_cancel_ = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_feed_cancel_ = 0x0f62acde;
            bool common_feed_cancel__ec {false};
            CommonStructMember common_feed_cancel_ {TypeObjectUtils::build_common_struct_member(member_id_feed_cancel_, member_flags_feed_cancel_, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_feed_cancel_, common_feed_cancel__ec))};
            if (!common_feed_cancel__ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure feed_cancel_ member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_feed_cancel_ = "feed_cancel_";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_feed_cancel_;
            ann_custom_Calculator_Request.reset();
            AppliedAnnotationSeq tmp_ann_custom_feed_cancel_;
            eprosima::fastcdr::optional<std::string> unit_feed_cancel_;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_feed_cancel_;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_feed_cancel_;
            eprosima::fastcdr::optional<std::string> hash_id_feed_cancel_;
            hash_id_feed_cancel_ = "";

            if (unit_feed_cancel_.has_value() || min_feed_cancel_.has_value() || max_feed_cancel_.has_value() || hash_id_feed_cancel_.has_value())
            {
                member_ann_builtin_feed_cancel_ = TypeObjectUtils::build_applied_builtin_member_annotations(unit_feed_cancel_, min_feed_cancel_, max_feed_cancel_, hash_id_feed_cancel_);
            }
            if (!tmp_ann_custom_feed_cancel_.empty())
            {
                ann_custom_Calculator_Request = tmp_ann_custom_feed_cancel_;
            }
            CompleteMemberDetail detail_feed_cancel_ = TypeObjectUtils::build_complete_member_detail(name_feed_cancel_, member_ann_builtin_feed_cancel_, ann_custom_Calculator_Request);
            CompleteStructMember member_feed_cancel_ = TypeObjectUtils::build_complete_struct_member(common_feed_cancel_, detail_feed_cancel_);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Request, member_feed_cancel_);
        }
        CompleteStructType struct_type_Calculator_Request = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_Request, header_Calculator_Request, member_seq_Calculator_Request);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_Request, type_name_Calculator_Request.to_string(), type_ids_Calculator_Request))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_Request already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Calculator_Reply_type_identifier(
        TypeIdentifierPair& type_ids_Calculator_Reply)
{

    ReturnCode_t return_code_Calculator_Reply {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Calculator_Reply =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "calculator_example::detail::Calculator_Reply", type_ids_Calculator_Reply);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Calculator_Reply)
    {
        StructTypeFlag struct_flags_Calculator_Reply = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_Calculator_Reply = "calculator_example::detail::Calculator_Reply";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Calculator_Reply;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Calculator_Reply;
        CompleteTypeDetail detail_Calculator_Reply = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Calculator_Reply, ann_custom_Calculator_Reply, type_name_Calculator_Reply.to_string());
        CompleteStructHeader header_Calculator_Reply;
        header_Calculator_Reply = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Calculator_Reply);
        CompleteStructMemberSeq member_seq_Calculator_Reply;
        {
            TypeIdentifierPair type_ids_representation_limits;
            ReturnCode_t return_code_representation_limits {eprosima::fastdds::dds::RETCODE_OK};
            return_code_representation_limits =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_representation_limits_Result", type_ids_representation_limits);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_representation_limits)
            {
                ::calculator_example::detail::register_Calculator_representation_limits_Result_type_identifier(type_ids_representation_limits);
            }
            StructMemberFlag member_flags_representation_limits = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_representation_limits = 0x0e205a8d;
            bool common_representation_limits_ec {false};
            CommonStructMember common_representation_limits {TypeObjectUtils::build_common_struct_member(member_id_representation_limits, member_flags_representation_limits, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_representation_limits, common_representation_limits_ec))};
            if (!common_representation_limits_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure representation_limits member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_representation_limits = "representation_limits";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_representation_limits;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_representation_limits;
            eprosima::fastcdr::optional<std::string> unit_representation_limits;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_representation_limits;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_representation_limits;
            eprosima::fastcdr::optional<std::string> hash_id_representation_limits;
            hash_id_representation_limits = "";

            if (unit_representation_limits.has_value() || min_representation_limits.has_value() || max_representation_limits.has_value() || hash_id_representation_limits.has_value())
            {
                member_ann_builtin_representation_limits = TypeObjectUtils::build_applied_builtin_member_annotations(unit_representation_limits, min_representation_limits, max_representation_limits, hash_id_representation_limits);
            }
            if (!tmp_ann_custom_representation_limits.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_representation_limits;
            }
            CompleteMemberDetail detail_representation_limits = TypeObjectUtils::build_complete_member_detail(name_representation_limits, member_ann_builtin_representation_limits, ann_custom_Calculator_Reply);
            CompleteStructMember member_representation_limits = TypeObjectUtils::build_complete_struct_member(common_representation_limits, detail_representation_limits);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_representation_limits);
        }
        {
            TypeIdentifierPair type_ids_addition;
            ReturnCode_t return_code_addition {eprosima::fastdds::dds::RETCODE_OK};
            return_code_addition =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_addition_Result", type_ids_addition);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_addition)
            {
                ::calculator_example::detail::register_Calculator_addition_Result_type_identifier(type_ids_addition);
            }
            StructMemberFlag member_flags_addition = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_addition = 0x04e82a2b;
            bool common_addition_ec {false};
            CommonStructMember common_addition {TypeObjectUtils::build_common_struct_member(member_id_addition, member_flags_addition, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_addition, common_addition_ec))};
            if (!common_addition_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure addition member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_addition = "addition";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_addition;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_addition;
            eprosima::fastcdr::optional<std::string> unit_addition;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_addition;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_addition;
            eprosima::fastcdr::optional<std::string> hash_id_addition;
            hash_id_addition = "";

            if (unit_addition.has_value() || min_addition.has_value() || max_addition.has_value() || hash_id_addition.has_value())
            {
                member_ann_builtin_addition = TypeObjectUtils::build_applied_builtin_member_annotations(unit_addition, min_addition, max_addition, hash_id_addition);
            }
            if (!tmp_ann_custom_addition.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_addition;
            }
            CompleteMemberDetail detail_addition = TypeObjectUtils::build_complete_member_detail(name_addition, member_ann_builtin_addition, ann_custom_Calculator_Reply);
            CompleteStructMember member_addition = TypeObjectUtils::build_complete_struct_member(common_addition, detail_addition);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_addition);
        }
        {
            TypeIdentifierPair type_ids_subtraction;
            ReturnCode_t return_code_subtraction {eprosima::fastdds::dds::RETCODE_OK};
            return_code_subtraction =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_subtraction_Result", type_ids_subtraction);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_subtraction)
            {
                ::calculator_example::detail::register_Calculator_subtraction_Result_type_identifier(type_ids_subtraction);
            }
            StructMemberFlag member_flags_subtraction = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_subtraction = 0x096bbc8d;
            bool common_subtraction_ec {false};
            CommonStructMember common_subtraction {TypeObjectUtils::build_common_struct_member(member_id_subtraction, member_flags_subtraction, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_subtraction, common_subtraction_ec))};
            if (!common_subtraction_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure subtraction member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_subtraction = "subtraction";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_subtraction;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_subtraction;
            eprosima::fastcdr::optional<std::string> unit_subtraction;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_subtraction;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_subtraction;
            eprosima::fastcdr::optional<std::string> hash_id_subtraction;
            hash_id_subtraction = "";

            if (unit_subtraction.has_value() || min_subtraction.has_value() || max_subtraction.has_value() || hash_id_subtraction.has_value())
            {
                member_ann_builtin_subtraction = TypeObjectUtils::build_applied_builtin_member_annotations(unit_subtraction, min_subtraction, max_subtraction, hash_id_subtraction);
            }
            if (!tmp_ann_custom_subtraction.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_subtraction;
            }
            CompleteMemberDetail detail_subtraction = TypeObjectUtils::build_complete_member_detail(name_subtraction, member_ann_builtin_subtraction, ann_custom_Calculator_Reply);
            CompleteStructMember member_subtraction = TypeObjectUtils::build_complete_struct_member(common_subtraction, detail_subtraction);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_subtraction);
        }
        {
            TypeIdentifierPair type_ids_fibonacci_seq;
            ReturnCode_t return_code_fibonacci_seq {eprosima::fastdds::dds::RETCODE_OK};
            return_code_fibonacci_seq =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_fibonacci_seq_Result", type_ids_fibonacci_seq);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_fibonacci_seq)
            {
                ::calculator_example::detail::register_Calculator_fibonacci_seq_Result_type_identifier(type_ids_fibonacci_seq);
            }
            StructMemberFlag member_flags_fibonacci_seq = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_fibonacci_seq = 0x0bad50ff;
            bool common_fibonacci_seq_ec {false};
            CommonStructMember common_fibonacci_seq {TypeObjectUtils::build_common_struct_member(member_id_fibonacci_seq, member_flags_fibonacci_seq, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_fibonacci_seq, common_fibonacci_seq_ec))};
            if (!common_fibonacci_seq_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure fibonacci_seq member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_fibonacci_seq = "fibonacci_seq";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_fibonacci_seq;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_fibonacci_seq;
            eprosima::fastcdr::optional<std::string> unit_fibonacci_seq;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_fibonacci_seq;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_fibonacci_seq;
            eprosima::fastcdr::optional<std::string> hash_id_fibonacci_seq;
            hash_id_fibonacci_seq = "";

            if (unit_fibonacci_seq.has_value() || min_fibonacci_seq.has_value() || max_fibonacci_seq.has_value() || hash_id_fibonacci_seq.has_value())
            {
                member_ann_builtin_fibonacci_seq = TypeObjectUtils::build_applied_builtin_member_annotations(unit_fibonacci_seq, min_fibonacci_seq, max_fibonacci_seq, hash_id_fibonacci_seq);
            }
            if (!tmp_ann_custom_fibonacci_seq.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_fibonacci_seq;
            }
            CompleteMemberDetail detail_fibonacci_seq = TypeObjectUtils::build_complete_member_detail(name_fibonacci_seq, member_ann_builtin_fibonacci_seq, ann_custom_Calculator_Reply);
            CompleteStructMember member_fibonacci_seq = TypeObjectUtils::build_complete_struct_member(common_fibonacci_seq, detail_fibonacci_seq);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_fibonacci_seq);
        }
        {
            TypeIdentifierPair type_ids_sum_all;
            ReturnCode_t return_code_sum_all {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sum_all =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_sum_all_Result", type_ids_sum_all);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sum_all)
            {
                ::calculator_example::detail::register_Calculator_sum_all_Result_type_identifier(type_ids_sum_all);
            }
            StructMemberFlag member_flags_sum_all = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_sum_all = 0x0635cd81;
            bool common_sum_all_ec {false};
            CommonStructMember common_sum_all {TypeObjectUtils::build_common_struct_member(member_id_sum_all, member_flags_sum_all, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sum_all, common_sum_all_ec))};
            if (!common_sum_all_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sum_all member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sum_all = "sum_all";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sum_all;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_sum_all;
            eprosima::fastcdr::optional<std::string> unit_sum_all;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sum_all;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sum_all;
            eprosima::fastcdr::optional<std::string> hash_id_sum_all;
            hash_id_sum_all = "";

            if (unit_sum_all.has_value() || min_sum_all.has_value() || max_sum_all.has_value() || hash_id_sum_all.has_value())
            {
                member_ann_builtin_sum_all = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sum_all, min_sum_all, max_sum_all, hash_id_sum_all);
            }
            if (!tmp_ann_custom_sum_all.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_sum_all;
            }
            CompleteMemberDetail detail_sum_all = TypeObjectUtils::build_complete_member_detail(name_sum_all, member_ann_builtin_sum_all, ann_custom_Calculator_Reply);
            CompleteStructMember member_sum_all = TypeObjectUtils::build_complete_struct_member(common_sum_all, detail_sum_all);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_sum_all);
        }
        {
            TypeIdentifierPair type_ids_accumulator;
            ReturnCode_t return_code_accumulator {eprosima::fastdds::dds::RETCODE_OK};
            return_code_accumulator =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_accumulator_Result", type_ids_accumulator);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_accumulator)
            {
                ::calculator_example::detail::register_Calculator_accumulator_Result_type_identifier(type_ids_accumulator);
            }
            StructMemberFlag member_flags_accumulator = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_accumulator = 0x03d4c1bd;
            bool common_accumulator_ec {false};
            CommonStructMember common_accumulator {TypeObjectUtils::build_common_struct_member(member_id_accumulator, member_flags_accumulator, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_accumulator, common_accumulator_ec))};
            if (!common_accumulator_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure accumulator member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_accumulator = "accumulator";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_accumulator;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_accumulator;
            eprosima::fastcdr::optional<std::string> unit_accumulator;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_accumulator;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_accumulator;
            eprosima::fastcdr::optional<std::string> hash_id_accumulator;
            hash_id_accumulator = "";

            if (unit_accumulator.has_value() || min_accumulator.has_value() || max_accumulator.has_value() || hash_id_accumulator.has_value())
            {
                member_ann_builtin_accumulator = TypeObjectUtils::build_applied_builtin_member_annotations(unit_accumulator, min_accumulator, max_accumulator, hash_id_accumulator);
            }
            if (!tmp_ann_custom_accumulator.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_accumulator;
            }
            CompleteMemberDetail detail_accumulator = TypeObjectUtils::build_complete_member_detail(name_accumulator, member_ann_builtin_accumulator, ann_custom_Calculator_Reply);
            CompleteStructMember member_accumulator = TypeObjectUtils::build_complete_struct_member(common_accumulator, detail_accumulator);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_accumulator);
        }
        {
            TypeIdentifierPair type_ids_filter;
            ReturnCode_t return_code_filter {eprosima::fastdds::dds::RETCODE_OK};
            return_code_filter =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "calculator_example::detail::Calculator_filter_Result", type_ids_filter);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_filter)
            {
                ::calculator_example::detail::register_Calculator_filter_Result_type_identifier(type_ids_filter);
            }
            StructMemberFlag member_flags_filter = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_filter = 0x047ac9b2;
            bool common_filter_ec {false};
            CommonStructMember common_filter {TypeObjectUtils::build_common_struct_member(member_id_filter, member_flags_filter, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_filter, common_filter_ec))};
            if (!common_filter_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure filter member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_filter = "filter";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_filter;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_filter;
            eprosima::fastcdr::optional<std::string> unit_filter;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_filter;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_filter;
            eprosima::fastcdr::optional<std::string> hash_id_filter;
            hash_id_filter = "";

            if (unit_filter.has_value() || min_filter.has_value() || max_filter.has_value() || hash_id_filter.has_value())
            {
                member_ann_builtin_filter = TypeObjectUtils::build_applied_builtin_member_annotations(unit_filter, min_filter, max_filter, hash_id_filter);
            }
            if (!tmp_ann_custom_filter.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_filter;
            }
            CompleteMemberDetail detail_filter = TypeObjectUtils::build_complete_member_detail(name_filter, member_ann_builtin_filter, ann_custom_Calculator_Reply);
            CompleteStructMember member_filter = TypeObjectUtils::build_complete_struct_member(common_filter, detail_filter);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_filter);
        }
        {
            TypeIdentifierPair type_ids_remoteEx;
            ReturnCode_t return_code_remoteEx {eprosima::fastdds::dds::RETCODE_OK};
            return_code_remoteEx =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::dds::rpc::RemoteExceptionCode_t", type_ids_remoteEx);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_remoteEx)
            {
                ::eprosima::fastdds::dds::rpc::register_RemoteExceptionCode_t_type_identifier(type_ids_remoteEx);
            }
            StructMemberFlag member_flags_remoteEx = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_remoteEx = 0x0f8e48f0;
            bool common_remoteEx_ec {false};
            CommonStructMember common_remoteEx {TypeObjectUtils::build_common_struct_member(member_id_remoteEx, member_flags_remoteEx, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_remoteEx, common_remoteEx_ec))};
            if (!common_remoteEx_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure remoteEx member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_remoteEx = "remoteEx";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_remoteEx;
            ann_custom_Calculator_Reply.reset();
            AppliedAnnotationSeq tmp_ann_custom_remoteEx;
            eprosima::fastcdr::optional<std::string> unit_remoteEx;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_remoteEx;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_remoteEx;
            eprosima::fastcdr::optional<std::string> hash_id_remoteEx;
            hash_id_remoteEx = "";

            if (unit_remoteEx.has_value() || min_remoteEx.has_value() || max_remoteEx.has_value() || hash_id_remoteEx.has_value())
            {
                member_ann_builtin_remoteEx = TypeObjectUtils::build_applied_builtin_member_annotations(unit_remoteEx, min_remoteEx, max_remoteEx, hash_id_remoteEx);
            }
            if (!tmp_ann_custom_remoteEx.empty())
            {
                ann_custom_Calculator_Reply = tmp_ann_custom_remoteEx;
            }
            CompleteMemberDetail detail_remoteEx = TypeObjectUtils::build_complete_member_detail(name_remoteEx, member_ann_builtin_remoteEx, ann_custom_Calculator_Reply);
            CompleteStructMember member_remoteEx = TypeObjectUtils::build_complete_struct_member(common_remoteEx, detail_remoteEx);
            TypeObjectUtils::add_complete_struct_member(member_seq_Calculator_Reply, member_remoteEx);
        }
        CompleteStructType struct_type_Calculator_Reply = TypeObjectUtils::build_complete_struct_type(struct_flags_Calculator_Reply, header_Calculator_Reply, member_seq_Calculator_Reply);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Calculator_Reply, type_name_Calculator_Reply.to_string(), type_ids_Calculator_Reply))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "calculator_example::detail::Calculator_Reply already registered in TypeObjectRegistry for a different type.");
        }
    }
}

} // namespace calculator_example

