﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;

public static class Tests_len0_0
{
    const string cns = "";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len1_1
{
    const string cns = "a";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len1_2
{
    const string cns = "A";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len1_3
{
    const string cns = " ";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len2_4
{
    const string cns = "a-";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len2_5
{
    const string cns = "aa";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len3_6
{
    const string cns = "a-a";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len4_7
{
    const string cns = "aaaa";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len5_8
{
    const string cns = "aaaaa";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len14_9
{
    const string cns = "aaaaaaaaa\u0436\u0436aaa";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len15_10
{
    const string cns = "aaaaaaaqqqqqqqq";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len31_11
{
    const string cns = "aaaaaaaaaaaaaaaaaaaaaaaaaa-aaaa";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len31_12
{
    const string cns = "aaaaaaaaaaaaaa <tag>aaaaaaaaaaa";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}

public static class Tests_len34_13
{
    const string cns = "aaaaaZZZZZZZaaaaaaaaaaaaaaaaaaaaa ";
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_0(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_0(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_1(string s) => Utils.Var(cns) == s;
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_1(string s) => cns == s;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_2(string s) => string.Equals(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_2(string s) => string.Equals(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_3(string s) => string.Equals(null, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_3(string s) => string.Equals(null, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_4(string s) => string.Equals((object)s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_4(string s) => string.Equals((object)s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_5(string s) => string.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_5(string s) => string.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_6(string s) => string.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_6(string s) => string.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_7(string s) => string.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_7(string s) => string.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_8(string s) => (s as object).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_8(string s) => (s as object).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_9(string s) => s.Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_9(string s) => s.Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_10(string s) => ((string)null).Equals(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_10(string s) => ((string)null).Equals(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_11(string s) => s.Equals(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_11(string s) => s.Equals(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_12(string s) => s.Equals(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_12(string s) => s.Equals(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_13(string s) => s.Equals(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_13(string s) => s.Equals(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_14(string s) => s == Utils.Var(cns);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_14(string s) => s == cns;
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_15(string s) => s.StartsWith(Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_15(string s) => s.StartsWith(cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_16(string s) => s.StartsWith(Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_16(string s) => s.StartsWith(cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_17(string s) => s.StartsWith(Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_17(string s) => s.StartsWith(cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_18(string s) => s.StartsWith(Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_18(string s) => s.StartsWith(cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_19(string s) => s.StartsWith(Utils.Var(cns), true, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_19(string s) => s.StartsWith(cns, true, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_20(string s) => s.StartsWith(Utils.Var(cns), false, null);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_20(string s) => s.StartsWith(cns, false, null);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_21(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_21(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_22(string s) => MemoryExtensions.SequenceEqual<char>(Utils.Var(cns), s);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_22(string s) => MemoryExtensions.SequenceEqual<char>(cns, s);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_23(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_23(string s) => MemoryExtensions.Equals(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_24(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_24(string s) => MemoryExtensions.Equals(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_25(string s) => MemoryExtensions.Equals(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_25(string s) => MemoryExtensions.Equals(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_26(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.InvariantCulture);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_26(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.InvariantCulture);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_27(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.Ordinal);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_27(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.Ordinal);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_28(string s) => MemoryExtensions.StartsWith(s, Utils.Var(cns), StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_28(string s) => MemoryExtensions.StartsWith(s, cns, StringComparison.OrdinalIgnoreCase);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_29(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_30(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(1), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_31(string s) => MemoryExtensions.SequenceEqual<char>(s.AsSpan(0, 2), cns);
    [MethodImpl(Utils.NoOpt)]public static bool Test_ref_32(string s) => MemoryExtensions.SequenceEqual<char>(s, Utils.Var(cns));
    [MethodImpl(Utils.Opt)]  public static bool Test_tst_32(string s) => MemoryExtensions.SequenceEqual<char>(s, cns);
}
