// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// To regenerate run the gen script in src/coreclr/tools/Common/JitInterface/ThunkGenerator
// and follow the instructions in docs/project/updating-jitinterface.md


#include "corinfoexception.h"
#include "../../../inc/corjit.h"

struct JitInterfaceCallbacks
{
    bool (* isIntrinsic)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn);
    bool (* notifyMethodInfoUsage)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn);
    uint32_t (* getMethodAttribs)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn);
    void (* setMethodAttribs)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, CorInfoMethodRuntimeFlags attribs);
    void (* getMethodSig)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, CORINFO_SIG_INFO* sig, CORINFO_CLASS_HANDLE memberParent);
    bool (* getMethodInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, CORINFO_METHOD_INFO* info, CORINFO_CONTEXT_HANDLE context);
    bool (* haveSameMethodDefinition)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE meth1Hnd, CORINFO_METHOD_HANDLE meth2Hnd);
    CORINFO_CLASS_HANDLE (* getTypeDefinition)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE type);
    CorInfoInline (* canInline)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE callerHnd, CORINFO_METHOD_HANDLE calleeHnd);
    void (* beginInlining)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE inlinerHnd, CORINFO_METHOD_HANDLE inlineeHnd);
    void (* reportInliningDecision)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE inlinerHnd, CORINFO_METHOD_HANDLE inlineeHnd, CorInfoInline inlineResult, const char* reason);
    bool (* canTailCall)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE callerHnd, CORINFO_METHOD_HANDLE declaredCalleeHnd, CORINFO_METHOD_HANDLE exactCalleeHnd, bool fIsTailPrefix);
    void (* reportTailCallDecision)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE callerHnd, CORINFO_METHOD_HANDLE calleeHnd, bool fIsTailPrefix, CorInfoTailCall tailCallResult, const char* reason);
    void (* getEHinfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, unsigned EHnumber, CORINFO_EH_CLAUSE* clause);
    CORINFO_CLASS_HANDLE (* getMethodClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method);
    void (* getMethodVTableOffset)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method, unsigned* offsetOfIndirection, unsigned* offsetAfterIndirection, bool* isRelative);
    bool (* resolveVirtualMethod)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_DEVIRTUALIZATION_INFO* info);
    CORINFO_METHOD_HANDLE (* getUnboxedEntry)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, bool* requiresInstMethodTableArg);
    CORINFO_METHOD_HANDLE (* getInstantiatedEntry)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, CORINFO_METHOD_HANDLE* methodArg, CORINFO_CLASS_HANDLE* classArg);
    CORINFO_CLASS_HANDLE (* getDefaultComparerClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE elemType);
    CORINFO_CLASS_HANDLE (* getDefaultEqualityComparerClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE elemType);
    CORINFO_CLASS_HANDLE (* getSZArrayHelperEnumeratorClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE elemType);
    void (* expandRawHandleIntrinsic)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_METHOD_HANDLE callerHandle, CORINFO_GENERICHANDLE_RESULT* pResult);
    bool (* isIntrinsicType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE classHnd);
    CorInfoCallConvExtension (* getUnmanagedCallConv)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method, CORINFO_SIG_INFO* callSiteSig, bool* pSuppressGCTransition);
    bool (* pInvokeMarshalingRequired)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method, CORINFO_SIG_INFO* callSiteSig);
    bool (* satisfiesMethodConstraints)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE parent, CORINFO_METHOD_HANDLE method);
    void (* methodMustBeLoadedBeforeCodeIsRun)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method);
    void (* getGSCookie)(void * thisHandle, CorInfoExceptionClass** ppException, GSCookie* pCookieVal, GSCookie** ppCookieVal);
    void (* setPatchpointInfo)(void * thisHandle, CorInfoExceptionClass** ppException, PatchpointInfo* patchpointInfo);
    PatchpointInfo* (* getOSRInfo)(void * thisHandle, CorInfoExceptionClass** ppException, unsigned* ilOffset);
    void (* resolveToken)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken);
    void (* findSig)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_MODULE_HANDLE module, unsigned sigTOK, CORINFO_CONTEXT_HANDLE context, CORINFO_SIG_INFO* sig);
    void (* findCallSiteSig)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_MODULE_HANDLE module, unsigned methTOK, CORINFO_CONTEXT_HANDLE context, CORINFO_SIG_INFO* sig);
    CORINFO_CLASS_HANDLE (* getTokenTypeAsHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken);
    int (* getStringLiteral)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_MODULE_HANDLE module, unsigned metaTOK, char16_t* buffer, int bufferSize, int startIndex);
    size_t (* printObjectDescription)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_OBJECT_HANDLE handle, char* buffer, size_t bufferSize, size_t* pRequiredBufferSize);
    CorInfoType (* asCorInfoType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    const char* (* getClassNameFromMetadata)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, const char** namespaceName);
    CORINFO_CLASS_HANDLE (* getTypeInstantiationArgument)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, unsigned index);
    CORINFO_CLASS_HANDLE (* getMethodInstantiationArgument)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, unsigned index);
    size_t (* printClassName)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, char* buffer, size_t bufferSize, size_t* pRequiredBufferSize);
    bool (* isValueClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    uint32_t (* getClassAttribs)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    const char* (* getClassAssemblyName)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    void* (* LongLifetimeMalloc)(void * thisHandle, CorInfoExceptionClass** ppException, size_t sz);
    void (* LongLifetimeFree)(void * thisHandle, CorInfoExceptionClass** ppException, void* obj);
    bool (* getIsClassInitedFlagAddress)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, CORINFO_CONST_LOOKUP* addr, int* offset);
    size_t (* getClassThreadStaticDynamicInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE clr);
    size_t (* getClassStaticDynamicInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE clr);
    bool (* getStaticBaseAddress)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, bool isGc, CORINFO_CONST_LOOKUP* addr);
    unsigned (* getClassSize)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    unsigned (* getHeapClassSize)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    bool (* canAllocateOnStack)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    unsigned (* getClassAlignmentRequirement)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, bool fDoubleAlignHint);
    unsigned (* getClassGClayout)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, uint8_t* gcPtrs);
    unsigned (* getClassNumInstanceFields)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CORINFO_FIELD_HANDLE (* getFieldInClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE clsHnd, int32_t num);
    GetTypeLayoutResult (* getTypeLayout)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE typeHnd, CORINFO_TYPE_LAYOUT_NODE* treeNodes, size_t* numTreeNodes);
    bool (* checkMethodModifier)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE hMethod, const char* modifier, bool fOptional);
    CorInfoHelpFunc (* getNewHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE classHandle, bool* pHasSideEffects);
    CorInfoHelpFunc (* getNewArrHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE arrayCls);
    CorInfoHelpFunc (* getCastingHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, bool fThrowing);
    CorInfoHelpFunc (* getSharedCCtorHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE clsHnd);
    CORINFO_CLASS_HANDLE (* getTypeForBox)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CorInfoHelpFunc (* getBoxHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CorInfoHelpFunc (* getUnBoxHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CORINFO_OBJECT_HANDLE (* getRuntimeTypePointer)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    bool (* isObjectImmutable)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_OBJECT_HANDLE objPtr);
    bool (* getStringChar)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_OBJECT_HANDLE strObj, int index, uint16_t* value);
    CORINFO_CLASS_HANDLE (* getObjectType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_OBJECT_HANDLE objPtr);
    bool (* getReadyToRunHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_LOOKUP_KIND* pGenericLookupKind, CorInfoHelpFunc id, CORINFO_METHOD_HANDLE callerHandle, CORINFO_CONST_LOOKUP* pLookup);
    void (* getReadyToRunDelegateCtorHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pTargetMethod, unsigned int targetConstraint, CORINFO_CLASS_HANDLE delegateType, CORINFO_METHOD_HANDLE callerHandle, CORINFO_LOOKUP* pLookup);
    CorInfoInitClassResult (* initClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, CORINFO_METHOD_HANDLE method, CORINFO_CONTEXT_HANDLE context);
    void (* classMustBeLoadedBeforeCodeIsRun)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CORINFO_CLASS_HANDLE (* getBuiltinClass)(void * thisHandle, CorInfoExceptionClass** ppException, CorInfoClassId classId);
    CorInfoType (* getTypeForPrimitiveValueClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CorInfoType (* getTypeForPrimitiveNumericClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    bool (* canCast)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE child, CORINFO_CLASS_HANDLE parent);
    TypeCompareState (* compareTypesForCast)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE fromClass, CORINFO_CLASS_HANDLE toClass);
    TypeCompareState (* compareTypesForEquality)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls1, CORINFO_CLASS_HANDLE cls2);
    bool (* isMoreSpecificType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls1, CORINFO_CLASS_HANDLE cls2);
    bool (* isExactType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    TypeCompareState (* isGenericType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    TypeCompareState (* isNullableType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    TypeCompareState (* isEnum)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls, CORINFO_CLASS_HANDLE* underlyingType);
    CORINFO_CLASS_HANDLE (* getParentType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CorInfoType (* getChildType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE clsHnd, CORINFO_CLASS_HANDLE* clsRet);
    bool (* isSDArray)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    unsigned (* getArrayRank)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE cls);
    CorInfoArrayIntrinsic (* getArrayIntrinsicID)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn);
    void* (* getArrayInitializationData)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, uint32_t size);
    CorInfoIsAccessAllowedResult (* canAccessClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_METHOD_HANDLE callerHandle, CORINFO_HELPER_DESC* pAccessHelper);
    size_t (* printFieldName)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, char* buffer, size_t bufferSize, size_t* pRequiredBufferSize);
    CORINFO_CLASS_HANDLE (* getFieldClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field);
    CorInfoType (* getFieldType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, CORINFO_CLASS_HANDLE* structType, CORINFO_CLASS_HANDLE fieldOwnerHint);
    unsigned (* getFieldOffset)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field);
    void (* getFieldInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_METHOD_HANDLE callerHandle, CORINFO_ACCESS_FLAGS flags, CORINFO_FIELD_INFO* pResult);
    uint32_t (* getThreadLocalFieldInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, bool isGCtype);
    void (* getThreadLocalStaticBlocksInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_THREAD_STATIC_BLOCKS_INFO* pInfo);
    void (* getThreadLocalStaticInfo_NativeAOT)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_THREAD_STATIC_INFO_NATIVEAOT* pInfo);
    bool (* isFieldStatic)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE fldHnd);
    int (* getArrayOrStringLength)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_OBJECT_HANDLE objHnd);
    void (* getBoundaries)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, unsigned int* cILOffsets, uint32_t** pILOffsets, ICorDebugInfo::BoundaryTypes* implicitBoundaries);
    void (* setBoundaries)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, uint32_t cMap, ICorDebugInfo::OffsetMapping* pMap);
    void (* getVars)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, uint32_t* cVars, ICorDebugInfo::ILVarInfo** vars, bool* extendOthers);
    void (* setVars)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, uint32_t cVars, ICorDebugInfo::NativeVarInfo* vars);
    void (* reportRichMappings)(void * thisHandle, CorInfoExceptionClass** ppException, ICorDebugInfo::InlineTreeNode* inlineTreeNodes, uint32_t numInlineTreeNodes, ICorDebugInfo::RichOffsetMapping* mappings, uint32_t numMappings);
    void (* reportMetadata)(void * thisHandle, CorInfoExceptionClass** ppException, const char* key, const void* value, size_t length);
    void* (* allocateArray)(void * thisHandle, CorInfoExceptionClass** ppException, size_t cBytes);
    void (* freeArray)(void * thisHandle, CorInfoExceptionClass** ppException, void* array);
    CORINFO_ARG_LIST_HANDLE (* getArgNext)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_ARG_LIST_HANDLE args);
    CorInfoTypeWithMod (* getArgType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_SIG_INFO* sig, CORINFO_ARG_LIST_HANDLE args, CORINFO_CLASS_HANDLE* vcTypeRet);
    int (* getExactClasses)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE baseType, int maxExactClasses, CORINFO_CLASS_HANDLE* exactClsRet);
    CORINFO_CLASS_HANDLE (* getArgClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_SIG_INFO* sig, CORINFO_ARG_LIST_HANDLE args);
    CorInfoHFAElemType (* getHFAType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE hClass);
    bool (* runWithErrorTrap)(void * thisHandle, CorInfoExceptionClass** ppException, ICorJitInfo::errorTrapFunction function, void* parameter);
    bool (* runWithSPMIErrorTrap)(void * thisHandle, CorInfoExceptionClass** ppException, ICorJitInfo::errorTrapFunction function, void* parameter);
    void (* getEEInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_EE_INFO* pEEInfoOut);
    void (* getAsyncInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_ASYNC_INFO* pAsyncInfoOut);
    mdMethodDef (* getMethodDefFromMethod)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE hMethod);
    size_t (* printMethodName)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, char* buffer, size_t bufferSize, size_t* pRequiredBufferSize);
    const char* (* getMethodNameFromMetadata)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, const char** className, const char** namespaceName, const char** enclosingClassNames, size_t maxEnclosingClassNames);
    unsigned (* getMethodHash)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn);
    bool (* getSystemVAmd64PassStructInRegisterDescriptor)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE structHnd, SYSTEMV_AMD64_CORINFO_STRUCT_REG_PASSING_DESCRIPTOR* structPassInRegDescPtr);
    void (* getSwiftLowering)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE structHnd, CORINFO_SWIFT_LOWERING* pLowering);
    void (* getFpStructLowering)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE structHnd, CORINFO_FPSTRUCT_LOWERING* pLowering);
    uint32_t (* getThreadTLSIndex)(void * thisHandle, CorInfoExceptionClass** ppException, void** ppIndirection);
    int32_t* (* getAddrOfCaptureThreadGlobal)(void * thisHandle, CorInfoExceptionClass** ppException, void** ppIndirection);
    void (* getHelperFtn)(void * thisHandle, CorInfoExceptionClass** ppException, CorInfoHelpFunc ftnNum, CORINFO_CONST_LOOKUP* pNativeEntrypoint, CORINFO_METHOD_HANDLE* pMethod);
    void (* getFunctionEntryPoint)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, CORINFO_CONST_LOOKUP* pResult, CORINFO_ACCESS_FLAGS accessFlags);
    void (* getFunctionFixedEntryPoint)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftn, bool isUnsafeFunctionPointer, CORINFO_CONST_LOOKUP* pResult);
    CorInfoHelpFunc (* getLazyStringLiteralHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_MODULE_HANDLE handle);
    CORINFO_MODULE_HANDLE (* embedModuleHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_MODULE_HANDLE handle, void** ppIndirection);
    CORINFO_CLASS_HANDLE (* embedClassHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE handle, void** ppIndirection);
    CORINFO_METHOD_HANDLE (* embedMethodHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE handle, void** ppIndirection);
    CORINFO_FIELD_HANDLE (* embedFieldHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE handle, void** ppIndirection);
    void (* embedGenericHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, bool fEmbedParent, CORINFO_METHOD_HANDLE callerHandle, CORINFO_GENERICHANDLE_RESULT* pResult);
    void (* getLocationOfThisType)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE context, CORINFO_LOOKUP_KIND* pLookupKind);
    void (* getAddressOfPInvokeTarget)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method, CORINFO_CONST_LOOKUP* pLookup);
    void* (* GetCookieForPInvokeCalliSig)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_SIG_INFO* szMetaSig, void** ppIndirection);
    void* (* GetCookieForInterpreterCalliSig)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_SIG_INFO* szMetaSig);
    CORINFO_JUST_MY_CODE_HANDLE (* getJustMyCodeHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE method, CORINFO_JUST_MY_CODE_HANDLE** ppIndirection);
    void (* GetProfilingHandle)(void * thisHandle, CorInfoExceptionClass** ppException, bool* pbHookFunction, void** pProfilerHandle, bool* pbIndirectedHandles);
    void (* getCallInfo)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_RESOLVED_TOKEN* pConstrainedResolvedToken, CORINFO_METHOD_HANDLE callerHandle, CORINFO_CALLINFO_FLAGS flags, CORINFO_CALL_INFO* pResult);
    bool (* getStaticFieldContent)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, uint8_t* buffer, int bufferSize, int valueOffset, bool ignoreMovableObjects);
    bool (* getObjectContent)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_OBJECT_HANDLE obj, uint8_t* buffer, int bufferSize, int valueOffset);
    CORINFO_CLASS_HANDLE (* getStaticFieldCurrentClass)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, bool* pIsSpeculative);
    CORINFO_VARARGS_HANDLE (* getVarArgsHandle)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_SIG_INFO* pSig, CORINFO_METHOD_HANDLE methHnd, void** ppIndirection);
    InfoAccessType (* constructStringLiteral)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_MODULE_HANDLE module, unsigned int metaTok, void** ppValue);
    InfoAccessType (* emptyStringLiteral)(void * thisHandle, CorInfoExceptionClass** ppException, void** ppValue);
    uint32_t (* getFieldThreadLocalStoreID)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_FIELD_HANDLE field, void** ppIndirection);
    CORINFO_METHOD_HANDLE (* GetDelegateCtor)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE methHnd, CORINFO_CLASS_HANDLE clsHnd, CORINFO_METHOD_HANDLE targetMethodHnd, DelegateCtorArgs* pCtorData);
    void (* MethodCompileComplete)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE methHnd);
    bool (* getTailCallHelpers)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* callToken, CORINFO_SIG_INFO* sig, CORINFO_GET_TAILCALL_HELPERS_FLAGS flags, CORINFO_TAILCALL_HELPERS* pResult);
    CORINFO_METHOD_HANDLE (* getAsyncResumptionStub)(void * thisHandle, CorInfoExceptionClass** ppException);
    bool (* convertPInvokeCalliToCall)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, bool mustConvert);
    bool (* notifyInstructionSetUsage)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_InstructionSet instructionSet, bool supportEnabled);
    void (* updateEntryPointForTailCall)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CONST_LOOKUP* entryPoint);
    void (* allocMem)(void * thisHandle, CorInfoExceptionClass** ppException, AllocMemArgs* pArgs);
    void (* reserveUnwindInfo)(void * thisHandle, CorInfoExceptionClass** ppException, bool isFunclet, bool isColdCode, uint32_t unwindSize);
    void (* allocUnwindInfo)(void * thisHandle, CorInfoExceptionClass** ppException, uint8_t* pHotCode, uint8_t* pColdCode, uint32_t startOffset, uint32_t endOffset, uint32_t unwindSize, uint8_t* pUnwindBlock, CorJitFuncKind funcKind);
    void* (* allocGCInfo)(void * thisHandle, CorInfoExceptionClass** ppException, size_t size);
    void (* setEHcount)(void * thisHandle, CorInfoExceptionClass** ppException, unsigned cEH);
    void (* setEHinfo)(void * thisHandle, CorInfoExceptionClass** ppException, unsigned EHnumber, const CORINFO_EH_CLAUSE* clause);
    bool (* logMsg)(void * thisHandle, CorInfoExceptionClass** ppException, unsigned level, const char* fmt, va_list args);
    int (* doAssert)(void * thisHandle, CorInfoExceptionClass** ppException, const char* szFile, int iLine, const char* szExpr);
    void (* reportFatalError)(void * thisHandle, CorInfoExceptionClass** ppException, CorJitResult result);
    JITINTERFACE_HRESULT (* getPgoInstrumentationResults)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftnHnd, ICorJitInfo::PgoInstrumentationSchema** pSchema, uint32_t* pCountSchemaItems, uint8_t** pInstrumentationData, ICorJitInfo::PgoSource* pPgoSource, bool* pDynamicPgo);
    JITINTERFACE_HRESULT (* allocPgoInstrumentationBySchema)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_METHOD_HANDLE ftnHnd, ICorJitInfo::PgoInstrumentationSchema* pSchema, uint32_t countSchemaItems, uint8_t** pInstrumentationData);
    void (* recordCallSite)(void * thisHandle, CorInfoExceptionClass** ppException, uint32_t instrOffset, CORINFO_SIG_INFO* callSig, CORINFO_METHOD_HANDLE methodHandle);
    void (* recordRelocation)(void * thisHandle, CorInfoExceptionClass** ppException, void* location, void* locationRW, void* target, uint16_t fRelocType, int32_t addlDelta);
    uint16_t (* getRelocTypeHint)(void * thisHandle, CorInfoExceptionClass** ppException, void* target);
    uint32_t (* getExpectedTargetArchitecture)(void * thisHandle, CorInfoExceptionClass** ppException);
    uint32_t (* getJitFlags)(void * thisHandle, CorInfoExceptionClass** ppException, CORJIT_FLAGS* flags, uint32_t sizeInBytes);
    CORINFO_METHOD_HANDLE (* getSpecialCopyHelper)(void * thisHandle, CorInfoExceptionClass** ppException, CORINFO_CLASS_HANDLE type);

};

class JitInterfaceWrapper : public ICorJitInfo
{
    void * _thisHandle;
    JitInterfaceCallbacks * _callbacks;

public:
    JitInterfaceWrapper(void * thisHandle, void ** callbacks)
        : _thisHandle(thisHandle), _callbacks((JitInterfaceCallbacks *)callbacks)
    {
    }


    virtual bool isIntrinsic(
          CORINFO_METHOD_HANDLE ftn)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isIntrinsic(_thisHandle, &pException, ftn);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool notifyMethodInfoUsage(
          CORINFO_METHOD_HANDLE ftn)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->notifyMethodInfoUsage(_thisHandle, &pException, ftn);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual uint32_t getMethodAttribs(
          CORINFO_METHOD_HANDLE ftn)
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getMethodAttribs(_thisHandle, &pException, ftn);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void setMethodAttribs(
          CORINFO_METHOD_HANDLE ftn,
          CorInfoMethodRuntimeFlags attribs)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->setMethodAttribs(_thisHandle, &pException, ftn, attribs);
    if (pException != nullptr) throw pException;
}

    virtual void getMethodSig(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_SIG_INFO* sig,
          CORINFO_CLASS_HANDLE memberParent)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getMethodSig(_thisHandle, &pException, ftn, sig, memberParent);
    if (pException != nullptr) throw pException;
}

    virtual bool getMethodInfo(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_METHOD_INFO* info,
          CORINFO_CONTEXT_HANDLE context)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getMethodInfo(_thisHandle, &pException, ftn, info, context);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool haveSameMethodDefinition(
          CORINFO_METHOD_HANDLE meth1Hnd,
          CORINFO_METHOD_HANDLE meth2Hnd)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->haveSameMethodDefinition(_thisHandle, &pException, meth1Hnd, meth2Hnd);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getTypeDefinition(
          CORINFO_CLASS_HANDLE type)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getTypeDefinition(_thisHandle, &pException, type);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoInline canInline(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE calleeHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoInline temp = _callbacks->canInline(_thisHandle, &pException, callerHnd, calleeHnd);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void beginInlining(
          CORINFO_METHOD_HANDLE inlinerHnd,
          CORINFO_METHOD_HANDLE inlineeHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->beginInlining(_thisHandle, &pException, inlinerHnd, inlineeHnd);
    if (pException != nullptr) throw pException;
}

    virtual void reportInliningDecision(
          CORINFO_METHOD_HANDLE inlinerHnd,
          CORINFO_METHOD_HANDLE inlineeHnd,
          CorInfoInline inlineResult,
          const char* reason)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->reportInliningDecision(_thisHandle, &pException, inlinerHnd, inlineeHnd, inlineResult, reason);
    if (pException != nullptr) throw pException;
}

    virtual bool canTailCall(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE declaredCalleeHnd,
          CORINFO_METHOD_HANDLE exactCalleeHnd,
          bool fIsTailPrefix)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->canTailCall(_thisHandle, &pException, callerHnd, declaredCalleeHnd, exactCalleeHnd, fIsTailPrefix);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void reportTailCallDecision(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE calleeHnd,
          bool fIsTailPrefix,
          CorInfoTailCall tailCallResult,
          const char* reason)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->reportTailCallDecision(_thisHandle, &pException, callerHnd, calleeHnd, fIsTailPrefix, tailCallResult, reason);
    if (pException != nullptr) throw pException;
}

    virtual void getEHinfo(
          CORINFO_METHOD_HANDLE ftn,
          unsigned EHnumber,
          CORINFO_EH_CLAUSE* clause)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getEHinfo(_thisHandle, &pException, ftn, EHnumber, clause);
    if (pException != nullptr) throw pException;
}

    virtual CORINFO_CLASS_HANDLE getMethodClass(
          CORINFO_METHOD_HANDLE method)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getMethodClass(_thisHandle, &pException, method);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getMethodVTableOffset(
          CORINFO_METHOD_HANDLE method,
          unsigned* offsetOfIndirection,
          unsigned* offsetAfterIndirection,
          bool* isRelative)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getMethodVTableOffset(_thisHandle, &pException, method, offsetOfIndirection, offsetAfterIndirection, isRelative);
    if (pException != nullptr) throw pException;
}

    virtual bool resolveVirtualMethod(
          CORINFO_DEVIRTUALIZATION_INFO* info)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->resolveVirtualMethod(_thisHandle, &pException, info);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_METHOD_HANDLE getUnboxedEntry(
          CORINFO_METHOD_HANDLE ftn,
          bool* requiresInstMethodTableArg)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_METHOD_HANDLE temp = _callbacks->getUnboxedEntry(_thisHandle, &pException, ftn, requiresInstMethodTableArg);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_METHOD_HANDLE getInstantiatedEntry(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_METHOD_HANDLE* methodArg,
          CORINFO_CLASS_HANDLE* classArg)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_METHOD_HANDLE temp = _callbacks->getInstantiatedEntry(_thisHandle, &pException, ftn, methodArg, classArg);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getDefaultComparerClass(
          CORINFO_CLASS_HANDLE elemType)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getDefaultComparerClass(_thisHandle, &pException, elemType);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getDefaultEqualityComparerClass(
          CORINFO_CLASS_HANDLE elemType)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getDefaultEqualityComparerClass(_thisHandle, &pException, elemType);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getSZArrayHelperEnumeratorClass(
          CORINFO_CLASS_HANDLE elemType)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getSZArrayHelperEnumeratorClass(_thisHandle, &pException, elemType);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void expandRawHandleIntrinsic(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_GENERICHANDLE_RESULT* pResult)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->expandRawHandleIntrinsic(_thisHandle, &pException, pResolvedToken, callerHandle, pResult);
    if (pException != nullptr) throw pException;
}

    virtual bool isIntrinsicType(
          CORINFO_CLASS_HANDLE classHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isIntrinsicType(_thisHandle, &pException, classHnd);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoCallConvExtension getUnmanagedCallConv(
          CORINFO_METHOD_HANDLE method,
          CORINFO_SIG_INFO* callSiteSig,
          bool* pSuppressGCTransition)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoCallConvExtension temp = _callbacks->getUnmanagedCallConv(_thisHandle, &pException, method, callSiteSig, pSuppressGCTransition);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool pInvokeMarshalingRequired(
          CORINFO_METHOD_HANDLE method,
          CORINFO_SIG_INFO* callSiteSig)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->pInvokeMarshalingRequired(_thisHandle, &pException, method, callSiteSig);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool satisfiesMethodConstraints(
          CORINFO_CLASS_HANDLE parent,
          CORINFO_METHOD_HANDLE method)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->satisfiesMethodConstraints(_thisHandle, &pException, parent, method);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void methodMustBeLoadedBeforeCodeIsRun(
          CORINFO_METHOD_HANDLE method)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->methodMustBeLoadedBeforeCodeIsRun(_thisHandle, &pException, method);
    if (pException != nullptr) throw pException;
}

    virtual void getGSCookie(
          GSCookie* pCookieVal,
          GSCookie** ppCookieVal)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getGSCookie(_thisHandle, &pException, pCookieVal, ppCookieVal);
    if (pException != nullptr) throw pException;
}

    virtual void setPatchpointInfo(
          PatchpointInfo* patchpointInfo)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->setPatchpointInfo(_thisHandle, &pException, patchpointInfo);
    if (pException != nullptr) throw pException;
}

    virtual PatchpointInfo* getOSRInfo(
          unsigned* ilOffset)
{
    CorInfoExceptionClass* pException = nullptr;
    PatchpointInfo* temp = _callbacks->getOSRInfo(_thisHandle, &pException, ilOffset);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void resolveToken(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->resolveToken(_thisHandle, &pException, pResolvedToken);
    if (pException != nullptr) throw pException;
}

    virtual void findSig(
          CORINFO_MODULE_HANDLE module,
          unsigned sigTOK,
          CORINFO_CONTEXT_HANDLE context,
          CORINFO_SIG_INFO* sig)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->findSig(_thisHandle, &pException, module, sigTOK, context, sig);
    if (pException != nullptr) throw pException;
}

    virtual void findCallSiteSig(
          CORINFO_MODULE_HANDLE module,
          unsigned methTOK,
          CORINFO_CONTEXT_HANDLE context,
          CORINFO_SIG_INFO* sig)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->findCallSiteSig(_thisHandle, &pException, module, methTOK, context, sig);
    if (pException != nullptr) throw pException;
}

    virtual CORINFO_CLASS_HANDLE getTokenTypeAsHandle(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getTokenTypeAsHandle(_thisHandle, &pException, pResolvedToken);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual int getStringLiteral(
          CORINFO_MODULE_HANDLE module,
          unsigned metaTOK,
          char16_t* buffer,
          int bufferSize,
          int startIndex)
{
    CorInfoExceptionClass* pException = nullptr;
    int temp = _callbacks->getStringLiteral(_thisHandle, &pException, module, metaTOK, buffer, bufferSize, startIndex);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual size_t printObjectDescription(
          CORINFO_OBJECT_HANDLE handle,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    CorInfoExceptionClass* pException = nullptr;
    size_t temp = _callbacks->printObjectDescription(_thisHandle, &pException, handle, buffer, bufferSize, pRequiredBufferSize);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoType asCorInfoType(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoType temp = _callbacks->asCorInfoType(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual const char* getClassNameFromMetadata(
          CORINFO_CLASS_HANDLE cls,
          const char** namespaceName)
{
    CorInfoExceptionClass* pException = nullptr;
    const char* temp = _callbacks->getClassNameFromMetadata(_thisHandle, &pException, cls, namespaceName);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getTypeInstantiationArgument(
          CORINFO_CLASS_HANDLE cls,
          unsigned index)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getTypeInstantiationArgument(_thisHandle, &pException, cls, index);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getMethodInstantiationArgument(
          CORINFO_METHOD_HANDLE ftn,
          unsigned index)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getMethodInstantiationArgument(_thisHandle, &pException, ftn, index);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual size_t printClassName(
          CORINFO_CLASS_HANDLE cls,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    CorInfoExceptionClass* pException = nullptr;
    size_t temp = _callbacks->printClassName(_thisHandle, &pException, cls, buffer, bufferSize, pRequiredBufferSize);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool isValueClass(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isValueClass(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual uint32_t getClassAttribs(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getClassAttribs(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual const char* getClassAssemblyName(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    const char* temp = _callbacks->getClassAssemblyName(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void* LongLifetimeMalloc(
          size_t sz)
{
    CorInfoExceptionClass* pException = nullptr;
    void* temp = _callbacks->LongLifetimeMalloc(_thisHandle, &pException, sz);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void LongLifetimeFree(
          void* obj)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->LongLifetimeFree(_thisHandle, &pException, obj);
    if (pException != nullptr) throw pException;
}

    virtual bool getIsClassInitedFlagAddress(
          CORINFO_CLASS_HANDLE cls,
          CORINFO_CONST_LOOKUP* addr,
          int* offset)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getIsClassInitedFlagAddress(_thisHandle, &pException, cls, addr, offset);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual size_t getClassThreadStaticDynamicInfo(
          CORINFO_CLASS_HANDLE clr)
{
    CorInfoExceptionClass* pException = nullptr;
    size_t temp = _callbacks->getClassThreadStaticDynamicInfo(_thisHandle, &pException, clr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual size_t getClassStaticDynamicInfo(
          CORINFO_CLASS_HANDLE clr)
{
    CorInfoExceptionClass* pException = nullptr;
    size_t temp = _callbacks->getClassStaticDynamicInfo(_thisHandle, &pException, clr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool getStaticBaseAddress(
          CORINFO_CLASS_HANDLE cls,
          bool isGc,
          CORINFO_CONST_LOOKUP* addr)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getStaticBaseAddress(_thisHandle, &pException, cls, isGc, addr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getClassSize(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getClassSize(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getHeapClassSize(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getHeapClassSize(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool canAllocateOnStack(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->canAllocateOnStack(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getClassAlignmentRequirement(
          CORINFO_CLASS_HANDLE cls,
          bool fDoubleAlignHint)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getClassAlignmentRequirement(_thisHandle, &pException, cls, fDoubleAlignHint);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getClassGClayout(
          CORINFO_CLASS_HANDLE cls,
          uint8_t* gcPtrs)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getClassGClayout(_thisHandle, &pException, cls, gcPtrs);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getClassNumInstanceFields(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getClassNumInstanceFields(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_FIELD_HANDLE getFieldInClass(
          CORINFO_CLASS_HANDLE clsHnd,
          int32_t num)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_FIELD_HANDLE temp = _callbacks->getFieldInClass(_thisHandle, &pException, clsHnd, num);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual GetTypeLayoutResult getTypeLayout(
          CORINFO_CLASS_HANDLE typeHnd,
          CORINFO_TYPE_LAYOUT_NODE* treeNodes,
          size_t* numTreeNodes)
{
    CorInfoExceptionClass* pException = nullptr;
    GetTypeLayoutResult temp = _callbacks->getTypeLayout(_thisHandle, &pException, typeHnd, treeNodes, numTreeNodes);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool checkMethodModifier(
          CORINFO_METHOD_HANDLE hMethod,
          const char* modifier,
          bool fOptional)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->checkMethodModifier(_thisHandle, &pException, hMethod, modifier, fOptional);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHelpFunc getNewHelper(
          CORINFO_CLASS_HANDLE classHandle,
          bool* pHasSideEffects)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getNewHelper(_thisHandle, &pException, classHandle, pHasSideEffects);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHelpFunc getNewArrHelper(
          CORINFO_CLASS_HANDLE arrayCls)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getNewArrHelper(_thisHandle, &pException, arrayCls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHelpFunc getCastingHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool fThrowing)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getCastingHelper(_thisHandle, &pException, pResolvedToken, fThrowing);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHelpFunc getSharedCCtorHelper(
          CORINFO_CLASS_HANDLE clsHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getSharedCCtorHelper(_thisHandle, &pException, clsHnd);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getTypeForBox(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getTypeForBox(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHelpFunc getBoxHelper(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getBoxHelper(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHelpFunc getUnBoxHelper(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getUnBoxHelper(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_OBJECT_HANDLE getRuntimeTypePointer(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_OBJECT_HANDLE temp = _callbacks->getRuntimeTypePointer(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool isObjectImmutable(
          CORINFO_OBJECT_HANDLE objPtr)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isObjectImmutable(_thisHandle, &pException, objPtr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool getStringChar(
          CORINFO_OBJECT_HANDLE strObj,
          int index,
          uint16_t* value)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getStringChar(_thisHandle, &pException, strObj, index, value);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getObjectType(
          CORINFO_OBJECT_HANDLE objPtr)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getObjectType(_thisHandle, &pException, objPtr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool getReadyToRunHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_LOOKUP_KIND* pGenericLookupKind,
          CorInfoHelpFunc id,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_CONST_LOOKUP* pLookup)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getReadyToRunHelper(_thisHandle, &pException, pResolvedToken, pGenericLookupKind, id, callerHandle, pLookup);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getReadyToRunDelegateCtorHelper(
          CORINFO_RESOLVED_TOKEN* pTargetMethod,
          unsigned int targetConstraint,
          CORINFO_CLASS_HANDLE delegateType,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_LOOKUP* pLookup)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getReadyToRunDelegateCtorHelper(_thisHandle, &pException, pTargetMethod, targetConstraint, delegateType, callerHandle, pLookup);
    if (pException != nullptr) throw pException;
}

    virtual CorInfoInitClassResult initClass(
          CORINFO_FIELD_HANDLE field,
          CORINFO_METHOD_HANDLE method,
          CORINFO_CONTEXT_HANDLE context)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoInitClassResult temp = _callbacks->initClass(_thisHandle, &pException, field, method, context);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void classMustBeLoadedBeforeCodeIsRun(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->classMustBeLoadedBeforeCodeIsRun(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
}

    virtual CORINFO_CLASS_HANDLE getBuiltinClass(
          CorInfoClassId classId)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getBuiltinClass(_thisHandle, &pException, classId);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoType getTypeForPrimitiveValueClass(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoType temp = _callbacks->getTypeForPrimitiveValueClass(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoType getTypeForPrimitiveNumericClass(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoType temp = _callbacks->getTypeForPrimitiveNumericClass(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool canCast(
          CORINFO_CLASS_HANDLE child,
          CORINFO_CLASS_HANDLE parent)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->canCast(_thisHandle, &pException, child, parent);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual TypeCompareState compareTypesForCast(
          CORINFO_CLASS_HANDLE fromClass,
          CORINFO_CLASS_HANDLE toClass)
{
    CorInfoExceptionClass* pException = nullptr;
    TypeCompareState temp = _callbacks->compareTypesForCast(_thisHandle, &pException, fromClass, toClass);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual TypeCompareState compareTypesForEquality(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    CorInfoExceptionClass* pException = nullptr;
    TypeCompareState temp = _callbacks->compareTypesForEquality(_thisHandle, &pException, cls1, cls2);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool isMoreSpecificType(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isMoreSpecificType(_thisHandle, &pException, cls1, cls2);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool isExactType(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isExactType(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual TypeCompareState isGenericType(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    TypeCompareState temp = _callbacks->isGenericType(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual TypeCompareState isNullableType(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    TypeCompareState temp = _callbacks->isNullableType(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual TypeCompareState isEnum(
          CORINFO_CLASS_HANDLE cls,
          CORINFO_CLASS_HANDLE* underlyingType)
{
    CorInfoExceptionClass* pException = nullptr;
    TypeCompareState temp = _callbacks->isEnum(_thisHandle, &pException, cls, underlyingType);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getParentType(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getParentType(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoType getChildType(
          CORINFO_CLASS_HANDLE clsHnd,
          CORINFO_CLASS_HANDLE* clsRet)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoType temp = _callbacks->getChildType(_thisHandle, &pException, clsHnd, clsRet);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool isSDArray(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isSDArray(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getArrayRank(
          CORINFO_CLASS_HANDLE cls)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getArrayRank(_thisHandle, &pException, cls);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoArrayIntrinsic getArrayIntrinsicID(
          CORINFO_METHOD_HANDLE ftn)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoArrayIntrinsic temp = _callbacks->getArrayIntrinsicID(_thisHandle, &pException, ftn);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void* getArrayInitializationData(
          CORINFO_FIELD_HANDLE field,
          uint32_t size)
{
    CorInfoExceptionClass* pException = nullptr;
    void* temp = _callbacks->getArrayInitializationData(_thisHandle, &pException, field, size);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoIsAccessAllowedResult canAccessClass(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_HELPER_DESC* pAccessHelper)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoIsAccessAllowedResult temp = _callbacks->canAccessClass(_thisHandle, &pException, pResolvedToken, callerHandle, pAccessHelper);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual size_t printFieldName(
          CORINFO_FIELD_HANDLE field,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    CorInfoExceptionClass* pException = nullptr;
    size_t temp = _callbacks->printFieldName(_thisHandle, &pException, field, buffer, bufferSize, pRequiredBufferSize);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getFieldClass(
          CORINFO_FIELD_HANDLE field)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getFieldClass(_thisHandle, &pException, field);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoType getFieldType(
          CORINFO_FIELD_HANDLE field,
          CORINFO_CLASS_HANDLE* structType,
          CORINFO_CLASS_HANDLE fieldOwnerHint)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoType temp = _callbacks->getFieldType(_thisHandle, &pException, field, structType, fieldOwnerHint);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getFieldOffset(
          CORINFO_FIELD_HANDLE field)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getFieldOffset(_thisHandle, &pException, field);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getFieldInfo(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_ACCESS_FLAGS flags,
          CORINFO_FIELD_INFO* pResult)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getFieldInfo(_thisHandle, &pException, pResolvedToken, callerHandle, flags, pResult);
    if (pException != nullptr) throw pException;
}

    virtual uint32_t getThreadLocalFieldInfo(
          CORINFO_FIELD_HANDLE field,
          bool isGCtype)
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getThreadLocalFieldInfo(_thisHandle, &pException, field, isGCtype);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getThreadLocalStaticBlocksInfo(
          CORINFO_THREAD_STATIC_BLOCKS_INFO* pInfo)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getThreadLocalStaticBlocksInfo(_thisHandle, &pException, pInfo);
    if (pException != nullptr) throw pException;
}

    virtual void getThreadLocalStaticInfo_NativeAOT(
          CORINFO_THREAD_STATIC_INFO_NATIVEAOT* pInfo)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getThreadLocalStaticInfo_NativeAOT(_thisHandle, &pException, pInfo);
    if (pException != nullptr) throw pException;
}

    virtual bool isFieldStatic(
          CORINFO_FIELD_HANDLE fldHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->isFieldStatic(_thisHandle, &pException, fldHnd);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual int getArrayOrStringLength(
          CORINFO_OBJECT_HANDLE objHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    int temp = _callbacks->getArrayOrStringLength(_thisHandle, &pException, objHnd);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getBoundaries(
          CORINFO_METHOD_HANDLE ftn,
          unsigned int* cILOffsets,
          uint32_t** pILOffsets,
          ICorDebugInfo::BoundaryTypes* implicitBoundaries)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getBoundaries(_thisHandle, &pException, ftn, cILOffsets, pILOffsets, implicitBoundaries);
    if (pException != nullptr) throw pException;
}

    virtual void setBoundaries(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t cMap,
          ICorDebugInfo::OffsetMapping* pMap)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->setBoundaries(_thisHandle, &pException, ftn, cMap, pMap);
    if (pException != nullptr) throw pException;
}

    virtual void getVars(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t* cVars,
          ICorDebugInfo::ILVarInfo** vars,
          bool* extendOthers)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getVars(_thisHandle, &pException, ftn, cVars, vars, extendOthers);
    if (pException != nullptr) throw pException;
}

    virtual void setVars(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t cVars,
          ICorDebugInfo::NativeVarInfo* vars)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->setVars(_thisHandle, &pException, ftn, cVars, vars);
    if (pException != nullptr) throw pException;
}

    virtual void reportRichMappings(
          ICorDebugInfo::InlineTreeNode* inlineTreeNodes,
          uint32_t numInlineTreeNodes,
          ICorDebugInfo::RichOffsetMapping* mappings,
          uint32_t numMappings)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->reportRichMappings(_thisHandle, &pException, inlineTreeNodes, numInlineTreeNodes, mappings, numMappings);
    if (pException != nullptr) throw pException;
}

    virtual void reportMetadata(
          const char* key,
          const void* value,
          size_t length)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->reportMetadata(_thisHandle, &pException, key, value, length);
    if (pException != nullptr) throw pException;
}

    virtual void* allocateArray(
          size_t cBytes)
{
    CorInfoExceptionClass* pException = nullptr;
    void* temp = _callbacks->allocateArray(_thisHandle, &pException, cBytes);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void freeArray(
          void* array)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->freeArray(_thisHandle, &pException, array);
    if (pException != nullptr) throw pException;
}

    virtual CORINFO_ARG_LIST_HANDLE getArgNext(
          CORINFO_ARG_LIST_HANDLE args)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_ARG_LIST_HANDLE temp = _callbacks->getArgNext(_thisHandle, &pException, args);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoTypeWithMod getArgType(
          CORINFO_SIG_INFO* sig,
          CORINFO_ARG_LIST_HANDLE args,
          CORINFO_CLASS_HANDLE* vcTypeRet)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoTypeWithMod temp = _callbacks->getArgType(_thisHandle, &pException, sig, args, vcTypeRet);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual int getExactClasses(
          CORINFO_CLASS_HANDLE baseType,
          int maxExactClasses,
          CORINFO_CLASS_HANDLE* exactClsRet)
{
    CorInfoExceptionClass* pException = nullptr;
    int temp = _callbacks->getExactClasses(_thisHandle, &pException, baseType, maxExactClasses, exactClsRet);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getArgClass(
          CORINFO_SIG_INFO* sig,
          CORINFO_ARG_LIST_HANDLE args)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getArgClass(_thisHandle, &pException, sig, args);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CorInfoHFAElemType getHFAType(
          CORINFO_CLASS_HANDLE hClass)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHFAElemType temp = _callbacks->getHFAType(_thisHandle, &pException, hClass);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool runWithErrorTrap(
          ICorJitInfo::errorTrapFunction function,
          void* parameter);

    virtual bool runWithSPMIErrorTrap(
          ICorJitInfo::errorTrapFunction function,
          void* parameter);

    virtual void getEEInfo(
          CORINFO_EE_INFO* pEEInfoOut)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getEEInfo(_thisHandle, &pException, pEEInfoOut);
    if (pException != nullptr) throw pException;
}

    virtual void getAsyncInfo(
          CORINFO_ASYNC_INFO* pAsyncInfoOut)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getAsyncInfo(_thisHandle, &pException, pAsyncInfoOut);
    if (pException != nullptr) throw pException;
}

    virtual mdMethodDef getMethodDefFromMethod(
          CORINFO_METHOD_HANDLE hMethod)
{
    CorInfoExceptionClass* pException = nullptr;
    mdMethodDef temp = _callbacks->getMethodDefFromMethod(_thisHandle, &pException, hMethod);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual size_t printMethodName(
          CORINFO_METHOD_HANDLE ftn,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    CorInfoExceptionClass* pException = nullptr;
    size_t temp = _callbacks->printMethodName(_thisHandle, &pException, ftn, buffer, bufferSize, pRequiredBufferSize);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual const char* getMethodNameFromMetadata(
          CORINFO_METHOD_HANDLE ftn,
          const char** className,
          const char** namespaceName,
          const char** enclosingClassNames,
          size_t maxEnclosingClassNames)
{
    CorInfoExceptionClass* pException = nullptr;
    const char* temp = _callbacks->getMethodNameFromMetadata(_thisHandle, &pException, ftn, className, namespaceName, enclosingClassNames, maxEnclosingClassNames);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual unsigned getMethodHash(
          CORINFO_METHOD_HANDLE ftn)
{
    CorInfoExceptionClass* pException = nullptr;
    unsigned temp = _callbacks->getMethodHash(_thisHandle, &pException, ftn);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool getSystemVAmd64PassStructInRegisterDescriptor(
          CORINFO_CLASS_HANDLE structHnd,
          SYSTEMV_AMD64_CORINFO_STRUCT_REG_PASSING_DESCRIPTOR* structPassInRegDescPtr)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getSystemVAmd64PassStructInRegisterDescriptor(_thisHandle, &pException, structHnd, structPassInRegDescPtr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getSwiftLowering(
          CORINFO_CLASS_HANDLE structHnd,
          CORINFO_SWIFT_LOWERING* pLowering)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getSwiftLowering(_thisHandle, &pException, structHnd, pLowering);
    if (pException != nullptr) throw pException;
}

    virtual void getFpStructLowering(
          CORINFO_CLASS_HANDLE structHnd,
          CORINFO_FPSTRUCT_LOWERING* pLowering)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getFpStructLowering(_thisHandle, &pException, structHnd, pLowering);
    if (pException != nullptr) throw pException;
}

    virtual uint32_t getThreadTLSIndex(
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getThreadTLSIndex(_thisHandle, &pException, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual int32_t* getAddrOfCaptureThreadGlobal(
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    int32_t* temp = _callbacks->getAddrOfCaptureThreadGlobal(_thisHandle, &pException, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void getHelperFtn(
          CorInfoHelpFunc ftnNum,
          CORINFO_CONST_LOOKUP* pNativeEntrypoint,
          CORINFO_METHOD_HANDLE* pMethod)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getHelperFtn(_thisHandle, &pException, ftnNum, pNativeEntrypoint, pMethod);
    if (pException != nullptr) throw pException;
}

    virtual void getFunctionEntryPoint(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_CONST_LOOKUP* pResult,
          CORINFO_ACCESS_FLAGS accessFlags)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getFunctionEntryPoint(_thisHandle, &pException, ftn, pResult, accessFlags);
    if (pException != nullptr) throw pException;
}

    virtual void getFunctionFixedEntryPoint(
          CORINFO_METHOD_HANDLE ftn,
          bool isUnsafeFunctionPointer,
          CORINFO_CONST_LOOKUP* pResult)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getFunctionFixedEntryPoint(_thisHandle, &pException, ftn, isUnsafeFunctionPointer, pResult);
    if (pException != nullptr) throw pException;
}

    virtual CorInfoHelpFunc getLazyStringLiteralHelper(
          CORINFO_MODULE_HANDLE handle)
{
    CorInfoExceptionClass* pException = nullptr;
    CorInfoHelpFunc temp = _callbacks->getLazyStringLiteralHelper(_thisHandle, &pException, handle);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_MODULE_HANDLE embedModuleHandle(
          CORINFO_MODULE_HANDLE handle,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_MODULE_HANDLE temp = _callbacks->embedModuleHandle(_thisHandle, &pException, handle, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE embedClassHandle(
          CORINFO_CLASS_HANDLE handle,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->embedClassHandle(_thisHandle, &pException, handle, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_METHOD_HANDLE embedMethodHandle(
          CORINFO_METHOD_HANDLE handle,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_METHOD_HANDLE temp = _callbacks->embedMethodHandle(_thisHandle, &pException, handle, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_FIELD_HANDLE embedFieldHandle(
          CORINFO_FIELD_HANDLE handle,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_FIELD_HANDLE temp = _callbacks->embedFieldHandle(_thisHandle, &pException, handle, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void embedGenericHandle(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool fEmbedParent,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_GENERICHANDLE_RESULT* pResult)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->embedGenericHandle(_thisHandle, &pException, pResolvedToken, fEmbedParent, callerHandle, pResult);
    if (pException != nullptr) throw pException;
}

    virtual void getLocationOfThisType(
          CORINFO_METHOD_HANDLE context,
          CORINFO_LOOKUP_KIND* pLookupKind)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getLocationOfThisType(_thisHandle, &pException, context, pLookupKind);
    if (pException != nullptr) throw pException;
}

    virtual void getAddressOfPInvokeTarget(
          CORINFO_METHOD_HANDLE method,
          CORINFO_CONST_LOOKUP* pLookup)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getAddressOfPInvokeTarget(_thisHandle, &pException, method, pLookup);
    if (pException != nullptr) throw pException;
}

    virtual void* GetCookieForPInvokeCalliSig(
          CORINFO_SIG_INFO* szMetaSig,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    void* temp = _callbacks->GetCookieForPInvokeCalliSig(_thisHandle, &pException, szMetaSig, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void* GetCookieForInterpreterCalliSig(
          CORINFO_SIG_INFO* szMetaSig)
{
    CorInfoExceptionClass* pException = nullptr;
    void* temp = _callbacks->GetCookieForInterpreterCalliSig(_thisHandle, &pException, szMetaSig);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_JUST_MY_CODE_HANDLE getJustMyCodeHandle(
          CORINFO_METHOD_HANDLE method,
          CORINFO_JUST_MY_CODE_HANDLE** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_JUST_MY_CODE_HANDLE temp = _callbacks->getJustMyCodeHandle(_thisHandle, &pException, method, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void GetProfilingHandle(
          bool* pbHookFunction,
          void** pProfilerHandle,
          bool* pbIndirectedHandles)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->GetProfilingHandle(_thisHandle, &pException, pbHookFunction, pProfilerHandle, pbIndirectedHandles);
    if (pException != nullptr) throw pException;
}

    virtual void getCallInfo(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_RESOLVED_TOKEN* pConstrainedResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_CALLINFO_FLAGS flags,
          CORINFO_CALL_INFO* pResult)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->getCallInfo(_thisHandle, &pException, pResolvedToken, pConstrainedResolvedToken, callerHandle, flags, pResult);
    if (pException != nullptr) throw pException;
}

    virtual bool getStaticFieldContent(
          CORINFO_FIELD_HANDLE field,
          uint8_t* buffer,
          int bufferSize,
          int valueOffset,
          bool ignoreMovableObjects)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getStaticFieldContent(_thisHandle, &pException, field, buffer, bufferSize, valueOffset, ignoreMovableObjects);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool getObjectContent(
          CORINFO_OBJECT_HANDLE obj,
          uint8_t* buffer,
          int bufferSize,
          int valueOffset)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getObjectContent(_thisHandle, &pException, obj, buffer, bufferSize, valueOffset);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_CLASS_HANDLE getStaticFieldCurrentClass(
          CORINFO_FIELD_HANDLE field,
          bool* pIsSpeculative)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_CLASS_HANDLE temp = _callbacks->getStaticFieldCurrentClass(_thisHandle, &pException, field, pIsSpeculative);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_VARARGS_HANDLE getVarArgsHandle(
          CORINFO_SIG_INFO* pSig,
          CORINFO_METHOD_HANDLE methHnd,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_VARARGS_HANDLE temp = _callbacks->getVarArgsHandle(_thisHandle, &pException, pSig, methHnd, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual InfoAccessType constructStringLiteral(
          CORINFO_MODULE_HANDLE module,
          unsigned int metaTok,
          void** ppValue)
{
    CorInfoExceptionClass* pException = nullptr;
    InfoAccessType temp = _callbacks->constructStringLiteral(_thisHandle, &pException, module, metaTok, ppValue);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual InfoAccessType emptyStringLiteral(
          void** ppValue)
{
    CorInfoExceptionClass* pException = nullptr;
    InfoAccessType temp = _callbacks->emptyStringLiteral(_thisHandle, &pException, ppValue);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual uint32_t getFieldThreadLocalStoreID(
          CORINFO_FIELD_HANDLE field,
          void** ppIndirection)
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getFieldThreadLocalStoreID(_thisHandle, &pException, field, ppIndirection);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_METHOD_HANDLE GetDelegateCtor(
          CORINFO_METHOD_HANDLE methHnd,
          CORINFO_CLASS_HANDLE clsHnd,
          CORINFO_METHOD_HANDLE targetMethodHnd,
          DelegateCtorArgs* pCtorData)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_METHOD_HANDLE temp = _callbacks->GetDelegateCtor(_thisHandle, &pException, methHnd, clsHnd, targetMethodHnd, pCtorData);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void MethodCompileComplete(
          CORINFO_METHOD_HANDLE methHnd)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->MethodCompileComplete(_thisHandle, &pException, methHnd);
    if (pException != nullptr) throw pException;
}

    virtual bool getTailCallHelpers(
          CORINFO_RESOLVED_TOKEN* callToken,
          CORINFO_SIG_INFO* sig,
          CORINFO_GET_TAILCALL_HELPERS_FLAGS flags,
          CORINFO_TAILCALL_HELPERS* pResult)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->getTailCallHelpers(_thisHandle, &pException, callToken, sig, flags, pResult);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_METHOD_HANDLE getAsyncResumptionStub()
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_METHOD_HANDLE temp = _callbacks->getAsyncResumptionStub(_thisHandle, &pException);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool convertPInvokeCalliToCall(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool mustConvert)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->convertPInvokeCalliToCall(_thisHandle, &pException, pResolvedToken, mustConvert);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual bool notifyInstructionSetUsage(
          CORINFO_InstructionSet instructionSet,
          bool supportEnabled)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->notifyInstructionSetUsage(_thisHandle, &pException, instructionSet, supportEnabled);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void updateEntryPointForTailCall(
          CORINFO_CONST_LOOKUP* entryPoint)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->updateEntryPointForTailCall(_thisHandle, &pException, entryPoint);
    if (pException != nullptr) throw pException;
}

    virtual void allocMem(
          AllocMemArgs* pArgs)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->allocMem(_thisHandle, &pException, pArgs);
    if (pException != nullptr) throw pException;
}

    virtual void reserveUnwindInfo(
          bool isFunclet,
          bool isColdCode,
          uint32_t unwindSize)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->reserveUnwindInfo(_thisHandle, &pException, isFunclet, isColdCode, unwindSize);
    if (pException != nullptr) throw pException;
}

    virtual void allocUnwindInfo(
          uint8_t* pHotCode,
          uint8_t* pColdCode,
          uint32_t startOffset,
          uint32_t endOffset,
          uint32_t unwindSize,
          uint8_t* pUnwindBlock,
          CorJitFuncKind funcKind)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->allocUnwindInfo(_thisHandle, &pException, pHotCode, pColdCode, startOffset, endOffset, unwindSize, pUnwindBlock, funcKind);
    if (pException != nullptr) throw pException;
}

    virtual void* allocGCInfo(
          size_t size)
{
    CorInfoExceptionClass* pException = nullptr;
    void* temp = _callbacks->allocGCInfo(_thisHandle, &pException, size);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void setEHcount(
          unsigned cEH)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->setEHcount(_thisHandle, &pException, cEH);
    if (pException != nullptr) throw pException;
}

    virtual void setEHinfo(
          unsigned EHnumber,
          const CORINFO_EH_CLAUSE* clause)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->setEHinfo(_thisHandle, &pException, EHnumber, clause);
    if (pException != nullptr) throw pException;
}

    virtual bool logMsg(
          unsigned level,
          const char* fmt,
          va_list args)
{
    CorInfoExceptionClass* pException = nullptr;
    bool temp = _callbacks->logMsg(_thisHandle, &pException, level, fmt, args);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual int doAssert(
          const char* szFile,
          int iLine,
          const char* szExpr)
{
    CorInfoExceptionClass* pException = nullptr;
    int temp = _callbacks->doAssert(_thisHandle, &pException, szFile, iLine, szExpr);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void reportFatalError(
          CorJitResult result)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->reportFatalError(_thisHandle, &pException, result);
    if (pException != nullptr) throw pException;
}

    virtual JITINTERFACE_HRESULT getPgoInstrumentationResults(
          CORINFO_METHOD_HANDLE ftnHnd,
          ICorJitInfo::PgoInstrumentationSchema** pSchema,
          uint32_t* pCountSchemaItems,
          uint8_t** pInstrumentationData,
          ICorJitInfo::PgoSource* pPgoSource,
          bool* pDynamicPgo)
{
    CorInfoExceptionClass* pException = nullptr;
    JITINTERFACE_HRESULT temp = _callbacks->getPgoInstrumentationResults(_thisHandle, &pException, ftnHnd, pSchema, pCountSchemaItems, pInstrumentationData, pPgoSource, pDynamicPgo);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual JITINTERFACE_HRESULT allocPgoInstrumentationBySchema(
          CORINFO_METHOD_HANDLE ftnHnd,
          ICorJitInfo::PgoInstrumentationSchema* pSchema,
          uint32_t countSchemaItems,
          uint8_t** pInstrumentationData)
{
    CorInfoExceptionClass* pException = nullptr;
    JITINTERFACE_HRESULT temp = _callbacks->allocPgoInstrumentationBySchema(_thisHandle, &pException, ftnHnd, pSchema, countSchemaItems, pInstrumentationData);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual void recordCallSite(
          uint32_t instrOffset,
          CORINFO_SIG_INFO* callSig,
          CORINFO_METHOD_HANDLE methodHandle)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->recordCallSite(_thisHandle, &pException, instrOffset, callSig, methodHandle);
    if (pException != nullptr) throw pException;
}

    virtual void recordRelocation(
          void* location,
          void* locationRW,
          void* target,
          uint16_t fRelocType,
          int32_t addlDelta)
{
    CorInfoExceptionClass* pException = nullptr;
    _callbacks->recordRelocation(_thisHandle, &pException, location, locationRW, target, fRelocType, addlDelta);
    if (pException != nullptr) throw pException;
}

    virtual uint16_t getRelocTypeHint(
          void* target)
{
    CorInfoExceptionClass* pException = nullptr;
    uint16_t temp = _callbacks->getRelocTypeHint(_thisHandle, &pException, target);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual uint32_t getExpectedTargetArchitecture()
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getExpectedTargetArchitecture(_thisHandle, &pException);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual uint32_t getJitFlags(
          CORJIT_FLAGS* flags,
          uint32_t sizeInBytes)
{
    CorInfoExceptionClass* pException = nullptr;
    uint32_t temp = _callbacks->getJitFlags(_thisHandle, &pException, flags, sizeInBytes);
    if (pException != nullptr) throw pException;
    return temp;
}

    virtual CORINFO_METHOD_HANDLE getSpecialCopyHelper(
          CORINFO_CLASS_HANDLE type)
{
    CorInfoExceptionClass* pException = nullptr;
    CORINFO_METHOD_HANDLE temp = _callbacks->getSpecialCopyHelper(_thisHandle, &pException, type);
    if (pException != nullptr) throw pException;
    return temp;
}
};
