// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// FROM /src/coreclr/tools/Common/JitInterface/ThunkGenerator/InstructionSetDesc.txt
// using /src/coreclr/tools/Common/JitInterface/ThunkGenerator/gen.bat

using System.Collections;
using System.Collections.Generic;
using System.Linq;
using Internal.TypeSystem;

namespace Internal.JitInterface
{
    public enum InstructionSet
    {
        ILLEGAL = 0,
        NONE = 127,
        ARM64_ArmBase = InstructionSet_ARM64.ArmBase,
        ARM64_AdvSimd = InstructionSet_ARM64.AdvSimd,
        ARM64_Aes = InstructionSet_ARM64.Aes,
        ARM64_Crc32 = InstructionSet_ARM64.Crc32,
        ARM64_Dp = InstructionSet_ARM64.Dp,
        ARM64_Rdm = InstructionSet_ARM64.Rdm,
        ARM64_Sha1 = InstructionSet_ARM64.Sha1,
        ARM64_Sha256 = InstructionSet_ARM64.Sha256,
        ARM64_Atomics = InstructionSet_ARM64.Atomics,
        ARM64_Vector64 = InstructionSet_ARM64.Vector64,
        ARM64_Vector128 = InstructionSet_ARM64.Vector128,
        ARM64_Dczva = InstructionSet_ARM64.Dczva,
        ARM64_Rcpc = InstructionSet_ARM64.Rcpc,
        ARM64_VectorT128 = InstructionSet_ARM64.VectorT128,
        ARM64_Rcpc2 = InstructionSet_ARM64.Rcpc2,
        ARM64_Sve = InstructionSet_ARM64.Sve,
        ARM64_Sve2 = InstructionSet_ARM64.Sve2,
        ARM64_ArmBase_Arm64 = InstructionSet_ARM64.ArmBase_Arm64,
        ARM64_AdvSimd_Arm64 = InstructionSet_ARM64.AdvSimd_Arm64,
        ARM64_Aes_Arm64 = InstructionSet_ARM64.Aes_Arm64,
        ARM64_Crc32_Arm64 = InstructionSet_ARM64.Crc32_Arm64,
        ARM64_Dp_Arm64 = InstructionSet_ARM64.Dp_Arm64,
        ARM64_Rdm_Arm64 = InstructionSet_ARM64.Rdm_Arm64,
        ARM64_Sha1_Arm64 = InstructionSet_ARM64.Sha1_Arm64,
        ARM64_Sha256_Arm64 = InstructionSet_ARM64.Sha256_Arm64,
        ARM64_Sve_Arm64 = InstructionSet_ARM64.Sve_Arm64,
        ARM64_Sve2_Arm64 = InstructionSet_ARM64.Sve2_Arm64,
        RiscV64_RiscV64Base = InstructionSet_RiscV64.RiscV64Base,
        RiscV64_Zba = InstructionSet_RiscV64.Zba,
        RiscV64_Zbb = InstructionSet_RiscV64.Zbb,
        X64_X86Base = InstructionSet_X64.X86Base,
        X64_SSE42 = InstructionSet_X64.SSE42,
        X64_AVX = InstructionSet_X64.AVX,
        X64_AVX2 = InstructionSet_X64.AVX2,
        X64_AVX512 = InstructionSet_X64.AVX512,
        X64_AVX512v2 = InstructionSet_X64.AVX512v2,
        X64_AVX512v3 = InstructionSet_X64.AVX512v3,
        X64_AVX10v1 = InstructionSet_X64.AVX10v1,
        X64_AVX10v2 = InstructionSet_X64.AVX10v2,
        X64_APX = InstructionSet_X64.APX,
        X64_AES = InstructionSet_X64.AES,
        X64_AES_V256 = InstructionSet_X64.AES_V256,
        X64_AES_V512 = InstructionSet_X64.AES_V512,
        X64_AVX512VP2INTERSECT = InstructionSet_X64.AVX512VP2INTERSECT,
        X64_AVXIFMA = InstructionSet_X64.AVXIFMA,
        X64_AVXVNNI = InstructionSet_X64.AVXVNNI,
        X64_GFNI = InstructionSet_X64.GFNI,
        X64_GFNI_V256 = InstructionSet_X64.GFNI_V256,
        X64_GFNI_V512 = InstructionSet_X64.GFNI_V512,
        X64_SHA = InstructionSet_X64.SHA,
        X64_WAITPKG = InstructionSet_X64.WAITPKG,
        X64_X86Serialize = InstructionSet_X64.X86Serialize,
        X64_Vector128 = InstructionSet_X64.Vector128,
        X64_Vector256 = InstructionSet_X64.Vector256,
        X64_Vector512 = InstructionSet_X64.Vector512,
        X64_VectorT128 = InstructionSet_X64.VectorT128,
        X64_VectorT256 = InstructionSet_X64.VectorT256,
        X64_VectorT512 = InstructionSet_X64.VectorT512,
        X64_AVXVNNIINT = InstructionSet_X64.AVXVNNIINT,
        X64_AVXVNNIINT_V512 = InstructionSet_X64.AVXVNNIINT_V512,
        X64_X86Base_X64 = InstructionSet_X64.X86Base_X64,
        X64_SSE42_X64 = InstructionSet_X64.SSE42_X64,
        X64_AVX_X64 = InstructionSet_X64.AVX_X64,
        X64_AVX2_X64 = InstructionSet_X64.AVX2_X64,
        X64_AVX512_X64 = InstructionSet_X64.AVX512_X64,
        X64_AVX512v2_X64 = InstructionSet_X64.AVX512v2_X64,
        X64_AVX512v3_X64 = InstructionSet_X64.AVX512v3_X64,
        X64_AVX10v1_X64 = InstructionSet_X64.AVX10v1_X64,
        X64_AVX10v2_X64 = InstructionSet_X64.AVX10v2_X64,
        X64_AES_X64 = InstructionSet_X64.AES_X64,
        X64_AVX512VP2INTERSECT_X64 = InstructionSet_X64.AVX512VP2INTERSECT_X64,
        X64_AVXIFMA_X64 = InstructionSet_X64.AVXIFMA_X64,
        X64_AVXVNNI_X64 = InstructionSet_X64.AVXVNNI_X64,
        X64_GFNI_X64 = InstructionSet_X64.GFNI_X64,
        X64_SHA_X64 = InstructionSet_X64.SHA_X64,
        X64_WAITPKG_X64 = InstructionSet_X64.WAITPKG_X64,
        X64_X86Serialize_X64 = InstructionSet_X64.X86Serialize_X64,
        X86_X86Base = InstructionSet_X86.X86Base,
        X86_SSE42 = InstructionSet_X86.SSE42,
        X86_AVX = InstructionSet_X86.AVX,
        X86_AVX2 = InstructionSet_X86.AVX2,
        X86_AVX512 = InstructionSet_X86.AVX512,
        X86_AVX512v2 = InstructionSet_X86.AVX512v2,
        X86_AVX512v3 = InstructionSet_X86.AVX512v3,
        X86_AVX10v1 = InstructionSet_X86.AVX10v1,
        X86_AVX10v2 = InstructionSet_X86.AVX10v2,
        X86_APX = InstructionSet_X86.APX,
        X86_AES = InstructionSet_X86.AES,
        X86_AES_V256 = InstructionSet_X86.AES_V256,
        X86_AES_V512 = InstructionSet_X86.AES_V512,
        X86_AVX512VP2INTERSECT = InstructionSet_X86.AVX512VP2INTERSECT,
        X86_AVXIFMA = InstructionSet_X86.AVXIFMA,
        X86_AVXVNNI = InstructionSet_X86.AVXVNNI,
        X86_GFNI = InstructionSet_X86.GFNI,
        X86_GFNI_V256 = InstructionSet_X86.GFNI_V256,
        X86_GFNI_V512 = InstructionSet_X86.GFNI_V512,
        X86_SHA = InstructionSet_X86.SHA,
        X86_WAITPKG = InstructionSet_X86.WAITPKG,
        X86_X86Serialize = InstructionSet_X86.X86Serialize,
        X86_Vector128 = InstructionSet_X86.Vector128,
        X86_Vector256 = InstructionSet_X86.Vector256,
        X86_Vector512 = InstructionSet_X86.Vector512,
        X86_VectorT128 = InstructionSet_X86.VectorT128,
        X86_VectorT256 = InstructionSet_X86.VectorT256,
        X86_VectorT512 = InstructionSet_X86.VectorT512,
        X86_AVXVNNIINT = InstructionSet_X86.AVXVNNIINT,
        X86_AVXVNNIINT_V512 = InstructionSet_X86.AVXVNNIINT_V512,
        X86_X86Base_X64 = InstructionSet_X86.X86Base_X64,
        X86_SSE42_X64 = InstructionSet_X86.SSE42_X64,
        X86_AVX_X64 = InstructionSet_X86.AVX_X64,
        X86_AVX2_X64 = InstructionSet_X86.AVX2_X64,
        X86_AVX512_X64 = InstructionSet_X86.AVX512_X64,
        X86_AVX512v2_X64 = InstructionSet_X86.AVX512v2_X64,
        X86_AVX512v3_X64 = InstructionSet_X86.AVX512v3_X64,
        X86_AVX10v1_X64 = InstructionSet_X86.AVX10v1_X64,
        X86_AVX10v2_X64 = InstructionSet_X86.AVX10v2_X64,
        X86_AES_X64 = InstructionSet_X86.AES_X64,
        X86_AVX512VP2INTERSECT_X64 = InstructionSet_X86.AVX512VP2INTERSECT_X64,
        X86_AVXIFMA_X64 = InstructionSet_X86.AVXIFMA_X64,
        X86_AVXVNNI_X64 = InstructionSet_X86.AVXVNNI_X64,
        X86_GFNI_X64 = InstructionSet_X86.GFNI_X64,
        X86_SHA_X64 = InstructionSet_X86.SHA_X64,
        X86_WAITPKG_X64 = InstructionSet_X86.WAITPKG_X64,
        X86_X86Serialize_X64 = InstructionSet_X86.X86Serialize_X64,
    }
    public enum InstructionSet_ARM64
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        ArmBase = 1,
        AdvSimd = 2,
        Aes = 3,
        Crc32 = 4,
        Dp = 5,
        Rdm = 6,
        Sha1 = 7,
        Sha256 = 8,
        Atomics = 9,
        Vector64 = 10,
        Vector128 = 11,
        Dczva = 12,
        Rcpc = 13,
        VectorT128 = 14,
        Rcpc2 = 15,
        Sve = 16,
        Sve2 = 17,
        ArmBase_Arm64 = 18,
        AdvSimd_Arm64 = 19,
        Aes_Arm64 = 20,
        Crc32_Arm64 = 21,
        Dp_Arm64 = 22,
        Rdm_Arm64 = 23,
        Sha1_Arm64 = 24,
        Sha256_Arm64 = 25,
        Sve_Arm64 = 26,
        Sve2_Arm64 = 27,
    }

    public enum InstructionSet_RiscV64
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        RiscV64Base = 1,
        Zba = 2,
        Zbb = 3,
    }

    public enum InstructionSet_X64
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        X86Base = 1,
        SSE42 = 2,
        AVX = 3,
        AVX2 = 4,
        AVX512 = 5,
        AVX512v2 = 6,
        AVX512v3 = 7,
        AVX10v1 = 8,
        AVX10v2 = 9,
        APX = 10,
        AES = 11,
        AES_V256 = 12,
        AES_V512 = 13,
        AVX512VP2INTERSECT = 14,
        AVXIFMA = 15,
        AVXVNNI = 16,
        GFNI = 17,
        GFNI_V256 = 18,
        GFNI_V512 = 19,
        SHA = 20,
        WAITPKG = 21,
        X86Serialize = 22,
        Vector128 = 23,
        Vector256 = 24,
        Vector512 = 25,
        VectorT128 = 26,
        VectorT256 = 27,
        VectorT512 = 28,
        AVXVNNIINT = 29,
        AVXVNNIINT_V512 = 30,
        X86Base_X64 = 31,
        SSE42_X64 = 32,
        AVX_X64 = 33,
        AVX2_X64 = 34,
        AVX512_X64 = 35,
        AVX512v2_X64 = 36,
        AVX512v3_X64 = 37,
        AVX10v1_X64 = 38,
        AVX10v2_X64 = 39,
        AES_X64 = 40,
        AVX512VP2INTERSECT_X64 = 41,
        AVXIFMA_X64 = 42,
        AVXVNNI_X64 = 43,
        GFNI_X64 = 44,
        SHA_X64 = 45,
        WAITPKG_X64 = 46,
        X86Serialize_X64 = 47,
    }

    public enum InstructionSet_X86
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        X86Base = 1,
        SSE42 = 2,
        AVX = 3,
        AVX2 = 4,
        AVX512 = 5,
        AVX512v2 = 6,
        AVX512v3 = 7,
        AVX10v1 = 8,
        AVX10v2 = 9,
        APX = 10,
        AES = 11,
        AES_V256 = 12,
        AES_V512 = 13,
        AVX512VP2INTERSECT = 14,
        AVXIFMA = 15,
        AVXVNNI = 16,
        GFNI = 17,
        GFNI_V256 = 18,
        GFNI_V512 = 19,
        SHA = 20,
        WAITPKG = 21,
        X86Serialize = 22,
        Vector128 = 23,
        Vector256 = 24,
        Vector512 = 25,
        VectorT128 = 26,
        VectorT256 = 27,
        VectorT512 = 28,
        AVXVNNIINT = 29,
        AVXVNNIINT_V512 = 30,
        X86Base_X64 = 31,
        SSE42_X64 = 32,
        AVX_X64 = 33,
        AVX2_X64 = 34,
        AVX512_X64 = 35,
        AVX512v2_X64 = 36,
        AVX512v3_X64 = 37,
        AVX10v1_X64 = 38,
        AVX10v2_X64 = 39,
        AES_X64 = 40,
        AVX512VP2INTERSECT_X64 = 41,
        AVXIFMA_X64 = 42,
        AVXVNNI_X64 = 43,
        GFNI_X64 = 44,
        SHA_X64 = 45,
        WAITPKG_X64 = 46,
        X86Serialize_X64 = 47,
    }

    public unsafe struct InstructionSetFlags : IEnumerable<InstructionSet>
    {
        private const int FlagsFieldCount = 2;
        private const int BitsPerFlagsField = 64;
        private fixed ulong _flags[FlagsFieldCount];
        public IEnumerable<InstructionSet_ARM64> ARM64Flags => this.Select((x) => (InstructionSet_ARM64)x);

        public IEnumerable<InstructionSet_RiscV64> RiscV64Flags => this.Select((x) => (InstructionSet_RiscV64)x);

        public IEnumerable<InstructionSet_X64> X64Flags => this.Select((x) => (InstructionSet_X64)x);

        public IEnumerable<InstructionSet_X86> X86Flags => this.Select((x) => (InstructionSet_X86)x);

        public InstructionSetFlags() { }

        private static uint GetFlagsFieldIndex(InstructionSet instructionSet)
        {
            uint bitIndex = (uint)instructionSet;
            return (uint)(bitIndex / (uint)BitsPerFlagsField);
        }

        private static ulong GetRelativeBitMask(InstructionSet instructionSet)
        {
            return ((ulong)1) << ((int)instructionSet & 0x3F);
        }

        public void AddInstructionSet(InstructionSet instructionSet)
        {
            uint index = GetFlagsFieldIndex(instructionSet);
            _flags[index] |= GetRelativeBitMask(instructionSet);
        }

        public void RemoveInstructionSet(InstructionSet instructionSet)
        {
            uint index = GetFlagsFieldIndex(instructionSet);
            ulong bitIndex = GetRelativeBitMask(instructionSet);
            _flags[index] &= ~bitIndex;
        }

        public bool HasInstructionSet(InstructionSet instructionSet)
        {
            uint index = GetFlagsFieldIndex(instructionSet);
            ulong bitIndex = GetRelativeBitMask(instructionSet);
            return ((_flags[index] & bitIndex) != 0);
        }

        public bool Equals(InstructionSetFlags other)
        {
            for (int i = 0; i < FlagsFieldCount; i++)
            {
                if (_flags[i] != other._flags[i])
                {
                    return false;
                }
            }
            return true;
        }

        public void Add(InstructionSetFlags other)
        {
            for (int i = 0; i < FlagsFieldCount; i++)
            {
                _flags[i] |= other._flags[i];
            }
        }

        public void IntersectionWith(InstructionSetFlags other)
        {
            for (int i = 0; i < FlagsFieldCount; i++)
            {
                _flags[i] &= other._flags[i];
            }
        }

        public void Remove(InstructionSetFlags other)
        {
            for (int i = 0; i < FlagsFieldCount; i++)
            {
                _flags[i] &= ~other._flags[i];
            }
        }

        public bool IsEmpty()
        {
            for (int i = 0; i < FlagsFieldCount; i++)
            {
                if (_flags[i] != 0)
                {
                    return false;
                }
            }
            return true;
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }

        public IEnumerator<InstructionSet> GetEnumerator()
        {
            for (int i = 1; i < (int)InstructionSet.NONE; i++)
            {
                InstructionSet instructionSet = (InstructionSet)i;
                if (HasInstructionSet(instructionSet))
                {
                    yield return instructionSet;
                }
            }
        }

        public void ExpandInstructionSetByImplication(TargetArchitecture architecture)
        {
            this = ExpandInstructionSetByImplicationHelper(architecture, this);
        }

        public static InstructionSet ConvertToImpliedInstructionSetForVectorInstructionSets(TargetArchitecture architecture, InstructionSet input)
        {
            switch (architecture)
            {
            case TargetArchitecture.ARM64:
                switch (input)
                {
                case InstructionSet.ARM64_Vector64: return InstructionSet.ARM64_AdvSimd;
                case InstructionSet.ARM64_Vector128: return InstructionSet.ARM64_AdvSimd;
                }
                break;
            case TargetArchitecture.X64:
                switch (input)
                {
                case InstructionSet.X64_Vector128: return InstructionSet.X64_X86Base;
                case InstructionSet.X64_Vector256: return InstructionSet.X64_AVX;
                case InstructionSet.X64_Vector512: return InstructionSet.X64_AVX512;
                }
                break;
            case TargetArchitecture.X86:
                switch (input)
                {
                case InstructionSet.X86_Vector128: return InstructionSet.X86_X86Base;
                case InstructionSet.X86_Vector256: return InstructionSet.X86_AVX;
                case InstructionSet.X86_Vector512: return InstructionSet.X86_AVX512;
                }
                break;
            }
            return input;
        }

        public static InstructionSetFlags ExpandInstructionSetByImplicationHelper(TargetArchitecture architecture, InstructionSetFlags input)
        {
            InstructionSetFlags oldflags;
            InstructionSetFlags resultflags = input;
            do
            {
                oldflags = resultflags;
                switch (architecture)
                {

                case TargetArchitecture.ARM64:
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve2))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve2_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve2_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve2);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Vector64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Vector128))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_VectorT128))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve2))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve);
                    break;

                case TargetArchitecture.RiscV64:
                    if (resultflags.HasInstructionSet(InstructionSet.RiscV64_Zbb))
                        resultflags.AddInstructionSet(InstructionSet.RiscV64_RiscV64Base);
                    if (resultflags.HasInstructionSet(InstructionSet.RiscV64_Zba))
                        resultflags.AddInstructionSet(InstructionSet.RiscV64_RiscV64Base);
                    break;

                case TargetArchitecture.X64:
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v2_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v3))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v3_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v3_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v1))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v1_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v1_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v2_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXIFMA))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXIFMA_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXIFMA_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXIFMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SHA))
                        resultflags.AddInstructionSet(InstructionSet.X64_SHA_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SHA_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SHA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_WAITPKG))
                        resultflags.AddInstructionSet(InstructionSet.X64_WAITPKG_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_WAITPKG_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_WAITPKG);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v3))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v1))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_V256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_V256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_V512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_V512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXIFMA))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_V256))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_V256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_V512))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_V512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SHA))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_WAITPKG))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNIINT))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNIINT_V512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_Vector128))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_Vector256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_Vector512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_VectorT128))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_VectorT256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_VectorT512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    break;

                case TargetArchitecture.X86:
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512v2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512v3))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX10v1))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512v3);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX10v2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX10v1);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES_V256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES_V256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES_V512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES_V512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512VP2INTERSECT))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVXIFMA))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVXVNNI))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI_V256))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI_V256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI_V512))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI_V512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SHA))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_WAITPKG))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Serialize))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVXVNNIINT))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVXVNNIINT_V512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX10v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_Vector128))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_Vector256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_Vector512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_VectorT128))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_VectorT256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_VectorT512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    break;
                }
            } while (!oldflags.Equals(resultflags));

            return resultflags;
        }

        public void ExpandInstructionSetByReverseImplication(TargetArchitecture architecture)
        {
            this = ExpandInstructionSetByReverseImplicationHelper(architecture, this);
        }

        private static InstructionSetFlags ExpandInstructionSetByReverseImplicationHelper(TargetArchitecture architecture, InstructionSetFlags input)
        {
            InstructionSetFlags oldflags;
            InstructionSetFlags resultflags = input;
            do
            {
                oldflags = resultflags;
                switch (architecture)
                {

                case TargetArchitecture.ARM64:
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve2_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve2);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Vector64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Vector128);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_VectorT128);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sve))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sve2);
                    break;

                case TargetArchitecture.RiscV64:
                    if (resultflags.HasInstructionSet(InstructionSet.RiscV64_RiscV64Base))
                        resultflags.AddInstructionSet(InstructionSet.RiscV64_Zbb);
                    if (resultflags.HasInstructionSet(InstructionSet.RiscV64_RiscV64Base))
                        resultflags.AddInstructionSet(InstructionSet.RiscV64_Zba);
                    break;

                case TargetArchitecture.X64:
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v3_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v1_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXIFMA_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXIFMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SHA_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SHA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_WAITPKG_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_WAITPKG);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512v3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512v3))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v1))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX10v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_V256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXIFMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_GFNI_V256))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_GFNI_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_SHA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_WAITPKG);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNIINT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX10v2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNIINT_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_Vector128);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_Vector256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_Vector512);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_VectorT128);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_VectorT256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X64_VectorT512);
                    break;

                case TargetArchitecture.X86:
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512v2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512v3);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512v3))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX10v1);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX10v1))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX10v2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES_V256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX512VP2INTERSECT);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVXIFMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI_V256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_GFNI_V256))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_GFNI_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_SHA);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_WAITPKG);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Serialize);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVXVNNIINT);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX10v2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVXVNNIINT_V512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_Vector128);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_Vector256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_Vector512);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_VectorT128);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_VectorT256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX512))
                        resultflags.AddInstructionSet(InstructionSet.X86_VectorT512);
                    break;
                }
            } while (!oldflags.Equals(resultflags));

            return resultflags;
        }

        private static Dictionary<(string, TargetArchitecture), string> AllInstructionSetGroups { get; } = new()
            {
                { ("x86-64",     TargetArchitecture.X64),   "base" },
                { ("x86-64",     TargetArchitecture.X86),   "base" },
                { ("x86-64-v2",  TargetArchitecture.X64),   "x86-64 sse4.2" },
                { ("x86-64-v2",  TargetArchitecture.X86),   "x86-64 sse4.2" },
                { ("x86-64-v3",  TargetArchitecture.X64),   "x86-64-v2 avx2" },
                { ("x86-64-v3",  TargetArchitecture.X86),   "x86-64-v2 avx2" },
                { ("x86-64-v4",  TargetArchitecture.X64),   "x86-64-v3 avx512" },
                { ("x86-64-v4",  TargetArchitecture.X86),   "x86-64-v3 avx512" },
                { ("armv8-a",    TargetArchitecture.ARM64), "neon" },
                { ("armv8.1-a",  TargetArchitecture.ARM64), "armv8-a lse crc rdma" },
                { ("armv8.2-a",  TargetArchitecture.ARM64), "armv8.1-a" },
                { ("armv8.3-a",  TargetArchitecture.ARM64), "armv8.2-a rcpc" },
                { ("armv8.4-a",  TargetArchitecture.ARM64), "armv8.3-a dotprod rcpc2" },
                { ("armv8.5-a",  TargetArchitecture.ARM64), "armv8.4-a" },
                { ("armv8.6-a",  TargetArchitecture.ARM64), "armv8.5-a" },
                { ("apple-m1",   TargetArchitecture.ARM64), "armv8.5-a" },
            };

        public static IEnumerable<string> AllCpuNames =>
            AllInstructionSetGroups.Keys.Select(key => key.Item1).Distinct();

        public static IEnumerable<string> CpuNameToInstructionSets(string cpu, TargetArchitecture arch) =>
            AllInstructionSetGroups.TryGetValue((cpu, arch), out string value) ? value.Split(' ') : null;

        public struct InstructionSetInfo
        {
            public readonly string Name;
            public readonly string ManagedName;
            public readonly InstructionSet InstructionSet;
            public readonly bool Specifiable;

            public InstructionSetInfo(string name, string managedName, InstructionSet instructionSet, bool specifiable)
            {
                Name = name;
                ManagedName = managedName;
                InstructionSet = instructionSet;
                Specifiable = specifiable;
            }
        }

        public static IEnumerable<InstructionSetInfo> ArchitectureToValidInstructionSets(TargetArchitecture architecture)
        {
            switch (architecture)
            {

                case TargetArchitecture.ARM64:
                    yield return new InstructionSetInfo("base", "ArmBase", InstructionSet.ARM64_ArmBase, true);
                    yield return new InstructionSetInfo("neon", "AdvSimd", InstructionSet.ARM64_AdvSimd, true);
                    yield return new InstructionSetInfo("aes", "Aes", InstructionSet.ARM64_Aes, true);
                    yield return new InstructionSetInfo("crc", "Crc32", InstructionSet.ARM64_Crc32, true);
                    yield return new InstructionSetInfo("dotprod", "Dp", InstructionSet.ARM64_Dp, true);
                    yield return new InstructionSetInfo("rdma", "Rdm", InstructionSet.ARM64_Rdm, true);
                    yield return new InstructionSetInfo("sha1", "Sha1", InstructionSet.ARM64_Sha1, true);
                    yield return new InstructionSetInfo("sha2", "Sha256", InstructionSet.ARM64_Sha256, true);
                    yield return new InstructionSetInfo("lse", "", InstructionSet.ARM64_Atomics, true);
                    yield return new InstructionSetInfo("Vector64", "", InstructionSet.ARM64_Vector64, false);
                    yield return new InstructionSetInfo("Vector128", "", InstructionSet.ARM64_Vector128, false);
                    yield return new InstructionSetInfo("Dczva", "", InstructionSet.ARM64_Dczva, false);
                    yield return new InstructionSetInfo("rcpc", "", InstructionSet.ARM64_Rcpc, true);
                    yield return new InstructionSetInfo("vectort128", "VectorT128", InstructionSet.ARM64_VectorT128, true);
                    yield return new InstructionSetInfo("rcpc2", "", InstructionSet.ARM64_Rcpc2, true);
                    yield return new InstructionSetInfo("sve", "Sve", InstructionSet.ARM64_Sve, true);
                    yield return new InstructionSetInfo("sve2", "Sve2", InstructionSet.ARM64_Sve2, true);
                    break;

                case TargetArchitecture.RiscV64:
                    yield return new InstructionSetInfo("base", "RiscV64Base", InstructionSet.RiscV64_RiscV64Base, true);
                    yield return new InstructionSetInfo("zba", "Zba", InstructionSet.RiscV64_Zba, true);
                    yield return new InstructionSetInfo("zbb", "Zbb", InstructionSet.RiscV64_Zbb, true);
                    break;

                case TargetArchitecture.X64:
                    yield return new InstructionSetInfo("base", "X86Base", InstructionSet.X64_X86Base, true);
                    yield return new InstructionSetInfo("base", "Sse", InstructionSet.X64_X86Base, true);
                    yield return new InstructionSetInfo("base", "Sse2", InstructionSet.X64_X86Base, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse42", InstructionSet.X64_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse3", InstructionSet.X64_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Ssse3", InstructionSet.X64_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse41", InstructionSet.X64_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Popcnt", InstructionSet.X64_SSE42, true);
                    yield return new InstructionSetInfo("avx", "Avx", InstructionSet.X64_AVX, true);
                    yield return new InstructionSetInfo("avx2", "Avx2", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Bmi1", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Bmi2", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "F16C", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Fma", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Lzcnt", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("avx512", "", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512F", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512F_VL", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512BW", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512BW_VL", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512CD", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512CD_VL", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512DQ", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512DQ_VL", InstructionSet.X64_AVX512, true);
                    yield return new InstructionSetInfo("avx512v2", "", InstructionSet.X64_AVX512v2, true);
                    yield return new InstructionSetInfo("avx512v2", "Avx512Vbmi", InstructionSet.X64_AVX512v2, true);
                    yield return new InstructionSetInfo("avx512v2", "Avx512Vbmi_VL", InstructionSet.X64_AVX512v2, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Bitalg", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Bitalg_VL", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vbmi2", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vbmi2_VL", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vpopcntdq", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vpopcntdq_VL", InstructionSet.X64_AVX512v3, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Bf16", InstructionSet.X64_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Bf16_VL", InstructionSet.X64_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Fp16", InstructionSet.X64_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Fp16_VL", InstructionSet.X64_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx10v1", InstructionSet.X64_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx10v1_V512", InstructionSet.X64_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v2", "Avx10v2", InstructionSet.X64_AVX10v2, true);
                    yield return new InstructionSetInfo("avx10v2", "Avx10v2_V512", InstructionSet.X64_AVX10v2, true);
                    yield return new InstructionSetInfo("apx", "", InstructionSet.X64_APX, true);
                    yield return new InstructionSetInfo("aes", "Aes", InstructionSet.X64_AES, true);
                    yield return new InstructionSetInfo("aes_v256", "Aes_V256", InstructionSet.X64_AES_V256, true);
                    yield return new InstructionSetInfo("aes_v512", "Aes_V512", InstructionSet.X64_AES_V512, true);
                    yield return new InstructionSetInfo("aes", "Pclmulqdq", InstructionSet.X64_AES, true);
                    yield return new InstructionSetInfo("aes_v256", "Pclmulqdq_V256", InstructionSet.X64_AES_V256, true);
                    yield return new InstructionSetInfo("aes_v512", "Pclmulqdq_V512", InstructionSet.X64_AES_V512, true);
                    yield return new InstructionSetInfo("avx512vp2intersect", "Avx512Vp2intersect", InstructionSet.X64_AVX512VP2INTERSECT, true);
                    yield return new InstructionSetInfo("avx512vp2intersect", "Avx512Vp2intersect_VL", InstructionSet.X64_AVX512VP2INTERSECT, true);
                    yield return new InstructionSetInfo("avxifma", "AvxIfma", InstructionSet.X64_AVXIFMA, true);
                    yield return new InstructionSetInfo("avxvnni", "AvxVnni", InstructionSet.X64_AVXVNNI, true);
                    yield return new InstructionSetInfo("gfni", "Gfni", InstructionSet.X64_GFNI, true);
                    yield return new InstructionSetInfo("gfni_v256", "Gfni_V256", InstructionSet.X64_GFNI_V256, true);
                    yield return new InstructionSetInfo("gfni_v512", "Gfni_V512", InstructionSet.X64_GFNI_V512, true);
                    yield return new InstructionSetInfo("sha", "Sha", InstructionSet.X64_SHA, true);
                    yield return new InstructionSetInfo("waitpkg", "WaitPkg", InstructionSet.X64_WAITPKG, true);
                    yield return new InstructionSetInfo("x86serialize", "X86Serialize", InstructionSet.X64_X86Serialize, true);
                    yield return new InstructionSetInfo("Vector128", "", InstructionSet.X64_Vector128, false);
                    yield return new InstructionSetInfo("Vector256", "", InstructionSet.X64_Vector256, false);
                    yield return new InstructionSetInfo("Vector512", "", InstructionSet.X64_Vector512, false);
                    yield return new InstructionSetInfo("vectort128", "", InstructionSet.X64_VectorT128, true);
                    yield return new InstructionSetInfo("vectort256", "", InstructionSet.X64_VectorT256, true);
                    yield return new InstructionSetInfo("vectort512", "", InstructionSet.X64_VectorT512, true);
                    yield return new InstructionSetInfo("avxvnniint", "AvxVnniInt8", InstructionSet.X64_AVXVNNIINT, true);
                    yield return new InstructionSetInfo("avxvnniint_v512", "AvxVnniInt8_V512", InstructionSet.X64_AVXVNNIINT_V512, true);
                    yield return new InstructionSetInfo("avxvnniint", "AvxVnniInt16", InstructionSet.X64_AVXVNNIINT, true);
                    yield return new InstructionSetInfo("avxvnniint_v512", "AvxVnniInt16_V512", InstructionSet.X64_AVXVNNIINT_V512, true);
                    break;

                case TargetArchitecture.X86:
                    yield return new InstructionSetInfo("base", "X86Base", InstructionSet.X86_X86Base, true);
                    yield return new InstructionSetInfo("base", "Sse", InstructionSet.X86_X86Base, true);
                    yield return new InstructionSetInfo("base", "Sse2", InstructionSet.X86_X86Base, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse42", InstructionSet.X86_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse3", InstructionSet.X86_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Ssse3", InstructionSet.X86_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse41", InstructionSet.X86_SSE42, true);
                    yield return new InstructionSetInfo("sse4.2", "Popcnt", InstructionSet.X86_SSE42, true);
                    yield return new InstructionSetInfo("avx", "Avx", InstructionSet.X86_AVX, true);
                    yield return new InstructionSetInfo("avx2", "Avx2", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Bmi1", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Bmi2", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "F16C", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Fma", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "Lzcnt", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx2", "", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("avx512", "", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512F", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512F_VL", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512BW", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512BW_VL", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512CD", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512CD_VL", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512DQ", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512", "Avx512DQ_VL", InstructionSet.X86_AVX512, true);
                    yield return new InstructionSetInfo("avx512v2", "", InstructionSet.X86_AVX512v2, true);
                    yield return new InstructionSetInfo("avx512v2", "Avx512Vbmi", InstructionSet.X86_AVX512v2, true);
                    yield return new InstructionSetInfo("avx512v2", "Avx512Vbmi_VL", InstructionSet.X86_AVX512v2, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Bitalg", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Bitalg_VL", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vbmi2", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vbmi2_VL", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vpopcntdq", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx512v3", "Avx512Vpopcntdq_VL", InstructionSet.X86_AVX512v3, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Bf16", InstructionSet.X86_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Bf16_VL", InstructionSet.X86_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Fp16", InstructionSet.X86_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx512Fp16_VL", InstructionSet.X86_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx10v1", InstructionSet.X86_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v1", "Avx10v1_V512", InstructionSet.X86_AVX10v1, true);
                    yield return new InstructionSetInfo("avx10v2", "Avx10v2", InstructionSet.X86_AVX10v2, true);
                    yield return new InstructionSetInfo("avx10v2", "Avx10v2_V512", InstructionSet.X86_AVX10v2, true);
                    yield return new InstructionSetInfo("apx", "", InstructionSet.X86_APX, true);
                    yield return new InstructionSetInfo("aes", "Aes", InstructionSet.X86_AES, true);
                    yield return new InstructionSetInfo("aes_v256", "Aes_V256", InstructionSet.X86_AES_V256, true);
                    yield return new InstructionSetInfo("aes_v512", "Aes_V512", InstructionSet.X86_AES_V512, true);
                    yield return new InstructionSetInfo("aes", "Pclmulqdq", InstructionSet.X86_AES, true);
                    yield return new InstructionSetInfo("aes_v256", "Pclmulqdq_V256", InstructionSet.X86_AES_V256, true);
                    yield return new InstructionSetInfo("aes_v512", "Pclmulqdq_V512", InstructionSet.X86_AES_V512, true);
                    yield return new InstructionSetInfo("avx512vp2intersect", "Avx512Vp2intersect", InstructionSet.X86_AVX512VP2INTERSECT, true);
                    yield return new InstructionSetInfo("avx512vp2intersect", "Avx512Vp2intersect_VL", InstructionSet.X86_AVX512VP2INTERSECT, true);
                    yield return new InstructionSetInfo("avxifma", "AvxIfma", InstructionSet.X86_AVXIFMA, true);
                    yield return new InstructionSetInfo("avxvnni", "AvxVnni", InstructionSet.X86_AVXVNNI, true);
                    yield return new InstructionSetInfo("gfni", "Gfni", InstructionSet.X86_GFNI, true);
                    yield return new InstructionSetInfo("gfni_v256", "Gfni_V256", InstructionSet.X86_GFNI_V256, true);
                    yield return new InstructionSetInfo("gfni_v512", "Gfni_V512", InstructionSet.X86_GFNI_V512, true);
                    yield return new InstructionSetInfo("sha", "Sha", InstructionSet.X86_SHA, true);
                    yield return new InstructionSetInfo("waitpkg", "WaitPkg", InstructionSet.X86_WAITPKG, true);
                    yield return new InstructionSetInfo("x86serialize", "X86Serialize", InstructionSet.X86_X86Serialize, true);
                    yield return new InstructionSetInfo("Vector128", "", InstructionSet.X86_Vector128, false);
                    yield return new InstructionSetInfo("Vector256", "", InstructionSet.X86_Vector256, false);
                    yield return new InstructionSetInfo("Vector512", "", InstructionSet.X86_Vector512, false);
                    yield return new InstructionSetInfo("vectort128", "", InstructionSet.X86_VectorT128, true);
                    yield return new InstructionSetInfo("vectort256", "", InstructionSet.X86_VectorT256, true);
                    yield return new InstructionSetInfo("vectort512", "", InstructionSet.X86_VectorT512, true);
                    yield return new InstructionSetInfo("avxvnniint", "AvxVnniInt8", InstructionSet.X86_AVXVNNIINT, true);
                    yield return new InstructionSetInfo("avxvnniint_v512", "AvxVnniInt8_V512", InstructionSet.X86_AVXVNNIINT_V512, true);
                    yield return new InstructionSetInfo("avxvnniint", "AvxVnniInt16", InstructionSet.X86_AVXVNNIINT, true);
                    yield return new InstructionSetInfo("avxvnniint_v512", "AvxVnniInt16_V512", InstructionSet.X86_AVXVNNIINT_V512, true);
                    break;
            }
        }

        public void Set64BitInstructionSetVariants(TargetArchitecture architecture)
        {
            switch (architecture)
            {

                case TargetArchitecture.ARM64:
                    if (HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        AddInstructionSet(InstructionSet.ARM64_ArmBase_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        AddInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Aes))
                        AddInstructionSet(InstructionSet.ARM64_Aes_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Crc32))
                        AddInstructionSet(InstructionSet.ARM64_Crc32_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Dp))
                        AddInstructionSet(InstructionSet.ARM64_Dp_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Rdm))
                        AddInstructionSet(InstructionSet.ARM64_Rdm_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Sha1))
                        AddInstructionSet(InstructionSet.ARM64_Sha1_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Sha256))
                        AddInstructionSet(InstructionSet.ARM64_Sha256_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Sve))
                        AddInstructionSet(InstructionSet.ARM64_Sve_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Sve2))
                        AddInstructionSet(InstructionSet.ARM64_Sve2_Arm64);
                    break;

                case TargetArchitecture.RiscV64:
                    break;

                case TargetArchitecture.X64:
                    if (HasInstructionSet(InstructionSet.X64_X86Base))
                        AddInstructionSet(InstructionSet.X64_X86Base_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSE42))
                        AddInstructionSet(InstructionSet.X64_SSE42_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX))
                        AddInstructionSet(InstructionSet.X64_AVX_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX2))
                        AddInstructionSet(InstructionSet.X64_AVX2_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX512))
                        AddInstructionSet(InstructionSet.X64_AVX512_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX512v2))
                        AddInstructionSet(InstructionSet.X64_AVX512v2_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX512v3))
                        AddInstructionSet(InstructionSet.X64_AVX512v3_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX10v1))
                        AddInstructionSet(InstructionSet.X64_AVX10v1_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX10v2))
                        AddInstructionSet(InstructionSet.X64_AVX10v2_X64);
                    if (HasInstructionSet(InstructionSet.X64_AES))
                        AddInstructionSet(InstructionSet.X64_AES_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT))
                        AddInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVXIFMA))
                        AddInstructionSet(InstructionSet.X64_AVXIFMA_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVXVNNI))
                        AddInstructionSet(InstructionSet.X64_AVXVNNI_X64);
                    if (HasInstructionSet(InstructionSet.X64_GFNI))
                        AddInstructionSet(InstructionSet.X64_GFNI_X64);
                    if (HasInstructionSet(InstructionSet.X64_SHA))
                        AddInstructionSet(InstructionSet.X64_SHA_X64);
                    if (HasInstructionSet(InstructionSet.X64_WAITPKG))
                        AddInstructionSet(InstructionSet.X64_WAITPKG_X64);
                    if (HasInstructionSet(InstructionSet.X64_X86Serialize))
                        AddInstructionSet(InstructionSet.X64_X86Serialize_X64);
                    break;

                case TargetArchitecture.X86:
                    break;
            }
        }

        public void Set64BitInstructionSetVariantsUnconditionally(TargetArchitecture architecture)
        {
            switch (architecture)
            {

                case TargetArchitecture.ARM64:
                    AddInstructionSet(InstructionSet.ARM64_ArmBase_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Aes_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Crc32_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Dp_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Rdm_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Sha1_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Sha256_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Sve_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Sve2_Arm64);
                    break;

                case TargetArchitecture.RiscV64:
                    break;

                case TargetArchitecture.X64:
                    AddInstructionSet(InstructionSet.X64_X86Base_X64);
                    AddInstructionSet(InstructionSet.X64_SSE42_X64);
                    AddInstructionSet(InstructionSet.X64_AVX_X64);
                    AddInstructionSet(InstructionSet.X64_AVX2_X64);
                    AddInstructionSet(InstructionSet.X64_AVX512_X64);
                    AddInstructionSet(InstructionSet.X64_AVX512v2_X64);
                    AddInstructionSet(InstructionSet.X64_AVX512v3_X64);
                    AddInstructionSet(InstructionSet.X64_AVX10v1_X64);
                    AddInstructionSet(InstructionSet.X64_AVX10v2_X64);
                    AddInstructionSet(InstructionSet.X64_AES_X64);
                    AddInstructionSet(InstructionSet.X64_AVX512VP2INTERSECT_X64);
                    AddInstructionSet(InstructionSet.X64_AVXIFMA_X64);
                    AddInstructionSet(InstructionSet.X64_AVXVNNI_X64);
                    AddInstructionSet(InstructionSet.X64_GFNI_X64);
                    AddInstructionSet(InstructionSet.X64_SHA_X64);
                    AddInstructionSet(InstructionSet.X64_WAITPKG_X64);
                    AddInstructionSet(InstructionSet.X64_X86Serialize_X64);
                    break;

                case TargetArchitecture.X86:
                    AddInstructionSet(InstructionSet.X86_X86Base_X64);
                    AddInstructionSet(InstructionSet.X86_SSE42_X64);
                    AddInstructionSet(InstructionSet.X86_AVX_X64);
                    AddInstructionSet(InstructionSet.X86_AVX2_X64);
                    AddInstructionSet(InstructionSet.X86_AVX512_X64);
                    AddInstructionSet(InstructionSet.X86_AVX512v2_X64);
                    AddInstructionSet(InstructionSet.X86_AVX512v3_X64);
                    AddInstructionSet(InstructionSet.X86_AVX10v1_X64);
                    AddInstructionSet(InstructionSet.X86_AVX10v2_X64);
                    AddInstructionSet(InstructionSet.X86_AES_X64);
                    AddInstructionSet(InstructionSet.X86_AVX512VP2INTERSECT_X64);
                    AddInstructionSet(InstructionSet.X86_AVXIFMA_X64);
                    AddInstructionSet(InstructionSet.X86_AVXVNNI_X64);
                    AddInstructionSet(InstructionSet.X86_GFNI_X64);
                    AddInstructionSet(InstructionSet.X86_SHA_X64);
                    AddInstructionSet(InstructionSet.X86_WAITPKG_X64);
                    AddInstructionSet(InstructionSet.X86_X86Serialize_X64);
                    break;
            }
        }
    }
    public static class InstructionSetParser
    {
        public static InstructionSet LookupPlatformIntrinsicInstructionSet(TargetArchitecture targetArch, TypeDesc intrinsicType)
        {
            MetadataType metadataType = intrinsicType.GetTypeDefinition() as MetadataType;
            if (metadataType == null)
                return InstructionSet.ILLEGAL;

            string namespaceName = metadataType.Namespace;
            string typeName = metadataType.Name;
            string nestedTypeName = null;
            while (metadataType.ContainingType != null)
            {
                var enclosingType = (MetadataType)metadataType.ContainingType;
                namespaceName = enclosingType.Namespace;
                nestedTypeName = nestedTypeName is null ? metadataType.Name : $"{metadataType.Name}_{nestedTypeName}";
                typeName = enclosingType.Name;
                metadataType = enclosingType;
            }

            string platformIntrinsicNamespace;

            switch (targetArch)
            {
                case TargetArchitecture.ARM64:
                    platformIntrinsicNamespace = "System.Runtime.Intrinsics.Arm";
                    break;

                case TargetArchitecture.X64:
                case TargetArchitecture.X86:
                    platformIntrinsicNamespace = "System.Runtime.Intrinsics.X86";
                    break;

                default:
                    return InstructionSet.ILLEGAL;
            }

            if (namespaceName != platformIntrinsicNamespace)
                return InstructionSet.ILLEGAL;

            switch (targetArch)
            {

                case TargetArchitecture.ARM64:
                switch (typeName)
                {

                    case "ArmBase":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_ArmBase_Arm64; }
                        else
                        { return InstructionSet.ARM64_ArmBase; }

                    case "AdvSimd":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_AdvSimd_Arm64; }
                        else
                        { return InstructionSet.ARM64_AdvSimd; }

                    case "Aes":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Aes_Arm64; }
                        else
                        { return InstructionSet.ARM64_Aes; }

                    case "Crc32":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Crc32_Arm64; }
                        else
                        { return InstructionSet.ARM64_Crc32; }

                    case "Dp":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Dp_Arm64; }
                        else
                        { return InstructionSet.ARM64_Dp; }

                    case "Rdm":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Rdm_Arm64; }
                        else
                        { return InstructionSet.ARM64_Rdm; }

                    case "Sha1":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Sha1_Arm64; }
                        else
                        { return InstructionSet.ARM64_Sha1; }

                    case "Sha256":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Sha256_Arm64; }
                        else
                        { return InstructionSet.ARM64_Sha256; }

                    case "VectorT128":
                        { return InstructionSet.ARM64_VectorT128; }

                    case "Sve":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Sve_Arm64; }
                        else
                        { return InstructionSet.ARM64_Sve; }

                    case "Sve2":
                        if (nestedTypeName == "Arm64")
                        { return InstructionSet.ARM64_Sve2_Arm64; }
                        else
                        { return InstructionSet.ARM64_Sve2; }

                }
                break;

                case TargetArchitecture.RiscV64:
                switch (typeName)
                {

                    case "RiscV64Base":
                        { return InstructionSet.RiscV64_RiscV64Base; }

                    case "Zba":
                        { return InstructionSet.RiscV64_Zba; }

                    case "Zbb":
                        { return InstructionSet.RiscV64_Zbb; }

                }
                break;

                case TargetArchitecture.X64:
                switch (typeName)
                {

                    case "X86Base":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_X86Base_X64; }
                        else
                        { return InstructionSet.X64_X86Base; }

                    case "Sse":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_X86Base_X64; }
                        else
                        { return InstructionSet.X64_X86Base; }

                    case "Sse2":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_X86Base_X64; }
                        else
                        { return InstructionSet.X64_X86Base; }

                    case "Sse42":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_SSE42_X64; }
                        else
                        { return InstructionSet.X64_SSE42; }

                    case "Sse3":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_SSE42_X64; }
                        else
                        { return InstructionSet.X64_SSE42; }

                    case "Ssse3":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_SSE42_X64; }
                        else
                        { return InstructionSet.X64_SSE42; }

                    case "Sse41":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_SSE42_X64; }
                        else
                        { return InstructionSet.X64_SSE42; }

                    case "Popcnt":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_SSE42_X64; }
                        else
                        { return InstructionSet.X64_SSE42; }

                    case "Avx":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX_X64; }
                        else
                        { return InstructionSet.X64_AVX; }

                    case "Avx2":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX2_X64; }
                        else
                        { return InstructionSet.X64_AVX2; }

                    case "Bmi1":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX2_X64; }
                        else
                        { return InstructionSet.X64_AVX2; }

                    case "Bmi2":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX2_X64; }
                        else
                        { return InstructionSet.X64_AVX2; }

                    case "F16C":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX2_X64; }
                        else
                        { return InstructionSet.X64_AVX2; }

                    case "Fma":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX2_X64; }
                        else
                        { return InstructionSet.X64_AVX2; }

                    case "Lzcnt":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX2_X64; }
                        else
                        { return InstructionSet.X64_AVX2; }

                    case "Avx512F":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512; }
                        else
                        { return InstructionSet.X64_AVX512; }

                    case "Avx512BW":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512; }
                        else
                        { return InstructionSet.X64_AVX512; }

                    case "Avx512CD":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512; }
                        else
                        { return InstructionSet.X64_AVX512; }

                    case "Avx512DQ":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512; }
                        else
                        { return InstructionSet.X64_AVX512; }

                    case "Avx512Vbmi":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512v2_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512v2_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512v2; }
                        else
                        { return InstructionSet.X64_AVX512v2; }

                    case "Avx512Bitalg":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512v3_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512v3_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512v3; }
                        else
                        { return InstructionSet.X64_AVX512v3; }

                    case "Avx512Vbmi2":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512v3_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512v3_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512v3; }
                        else
                        { return InstructionSet.X64_AVX512v3; }

                    case "Avx512Vpopcntdq":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512v3_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512v3_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512v3; }
                        else
                        { return InstructionSet.X64_AVX512v3; }

                    case "Avx512Bf16":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX10v1_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX10v1_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX10v1; }
                        else
                        { return InstructionSet.X64_AVX10v1; }

                    case "Avx512Fp16":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX10v1_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX10v1_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX10v1; }
                        else
                        { return InstructionSet.X64_AVX10v1; }

                    case "Avx10v1":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX10v1_X64; }
                        else
                        if (nestedTypeName == "V512_X64")
                        { return InstructionSet.X64_AVX10v1_X64; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_AVX10v1; }
                        else
                        { return InstructionSet.X64_AVX10v1; }

                    case "Avx10v2":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX10v2_X64; }
                        else
                        if (nestedTypeName == "V512_X64")
                        { return InstructionSet.X64_AVX10v2_X64; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_AVX10v2; }
                        else
                        { return InstructionSet.X64_AVX10v2; }

                    case "Aes":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AES_X64; }
                        else
                        if (nestedTypeName == "V256")
                        { return InstructionSet.X64_AES_V256; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_AES_V512; }
                        else
                        { return InstructionSet.X64_AES; }

                    case "Pclmulqdq":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AES_X64; }
                        else
                        if (nestedTypeName == "V256")
                        { return InstructionSet.X64_AES_V256; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_AES_V512; }
                        else
                        { return InstructionSet.X64_AES; }

                    case "Avx512Vp2intersect":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVX512VP2INTERSECT_X64; }
                        else
                        if (nestedTypeName == "VL_X64")
                        { return InstructionSet.X64_AVX512VP2INTERSECT_X64; }
                        else
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X64_AVX512VP2INTERSECT; }
                        else
                        { return InstructionSet.X64_AVX512VP2INTERSECT; }

                    case "AvxIfma":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVXIFMA_X64; }
                        else
                        { return InstructionSet.X64_AVXIFMA; }

                    case "AvxVnni":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_AVXVNNI_X64; }
                        else
                        { return InstructionSet.X64_AVXVNNI; }

                    case "Gfni":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_GFNI_X64; }
                        else
                        if (nestedTypeName == "V256")
                        { return InstructionSet.X64_GFNI_V256; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_GFNI_V512; }
                        else
                        { return InstructionSet.X64_GFNI; }

                    case "Sha":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_SHA_X64; }
                        else
                        { return InstructionSet.X64_SHA; }

                    case "WaitPkg":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_WAITPKG_X64; }
                        else
                        { return InstructionSet.X64_WAITPKG; }

                    case "X86Serialize":
                        if (nestedTypeName == "X64")
                        { return InstructionSet.X64_X86Serialize_X64; }
                        else
                        { return InstructionSet.X64_X86Serialize; }

                    case "AvxVnniInt8":
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_AVXVNNIINT_V512; }
                        else
                        { return InstructionSet.X64_AVXVNNIINT; }

                    case "AvxVnniInt16":
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X64_AVXVNNIINT_V512; }
                        else
                        { return InstructionSet.X64_AVXVNNIINT; }

                }
                break;

                case TargetArchitecture.X86:
                switch (typeName)
                {

                    case "X86Base":
                        { return InstructionSet.X86_X86Base; }

                    case "Sse":
                        { return InstructionSet.X86_X86Base; }

                    case "Sse2":
                        { return InstructionSet.X86_X86Base; }

                    case "Sse42":
                        { return InstructionSet.X86_SSE42; }

                    case "Sse3":
                        { return InstructionSet.X86_SSE42; }

                    case "Ssse3":
                        { return InstructionSet.X86_SSE42; }

                    case "Sse41":
                        { return InstructionSet.X86_SSE42; }

                    case "Popcnt":
                        { return InstructionSet.X86_SSE42; }

                    case "Avx":
                        { return InstructionSet.X86_AVX; }

                    case "Avx2":
                        { return InstructionSet.X86_AVX2; }

                    case "Bmi1":
                        { return InstructionSet.X86_AVX2; }

                    case "Bmi2":
                        { return InstructionSet.X86_AVX2; }

                    case "F16C":
                        { return InstructionSet.X86_AVX2; }

                    case "Fma":
                        { return InstructionSet.X86_AVX2; }

                    case "Lzcnt":
                        { return InstructionSet.X86_AVX2; }

                    case "Avx512F":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512; }
                        else
                        { return InstructionSet.X86_AVX512; }

                    case "Avx512BW":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512; }
                        else
                        { return InstructionSet.X86_AVX512; }

                    case "Avx512CD":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512; }
                        else
                        { return InstructionSet.X86_AVX512; }

                    case "Avx512DQ":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512; }
                        else
                        { return InstructionSet.X86_AVX512; }

                    case "Avx512Vbmi":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512v2; }
                        else
                        { return InstructionSet.X86_AVX512v2; }

                    case "Avx512Bitalg":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512v3; }
                        else
                        { return InstructionSet.X86_AVX512v3; }

                    case "Avx512Vbmi2":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512v3; }
                        else
                        { return InstructionSet.X86_AVX512v3; }

                    case "Avx512Vpopcntdq":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512v3; }
                        else
                        { return InstructionSet.X86_AVX512v3; }

                    case "Avx512Bf16":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX10v1; }
                        else
                        { return InstructionSet.X86_AVX10v1; }

                    case "Avx512Fp16":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX10v1; }
                        else
                        { return InstructionSet.X86_AVX10v1; }

                    case "Avx10v1":
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_AVX10v1; }
                        else
                        { return InstructionSet.X86_AVX10v1; }

                    case "Avx10v2":
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_AVX10v2; }
                        else
                        { return InstructionSet.X86_AVX10v2; }

                    case "Aes":
                        if (nestedTypeName == "V256")
                        { return InstructionSet.X86_AES_V256; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_AES_V512; }
                        else
                        { return InstructionSet.X86_AES; }

                    case "Pclmulqdq":
                        if (nestedTypeName == "V256")
                        { return InstructionSet.X86_AES_V256; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_AES_V512; }
                        else
                        { return InstructionSet.X86_AES; }

                    case "Avx512Vp2intersect":
                        if (nestedTypeName == "VL")
                        { return InstructionSet.X86_AVX512VP2INTERSECT; }
                        else
                        { return InstructionSet.X86_AVX512VP2INTERSECT; }

                    case "AvxIfma":
                        { return InstructionSet.X86_AVXIFMA; }

                    case "AvxVnni":
                        { return InstructionSet.X86_AVXVNNI; }

                    case "Gfni":
                        if (nestedTypeName == "V256")
                        { return InstructionSet.X86_GFNI_V256; }
                        else
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_GFNI_V512; }
                        else
                        { return InstructionSet.X86_GFNI; }

                    case "Sha":
                        { return InstructionSet.X86_SHA; }

                    case "WaitPkg":
                        { return InstructionSet.X86_WAITPKG; }

                    case "X86Serialize":
                        { return InstructionSet.X86_X86Serialize; }

                    case "AvxVnniInt8":
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_AVXVNNIINT_V512; }
                        else
                        { return InstructionSet.X86_AVXVNNIINT; }

                    case "AvxVnniInt16":
                        if (nestedTypeName == "V512")
                        { return InstructionSet.X86_AVXVNNIINT_V512; }
                        else
                        { return InstructionSet.X86_AVXVNNIINT; }

                }
                break;

            }
            return InstructionSet.ILLEGAL;
        }
    }
}
