import argparse
from typing import Any, Optional, Tuple, List, Generator, Dict

def find_locale_dir(): ...

TRANSLATION_CATALOG: Any
MODULE_NAME: Any
LOGGER: Any
VERSION: Any
PROJECT_URL: str
STANDARD_BAG_INFO_HEADERS: Any
CHECKSUM_ALGOS: Any
DEFAULT_CHECKSUMS: Any
HASH_BLOCK_SIZE: Any
open_text_file: Any
UNICODE_BYTE_ORDER_MARK: str

def make_bag(bag_dir: Any, bag_info: Optional[Any] = ..., processes: int = ..., checksums: Optional[Any] = ..., checksum: Optional[Any] = ..., encoding: str = ...): ...

class Bag:
    valid_files: Any = ...
    valid_directories: Any = ...
    tags: Any = ...
    info: Dict[str, str] = ...
    entries: Any = ...
    normalized_filesystem_names: Any = ...
    normalized_manifest_names: Any = ...
    algorithms: Any = ...
    tag_file_name: Any = ...
    path: Any = ...
    def __init__(self, path: Optional[Any] = ...) -> None: ...
    @property
    def algs(self): ...
    @property
    def version(self): ...
    def manifest_files(self) -> None: ...
    def tagmanifest_files(self) -> None: ...
    def compare_manifests_with_fs(self) -> Tuple[List[str], List[str]]: ...
    def compare_fetch_with_fs(self): ...
    def payload_files(self) -> None: ...
    def payload_entries(self): ...
    def save(self, processes: int = ..., manifests: bool = ...) -> None: ...
    def tagfile_entries(self): ...
    def missing_optional_tagfiles(self) -> Generator[str, None, None]: ...
    def fetch_entries(self) -> None: ...
    def files_to_be_fetched(self) -> None: ...
    def has_oxum(self) -> bool: ...
    def validate(self, processes: int = ..., fast: bool = ..., completeness_only: bool = ...): ...
    def is_valid(self, fast: bool = ..., completeness_only: bool = ...): ...
    def validate_fetch(self) -> None: ...

class BagError(Exception): ...

class BagValidationError(BagError):
    message: Any = ...
    details: Any = ...
    def __init__(self, message: Any, details: Optional[Any] = ...) -> None: ...

class ManifestErrorDetail(BagError):
    path: Any = ...
    def __init__(self, path: Any) -> None: ...

class ChecksumMismatch(ManifestErrorDetail):
    path: Any = ...
    algorithm: Any = ...
    expected: Any = ...
    found: Any = ...
    def __init__(self, path: Any, algorithm: Optional[Any] = ..., expected: Optional[Any] = ..., found: Optional[Any] = ...) -> None: ...

class FileMissing(ManifestErrorDetail): ...
class UnexpectedFile(ManifestErrorDetail): ...

class FileNormalizationConflict(BagError):
    file_a: Any = ...
    file_b: Any = ...
    def __init__(self, file_a: Any, file_b: Any) -> None: ...

def posix_multiprocessing_worker_initializer() -> None: ...
def normalize_unicode_py3(s: Any): ...
def normalize_unicode_py2(s: Any): ...
normalize_unicode = normalize_unicode_py3

def build_unicode_normalized_lookup_dict(filenames: Any): ...
def get_hashers(algorithms: Any): ...
def make_manifests(data_dir: Any, processes: Any, algorithms: Any = ..., encoding: str = ...): ...
def generate_manifest_lines(filename: Any, algorithms: Any = ...): ...
def force_unicode_py2(s: Any): ...
force_unicode = str

class BagArgumentParser(argparse.ArgumentParser):
    bag_info: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...

class BagHeaderAction(argparse.Action):
    def __call__(self, parser: Any, _: Any, values: Any, option_string: Optional[Any] = ...) -> None: ...

def main() -> None: ...
