/* $Id: hawki_dfs.h,v 1.58 2013-03-25 11:35:07 cgarcia Exp $
 *
 * This file is part of the HAWKI Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-03-25 11:35:07 $
 * $Revision: 1.58 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HAWKI_DFS_H
#define HAWKI_DFS_H

/*-----------------------------------------------------------------------------
   								Define
 -----------------------------------------------------------------------------*/

/******************************************/
/* DEFINE HERE THE DIFFERENT COLUMN NAMES */
/******************************************/
#define HAWKI_COL_RAW_JITTER_QC_TEL_ALT               "TEL_ALT"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AZ                "TEL_AZ"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_RHUM         "TEL_AMBI_RHUM"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_TAU0         "TEL_AMBI_TAU0"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_TEMP         "TEL_AMBI_TEMP"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_WINDDIR      "TEL_AMBI_WINDDIR"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_WINDSP       "TEL_AMBI_WINDSP"
#define HAWKI_COL_RAW_JITTER_QC_TEL_IA_FWHM           "TEL_IA_FWHM"
#define HAWKI_COL_RAW_JITTER_QC_ADA_ABSROT_START      "ADA_ABSROT_START"
#define HAWKI_COL_RAW_JITTER_QC_ADA_ABSROT_END        "ADA_ABSROT_END"
#define HAWKI_COL_RAW_JITTER_QC_ADA_ABSROT_DELTA      "ADA_ABSROT_DELTA"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AIRM_START        "TEL_AIRM_START"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AIRM_END          "TEL_AIRM_END"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AIRM              "TEL_AIRM"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_FWHM_START   "TEL_AMBI_FWHM_START"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_FWHM_END     "TEL_AMBI_FWHM_END"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_FWHM         "TEL_AMBI_FWHM"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_PRES_START   "TEL_AMBI_PRES_START"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_PRES_END     "TEL_AMBI_PRES_END"
#define HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_PRES         "TEL_AMBI_PRES"
#define HAWKI_COL_RAW_JITTER_QC_TEL_PARANG_START      "TEL_PARANG_START"
#define HAWKI_COL_RAW_JITTER_QC_TEL_PARANG_END        "TEL_PARANG_END"
#define HAWKI_COL_RAW_JITTER_QC_TEL_PARANG            "TEL_PARANG"
#define HAWKI_COL_RAW_JITTER_QC_TEL_PARANG_DELTA      "TEL_PARANG_DELTA"
#define HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETA        "SEQ_CUMOFFSETA"
#define HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETD        "SEQ_CUMOFFSETD"
#define HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETX        "SEQ_CUMOFFSETX"
#define HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETY        "SEQ_CUMOFFSETY"

#define HAWKI_COL_STAT_MIN     "MINIMUM"
#define HAWKI_COL_STAT_MAX     "MAXIMUM"
#define HAWKI_COL_STAT_MED     "MEDIAN"
#define HAWKI_COL_STAT_MEAN    "MEAN"
#define HAWKI_COL_STAT_RMS     "RMS"
#define HAWKI_COL_STAT_USED    "USED"

#define HAWKI_COL_ZPOINT_MAG          "MAG"
#define HAWKI_COL_ZPOINT_STARNAME     "STARNAME"
#define HAWKI_COL_ZPOINT_CHIP         "CHIP"
#define HAWKI_COL_ZPOINT_ERRMAG       "MAG_ERR"
#define HAWKI_COL_ZPOINT_FILTER       "FILTER"
#define HAWKI_COL_ZPOINT_AIRMASS      "AIRMASS"
#define HAWKI_COL_ZPOINT_POSX         "POSX"
#define HAWKI_COL_ZPOINT_POSY         "POSY"
#define HAWKI_COL_ZPOINT_ZPOINT       "ZPOINT"
#define HAWKI_COL_ZPOINT_ZPOINT_ERR   "ZPOINT_ERR"
#define HAWKI_COL_ZPOINT_ATX0         "ATX0"
#define HAWKI_COL_ZPOINT_FLUX         "FLUX"
#define HAWKI_COL_ZPOINT_FLUX_ERR     "FLUX_ERR"
#define HAWKI_COL_ZPOINT_INSTRMAG     "INSTRMAG"
#define HAWKI_COL_ZPOINT_INSTRMAG_ERR "INSTRMAG_ERR"
#define HAWKI_COL_ZPOINT_PEAK         "PEAK"
#define HAWKI_COL_ZPOINT_BGD          "BGD"
#define HAWKI_COL_ZPOINT_FWHMX        "FWHMX"
#define HAWKI_COL_ZPOINT_FWHMY        "FWHMY"
#define HAWKI_COL_ZPOINT_FWHM         "FWHM"
#define HAWKI_COL_ZPOINT_FWHMX_AS     "FWHMX_AS"
#define HAWKI_COL_ZPOINT_FWHMY_AS     "FWHMY_AS"
#define HAWKI_COL_ZPOINT_FWHM_AS      "FWHM_AS"
#define HAWKI_COL_ZPOINT_STARMAG      "STAR_CAT_MAG"

#define HAWKI_COL_PHOT_FILTER       "FILTER"
#define HAWKI_COL_PHOT_EXTCOEFF     "EXT"
#define HAWKI_COL_PHOT_DEXTCOEFF    "DEXT"
#define HAWKI_COL_PHOT_ZEROPOINT    "ZPOINT"
#define HAWKI_COL_PHOT_DZEROPOINT   "DZPOINT"
#define HAWKI_COL_PHOT_COLORTERM    "COL"
#define HAWKI_COL_PHOT_DCOLORTERM   "DCOL"

#define HAWKI_COL_OBJ_POSX          "POS_X"
#define HAWKI_COL_OBJ_POSY          "POS_Y"
#define HAWKI_COL_OBJ_FWHM_MAJAX    "FWHM_MAJAX"
#define HAWKI_COL_OBJ_FWHM_MINAX    "FWHM_MINAX"
#define HAWKI_COL_OBJ_ELLIP         "ELLIP"
#define HAWKI_COL_OBJ_ANGLE         "ANGLE"
#define HAWKI_COL_OBJ_FLUX          "FLUX"

#define HAWKI_COL_ILLUM_POSX        "POSX"
#define HAWKI_COL_ILLUM_POSY        "POSY"
#define HAWKI_COL_ILLUM_FLUX        "FLUX"

#define HAWKI_COL_DIST_DXGC         "DXGC"
#define HAWKI_COL_DIST_DYGC         "DYGC"
#define HAWKI_COL_DIST_I            "I"
#define HAWKI_COL_DIST_J            "J"

#define HAWKI_COL_OFFSET_X          "X_OFFSET"
#define HAWKI_COL_OFFSET_Y          "Y_OFFSET"
#define HAWKI_COL_CORRELATION       "CORRELATION"

#define HAWKI_COL_2MASS_RA          "RA"
#define HAWKI_COL_2MASS_DEC         "Dec"
#define HAWKI_COL_2MASS_J_MAG       "j_m"
#define HAWKI_COL_2MASS_J_MAGSIG    "j_msig"
#define HAWKI_COL_2MASS_H_MAG       "h_m"
#define HAWKI_COL_2MASS_H_MAGSIG    "h_msig"
#define HAWKI_COL_2MASS_K_MAG       "k_m"
#define HAWKI_COL_2MASS_K_MAGSIG    "k_msig"
#define HAWKI_COL_2MASS_XPREDICT    "xpredict"
#define HAWKI_COL_2MASS_YPREDICT    "ypredict"

#define HAWKI_COL_MATCHING_SETS     "MATCHING_SETS"

/*************************************/
/* DEFINE HERE THE PRO.CATG KEYWORDS */

/* Type HAWKI_PROTYPE_COMBINED */
#define HAWKI_CALPRO_COMBINED                "COMBINED"

/* Type HAWKI_PROTYPE_COMB_CONTRIB_MAP */
#define HAWKI_CALPRO_COMB_CONTRIB_MAP        "COMBINED_CONTRIB_MAP"

/* Type HAWKI_PROTYPE_STITCHED */
#define HAWKI_CALPRO_STITCHED                "STITCHED"

/* Type HAWKI_PROTYPE_DIST_CORRECTED */
#define HAWKI_CALPRO_DIST_CORRECTED          "DIST_CORRECTED"

/* Type HAWKI_PROTYPE_ILLUM */
#define HAWKI_CALPRO_ILLUM                   "ILLUM"

/* Type HAWKI_PROTYPE_BKGIMAGE */
#define HAWKI_CALPRO_BKGIMAGE                "BKG_IM"

/* Type HAWKI_PROTYPE_BKGBPM */
#define HAWKI_CALPRO_BKGBPM                  "BKG_BPM"

/* Type HAWKI_PROTYPE_OBJ_PARAM */
#define HAWKI_CALPRO_OBJ_PARAM               "OBJ_PARAM"

/* Type HAWKI_PROTYPE_OBJ_MASK */
#define HAWKI_CALPRO_OBJ_MASK                "OBJ_MASK"

/* Type HAWKI_PROTYPE_SCIENCE_PCS */
#define HAWKI_CALPRO_SCIENCE_PCS             "SCIENCE_PCS"

/* Type HAWKI_PROTYPE_ERRMAP */
#define HAWKI_CALPRO_FLAT_ERRMAP             "FLAT_ERRMAP"

/* Type HAWKI_PROTYPE_BPM */
#define HAWKI_CALPRO_BPM                     "BPM"
#define HAWKI_CALPRO_BPM_HOT                 "BPM_HOT"
#define HAWKI_CALPRO_BPM_COLD                "BPM_COLD"

/* Type HAWKI_PROTYPE_FLAT */
#define HAWKI_CALPRO_FLAT                    "FLAT_IM"
#define HAWKI_CALPRO_FLAT_ERR                "FLAT_ERR"
#define HAWKI_CALPRO_FLAT_RECOMPUTED         "FLAT_RECOMPUTED"

/* Type HAWKI_PROTYPE_DARK */
#define HAWKI_CALPRO_DARK                    "DARK_IM"

/* Type HAWKI_PROTYPE_DARK_ERR */
#define HAWKI_CALPRO_DARK_ERR                "DARK_ERR"

/* Type HAWKI_PROTYPE_ILLUM_PHOTOM */
#define HAWKI_CALPRO_ILLUM_PHOTOM            "ILLUM_PHOTOM"

/* Type HAWKI_PROTYPE_FLAT_STATS */
#define HAWKI_CALPRO_FLAT_STATS              "FLAT_STATS"

/* Type HAWKI_PROTYPE_FLAT_STATS_EVEN_COL */
#define HAWKI_CALPRO_FLAT_STATS_EVEN_COL     "FLAT_STATS_EVEN_COL"

/* Type HAWKI_PROTYPE_FLAT_STATS_ODD_COL */
#define HAWKI_CALPRO_FLAT_STATS_ODD_COL      "FLAT_STATS_ODD_COL"

/* Type HAWKI_PROTYPE_FLAT_STATS_EVEN_ROW */
#define HAWKI_CALPRO_FLAT_STATS_EVEN_ROW     "FLAT_STATS_EVEN_ROW"

/* Type HAWKI_PROTYPE_FLAT_STATS_ODD_ROW */
#define HAWKI_CALPRO_FLAT_STATS_ODD_ROW      "FLAT_STATS_ODD_ROW"

/* Type HAWKI_PROTYPE_DARK_STATS */
#define HAWKI_CALPRO_DARK_STATS              "DARK_STATS"

/* Type HAWKI_PROTYPE_ZPOINT_STATS */
#define HAWKI_CALPRO_ZPOINT_STATS            "ZPOINT_STATS"

/* Type HAWKI_PROTYPE_JITTER_STATS */
#define HAWKI_CALPRO_JITTER_STATS            "JITTER_STATS"

/* Type HAWKI_PROTYPE_JITTER_BKG_STATS */
#define HAWKI_CALPRO_JITTER_BKG_STATS        "BKG_STATS"

/* Type HAWKI_PROTYPE_STDSTARS */
#define HAWKI_CALPRO_STDSTARS                "STDSTARS_CATS"

/* Type HAWKI_PROTYPE_DISTORTION */
#define HAWKI_CALPRO_DISTORTION              "DISTORTION"

/* Type HAWKI_PROTYPE_DISTORTION_X */
#define HAWKI_CALPRO_DISTORTION_X            "DISTORTION_X"

/* Type HAWKI_PROTYPE_DISTORTION_Y */
#define HAWKI_CALPRO_DISTORTION_Y            "DISTORTION_Y"

/* Type HAWKI_PROTYPE_ZPOINT_TAB */
#define HAWKI_CALPRO_ZPOINT_TAB              "ZPOINT_RES"

/* Type HAWKI_PROTYPE_PHOT_TAB */
#define HAWKI_CALPRO_PHOT_TAB              "PHOT_COEFF"

/* Type HAWKI_PROTYPE_ZPOINT_IMA */
#define HAWKI_CALPRO_ZPOINT_IMA              "ZPOINT_IMA"

/* Type HAWKI_PROTYPE_COEFFS */
#define HAWKI_CALPRO_LINGAIN_LIN             "LINGAIN_LIN"
#define HAWKI_CALPRO_LINGAIN_GAIN            "LINGAIN_GAIN"
#define HAWKI_CALPRO_LINGAIN_COEFFS          "LINGAIN_COEFFS"
#define HAWKI_CALPRO_LINGAIN_BPM             "LINGAIN_BPM"
#define HAWKI_CALPRO_LINGAIN_CORR            "LINGAIN_CORR"
#define HAWKI_CALPRO_LINGAIN_DIFF            "LINGAIN_DIFF"

/* Type HAWKI_PROTYPE_BETSFOCUS */
#define HAWKI_CALPRO_BESTFOCUS               "BEST_FOCUS"

/* Type HAWKI_PROTYPE_BASICCALIBRATED */
#define HAWKI_CALPRO_BASICCALIBRATED         "BASIC_CALIBRATED"

/* Type HAWKI_PROTYPE_SKY_BASICCALIBRATED */
#define HAWKI_CALPRO_SKY_BASICCALIBRATED     "SKY_BASIC_CALIBRATED"

/* Type HAWKI_PROTYPE_BKG_SUBTRACTED */
#define HAWKI_CALPRO_BKG_SUBTRACTED          "BKG_SUBTRACTED"

/* Type HAWKI_PROTYPE_FILTERPOSCHECK_STATS */
#define HAWKI_CALPRO_FILTERPOSCHECK_STATS    "FILTERPOS_CHECK_STATS"

/* Type HAWKI_PROTYPE_OFFSETS */
#define HAWKI_CALPRO_OFFSETS                 "OFFSETS_REFINED"

/*************************************/

/*************************************/
/* DEFINE HERE THE PRO.TYPE KEYWORDS */
/* Images */
#define HAWKI_PROTYPE_BPM                      "BPM"
#define HAWKI_PROTYPE_DARK                     "DARK"
#define HAWKI_PROTYPE_DARK_ERR                 "DARK_ERR"
#define HAWKI_PROTYPE_FLAT                     "FLAT"
#define HAWKI_PROTYPE_ZPOINT_IMA               "ZPOINT_IMA"
#define HAWKI_PROTYPE_COMBINED                 "COMBINED"
#define HAWKI_PROTYPE_COMB_CONTRIB_MAP         "COMBINED_CONTRIB_MAP"
#define HAWKI_PROTYPE_STITCHED                 "STITCHED"
#define HAWKI_PROTYPE_ILLUM                    "ILLUM"
#define HAWKI_PROTYPE_DIST_CORRECTED           "DIST_CORRECTED"
#define HAWKI_PROTYPE_BKGIMAGE                 "BKG_IM"
#define HAWKI_PROTYPE_BKGBPM                   "BKG_BPM"
#define HAWKI_PROTYPE_ERRMAP                   "ERRMAP"
#define HAWKI_PROTYPE_BESTFOCUS                "BEST_FOCUS"
#define HAWKI_PROTYPE_BASICCALIBRATED          "BASIC_CALIBRATED"
#define HAWKI_PROTYPE_SKY_BASICCALIBRATED      "SKY_BASIC_CALIBRATED"
#define HAWKI_PROTYPE_BKG_SUBTRACTED           "BKG_SUBTRACTED"
#define HAWKI_PROTYPE_OBJ_MASK                 "OBJ_MASK"
#define HAWKI_PROTYPE_DISTORTION_X             "DISTORTION_X"
#define HAWKI_PROTYPE_DISTORTION_Y             "DISTORTION_Y"


/* Tables */
/* Col: HAWKI_COL_OBJ_POSX */
/*      HAWKI_COL_OBJ_POSY */
/*      HAWKI_COL_OBJ_FWHMX */
/*      HAWKI_COL_OBJ_FWHMY */
/*      HAWKI_COL_OBJ_ANGLE */
/*      HAWKI_COL_OBJ_FLUX */
#define HAWKI_PROTYPE_OBJ_PARAM                "OBJ_PARAM"

/* Col: HAWKI_COL_ILLUM_POSX */
/*      HAWKI_COL_ILLUM_POSY */
/*      HAWKI_COL_ILLUM_FLUX */
#define HAWKI_PROTYPE_ILLUM_PHOTOM             "ILLUM_PHOTOM"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_FLAT_STATS               "FLAT_STATS"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_FLAT_STATS_EVEN_COL      "FLAT_STATS_EVEN_COL"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_FLAT_STATS_ODD_COL       "FLAT_STATS_ODD_COL"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_FLAT_STATS_EVEN_ROW      "FLAT_STATS_EVEN_ROW"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_FLAT_STATS_ODD_ROW       "FLAT_STATS_ODD_ROW"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_DARK_STATS               "DARK_STATS"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_ZPOINT_STATS             "ZPOINT_STATS"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_JITTER_STATS             "JITTER_STATS"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_JITTER_BKG_STATS         "BKG_STATS"

/* Col: HAWKI_COL_STAT_MIN */
/*      HAWKI_COL_STAT_MAX */
/*      HAWKI_COL_STAT_MED */
/*      HAWKI_COL_STAT_RMS */
/*      HAWKI_COL_STAT_MEAN */
/*      HAWKI_COL_STAT_USED */
#define HAWKI_PROTYPE_FILTERPOSCHECK_STATS     "FILTERPOS_CHECK_STATS"

/* Col: IRPLIB_STDSTAR_STAR_COL */
/*      IRPLIB_STDSTAR_TYPE_COL */
/*      IRPLIB_STDSTAR_RA_COL */
/*      IRPLIB_STDSTAR_DEC_COL */
/*      Filters .... */
#define HAWKI_PROTYPE_STDSTARS                 "STDSTARS"

/* Col: HAWKI_COL_DIST_DXGC */
/*      HAWKI_COL_DIST_DYGC */
/*      HAWKI_COL_DIST_I */
/*      HAWKI_COL_DIST_J */
#define HAWKI_PROTYPE_DISTORTION               "DISTORTION"

/* Col: HAWKI_COL_ZPOINT_CHIP */
/*      HAWKI_COL_ZPOINT_POSX */
/*      HAWKI_COL_ZPOINT_POSY */
/*      HAWKI_COL_ZPOINT_ZPOINT */
/*      HAWKI_COL_ZPOINT_ATX0 */
/*      HAWKI_COL_ZPOINT_FLUX */
/*      HAWKI_COL_ZPOINT_PEAK */
/*      HAWKI_COL_ZPOINT_BGD */
/*      HAWKI_COL_ZPOINT_FWHMX */
/*      HAWKI_COL_ZPOINT_FWHMY */
/*      HAWKI_COL_ZPOINT_FWHM */
/*      HAWKI_COL_ZPOINT_FWHMX_AS */
/*      HAWKI_COL_ZPOINT_FWHMY_AS */
/*      HAWKI_COL_ZPOINT_FWHM_AS */
#define HAWKI_PROTYPE_ZPOINT_TAB               "ZPOINT_TAB"

/* Col: HAWKI_COL_PHOT_FILTER */
/*      HAWKI_COL_PHOT_EXTCOEFF  */
/*      HAWKI_COL_PHOT_DEXTCOEFF  */
/*      HAWKI_COL_PHOT_ZEROPOINT   */
/*      HAWKI_COL_PHOT_DZEROPOINT    */
/*      HAWKI_COL_PHOT_COLORTERM    */
/*      HAWKI_COL_PHOT_DCOLORTERM  */
#define HAWKI_PROTYPE_PHOT_TAB                 "PHOT_COEFF"

/* Col: HAWKI_COL_RAW_JITTER_QC_TEL_ALT */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AZ  */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_RHUM */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_TAU0 */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_TEMP */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_WINDDIR */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_WINDSP */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_IA_FWHM  */
/*      HAWKI_COL_RAW_JITTER_QC_ADA_ABSROT_START  */
/*      HAWKI_COL_RAW_JITTER_QC_ADA_ABSROT_END */
/*      HAWKI_COL_RAW_JITTER_QC_ADA_ABSROT_DELTA */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AIRM_START */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AIRM_END */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AIRM */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_FWHM_START */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_FWHM_END */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_FWHM */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_PRES_START */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_PRES_END */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_AMBI_PRES */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_PARANG_START */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_PARANG_END */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_PARANG */
/*      HAWKI_COL_RAW_JITTER_QC_TEL_PARANG_DELTA */
/*      HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETA */
/*      HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETD */
/*      HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETX */
/*      HAWKI_COL_RAW_JITTER_QC_SEQ_CUMOFFSETY */
#define HAWKI_PROTYPE_SCIENCE_PCS              "SCIENCE_PCS"

/*      HAWKI_COL_OFFSET_X */
/*      HAWKI_COL_OFFSET_Y */
/*      HAWKI_COL_CORRELATION */
#define HAWKI_PROTYPE_OFFSETS                  "OFFSETS_REFINED"

/* TODO: This is to be deprecated */
#define HAWKI_PROTYPE_COEFFS                   "COEFFS"

#define HAWKI_PROTYPE_LIN_STATS                "LIN_STATS"
#define HAWKI_PROTYPE_LIN_COEFFS               "LIN_COEFFS"
#define HAWKI_PROTYPE_GAIN_STATS               "GAIN_STATS"
#define HAWKI_PROTYPE_BPM_LEVELS               "BPM_LEVELS"
#define HAWKI_PROTYPE_LINGAIN_CORR             "LINGAIN_CORR"
#define HAWKI_PROTYPE_LINGAIN_DIFF             "LINGAIN_DIFF"



/************************************/

/************************************/
/* Define here the DO.CATG keywords */
#define HAWKI_COMMAND_LINE          "COMMAND_LINE"

#define HAWKI_CAL_DARK_RAW          "DARK"
#define HAWKI_TEC_FLAT_RAW          "TEC_FLAT"
#define HAWKI_CAL_FLAT_RAW          "FLAT"
#define HAWKI_CAL_FOCUS_RAW         "FOCUS"
#define HAWKI_CAL_ZPOINT_RAW        "ZPOINT"
#define HAWKI_CAL_ILLUM_RAW         "TEC_STD"
#define HAWKI_IMG_JITTER_RAW        "JITTER_OBS"
#define HAWKI_IMG_JITTER_SKY_RAW    "JITTER_SKY"
#define HAWKI_CAL_LINGAIN_LAMP_RAW  "DETLIN_LAMP"
#define HAWKI_CAL_LINGAIN_DARK_RAW  "DETLIN_DARK"
#define HAWKI_CAL_DISTOR_RAW        "DISTOR_OBS"
#define HAWKI_CAL_DISTOR_SKY_RAW    "DISTOR_SKY"

#define HAWKI_UTIL_STDSTARS_RAW     "STDSTAR_CAT"
#define HAWKI_UTIL_DISTMAP_RAW      "DIST_MAP"
#define HAWKI_UTIL_CAT_2MASS        "CAT_2MASS"
/************************************/

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
CPL_BEGIN_DECLS
int hawki_dfs_set_groups(cpl_frameset *) ;
CPL_END_DECLS

#endif
