----------------------------------------------------------------------------
-- |
-- Module      :  Main
-- Copyright   :  (c) Jan Vornberger 2009
-- License     :  BSD3-style (see LICENSE)
--
-- Maintainer  :  jan.vornberger@informatik.uni-oldenburg.de
-- Stability   :  unstable
-- Portability :  not portable
--
-----------------------------------------------------------------------------

module Main where

import Graphics.UI.Gtk
import System.Environment(getArgs,getProgName)

main :: IO ()
main = do
    args <- getArgs
    progName <- getProgName
    if length args /= 3
        then putStrLn $ "Usage: " ++ progName ++ " 0 0 65535"
        else let r = read $ args !! 0
                 g = read $ args !! 1
                 b = read $ args !! 2
             in showMockWin (Color r g b)

showMockWin :: Color -> IO ()
showMockWin c = do
    initGUI
    window <- windowNew
    onDestroy window mainQuit
    widgetModifyBg window StateNormal c
    widgetShowAll window
    mainGUI
