#!/usr/bin/perl
#
# Converts a bld dump printed by bldread to a zone file.
#
# Olivier Beyssac <obld@r14.freenix.org>
#

use Date::Format;
use strict;

my $domain = "FILLME";
my $ns0 = "FILLME";
my $ip0 = "FILLME";
my $ns1 = "FILLME";
my $ip1 = "FILLME";

my $date = time2str("%Y%m%d%H", time());

print <<EOF
\$TTL 1800
$domain. IN SOA $ns0. postmaster.$ns0 (
  $date
  21600
  7200
  3600000
  7200)

@ IN NS $ns0.
@ IN NS $ns1.
ns0 IN A $ip0
ns1 IN A $ip1

; Blacklist begins here
EOF
;

while (<>) {
    if (/^([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+);/) {
	print "$4.$3.$2.$1 IN A 127.0.0.1\n\t\tTXT \"Blacklisted by postmaster\@$domain\"\n";
    }
}
