/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Element;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class ElementFactory {
    private static String[] components = new String[]{"com.fluendo.plugin.HTTPSrc", "com.fluendo.plugin.VideoSink", "com.fluendo.plugin.AudioSinkJ2", "com.fluendo.plugin.AudioSinkSA", "com.fluendo.plugin.Queue", "com.fluendo.plugin.FakeSink", "com.fluendo.plugin.Overlay", "com.fluendo.plugin.Selector", "com.fluendo.plugin.OggDemux", "com.fluendo.plugin.TheoraDec", "com.fluendo.plugin.VorbisDec", "com.fluendo.plugin.KateDec", "com.fluendo.plugin.KateOverlay"};
    private static Vector elements = new Vector();

    static {
        ElementFactory.loadElements();
    }

    public static void loadElements() {
        try {
            int n = 0;
            while (n < components.length) {
                String string = components[n];
                try {
                    Class<?> clazz = Class.forName(string);
                    Debug.log(3, "registered plugin: " + string);
                    Element element = (Element)clazz.newInstance();
                    elements.addElement(element);
                }
                catch (Throwable throwable) {
                    Debug.log(3, "Failed to register plugin: " + string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final Element dup(Element element, String string) {
        Element element2 = null;
        Class<?> clazz = element.getClass();
        try {
            element2 = (Element)clazz.newInstance();
            if (element2 != null && string != null) {
                element2.setName(string);
            }
            Debug.log(3, "create element: " + element2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return element2;
    }

    private static final Element findTypeFind(byte[] byArray, int n, int n2) {
        int n3 = -1;
        Element element = null;
        Enumeration enumeration = elements.elements();
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            int n4 = element2.typeFind(byArray, n, n2);
            if (n4 <= n3) continue;
            n3 = n4;
            element = element2;
        }
        return element;
    }

    public static final String typeFindMime(byte[] byArray, int n, int n2) {
        String string = null;
        Element element = ElementFactory.findTypeFind(byArray, n, n2);
        if (element != null) {
            string = element.getMime();
        }
        return string;
    }

    public static final Element makeTypeFind(byte[] byArray, int n, int n2, String string) {
        Element element = null;
        element = ElementFactory.findTypeFind(byArray, n, n2);
        if (element != null) {
            element = ElementFactory.dup(element, string);
        }
        return element;
    }

    public static final Element makeByMime(String string, String string2) {
        Element element = null;
        Enumeration enumeration = elements.elements();
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            if (!string.equals(element2.getMime())) continue;
            element = ElementFactory.dup(element2, string2);
            break;
        }
        return element;
    }

    public static final Element makeByName(String string, String string2) {
        Element element = null;
        Enumeration enumeration = elements.elements();
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            if (!string.equals(element2.getFactoryName())) continue;
            element = ElementFactory.dup(element2, string2);
            break;
        }
        return element;
    }
}

