/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2025 UniPro <ugene@unipro.ru>
 * http://ugene.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "CoreLibConstants.h"

namespace U2 {

namespace Workflow {

const QString CoreLibConstants::READ_TEXT_PROTO_ID("read-text");
const QString CoreLibConstants::WRITE_TEXT_PROTO_ID("write-text");
const QString CoreLibConstants::WRITE_FASTA_PROTO_ID("write-fasta");
const QString CoreLibConstants::WRITE_GENBANK_PROTO_ID("write-genbank");
const QString CoreLibConstants::WRITE_CLUSTAL_PROTO_ID("write-clustalw");
const QString CoreLibConstants::WRITE_STOCKHOLM_PROTO_ID("write-stockholm");
const QString CoreLibConstants::WRITE_MSA_PROTO_ID("write-msa");
const QString CoreLibConstants::WRITE_SEQ_PROTO_ID("write-sequence");
const QString CoreLibConstants::WRITE_FASTQ_PROTO_ID("write-fastq");
const QString CoreLibConstants::GENERIC_READ_MA_PROTO_ID("read-msa");
const QString CoreLibConstants::GENERIC_READ_SEQ_PROTO_ID("read-sequence");
const QString CoreLibConstants::GROUPER_ID("grouper");

const QString CoreLibConstants::TEXT_TYPESET_ID("text.content");

const QString CoreLibConstants::WORKFLOW_ON_CLOUD_TASK_ID("cloud.workflow");
const QString CoreLibConstants::WORKFLOW_SCHEMA_ATTR("workflow.shema");
const QString CoreLibConstants::DATA_IN_ATTR("data.in");
const QString CoreLibConstants::DATA_OUT_ATTR("data.out");
const QString CoreLibConstants::GROUPER_SLOT_ATTR("group-slot");
const QString CoreLibConstants::GROUPER_OUT_SLOTS_ATTR("out-slot");
const QString CoreLibConstants::GROUPER_OPER_ATTR("group-op");

}  // namespace Workflow

}  // namespace U2
