#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dark Reign 2
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251113.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='dark-reign-2'
GAME_NAME='Dark Reign 2'

ARCHIVE_BASE_1_NAME='setup_dark_reign_2_1.3_(56283).exe'
ARCHIVE_BASE_1_MD5='23b441f1a8ffd5302e7cde3c1099cb73'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_VERSION='1.3.882-gog56283'
ARCHIVE_BASE_1_SIZE='572562'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/dark_reign_2'

ARCHIVE_BASE_0_NAME='setup_dark_reign2_2.0.0.11.exe'
ARCHIVE_BASE_0_MD5='9a3d10825507b73c4db178f9caea2406'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.3.882-gog2.0.0.11'
ARCHIVE_BASE_0_SIZE='450000'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
## dr2.exe requirements
CONTENT_LIBS_BIN_FILES='
binkw32.dll
mss32.dll'
## mss32.dll requirements
CONTENT_LIBS0_BIN_FILES='
_INMM.dll'
## _INMM.dll requirements
CONTENT_LIBS1_BIN_FILES='
libvorbisfile.dll'
## libvorbisfile.dll requirements
CONTENT_LIBS2_BIN_FILES='
libvorbis.dll'
CONTENT_GAME_BIN_FILES='
library/activision/tools.cat
library/won/kver.pub
library/engine/startup.cfg
library/engine/download.cfg
dr2.exe'
## launcher.exe is only provided with the 2.0.0.11 GOG build.
CONTENT_GAME_BIN_FILES_0="$CONTENT_GAME_BIN_FILES
launcher.exe"
CONTENT_GAME_DATA_FILES='
missions
mods
music
packs
sides
worlds'
CONTENT_DOC_DATA_FILES='
customer_support.htm
manual.pdf
readme.rtf
license.txt'

USER_PERSISTENT_DIRECTORIES='
mods
users'
USER_PERSISTENT_FILES='
settings.cfg'

## Without a virtual desktop, the profile creation/selection screen is badly rendered, making it unusable.
## (WINE 10.0)
WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='dr2.exe'
APP_MAIN_EXE_0='launcher.exe'
APP_MAIN_ICON='dr2.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Register the game CD-key.

REQUIREMENTS_LIST='
base64
xxd'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Extract and store the game CD-key.

cdkey_destination="$(package_path 'PKG_BIN')$(path_game_data)"
mkdir --parents "$cdkey_destination"
## The source is a base64-encoded string, that must be converted to an hexadecimal representation.
sed --silent --expression='71s/.*"valueData": "\(.*\)",/\1/p' \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/goggame-1207658911.script" |
	base64 --decode |
	xxd -plain \
	> "${cdkey_destination}/cdkey"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## - Register the game CD-key.
## - Install shipped libraries.
wineprefix_init_custom() {
	cat <<- 'EOF'
	# Register the game CD-key.
	cdkey=$(cat "${PATH_GAME_DATA}/cdkey")
	$(wine_command) reg add "HKLM\\Software\\WON\\CDKeys" /v "DarkReign2" /t REG_BINARY /d "$cdkey" /f
	EOF
	cat <<- EOF
	# Install shipped libraries.
	ln --force --symbolic $(path_libraries)/* "\${PATH_PREFIX}"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
