#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Lyne
# send your bug reports to contact@dotslashplay.it
###

script_version=20241224.3

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='lyne'
GAME_NAME='Lyne'

ARCHIVE_BASE_ITCH_0_NAME='LYNE_linux.zip'
ARCHIVE_BASE_ITCH_0_MD5='71ffe45ef87ce65c3f8b29987aa602db'
ARCHIVE_BASE_ITCH_0_SIZE='168723'
ARCHIVE_BASE_ITCH_0_VERSION='1.5.0-itch.2024.08.16'
ARCHIVE_BASE_ITCH_0_URL='https://thomasbowker.itch.io/lyne'

ARCHIVE_BASE_HUMBLE_0_NAME='LYNE_145_linux.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='85c9ca3cd3c7dda1d351c8ab0441d877'
ARCHIVE_BASE_HUMBLE_0_SIZE='142863'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.4.5-humble1'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/lyne'

ARCHIVE_BASE_HUMBLE_MULTIARCH_0_NAME='LYNE_120_lin.zip'
ARCHIVE_BASE_HUMBLE_MULTIARCH_0_MD5='f05951586a5b8cf42e20e0e6f04e65da'
ARCHIVE_BASE_HUMBLE_MULTIARCH_0_SIZE='110000'
ARCHIVE_BASE_HUMBLE_MULTIARCH_0_VERSION='1.2.0.30-humble171211'

UNITY3D_NAME='LYNE'
UNITY3D_PLUGINS_HUMBLE_MULTIARCH='
ScreenSelector.so'

CONTENT_PATH_DEFAULT_ITCH='.'
CONTENT_PATH_DEFAULT_HUMBLE='LYNE_145_lin'
CONTENT_PATH_DEFAULT_HUMBLE_MULTIARCH='LYNE_120_lin'
CONTENT_GAME0_BIN_FILES_ITCH='
LYNE.x64'
CONTENT_GAME0_BIN_FILES_HUMBLE_0='
LYNE.x64'
CONTENT_DOC_DATA_FILES='
readme.txt'

APP_MAIN_EXE_ITCH_0='LYNE.x64'
APP_MAIN_EXE_HUMBLE_0='LYNE.x64'
## Force windowed mode to prevent mouse input problems
APP_MAIN_OPTIONS='-screen-fullscreen 0'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'
PACKAGES_LIST_HUMBLE_MULTIARCH='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES_ITCH='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE_MULTIARCH='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES_HUMBLE_MULTIARCH="$PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE_MULTIARCH"
PKG_BIN32_DEPENDENCIES_LIBRARIES_HUMBLE_MULTIARCH="$PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE_MULTIARCH"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent the inclusion of Steam libraries
	case "$(current_archive)" in
		('ARCHIVE_BASE_HUMBLE_MULTIARCH_'*)
			# The multiarch archives rely on UNITY3D_PLUGINS to exclude unwanted libraries.
		;;
		(*)
			rm --recursive "$(unity3d_name)_Data/Plugins"
		;;
	esac
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

case "$(current_archive)" in
	('ARCHIVE_BASE_HUMBLE_MULTIARCH_'*)
		launchers_generation 'PKG_BIN64'
		launchers_generation 'PKG_BIN32'
	;;
	(*)
		launchers_generation 'PKG_BIN'
	;;
esac

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
