#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# Creepy Tale 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20230414.1

GAME_ID='creepy-tale-1'
GAME_NAME='Creepy Tale'

ARCHIVE_GOG='creepy_tale_english_1_0_2c_42446.sh'
ARCHIVE_GOG_URL='https://www.gog.com/game/creepy_tale'
ARCHIVE_GOG_MD5='727b15afedd0ef2e58565b40419e76de'
ARCHIVE_GOG_SIZE='190000'
ARCHIVE_GOG_VERSION='1.0.2c-gog42446'
ARCHIVE_GOG_TYPE='mojosetup'

ARCHIVE_GAME_BIN_PATH='data/noarch/game'
ARCHIVE_GAME_BIN_FILES='creepy_tale.x86_64 creepy_tale_Data/*/x86 LinuxPlayer_s.debug UnityPlayer_s.debug UnityPlayer.so'

ARCHIVE_GAME_DATA_PATH='data/noarch/game'
ARCHIVE_GAME_DATA_FILES='creepy_tale_Data'

DATA_DIRS='./logs'

APP_MAIN_TYPE='native'
# shellcheck disable=SC2016
# APP_MAIN_PRERUN='export LANG=C'
APP_MAIN_EXE='creepy_tale.x86_64'
# shellcheck disable=SC2016
APP_MAIN_OPTIONS='-logFile ./logs/$(date +%F-%R).log'
APP_MAIN_ICON='creepy_tale_Data/Resources/UnityPlayer.png'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID glibc"

# Ensure easy upgrade from packages generated with pre-20230414.1 game scripts

PKG_BIN_PROVIDE='creepy-tale'
PKG_DATA_PROVIDE='creepy-tale-data'

# Load common functions

target_version='2.12'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Get icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Clean up temporary directories

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
