/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_PhysicalAssetCapabilities.h"
#include "OpenDRIM_PhysicalAssetCapabilitiesAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderSetInstance PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderModifyInstance
#endif

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_init(const CMPIBroker* broker);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_PhysicalAssetCapabilities> instances;
	string errorMessage;
	
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_PhysicalAssetCapabilities> instances;
	string errorMessage;
	
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PhysicalAssetCapabilities instance;
	PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PhysicalAssetCapabilities newInstance, oldInstance;
	PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, ci, newInstance);
	PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PhysicalAssetCapabilities instance;
	PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PhysicalAssetCapabilities instance;
	PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PhysicalAssetCapabilities instance;
	PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"InstanceID"};
	int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="CreateGoalSettings") {
		unsigned short returnValue;
		OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_In inArgs;
		PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(_broker, in, inArgs);
		OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_Out outArgs;
		
		errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint16, CMPI_uint16);
	}
	else {
		errorMessage = (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_init FAILED: " + (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_unload FAILED: " + (string) OpenDRIM_PhysicalAssetCapabilities_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_INIT if (PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_init(_broker) < 0) return NULL

CMInstanceMIStub(PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider, PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider, _broker, PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_INIT);
CMMethodMIStub(PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider, PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider, _broker, PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
