/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CompositeFigureEvent;
import org.jhotdraw.draw.CompositeFigureListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public abstract class AbstractCompositeFigure
extends AbstractFigure
implements CompositeFigure {
    protected Layouter layouter;
    protected ArrayList<Figure> children = new ArrayList();
    protected transient Rectangle2D.Double cachedDrawingArea;
    protected transient Rectangle2D.Double cachedBounds;
    protected EventHandler eventHandler = this.createEventHandler();

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        if (n == 0) {
            linkedList.add(new BoundsOutlineHandle(this, true, false));
            TransformHandleKit.addScaleMoveTransformHandles(this, linkedList);
        }
        return linkedList;
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    @Override
    public boolean add(Figure figure) {
        this.add(this.getChildCount(), figure);
        return true;
    }

    @Override
    public void add(int n, Figure figure) {
        this.basicAdd(n, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
        this.fireFigureAdded(figure, n);
        this.invalidate();
    }

    public void addAll(Collection<? extends Figure> collection) {
        this.addAll(this.getChildCount(), collection);
    }

    public final void addAll(int n, Collection<? extends Figure> collection) {
        for (Figure figure : collection) {
            this.basicAdd(n++, figure);
            if (this.getDrawing() != null) {
                figure.addNotify(this.getDrawing());
            }
            this.fireFigureAdded(figure, n);
        }
        this.invalidate();
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getChildCount(), figure);
    }

    public void basicAddAll(int n, Collection<? extends Figure> collection) {
        for (Figure figure : collection) {
            this.basicAdd(n++, figure);
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        for (Figure figure : this.getChildren()) {
            figure.addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
        for (Figure figure : new LinkedList<Figure>(this.getChildren())) {
            figure.removeNotify(drawing);
        }
    }

    @Override
    public boolean remove(Figure figure) {
        int n = this.children.indexOf(figure);
        if (n == -1) {
            return false;
        }
        this.basicRemoveChild(n);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.fireFigureRemoved(figure, n);
        return true;
    }

    @Override
    public Figure removeChild(int n) {
        Figure figure = this.basicRemoveChild(n);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        return figure;
    }

    public void removeAll(Collection<? extends Figure> collection) {
        for (Figure figure : collection) {
            this.remove(figure);
        }
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        for (Figure figure : new LinkedList<Figure>(this.getChildren())) {
            if (this.getDrawing() != null) {
                figure.removeNotify(this.getDrawing());
            }
            int n = this.basicRemove(figure);
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        for (Figure figure : new LinkedList<Figure>(this.getChildren())) {
            this.basicRemove(figure);
        }
    }

    public void basicRemoveAll(Collection<? extends Figure> collection) {
        for (Figure figure : collection) {
            this.basicRemove(figure);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.basicRemove(figure) != -1) {
            this.basicAdd(0, figure);
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.basicRemove(figure) != -1) {
            this.basicAdd(figure);
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        for (Figure figure : this.getChildren()) {
            figure.transform(affineTransform);
        }
        this.invalidate();
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        Rectangle2D.Double double_3 = this.getBounds();
        Rectangle2D.Double double_4 = new Rectangle2D.Double(Math.min(double_.x, double_2.x), Math.min(double_.y, double_2.y), Math.abs(double_.x - double_2.x), Math.abs(double_.y - double_2.y));
        double d = double_4.width / double_3.width;
        double d2 = double_4.height / double_3.height;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-double_3.x, -double_3.y);
        if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2) || d == 1.0 && d2 == 1.0 || d < 1.0E-4 || d2 < 1.0E-4)) {
            this.transform(affineTransform);
            affineTransform.setToIdentity();
            affineTransform.scale(d, d2);
            this.transform(affineTransform);
            affineTransform.setToIdentity();
        }
        affineTransform.translate(double_4.x, double_4.y);
        this.transform(affineTransform);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children.size() == 0 ? new LinkedList() : new ReversedList<Figure>(this.getChildren());
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        for (Figure figure : this.getChildren()) {
            figure.set(attributeKey, t);
        }
        this.invalidate();
    }

    @Override
    public <T> T get(AttributeKey<T> attributeKey) {
        return null;
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>();
    }

    @Override
    public Object getAttributesRestoreData() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Figure figure : this.getChildren()) {
            linkedList.add(figure.getAttributesRestoreData());
        }
        return linkedList;
    }

    @Override
    public void restoreAttributesTo(Object object) {
        Iterator iterator = ((LinkedList)object).iterator();
        for (Figure figure : this.getChildren()) {
            figure.restoreAttributesTo(iterator.next());
        }
    }

    @Override
    public boolean contains(Figure figure) {
        return this.children.contains(figure);
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        if (this.get(AttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)this.get(AttributeKeys.TRANSFORM).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                InternalError internalError = new InternalError(noninvertibleTransformException.getMessage());
                internalError.initCause(noninvertibleTransformException);
                throw internalError;
            }
        }
        if (this.getDrawingArea().contains(double_)) {
            for (Figure figure : this.getChildrenFrontToBack()) {
                if (!figure.isVisible() || !figure.contains(double_)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        if (this.getDrawingArea().contains(double_)) {
            Figure figure = null;
            for (Figure figure2 : this.getChildrenFrontToBack()) {
                if (!figure2.isVisible() || (figure = figure2.findFigureInside(double_)) == null) continue;
                return figure;
            }
        }
        return null;
    }

    public Figure findChild(Point2D.Double double_) {
        if (this.getBounds().contains(double_)) {
            Object var2_2 = null;
            for (Figure figure : this.getChildrenFrontToBack()) {
                if (!figure.isVisible() || !figure.contains(double_)) continue;
                return figure;
            }
        }
        return null;
    }

    public int findChildIndex(Point2D.Double double_) {
        Figure figure = this.findChild(double_);
        return figure == null ? -1 : this.children.indexOf(figure);
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double double_ = this.getBounds();
            Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
            Rectangle2D.Double double_3 = this.getLayouter().layout(this, double_2, double_2);
            this.setBounds(new Point2D.Double(double_3.x, double_3.y), new Point2D.Double(double_3.x + double_3.width, double_3.y + double_3.height));
            this.invalidate();
        }
    }

    @Override
    public void setLayouter(Layouter layouter) {
        this.layouter = layouter;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        if (this.layouter != null) {
            Rectangle2D.Double double_ = this.layouter.calculateLayout(this, this.getStartPoint(), this.getEndPoint());
            return new Dimension2DDouble(double_.width, double_.height);
        }
        return super.getPreferredSize();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            for (Figure figure : this.getChildren()) {
                if (!figure.isVisible() || !figure.getDrawingArea().intersects(rectangle)) continue;
                figure.draw(graphics2D);
            }
        } else {
            for (Figure figure : this.getChildren()) {
                if (!figure.isVisible()) continue;
                figure.draw(graphics2D);
            }
        }
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        linkedList.add(this);
        linkedList.addAll(this.getChildren());
        return linkedList;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        dOMInput.openElement("children");
        for (int i = 0; i < dOMInput.getElementCount(); ++i) {
            this.basicAdd((Figure)dOMInput.readObject(i));
        }
        dOMInput.closeElement();
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        dOMOutput.openElement("children");
        for (Figure figure : this.getChildren()) {
            dOMOutput.writeObject(figure);
        }
        dOMOutput.closeElement();
    }

    @Override
    public void restoreTransformTo(Object object) {
        LinkedList linkedList = (LinkedList)object;
        Iterator iterator = linkedList.iterator();
        for (Figure figure : this.getChildren()) {
            figure.restoreTransformTo(iterator.next());
        }
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Figure figure : this.getChildren()) {
            linkedList.add(figure.getTransformRestoreData());
        }
        return linkedList;
    }

    @Override
    public void basicAdd(int n, Figure figure) {
        this.children.add(n, figure);
        figure.addFigureListener(this.eventHandler);
    }

    @Override
    public Figure basicRemoveChild(int n) {
        Figure figure = this.children.remove(n);
        figure.removeFigureListener(this.eventHandler);
        this.invalidate();
        return figure;
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public AbstractCompositeFigure clone() {
        AbstractCompositeFigure abstractCompositeFigure = (AbstractCompositeFigure)super.clone();
        abstractCompositeFigure.children = new ArrayList();
        abstractCompositeFigure.eventHandler = abstractCompositeFigure.createEventHandler();
        for (Figure figure : this.children) {
            Figure figure2 = (Figure)figure.clone();
            abstractCompositeFigure.children.add(figure2);
            figure2.addFigureListener(abstractCompositeFigure.eventHandler);
        }
        return abstractCompositeFigure;
    }

    @Override
    protected void validate() {
        super.validate();
        this.layout();
    }

    @Override
    protected void invalidate() {
        this.cachedBounds = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public void willChange() {
        super.willChange();
        for (Figure figure : this.children) {
            figure.willChange();
        }
    }

    @Override
    public void changed() {
        for (Figure figure : this.children) {
            figure.changed();
        }
        super.changed();
    }

    @Override
    public int basicRemove(Figure figure) {
        int n = this.children.indexOf(figure);
        if (n != -1) {
            this.basicRemoveChild(n);
        }
        return n;
    }

    @Override
    public int indexOf(Figure figure) {
        return this.children.indexOf(figure);
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            if (this.getChildCount() == 0) {
                this.cachedDrawingArea = new Rectangle2D.Double();
            } else {
                for (Figure figure : this.children) {
                    if (this.cachedDrawingArea == null) {
                        this.cachedDrawingArea = figure.getDrawingArea();
                        continue;
                    }
                    this.cachedDrawingArea.add(figure.getDrawingArea());
                }
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            if (this.getChildCount() == 0) {
                this.cachedBounds = new Rectangle2D.Double();
            } else {
                for (Figure figure : this.children) {
                    if (this.cachedBounds == null) {
                        this.cachedBounds = figure.getBounds();
                        continue;
                    }
                    this.cachedBounds.add(figure.getBounds());
                }
            }
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    protected void fireFigureAdded(Figure figure, int n) {
        CompositeFigureEvent compositeFigureEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CompositeFigureListener.class) continue;
            if (compositeFigureEvent == null) {
                compositeFigureEvent = new CompositeFigureEvent(this, figure, figure.getDrawingArea(), n);
            }
            ((CompositeFigureListener)objectArray[i + 1]).figureAdded(compositeFigureEvent);
        }
    }

    protected void fireFigureRemoved(Figure figure, int n) {
        CompositeFigureEvent compositeFigureEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CompositeFigureListener.class) continue;
            if (compositeFigureEvent == null) {
                compositeFigureEvent = new CompositeFigureEvent(this, figure, figure.getDrawingArea(), n);
            }
            ((CompositeFigureListener)objectArray[i + 1]).figureRemoved(compositeFigureEvent);
        }
    }

    @Override
    public void removeCompositeFigureListener(CompositeFigureListener compositeFigureListener) {
        this.listenerList.remove(CompositeFigureListener.class, compositeFigureListener);
    }

    @Override
    public void addCompositeFigureListener(CompositeFigureListener compositeFigureListener) {
        this.listenerList.add(CompositeFigureListener.class, compositeFigureListener);
    }

    protected class EventHandler
    extends FigureAdapter
    implements UndoableEditListener,
    Serializable {
        protected EventHandler() {
        }

        @Override
        public void figureRequestRemove(FigureEvent figureEvent) {
            AbstractCompositeFigure.this.remove(figureEvent.getFigure());
        }

        @Override
        public void figureChanged(FigureEvent figureEvent) {
            Rectangle2D.Double double_ = AbstractCompositeFigure.this.getDrawingArea();
            double_.add(figureEvent.getInvalidatedArea());
            AbstractCompositeFigure.this.invalidate();
            AbstractCompositeFigure.this.validate();
            double_.add(AbstractCompositeFigure.this.getDrawingArea());
            AbstractCompositeFigure.this.fireFigureChanged(double_);
        }

        @Override
        public void areaInvalidated(FigureEvent figureEvent) {
            AbstractCompositeFigure.this.fireAreaInvalidated(figureEvent);
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            AbstractCompositeFigure.this.fireUndoableEditHappened(undoableEditEvent.getEdit());
        }

        @Override
        public void attributeChanged(FigureEvent figureEvent) {
            AbstractCompositeFigure.this.invalidate();
        }

        @Override
        public void figureAdded(FigureEvent figureEvent) {
            AbstractCompositeFigure.this.invalidate();
        }

        @Override
        public void figureRemoved(FigureEvent figureEvent) {
            AbstractCompositeFigure.this.invalidate();
        }
    }
}

