// Tags: JDK1.2

// Copyright (C) 2004 David Gilbert <david.gilbert@object-refinery.com>

// Mauve is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// Mauve is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 

// You should have received a copy of the GNU General Public License
// along with Mauve; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.  */

package gnu.testlet.java.awt.image.SinglePixelPackedSampleModel;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SinglePixelPackedSampleModel;

/**
 * Some checks for the <code>getPixels()</code> method in the 
 * {@link SinglePixelPackedSampleModel} class.
 */
public class getPixels implements Testlet 
{

  /**
   * Runs the test using the specified harness.
   * 
   * @param harness  the test harness (<code>null</code> not permitted).
   */
  public void test(TestHarness harness)      
  {
    SinglePixelPackedSampleModel m1 = new SinglePixelPackedSampleModel(
      DataBuffer.TYPE_BYTE, 2, 2, new int[] { 0xF0, 0x0F }
    );
    DataBufferByte db = new DataBufferByte(new byte[] { (byte) 0x12, (byte) 0x34, (byte) 0xAB, (byte) 0xCD }, 4);

    // check regular fetch
    int[] samples = m1.getPixels(0, 0, 1, 2, (int[]) null, db);
    harness.check(samples[0], 0x01);  // 1
    harness.check(samples[1], 0x02);  // 2
    harness.check(samples[2], 0x0A);  // 3
    harness.check(samples[3], 0x0B);  // 4

    // check regular fetch with negative x
    try
    {
      samples = m1.getPixels(-1, 0, 1, 1, (int[]) null, db);
      harness.check(false);
    }
    catch (ArrayIndexOutOfBoundsException e) 
    {
      harness.check(true);
    }
 
    // check regular fetch with negative y
    try
    {
      samples = m1.getPixels(0, -1, 1, 1, (int[]) null, db);
      harness.check(false);
    }
    catch (ArrayIndexOutOfBoundsException e) 
    {
      harness.check(true);
    }
 
    // check regular fetch with w < 0
    try
    {
      samples = m1.getPixels(0, 0, -1, 1, (int[]) null, db);
      harness.check(false);
    }
    catch (NegativeArraySizeException e)
    {
      harness.check(true);
    }
    catch (ArrayIndexOutOfBoundsException e) 
    {
      harness.check(true);
    }
 
    // check regular fetch with h < 0
    try
    {
      samples = m1.getPixels(0, 0, 1, -1, (int[]) null, db);
      harness.check(false);
    }
    catch (NegativeArraySizeException e)
    {
      harness.check(true);
    }
    catch (ArrayIndexOutOfBoundsException e) 
    {
      harness.check(true);
    }
 
    // check regular fetch with presupplied array
    int[] samplesIn = new int[4];
    int[] samplesOut = m1.getPixels(1, 0, 1, 2, samplesIn, db);
    harness.check(samplesIn == samplesOut);
    harness.check(samplesOut[0], 0x03);
    harness.check(samplesOut[1], 0x04);
    harness.check(samplesOut[2], 0x0C);
    harness.check(samplesOut[3], 0x0D);

    // check regular fetch with presupplied array too short
    int[] samplesIn2 = new int[1];
    try 
    {
      /* int[] samplesOut2 = */ m1.getPixels(1, 1, 1, 2, samplesIn2, db);
      harness.check(false);
    }
    catch (ArrayIndexOutOfBoundsException e)
    {
      harness.check(true);
    }

    // check null data buffer
    try
    {
      samples = m1.getPixels(0, 0, 1, 1, (int[]) null, null);
      harness.check(false);
    }
    catch (NullPointerException e) 
    {
      harness.check(true);
    }
    
    // check other array types
    try
    {
      float[] samples1 = m1.getPixels(0, 0, 1, 1, (float[]) null, db);
      harness.check(true);
    }
    catch (NullPointerException e) 
    {
      harness.check(false);
    }
  }
}

