import ctypes
import os


class UnshareFlags:
    # from /usr/include/linux/sched.h, see also unshare(2)
    CLONE_FILES = 0x00000400
    CLONE_FS = 0x00000200
    CLONE_NEWIPC = 0x08000000
    CLONE_NEWNET = 0x40000000
    CLONE_NEWNS = 0x00020000  # equivalent to unshare --mount
    CLONE_NEWUTS = 0x04000000
    CLONE_SYSVSEM = 0x00040000
    CLONE_NEWPID = 0x20000000      # /* New pid namespace */


def unshare(flags):
    libc = ctypes.CDLL("libc.so.6", use_errno=True)
    res = libc.unshare(ctypes.c_int(flags))
    if res == -1:
        e = ctypes.get_errno()
        raise OSError(e, os.strerror(e))
