% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eol_pages.R
\name{eol_pages}
\alias{eol_pages}
\title{Search for pages in EOL database using a taxonconceptID.}
\usage{
eol_pages(taxonconceptID, iucn = FALSE, images = 0, videos = 0,
  sounds = 0, maps = 0, text = 0, subjects = "overview",
  licenses = "all", details = FALSE, common_names = FALSE,
  synonyms = FALSE, references = FALSE, taxonomy = TRUE, vetted = 0,
  cache_ttl = NULL, key = NULL, ...)
}
\arguments{
\item{taxonconceptID}{The taxonconceptID (numeric), which is also the page
number.}

\item{iucn}{Include the IUCN Red List status object (Default: \code{FALSE})}

\item{images}{Limits the number of returned image objects (values 0 - 75)}

\item{videos}{Limits the number of returned video objects (values 0 - 75)}

\item{sounds}{Limits the number of returned sound objects (values 0 - 75)}

\item{maps}{Limits the number of returned map objects (values 0 - 75)}

\item{text}{Limits the number of returned text objects (values 0 - 75)}

\item{subjects}{'overview' (default) to return the overview text
(if exists), a pipe | delimited list of subject names from the list of EOL
accepted subjects (e.g. TaxonBiology, FossilHistory), or 'all' to get text
in any subject. Always returns an overview text as a first result (if one
exists in the given context).}

\item{licenses}{A pipe | delimited list of licenses or 'all' (default) to
get objects under any license. Licenses abbreviated cc- are all Creative
Commons licenses. Visit their site for more information on the various
licenses they offer.}

\item{details}{Include all metadata for data objects. (Default: \code{FALSE})}

\item{common_names}{Return all common names for the page's taxon
(Default: \code{FALSE})}

\item{synonyms}{Return all synonyms for the page's taxon
(Default: \code{FALSE})}

\item{references}{Return all references for the page's taxon
(Default: \code{FALSE})}

\item{taxonomy}{(logical) Whether to return any taxonomy details from
different taxon hierarchy providers, in an array named \code{taxonconcepts}
(Default: \code{TRUE})}

\item{vetted}{If 'vetted' is given a value of '1', then only trusted
content will be returned. If 'vetted' is '2', then only trusted and
unreviewed content will be returned (untrusted content will not be returned).
The default is to return all content. (Default: \code{FALSE})}

\item{cache_ttl}{The number of seconds you wish to have the response cached.}

\item{key}{Your EOL API key; loads from .Rprofile, or you can specify the
key manually the in the function call.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
JSON list object, or data.frame.
}
\description{
Search for pages in EOL database using a taxonconceptID.
}
\details{
It's possible to return JSON or XML with the EOL API. However,
		this function only returns JSON for now.
}
\examples{
\dontrun{
(pageid <- eol_search('Pomatomus')$pageid[1])
eol_pages(taxonconceptID=pageid)$scinames
}
}
