% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5R.R
\docType{class}
\name{H5R_DATASET_REGION-class}
\alias{H5R_DATASET_REGION-class}
\alias{H5R_DATASET_REGION}
\title{Class for HDF5 dataset-region references.}
\value{
Object of class \code{\link[=H5R_DATASET_REGION]{H5R_DATASET_REGION}}.
}
\description{
\code{H5R_DATASET_REGION} is the reference class for dataset regions. Users should not create this class by themselves, but use the appropriate 
and instead use the \code{create_reference} methods of \code{H5D}, \code{H5Group} or \code{H5File} classes.
}
\section{Methods}{

\describe{
\item{\code{new(num = 0, id = NULL)}}{

Create a new reference for dataset regions; Usually, users shouldn't have to call this, but use the 
\code{create_reference} method of a dataset.}

\item{\code{dereference(object_access_pl = h5const$H5P_DEFAULT, obj = NULL,
  get_value = FALSE)}}{

Dereference an H5R reference for a dataset region. The file the reference is pointing to is assigned automatically.
It returns a list where each item is a list with components \code{dataset}, being an \code{H5D} object and
\code{space} being a \code{H5S} object. When setting \code{get_value=TRUE}, then instead of these objects
The data itself is returned
This function implements the HDF5-API function H5Rdereference.
Please see the documentation at \url{https://portal.hdfgroup.org/display/HDF5/H5R_DEREFERENCE} for details.

\strong{Parameters}
\describe{
\item{obj}{Overriding the default file the reference is referring to}
\item{object_access_pl}{The object-access property list. Currently always the default}
}}
}}

\author{
Holger Hoefling
}
