% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getGroups.glmmTMB}
\alias{getGroups.glmmTMB}
\alias{getGroups}
\title{Extract Grouping Factors from an Object}
\usage{
\method{getGroups}{glmmTMB}(object, form = formula(object), level, data, sep = "/", ...)
}
\arguments{
\item{object}{a fitted \code{glmmTMB} object.}

\item{form}{ignored (included for compatibility).}

\item{level}{integer indicating the level of the random effects structure to extract, 
defaults to 1 if missing.}

\item{data}{ignored (included for compatibility).}

\item{sep}{ignored (included for compatibility).}

\item{...}{additional arguments (not used).}
}
\value{
A factor representing the grouping structure at the specified level,
  with a \code{group} attribute indicating the name of the grouping factor.
}
\description{
This (simplified) method for \code{\link[nlme]{getGroups}} extracts the grouping factor
for a specified level of the random effects structure in a \code{glmmTMB} object.
}
\examples{
model <- glmmTMB(count ~ mined + (1 | spp), data = Salamanders, family = nbinom1)
getGroups(model)
}
