% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{estimateDispersionsGeneEst}
\alias{estimateDispersionsGeneEst}
\alias{estimateDispersionsFit}
\alias{estimateDispersionsMAP}
\alias{estimateDispersionsPriorVar}
\alias{estimateDispersionsFit}
\alias{estimateDispersionsMAP}
\alias{estimateDispersionsPriorVar}
\title{Low-level functions to fit dispersion estimates}
\usage{
estimateDispersionsGeneEst(object, minDisp = 1e-08, kappa_0 = 1,
  dispTol = 1e-06, maxit = 100, quiet = FALSE, modelMatrix = NULL,
  niter = 1, linearMu = NULL, minmu = 0.5)

estimateDispersionsFit(object, fitType = c("parametric", "local", "mean"),
  minDisp = 1e-08, quiet = FALSE)

estimateDispersionsMAP(object, outlierSD = 2, dispPriorVar, minDisp = 1e-08,
  kappa_0 = 1, dispTol = 1e-06, maxit = 100, modelMatrix = NULL,
  quiet = FALSE)

estimateDispersionsPriorVar(object, minDisp = 1e-08, modelMatrix = NULL)
}
\arguments{
\item{object}{a DESeqDataSet}

\item{minDisp}{small value for the minimum dispersion, to allow
for calculations in log scale, one order of magnitude above this value is used
as a test for inclusion in mean-dispersion fitting}

\item{kappa_0}{control parameter used in setting the initial proposal
in backtracking search, higher kappa_0 results in larger steps}

\item{dispTol}{control parameter to test for convergence of log dispersion,
stop when increase in log posterior is less than dispTol}

\item{maxit}{control parameter: maximum number of iterations to allow for convergence}

\item{quiet}{whether to print messages at each step}

\item{modelMatrix}{for advanced use only,
a substitute model matrix for gene-wise and MAP dispersion estimation}

\item{niter}{number of times to iterate between estimation of means and
estimation of dispersion}

\item{linearMu}{estimate the expected counts matrix using a linear model,
default is NULL, in which case a lienar model is used if the
number of groups defined by the model matrix is equal to the number
of columns of the model matrix}

\item{minmu}{lower bound on the estimated count for fitting gene-wise dispersion}

\item{fitType}{either "parametric", "local", or "mean"
for the type of fitting of dispersions to the mean intensity.
See \code{\link{estimateDispersions}} for description.}

\item{outlierSD}{the number of standard deviations of log
gene-wise estimates above the prior mean (fitted value),
above which dispersion estimates will be labelled
outliers. Outliers will keep their original value and
not be shrunk using the prior.}

\item{dispPriorVar}{the variance of the normal prior on the log dispersions.
If not supplied, this is calculated as the difference between
the mean squared residuals of gene-wise estimates to the
fitted dispersion and the expected sampling variance
of the log dispersion}
}
\value{
a DESeqDataSet with gene-wise, fitted, or final MAP
dispersion estimates in the metadata columns of the object.

\code{estimateDispersionsPriorVar} is called inside of \code{estimateDispersionsMAP}
and stores the dispersion prior variance as an attribute of
\code{dispersionFunction(dds)}, which can be manually provided to
\code{estimateDispersionsMAP} for parallel execution.
}
\description{
Normal users should instead use \code{\link{estimateDispersions}}.
These low-level functions are called by \code{\link{estimateDispersions}},
but are exported and documented for non-standard usage.
For instance, it is possible to replace fitted values with a custom fit and continue
with the maximum a posteriori dispersion estimation, as demonstrated in the
examples below.
}
\examples{

dds <- makeExampleDESeqDataSet()
dds <- estimateSizeFactors(dds)
dds <- estimateDispersionsGeneEst(dds)
dds <- estimateDispersionsFit(dds)
dds <- estimateDispersionsMAP(dds)
plotDispEsts(dds) 

# after having run estimateDispersionsFit()
# the dispersion prior variance over all genes
# can be obtained like so:

dispPriorVar <- estimateDispersionsPriorVar(dds)

}
\seealso{
\code{\link{estimateDispersions}}
}
