# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ...operations._automation_client_operations import build_convert_graph_runbook_content_request
from .._vendor import AutomationClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AutomationClientOperationsMixin(AutomationClientMixinABC):

    @overload
    async def convert_graph_runbook_content(
        self,
        resource_group_name: str,
        automation_account_name: str,
        parameters: _models.GraphicalRunbookContent,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GraphicalRunbookContent:
        """Post operation to serialize or deserialize GraphRunbookContent.

        :param resource_group_name: Name of an Azure Resource group. Required.
        :type resource_group_name: str
        :param automation_account_name: The name of the automation account. Required.
        :type automation_account_name: str
        :param parameters: Input data describing the graphical runbook. Required.
        :type parameters: ~azure.mgmt.automation.models.GraphicalRunbookContent
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GraphicalRunbookContent or the result of cls(response)
        :rtype: ~azure.mgmt.automation.models.GraphicalRunbookContent
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def convert_graph_runbook_content(
        self,
        resource_group_name: str,
        automation_account_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GraphicalRunbookContent:
        """Post operation to serialize or deserialize GraphRunbookContent.

        :param resource_group_name: Name of an Azure Resource group. Required.
        :type resource_group_name: str
        :param automation_account_name: The name of the automation account. Required.
        :type automation_account_name: str
        :param parameters: Input data describing the graphical runbook. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GraphicalRunbookContent or the result of cls(response)
        :rtype: ~azure.mgmt.automation.models.GraphicalRunbookContent
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def convert_graph_runbook_content(
        self,
        resource_group_name: str,
        automation_account_name: str,
        parameters: Union[_models.GraphicalRunbookContent, IO[bytes]],
        **kwargs: Any
    ) -> _models.GraphicalRunbookContent:
        """Post operation to serialize or deserialize GraphRunbookContent.

        :param resource_group_name: Name of an Azure Resource group. Required.
        :type resource_group_name: str
        :param automation_account_name: The name of the automation account. Required.
        :type automation_account_name: str
        :param parameters: Input data describing the graphical runbook. Is either a
         GraphicalRunbookContent type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.automation.models.GraphicalRunbookContent or IO[bytes]
        :return: GraphicalRunbookContent or the result of cls(response)
        :rtype: ~azure.mgmt.automation.models.GraphicalRunbookContent
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-08-08"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GraphicalRunbookContent] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "GraphicalRunbookContent")

        _request = build_convert_graph_runbook_content_request(
            resource_group_name=resource_group_name,
            automation_account_name=automation_account_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("GraphicalRunbookContent", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
