; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s

define void @store_promote_4i8(<vscale x 4 x i8> %data, <vscale x 4 x i8>* %a) {
; CHECK-LABEL: store_promote_4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1b { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  store <vscale x 4 x i8> %data, <vscale x 4 x i8>* %a
  ret void
}

define void @store_split_i16(<vscale x 16 x i16> %data, <vscale x 16 x i16>* %a) {
; CHECK-LABEL: store_split_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1h { z1.h }, p0, [x0, #1, mul vl]
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  store <vscale x 16 x i16> %data, <vscale x 16 x i16>* %a
  ret void
}

define void @store_split_16i32(<vscale x 16 x i32> %data, <vscale x 16 x i32>* %a) {
; CHECK-LABEL: store_split_16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1w { z3.s }, p0, [x0, #3, mul vl]
; CHECK-NEXT:    st1w { z2.s }, p0, [x0, #2, mul vl]
; CHECK-NEXT:    st1w { z1.s }, p0, [x0, #1, mul vl]
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  store <vscale x 16 x i32> %data, <vscale x 16 x i32>* %a
  ret void
}

define void @store_split_16i64(<vscale x 16 x i64> %data, <vscale x 16 x i64>* %a) {
; CHECK-LABEL: store_split_16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1d { z7.d }, p0, [x0, #7, mul vl]
; CHECK-NEXT:    st1d { z6.d }, p0, [x0, #6, mul vl]
; CHECK-NEXT:    st1d { z5.d }, p0, [x0, #5, mul vl]
; CHECK-NEXT:    st1d { z4.d }, p0, [x0, #4, mul vl]
; CHECK-NEXT:    st1d { z3.d }, p0, [x0, #3, mul vl]
; CHECK-NEXT:    st1d { z2.d }, p0, [x0, #2, mul vl]
; CHECK-NEXT:    st1d { z1.d }, p0, [x0, #1, mul vl]
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  store <vscale x 16 x i64> %data, <vscale x 16 x i64>* %a
  ret void
}
