/***************************************************************************
 *   KSystemLog, a system log viewer tool                                  *
 *   Copyright (C) 2007 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#ifndef _SYSLOG_ANALYZER_H_
#define _SYSLOG_ANALYZER_H_

#include <QString>

#include "fileAnalyzer.h"

#include "logFile.h"

class LogFileReader;

class LogMode;
class LogLine;

class SyslogAnalyzer : public FileAnalyzer
{
    Q_OBJECT

public:
    explicit SyslogAnalyzer(LogMode *logMode);

    virtual ~SyslogAnalyzer();

    virtual LogViewColumns initColumns();

protected:
    virtual LogFileReader *createLogFileReader(const LogFile &logFile);
    virtual Analyzer::LogFileSortMode logFileSortMode();
    virtual LogLine *parseMessage(const QString &logLine, const LogFile &originalFile);

private:
    inline QString undefinedHostName();
    inline QString undefinedProcess();
    inline LogLine *undefinedLogLine(const QString &message, const LogFile &originalFile);
};

#endif // _SYSLOG_ANALYZER_H_
